/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.ui.swing.source;

import com.sap.jvm.debugging.ui.swing.source.SourceCodeManager;
import com.sap.jvm.tracing.Trace;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

public final class LinePainter
implements Highlighter.HighlightPainter,
MouseListener,
MouseMotionListener {
    private final SourceCodeManager.SourceCodeManagerInternal internal;
    private final JEditorPane pane;
    private final Color color;
    private Rectangle lastView;

    public LinePainter(SourceCodeManager.SourceCodeManagerInternal internal, JEditorPane pane) {
        this.internal = internal;
        this.pane = pane;
        this.color = pane.getSelectionColor().brighter().brighter();
        pane.addMouseListener(this);
        pane.addMouseMotionListener(this);
        try {
            pane.getHighlighter().addHighlight(0, 0, this);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    @Override
    public void paint(Graphics g, int p0, int p1, Shape bounds, JTextComponent c) {
        if (!this.internal.isCurrentEditor((JEditorPane)c)) {
            this.lastView = null;
            return;
        }
        Element root = c.getDocument().getDefaultRootElement();
        int currentLine = this.internal.getCurrentLine((JEditorPane)c);
        if (currentLine > 0 && currentLine < root.getElementCount()) {
            int offset = root.getElement(currentLine - 1).getStartOffset();
            try {
                Rectangle r = c.modelToView(offset);
                g.setColor(this.color);
                g.fillRect(0, r.y, c.getWidth(), r.height);
                if (this.lastView == null) {
                    this.lastView = r;
                }
            }
            catch (BadLocationException e) {
                Trace.warn((Throwable)e, (String)"Bad location");
            }
        } else {
            this.lastView = null;
        }
    }

    private void resetHighlight() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Element root = LinePainter.this.pane.getDocument().getDefaultRootElement();
                int currentLine = LinePainter.this.internal.getCurrentLine(LinePainter.this.pane);
                if (currentLine > 0 && currentLine < root.getElementCount()) {
                    int offset = root.getElement(currentLine - 1).getStartOffset();
                    try {
                        Rectangle currentView = LinePainter.this.pane.modelToView(offset);
                        if (LinePainter.this.lastView != null && currentView.y != ((LinePainter)LinePainter.this).lastView.y) {
                            LinePainter.this.pane.repaint(0, ((LinePainter)LinePainter.this).lastView.y, LinePainter.this.pane.getWidth(), ((LinePainter)LinePainter.this).lastView.height);
                            LinePainter.this.lastView = currentView;
                        }
                    }
                    catch (BadLocationException e) {
                        Trace.warn((Throwable)e, (String)"Bad location");
                    }
                } else if (LinePainter.this.lastView != null) {
                    LinePainter.this.pane.repaint(0, ((LinePainter)LinePainter.this).lastView.y, LinePainter.this.pane.getWidth(), ((LinePainter)LinePainter.this).lastView.height);
                    LinePainter.this.lastView = null;
                }
            }
        });
    }

    public void update() {
        this.resetHighlight();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.resetHighlight();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.resetHighlight();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

