/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.ui.swing.source;

import com.sap.jvm.debugging.ui.swing.source.SourceCodeManager;
import com.sap.jvm.tracing.Trace;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;

public final class SearchHelper {
    private final SourceCodeManager.SourceCodeManagerInternal internal;
    private final Highlighter.HighlightPainter painter = new DefaultHighlighter.DefaultHighlightPainter(Color.YELLOW);
    private String searchPattern = null;
    private int[] searchLines = null;
    private int currentSearchOffset = -1;
    private Highlighter lastHighlighter = null;
    private final List<Object> highlightTags = new ArrayList<Object>();

    public SearchHelper(SourceCodeManager.SourceCodeManagerInternal internal, JTabbedPane tabView) {
        this.internal = internal;
        tabView.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SearchHelper.this.reset();
            }
        });
    }

    public void search(JEditorPane editor, String pattern) {
        if (editor == null) {
            return;
        }
        if (this.searchPattern != null && this.searchPattern.length() > 0 && this.searchPattern.equals(pattern)) {
            this.focusSearchResult(editor, pattern, 1);
            return;
        }
        this.removeLastHighlights();
        Highlighter highlighter = editor.getHighlighter();
        if (pattern == null || pattern.length() == 0) {
            return;
        }
        ArrayList<Integer> lines = new ArrayList<Integer>();
        Document document = editor.getDocument();
        Element root = document.getDefaultRootElement();
        try {
            String text = document.getText(0, document.getLength());
            int i = 0;
            while ((i = text.indexOf(pattern, i)) >= 0) {
                lines.add(root.getElementIndex(i));
                this.highlightTags.add(highlighter.addHighlight(i, i + pattern.length(), this.painter));
                i += pattern.length();
            }
        }
        catch (BadLocationException e) {
            Trace.warn((Throwable)e, (String)"Exception while highlighting search result");
        }
        this.searchPattern = pattern;
        this.searchLines = new int[lines.size()];
        for (int i = 0; i < this.searchLines.length; ++i) {
            this.searchLines[i] = (Integer)lines.get(i);
        }
        this.currentSearchOffset = -1;
        this.lastHighlighter = highlighter;
        this.focusSearchResult(editor, pattern, 1);
    }

    public void focusSearchResult(JEditorPane editor, String pattern, int offset) {
        if (this.searchLines == null) {
            this.search(editor, pattern);
        }
        assert (this.searchLines == null || this.searchLines.length == 0 || Math.abs(offset) <= this.searchLines.length);
        if (editor == null || this.searchLines == null || this.searchLines.length == 0) {
            return;
        }
        this.currentSearchOffset = (this.currentSearchOffset + offset + this.searchLines.length) % this.searchLines.length;
        assert (this.currentSearchOffset >= 0 && this.currentSearchOffset < this.searchLines.length);
        this.internal.scrollToLine(editor, this.searchLines[this.currentSearchOffset]);
    }

    public void reset() {
        this.searchPattern = null;
        this.searchLines = null;
        this.currentSearchOffset = -1;
        this.removeLastHighlights();
    }

    private void removeLastHighlights() {
        if (this.lastHighlighter == null) {
            return;
        }
        for (Object tag : this.highlightTags) {
            this.lastHighlighter.removeHighlight(tag);
        }
        this.lastHighlighter = null;
        this.highlightTags.clear();
    }
}

