/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.ui.swing.source;

import com.sap.jvm.debugging.controller.packets.DisassembledClassPacket;
import com.sap.jvm.debugging.controller.packets.HotCodeReplacementPacketImpl;
import com.sap.jvm.debugging.controller.packets.breakpoints.BreakpointParser;
import com.sap.jvm.debugging.controller.packets.breakpoints.LineBreakpointSpecification;
import com.sap.jvm.debugging.controller.packets.variables.AddExpressionPacketImpl;
import com.sap.jvm.debugging.presentation.BreakpointSpecification;
import com.sap.jvm.debugging.presentation.BreakpointType;
import com.sap.jvm.debugging.ui.swing.BreakpointManager;
import com.sap.jvm.debugging.ui.swing.FrontendController;
import com.sap.jvm.debugging.ui.swing.JvmDebugger;
import com.sap.jvm.debugging.ui.swing.icons.ImageRepository;
import com.sap.jvm.debugging.ui.swing.source.ClassFileFilter;
import com.sap.jvm.debugging.ui.swing.source.DirectoryFileFilter;
import com.sap.jvm.debugging.ui.swing.source.DisassemblyManager;
import com.sap.jvm.debugging.ui.swing.source.EditorType;
import com.sap.jvm.debugging.ui.swing.source.JavaFileFilter;
import com.sap.jvm.debugging.ui.swing.source.LineNumberPanel;
import com.sap.jvm.debugging.ui.swing.source.LinePainter;
import com.sap.jvm.debugging.ui.swing.source.SearchHelper;
import com.sap.jvm.debugging.ui.swing.source.SourceCodeProperties;
import com.sap.jvm.debugging.ui.swing.source.SourceCodeView;
import com.sap.jvm.debugging.ui.swing.source.SourceCodeViewAdministration;
import com.sap.jvm.debugging.ui.swing.source.SourceLookup;
import com.sap.jvm.debugging.ui.swing.source.SourceMouseListener;
import com.sap.jvm.debugging.ui.swing.source.ZipFileFilter;
import com.sap.jvm.tracing.Trace;
import com.sap.jvm.util.concurrent.QueueHelper;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.html.HTMLEditorKit;

public final class SourceCodeManager {
    private static final String OPEN_FILE = "open_file";
    private static final String ADD_DIR = "add_dir";
    private static final String ADD_SUPER_DIR = "add_super_dir";
    private static final String ADD_ZIP = "add_zip";
    private static final String REFRESH = "refresh";
    private JvmDebugger.SwingDebugger context = null;
    private FrontendController controller = null;
    private final BreakpointManager breakpoints;
    private final SourceCodeManagerInternal internal = new SourceCodeManagerInternal();
    private final SourceMouseListener listener;
    private JEditorPane current = null;
    private int currentLine = -1;
    private JEditorPane currentAlternative = null;
    private int currentAlternativeLine = -1;
    private final Runnable expressionViewShower;
    private final Runnable breakpointViewShower;
    private final SourceCodeView view;
    private final SourceCodeProperties sourceProperties;
    private final SourceLookup sourceLookup;
    private final SourceCodeViewAdministration viewAdmin;
    private final DisassemblyManager disassemblyManager;
    private final SearchHelper searchHelper;
    private JEditorPane lastScrolledToEditor;
    private int lastScrolledToLine = -1;
    private JEditorPane lastScrolledToAlternativeEditor;
    private int lastScrolledToAlternativeLine = -1;

    public SourceCodeManager(Runnable expressionViewShower, Runnable breakpointViewShower, BreakpointManager breakpoints) {
        this.expressionViewShower = expressionViewShower;
        this.breakpointViewShower = breakpointViewShower;
        this.breakpoints = breakpoints;
        this.viewAdmin = new SourceCodeViewAdministration();
        this.view = new SourceCodeView(this.internal);
        this.listener = new SourceMouseListener(this.internal, this.view);
        this.sourceProperties = new SourceCodeProperties(this.internal);
        this.sourceLookup = new SourceLookup(this.internal, this.sourceProperties, this.view);
        this.disassemblyManager = new DisassemblyManager();
        this.view.updateButtons(this.controller != null);
        this.searchHelper = new SearchHelper(this.internal, this.view.getTabView());
        breakpoints.addListener(new BreakpointManager.BreakpointListener(){

            @Override
            public void breakpointsChanged(BreakpointSpecification[] bps) {
                SourceCodeManager.this.handleBreakpointChange(bps);
            }
        });
    }

    public JComponent getSource() {
        return this.view.getSource();
    }

    public boolean isShowingDisassembly() {
        return this.viewAdmin.isDisassemblyView(this.view.getTabView().getSelectedComponent());
    }

    public void showSource(String file, String prefix, int line, int bci, long threadId, int frameIndex, String methodName) {
        this.showSource(file, prefix, line, bci, threadId, frameIndex, methodName, true, false);
    }

    public void showSource(String file, int line) {
        if (this.showSource(file, "", 0, 0, 0L, -1, null, false, false)) {
            this.scrollToLine(this.current, line, false, false);
            this.scrollToLine(this.currentAlternative, this.currentAlternativeLine, true, false);
        } else {
            String className = file.replace('/', '.');
            if (className.endsWith(".java")) {
                className = className.substring(0, className.length() - ".java".length());
            }
            this.showLinkPage(file, className);
        }
    }

    private boolean showSource(String file, String prefix, int line, int bci, long threadId, int frameIndex, String methodName, boolean showDisassembly, boolean ignoreExisting) {
        SourceLookup.ZipData zipData;
        int methodStart;
        int openingParenthesis;
        if ("".equals(file)) {
            this.removeHighlight();
            return false;
        }
        String path = (prefix.length() == 0 ? "" : prefix + '/') + file;
        String className = null;
        if (methodName != null && (openingParenthesis = methodName.indexOf(40)) >= 0 && (methodStart = methodName.lastIndexOf(46, openingParenthesis)) > 0) {
            className = methodName.substring(0, methodStart).replace('/', '.');
        }
        Component currentComponent = this.view.getTabView().getSelectedComponent();
        Component sourceComponent = this.viewAdmin.getSourceView(path, null);
        Component disassemblyComponent = this.viewAdmin.getSourceView(null, className);
        Component component = null;
        Component alternativeComponent = null;
        if (currentComponent == sourceComponent) {
            component = sourceComponent;
            alternativeComponent = disassemblyComponent;
        } else if (currentComponent == disassemblyComponent) {
            component = disassemblyComponent;
            alternativeComponent = sourceComponent;
        } else if (sourceComponent != null) {
            component = sourceComponent;
            alternativeComponent = disassemblyComponent;
        } else {
            component = disassemblyComponent;
            assert (alternativeComponent == null);
        }
        if (component != null && !ignoreExisting) {
            this.view.getTabView().setSelectedComponent(component);
            int realLine = line;
            EditorType type = this.viewAdmin.getViewType(component);
            if (type != EditorType.SOURCE) {
                realLine = this.disassemblyManager.getLine(className, methodName, type, bci);
            }
            int alternativeLine = line;
            EditorType alternativeType = this.viewAdmin.getViewType(alternativeComponent);
            if (alternativeType == null) {
                alternativeLine = -1;
            } else if (alternativeType != EditorType.SOURCE) {
                alternativeLine = this.disassemblyManager.getLine(className, methodName, alternativeType, bci);
            }
            this.viewAdmin.registerClassMapping(path, className);
            this.setCurrent(this.viewAdmin.getEditor(component), realLine, this.viewAdmin.getEditor(alternativeComponent), alternativeLine);
            this.scrollToLine(this.current, realLine, false, false);
            this.scrollToLine(this.currentAlternative, this.currentAlternativeLine, true, false);
            return true;
        }
        File potentialFile = this.sourceLookup.lookup(path);
        SourceLookup.ZipData zipData2 = zipData = potentialFile != null ? new SourceLookup.ZipData(null, null) : this.sourceLookup.lookupZip(path);
        if (potentialFile != null || zipData.isValid()) {
            this.createTab(potentialFile, zipData.getContent(), path, className, zipData.getUrl(), EditorType.SOURCE);
            JEditorPane editor = this.viewAdmin.getEditor(this.viewAdmin.getSourceView(path, className));
            this.setCurrent(editor, line, null, -1);
            this.scrollToLine(editor, line, false, false);
            return true;
        }
        if (className == null || !showDisassembly) {
            return false;
        }
        this.createTab(null, "Loading disassembly of class '" + className + "'...", path, className, null, EditorType.DISASSEMBLED_SOURCE);
        JEditorPane editor = this.viewAdmin.getEditor(this.viewAdmin.getSourceView(null, className));
        this.setCurrent(editor, 0, null, -1);
        QueueHelper.put(this.controller.getWriteQueue(), this.disassemblyManager.requestDisassembly(className, bci, threadId, frameIndex, methodName));
        return true;
    }

    public void setContext(JvmDebugger.SwingDebugger context) {
        assert (this.context == null && context != null);
        this.context = context;
        this.sourceProperties.setContext(context);
        this.sourceLookup.updateSourceProperties();
    }

    public void setController(FrontendController controller) {
        assert (this.controller == null && controller != null);
        this.controller = controller;
        this.view.updateButtons(true);
    }

    public void reset() {
        this.controller = null;
        this.removeHighlight();
        this.disassemblyManager.reset();
    }

    public void removeHighlight() {
        this.setCurrent(null, -1, null, -1);
    }

    public void showDisassembly(DisassembledClassPacket packet) {
        this.showDisassembly(packet, null);
    }

    public String getActiveClassName() {
        Component component = this.view.getTabView().getSelectedComponent();
        if (component == null) {
            return null;
        }
        if (this.viewAdmin.getViewType(component) == EditorType.SOURCE) {
            String path = this.viewAdmin.getSourcePath(component);
            String className = path.replace('/', '.');
            if (className.endsWith(".java")) {
                className = className.substring(0, className.length() - ".java".length());
            }
            return className;
        }
        return this.viewAdmin.getClassName(component);
    }

    public String getActivePath() {
        Component component = this.view.getTabView().getSelectedComponent();
        if (component == null) {
            return null;
        }
        if (this.viewAdmin.getViewType(component) == EditorType.SOURCE) {
            return this.viewAdmin.getSourcePath(component);
        }
        String className = this.viewAdmin.getClassName(component);
        int index = className.indexOf(36);
        if (index > 0) {
            className = className.substring(0, index);
        }
        return className.replace('.', '/') + ".java";
    }

    private void showDisassembly(DisassembledClassPacket packet, EditorType forcedType) {
        DisassemblyManager.DisassemblyLocation location = this.disassemblyManager.handleDisassembly(packet);
        Component component = this.viewAdmin.getSourceView(null, packet.getClassName());
        JEditorPane editor = this.viewAdmin.getEditor(component);
        EditorType type = forcedType;
        if (type == null) {
            type = component == null ? EditorType.DISASSEMBLED_SOURCE : this.viewAdmin.getViewType(component);
        }
        int lineNr = -1;
        if (location != null) {
            lineNr = this.disassemblyManager.getLine(packet.getClassName(), location.getMethod(), type, location.getByteCodeIndex());
        }
        String content = this.disassemblyManager.getContent(packet.getClassName(), type);
        if (editor == null) {
            String path = this.viewAdmin.getSourcePath(packet.getClassName());
            this.createTab(null, content, path, packet.getClassName(), null, type);
            editor = this.viewAdmin.getEditor(this.viewAdmin.getSourceView(null, packet.getClassName()));
        } else {
            this.viewAdmin.updateViewType(component, type);
            editor.setText(content);
            this.view.updateNavigationButtons();
        }
        if (lineNr >= 0) {
            int line = lineNr;
            JEditorPane editPane = editor;
            this.setCurrent(editor, line, null, -1);
            if (line >= 0) {
                this.scrollToLine(editPane, line, false, false);
            }
        }
    }

    private void setCurrent(JEditorPane editor, int line, JEditorPane alternativeEditor, int alternativeLine) {
        this.current = editor;
        this.currentLine = line;
        this.currentAlternative = alternativeEditor;
        this.currentAlternativeLine = alternativeLine;
        for (int i = 0; i < this.view.getTabView().getTabCount(); ++i) {
            JScrollPane component = (JScrollPane)this.view.getTabView().getComponentAt(i);
            LineNumberPanel panel = (LineNumberPanel)component.getRowHeader().getView();
            panel.update();
        }
        this.viewAdmin.updateLinePainters();
    }

    private void scrollToLine(final JEditorPane editor, final int line, boolean isAlternative, boolean forced) {
        boolean scroll = true;
        if (!forced) {
            if (isAlternative) {
                if (this.lastScrolledToAlternativeEditor == editor && this.lastScrolledToAlternativeLine == line) {
                    scroll = false;
                } else {
                    this.lastScrolledToAlternativeEditor = editor;
                    this.lastScrolledToAlternativeLine = line;
                }
            } else if (this.lastScrolledToEditor == editor && this.lastScrolledToLine == line) {
                scroll = false;
            } else {
                this.lastScrolledToEditor = editor;
                this.lastScrolledToLine = line;
            }
        }
        if (editor == null || !scroll) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Element root = editor.getDocument().getDefaultRootElement();
                if (line > 0 && line < root.getElementCount()) {
                    int offset = root.getElement(line - 1).getStartOffset();
                    int visible = editor.getVisibleRect().height;
                    try {
                        Rectangle target = editor.modelToView(offset);
                        if (target == null) {
                            return;
                        }
                        int lineHeight = target.height;
                        visible -= target.height;
                        while (visible > lineHeight) {
                            target.y = Math.max(0, target.y - lineHeight);
                            target.height += lineHeight;
                            if ((visible -= lineHeight) <= lineHeight) continue;
                            target.height += lineHeight;
                            visible -= lineHeight;
                        }
                        editor.scrollRectToVisible(target);
                        editor.repaint(0, target.y, editor.getWidth(), target.height);
                    }
                    catch (BadLocationException e) {
                        Trace.warn((Throwable)e, (String)"Exception while setting source line");
                    }
                }
            }
        });
    }

    private void createTab(File file, String text, String path, String className, URL url, EditorType type) {
        boolean hasOldView;
        assert (!(file != null && text != null || file == null && text == null));
        String pathWithPrefix = path;
        if (pathWithPrefix == null) {
            pathWithPrefix = this.findPathFromFile(file);
        }
        JScrollPane scrollPane = type == EditorType.SOURCE ? (JScrollPane)this.viewAdmin.getSourceView(pathWithPrefix, null) : (JScrollPane)this.viewAdmin.getSourceView(null, className);
        JEditorPane sourceCode = this.viewAdmin.getEditor(scrollPane);
        LinePainter painter = this.viewAdmin.getPainter(scrollPane);
        boolean bl = hasOldView = scrollPane != null;
        if (sourceCode == null) {
            sourceCode = new JEditorPane();
        }
        sourceCode.setContentType("text/plain");
        try {
            int index;
            String name;
            if (file != null) {
                sourceCode.setPage(file.toURI().toURL());
            } else {
                sourceCode.setText(text);
            }
            String string = name = file != null ? file.getName() : null;
            if (name == null) {
                index = path.lastIndexOf(47);
                String string2 = name = index >= 0 ? path.substring(index + 1) : path;
            }
            if (type != EditorType.SOURCE && name.endsWith(".java")) {
                index = className.lastIndexOf(46);
                name = (index >= 0 ? className.substring(index + 1) : className) + ".class";
            }
            if (!hasOldView) {
                sourceCode.addMouseListener(this.listener);
            }
            sourceCode.setEditable(false);
            sourceCode.setCaretColor(sourceCode.getSelectionColor());
            sourceCode.getCaret().setBlinkRate(0);
            Font oldFont = sourceCode.getFont();
            sourceCode.setFont(new Font("Monospaced", oldFont.getStyle(), oldFont.getSize()));
            int index2 = -1;
            if (!hasOldView) {
                index2 = this.view.getTabView().getTabCount();
                scrollPane = new JScrollPane(sourceCode);
                LineNumberPanel numberPanel = new LineNumberPanel(this.internal, sourceCode);
                numberPanel.addMouseListener(this.listener);
                scrollPane.setRowHeaderView(numberPanel);
                painter = new LinePainter(this.internal, sourceCode);
                this.view.getTabView().addTab(name, type.getIcon(), scrollPane);
                this.view.getTabView().setSelectedComponent(scrollPane);
                this.view.addTabCloseButton(index2, scrollPane, type);
            } else {
                index2 = this.view.getTabView().indexOfComponent(scrollPane);
            }
            this.view.getTabView().setToolTipTextAt(index2, this.getToolTip(file, url, className));
            this.viewAdmin.registerView(pathWithPrefix, className, scrollPane, type, file, url, painter);
            if (hasOldView) {
                this.view.updateNavigationButtons();
            }
            this.sourceLookup.updateSourceProperties();
        }
        catch (IOException e) {
            Trace.warn((Throwable)e, () -> "Error opening file '" + file.getPath() + "'.");
        }
    }

    private String getToolTip(File file, URL url, String className) {
        if (file != null) {
            return file.toString();
        }
        if (url != null) {
            return url.toString();
        }
        return className;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String findPathFromFile(File file) {
        FileReader fileReader = null;
        BufferedReader reader = null;
        try {
            fileReader = new FileReader(file);
            reader = new BufferedReader(fileReader);
            String nextLine = reader.readLine();
            while (nextLine != null) {
                String line = nextLine;
                nextLine = null;
                int index = line.indexOf("/*");
                while (index >= 0) {
                    int index2 = line.indexOf("*/");
                    if (index2 >= 0 && index2 > index + 1) {
                        line = line.substring(0, index) + line.substring(index2 + 2);
                    } else {
                        line = line.substring(0, index);
                        assert (nextLine == null);
                        while ((nextLine = reader.readLine()) != null) {
                            int index3 = nextLine.indexOf("*/");
                            if (index3 < 0) continue;
                            nextLine = nextLine.substring(index3 + 2);
                            break;
                        }
                        if (nextLine == null) break;
                    }
                    index = line.indexOf("/*");
                }
                if ((index = line.indexOf("//")) >= 0) {
                    line = line.substring(0, index);
                }
                if ((line = line.trim()).startsWith("package")) {
                    index = (line = line.substring("package".length()).trim()).indexOf(59);
                    if (index >= 0) {
                        line = line.substring(0, index).trim();
                    }
                    if (!"".equals(line)) {
                        line = line.replace('.', '/');
                        String string = line + '/' + file.getName();
                        return string;
                    }
                }
                nextLine = nextLine == null ? reader.readLine() : nextLine;
            }
        }
        catch (IOException e) {
            Trace.warn((Throwable)e, () -> "Exception while reading file '" + file.getAbsolutePath() + "'");
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    Trace.warn((Throwable)e, () -> "Exception while closing file '" + file.getAbsolutePath() + "'");
                }
            } else if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException e) {
                    Trace.warn((Throwable)e, () -> "Exception while closing file '" + file.getAbsolutePath() + "'");
                }
            }
        }
        return file.getName();
    }

    private void openFile() {
        JFileChooser chooser = new JFileChooser(this.sourceProperties.getLastUsedDirectory());
        chooser.setMultiSelectionEnabled(true);
        chooser.setFileFilter(new JavaFileFilter());
        int result = chooser.showOpenDialog(this.getSource());
        if (result == 0) {
            for (File f : chooser.getSelectedFiles()) {
                this.createTab(f, null, null, null, null, EditorType.SOURCE);
                JEditorPane editor = this.viewAdmin.getEditor(this.viewAdmin.getSourceView(this.findPathFromFile(f), null));
                this.setCurrent(editor, 0, null, -1);
            }
        }
        this.sourceProperties.setLastUsedDirectory(chooser.getCurrentDirectory().toString());
    }

    private void addSourceDir(boolean isSuperSourceDir) {
        JFileChooser chooser = new JFileChooser(this.sourceProperties.getLastUsedDirectory());
        chooser.setMultiSelectionEnabled(true);
        chooser.setFileSelectionMode(1);
        chooser.setFileFilter(new DirectoryFileFilter());
        int result = chooser.showOpenDialog(this.getSource());
        if (result == 0) {
            assert (chooser.getSelectedFile().isDirectory());
            this.sourceLookup.addSourceDir(chooser.getSelectedFiles(), isSuperSourceDir);
        }
        this.sourceProperties.setLastUsedDirectory(chooser.getCurrentDirectory().toString());
    }

    private void addSourceZip() {
        JFileChooser chooser = new JFileChooser(this.sourceProperties.getLastUsedDirectory());
        chooser.setMultiSelectionEnabled(true);
        chooser.setFileFilter(new ZipFileFilter());
        int result = chooser.showOpenDialog(this.getSource());
        if (result == 0) {
            this.sourceLookup.addSourceZips(chooser.getSelectedFiles());
        }
        this.sourceProperties.setLastUsedDirectory(chooser.getCurrentDirectory().toString());
    }

    public void propertiesChanged() {
        this.sourceLookup.propertiesChanged();
    }

    private void closeEditors() {
        for (int i = this.view.getTabView().getTabCount() - 1; i >= 0; --i) {
            this.removeTab(this.view.getTabView().getComponentAt(i));
        }
    }

    public void clearProperties() {
        this.closeEditors();
        this.sourceLookup.clearProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void redefineClass() {
        String className = (String)JOptionPane.showInputDialog(this.getSource(), "Please specify the fully qualified name of the class to redefine", "Class redefinition", 3, null, null, "<package>.<class>");
        if (className != null) {
            JFileChooser chooser = new JFileChooser(this.sourceProperties.getLastUsedDirectory());
            chooser.setMultiSelectionEnabled(false);
            chooser.setFileFilter(new ClassFileFilter());
            int result = chooser.showOpenDialog(this.getSource());
            if (result == 0) {
                RandomAccessFile file = null;
                try {
                    file = new RandomAccessFile(chooser.getSelectedFile(), "r");
                    if (file.length() > Integer.MAX_VALUE) {
                        throw new UnsupportedOperationException("Class file to big: " + file.length() + " bytes");
                    }
                    byte[] classBytes = new byte[(int)file.length()];
                    file.readFully(classBytes);
                    HashMap<String, byte[]> classMapping = new HashMap<String, byte[]>();
                    classMapping.put(className, classBytes);
                    QueueHelper.put(this.controller.getWriteQueue(), new HotCodeReplacementPacketImpl(classMapping));
                }
                catch (IOException e) {
                    Trace.warn((Throwable)e, () -> "Exception while reading class file '" + chooser.getSelectedFile() + "'");
                }
                finally {
                    if (file != null) {
                        try {
                            file.close();
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
            this.sourceProperties.setLastUsedDirectory(chooser.getCurrentDirectory().toString());
        }
    }

    private void disassembleClass(String name) {
        String className = name;
        if (className == null) {
            className = (String)JOptionPane.showInputDialog(this.getSource(), "Please specify the fully qualified name of the class to disassemble", "Class Disassembly", 3, null, null, "<package>.<class>");
        }
        if (className != null) {
            String path = className.replace('.', '/') + ".java";
            this.createTab(null, "Loading decompiled code of class '" + className + "'...", path, className, null, EditorType.DISASSEMBLED_SOURCE);
            JEditorPane editor = this.viewAdmin.getEditor(this.viewAdmin.getSourceView(null, className));
            this.setCurrent(editor, 0, null, -1);
            QueueHelper.put(this.controller.getWriteQueue(), this.disassemblyManager.requestDisassembly(className, -1, 0L, -1, null));
        }
    }

    private void decompileClass(String name) {
        String className = name;
        if (className == null) {
            className = (String)JOptionPane.showInputDialog(this.getSource(), "Please specify the fully qualified name of the class to decompile", "Class Decompilation", 3, null, null, "<package>.<class>");
        }
        if (className != null) {
            String path = className.replace('.', '/') + ".java";
            this.createTab(null, "Loading decompiled code of class '" + className + "'...", path, className, null, EditorType.DECOMPILED_SOURCE);
            JEditorPane editor = this.viewAdmin.getEditor(this.viewAdmin.getSourceView(null, className));
            this.setCurrent(editor, 0, null, -1);
            QueueHelper.put(this.controller.getWriteQueue(), this.disassemblyManager.requestDisassembly(className, -1, 0L, -1, null));
        }
    }

    private void toggleBetweenDisassemblyAndDecompiledCode() {
        Component component = this.view.getTabView().getSelectedComponent();
        if (component != null) {
            DisassembledClassPacket.MethodByteCodeIndex bci;
            EditorType type = this.viewAdmin.getViewType(component);
            if (type != EditorType.DISASSEMBLED_SOURCE && type != EditorType.DECOMPILED_SOURCE) {
                return;
            }
            EditorType newType = type == EditorType.DISASSEMBLED_SOURCE ? EditorType.DECOMPILED_SOURCE : EditorType.DISASSEMBLED_SOURCE;
            String className = this.viewAdmin.getClassName(component);
            JEditorPane editor = this.viewAdmin.getEditor(component);
            DisassembledClassPacket.MethodByteCodeIndex methodByteCodeIndex = bci = this.current == editor ? this.disassemblyManager.getMethodByteCodeIndex(className, type, this.currentLine) : null;
            if (this.currentAlternative == editor) {
                bci = this.disassemblyManager.getMethodByteCodeIndex(className, type, this.currentAlternativeLine);
            }
            int index = bci == null ? 0 : bci.getByteCodeIndex();
            String method = bci == null ? null : bci.getMethod();
            this.disassemblyManager.requestDisassembly(className, index, 0L, -1, method);
            this.showDisassembly(this.disassemblyManager.getPacket(className), newType);
        }
    }

    private void removeTab(Component component) {
        int index = this.view.getTabView().indexOfComponent(component);
        if (index >= 0) {
            this.view.getTabView().remove(index);
        }
        this.viewAdmin.deregisterView(component);
        this.sourceLookup.updateSourceProperties();
    }

    private void toggleLineBreakpoint(int line) {
        Component component = this.view.getTabView().getSelectedComponent();
        if (component != null) {
            String path = this.viewAdmin.getSourcePath(component);
            assert (path != null);
            String name = path + ":" + line;
            BreakpointSpecification spec = BreakpointParser.deserialize(BreakpointType.LINE, name);
            this.toggleBreakpoint(spec);
        }
    }

    private void toggleBciBreakpoint(DisassembledClassPacket.MethodByteCodeIndex bci) {
        Component component = this.view.getTabView().getSelectedComponent();
        if (component != null) {
            int signatureStart = bci.getMethod().indexOf(40);
            String name = bci.getMethod().substring(0, signatureStart) + ":" + bci.getByteCodeIndex();
            BreakpointSpecification spec = BreakpointParser.deserialize(BreakpointType.METHOD_BYTE_CODE_INDEX, name);
            this.toggleBreakpoint(spec);
        }
    }

    private void toggleBreakpoint(BreakpointSpecification bp) {
        if (this.breakpoints.breakpointExists(bp.getName())) {
            this.breakpoints.removeBreakpoint(bp);
        } else {
            this.breakpoints.addBreakpoint(bp);
        }
        this.breakpointViewShower.run();
    }

    private void handleBreakpointChange(BreakpointSpecification[] bps) {
        int[] emptyBreakpoints = new int[]{};
        boolean[] emptyEnablement = new boolean[]{};
        for (int i = 0; i < this.view.getTabView().getTabCount(); ++i) {
            JScrollPane pane = (JScrollPane)this.view.getTabView().getComponentAt(i);
            LineNumberPanel lnp = (LineNumberPanel)pane.getRowHeader().getView();
            lnp.updateBreakpoints(emptyBreakpoints, emptyEnablement);
        }
        HashMap<String, ArrayList<Integer>> bpMapping = new HashMap<String, ArrayList<Integer>>();
        HashMap<String, ArrayList<Boolean>> bpEnablement = new HashMap<String, ArrayList<Boolean>>();
        for (BreakpointSpecification b : bps) {
            LineBreakpointSpecification lineBp;
            String path;
            JScrollPane pane;
            if (!(b instanceof LineBreakpointSpecification) || (pane = (JScrollPane)this.viewAdmin.getSourceView(path = (lineBp = (LineBreakpointSpecification)b).getFileName(), null)) == null) continue;
            ArrayList<Integer> list = (ArrayList<Integer>)bpMapping.get(path);
            ArrayList<Boolean> enablement = (ArrayList<Boolean>)bpEnablement.get(path);
            if (list == null) {
                list = new ArrayList<Integer>();
                bpMapping.put(path, list);
                enablement = new ArrayList<Boolean>();
                bpEnablement.put(path, enablement);
            }
            list.add(lineBp.getLineNumber());
            enablement.add(lineBp.isEnabled());
        }
        for (Map.Entry entry : bpMapping.entrySet()) {
            JScrollPane pane = (JScrollPane)this.viewAdmin.getSourceView((String)entry.getKey(), null);
            if (pane == null) continue;
            LineNumberPanel lnp = (LineNumberPanel)pane.getRowHeader().getView();
            int[] lineBps = new int[((List)entry.getValue()).size()];
            boolean[] enablement = new boolean[lineBps.length];
            List enablementList = (List)bpEnablement.get(entry.getKey());
            for (int i = 0; i < lineBps.length; ++i) {
                lineBps[i] = (Integer)((List)entry.getValue()).get(i);
                enablement[i] = (Boolean)enablementList.get(i);
            }
            lnp.updateBreakpoints(lineBps, enablement);
        }
    }

    private void showLinkPage(final String path, String className) {
        URL fileIcon = ImageRepository.getImageUrl("resources/java_file.gif");
        URL addDirIcon = ImageRepository.getImageUrl("resources/folder.gif");
        URL addSuperDirIcon = ImageRepository.getImageUrl("resources/folders.png");
        URL addZipIcon = ImageRepository.getImageUrl("resources/zip_file.gif");
        URL refreshIcon = ImageRepository.getImageUrl("resources/refresh.gif");
        String text = "<div style=\"margin:10px\">Loading of class '" + className + "'  failed.<br/>You can <table><tr><td><img src=\"" + fileIcon + "\"/></td><td><a href=\"" + OPEN_FILE + "\">open it directly</a></td></tr><tr><td><img src=\"" + addDirIcon + "\"/></td><td><a href=\"" + ADD_DIR + "\">add a source directory</a></td></tr><tr><td><img src=\"" + addSuperDirIcon + "\"/></td><td><a href=\"" + ADD_SUPER_DIR + "\">add a super source directory</a></td></tr><tr><td><img src=\"" + addZipIcon + "\"/></td><td><a href=\"" + ADD_ZIP + "\">add a source archive</a></td></tr><tr><td><img src=\"" + refreshIcon + "\"/></td><td><a href=\"" + REFRESH + "\">just try again</a></td></tr></table></div>";
        this.createTab(null, text, path, className, null, EditorType.SOURCE);
        Component component = this.viewAdmin.getSourceView(path, null);
        final JEditorPane editor = this.viewAdmin.getEditor(component);
        editor.setContentType("text/html");
        editor.setText(text);
        editor.setEditable(false);
        this.viewAdmin.registerHyperlinkListener(component, new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                    return;
                }
                String contentTypeBefore = editor.getContentType();
                String linkTarget = e.getDescription();
                if (SourceCodeManager.OPEN_FILE.equals(linkTarget)) {
                    SourceCodeManager.this.openFile();
                } else if (SourceCodeManager.ADD_DIR.equals(linkTarget)) {
                    SourceCodeManager.this.addSourceDir(false);
                    this.refreshTab();
                } else if (SourceCodeManager.ADD_SUPER_DIR.equals(linkTarget)) {
                    SourceCodeManager.this.addSourceDir(true);
                    this.refreshTab();
                } else if (SourceCodeManager.ADD_ZIP.equals(linkTarget)) {
                    SourceCodeManager.this.addSourceZip();
                    this.refreshTab();
                } else if (SourceCodeManager.REFRESH.equals(linkTarget)) {
                    this.refreshTab();
                }
                if (!editor.getContentType().equals(contentTypeBefore)) {
                    editor.setCursor(new Cursor(0));
                }
            }

            private void refreshTab() {
                SourceCodeManager.this.showSource(path, "", 0, 0, 0L, -1, null, false, true);
            }
        });
        this.setCurrent(editor, 0, null, -1);
    }

    public final class SourceCodeManagerInternal {
        public void openFile() {
            SourceCodeManager.this.openFile();
        }

        public void addSourceDir(boolean isSuperSourceDir) {
            SourceCodeManager.this.addSourceDir(isSuperSourceDir);
        }

        public void addSourceZip() {
            SourceCodeManager.this.addSourceZip();
        }

        public void editSourceLookupPaths() {
            SourceCodeManager.this.sourceLookup.editSourceLookupPaths();
        }

        public void redefineClass() {
            SourceCodeManager.this.redefineClass();
        }

        public void disassembleClass() {
            SourceCodeManager.this.disassembleClass(null);
        }

        public void decompileClass() {
            SourceCodeManager.this.decompileClass(null);
        }

        public void closeCurrentEditor() {
            Component component = SourceCodeManager.this.view.getTabView().getSelectedComponent();
            if (component != null) {
                this.removeTab(component);
            }
        }

        public void closeEditors() {
            SourceCodeManager.this.closeEditors();
        }

        public void toggleBetweenDisassemblyAndDecompiledCode() {
            SourceCodeManager.this.toggleBetweenDisassemblyAndDecompiledCode();
        }

        public void removeTab(Component component) {
            SourceCodeManager.this.removeTab(component);
        }

        public boolean isCurrentEditor(JEditorPane pane) {
            return SourceCodeManager.this.current == pane || SourceCodeManager.this.currentAlternative == pane;
        }

        public int getCurrentLine(JEditorPane pane) {
            if (SourceCodeManager.this.current == pane) {
                return SourceCodeManager.this.currentLine;
            }
            if (SourceCodeManager.this.currentAlternative == pane) {
                return SourceCodeManager.this.currentAlternativeLine;
            }
            return -1;
        }

        public JEditorPane getActiveEditor() {
            return SourceCodeManager.this.viewAdmin.getEditor(SourceCodeManager.this.view.getTabView().getSelectedComponent());
        }

        public void inspectSelection() {
            String selection = SourceCodeManager.this.listener.getCurrentSelection();
            SourceCodeManager.this.listener.resetCurrentSelection();
            assert (selection != null);
            QueueHelper.put(SourceCodeManager.this.controller.getWriteQueue(), new AddExpressionPacketImpl(0L, -1, selection));
            SourceCodeManager.this.expressionViewShower.run();
        }

        public void toggleBreakpoint() {
            int line = SourceCodeManager.this.listener.getCurrentLine();
            SourceCodeManager.this.listener.resetCurrentLine();
            assert (line >= 0);
            this.toggleBreakpoint(line);
        }

        public void toggleBreakpoint(int line) {
            Component component = SourceCodeManager.this.view.getTabView().getSelectedComponent();
            EditorType type = SourceCodeManager.this.viewAdmin.getViewType(component);
            if (type == EditorType.DISASSEMBLED_SOURCE || type == EditorType.DECOMPILED_SOURCE) {
                String className = SourceCodeManager.this.viewAdmin.getClassName(component);
                DisassembledClassPacket.MethodByteCodeIndex bci = SourceCodeManager.this.disassemblyManager.getMethodByteCodeIndex(className, type, line);
                if (bci != null) {
                    SourceCodeManager.this.toggleBciBreakpoint(bci);
                }
            } else {
                SourceCodeManager.this.toggleLineBreakpoint(line);
            }
        }

        public String getCurrentClassName() {
            Component component = SourceCodeManager.this.view.getTabView().getSelectedComponent();
            if (SourceCodeManager.this.viewAdmin.getViewType(component) == EditorType.SOURCE) {
                return null;
            }
            return SourceCodeManager.this.viewAdmin.getClassName(component);
        }

        public boolean showsDisassembly(String className) {
            Component component2;
            Component component = SourceCodeManager.this.view.getTabView().getSelectedComponent();
            return component == (component2 = SourceCodeManager.this.viewAdmin.getSourceView(null, className)) && SourceCodeManager.this.viewAdmin.getViewType(component) == EditorType.DISASSEMBLED_SOURCE;
        }

        public boolean showsDecompiledCode(String className) {
            Component component2;
            Component component = SourceCodeManager.this.view.getTabView().getSelectedComponent();
            return component == (component2 = SourceCodeManager.this.viewAdmin.getSourceView(null, className)) && SourceCodeManager.this.viewAdmin.getViewType(component) == EditorType.DECOMPILED_SOURCE;
        }

        public void openTab(File file, String text, String path, URL url) {
            String p = path;
            if (file != null && p == null) {
                p = SourceCodeManager.this.findPathFromFile(file);
            }
            SourceCodeManager.this.createTab(file, text, p, null, url, EditorType.SOURCE);
            JEditorPane editor = SourceCodeManager.this.viewAdmin.getEditor(SourceCodeManager.this.viewAdmin.getSourceView(path, null));
            SourceCodeManager.this.setCurrent(editor, 0, null, -1);
        }

        public void openTabIfAvailable(String path) {
            if (SourceCodeManager.this.viewAdmin.getSourceView(path, null) != null) {
                return;
            }
            SourceCodeManager.this.showSource(path, "", 0, 0, 0L, -1, null, false, false);
        }

        public List<String> getOpenFiles() {
            ArrayList<String> openFiles = new ArrayList<String>();
            for (int i = 0; i < SourceCodeManager.this.view.getTabView().getTabCount(); ++i) {
                String path;
                Component component = SourceCodeManager.this.view.getTabView().getComponentAt(i);
                if (SourceCodeManager.this.viewAdmin.getViewType(component) != EditorType.SOURCE || (path = SourceCodeManager.this.viewAdmin.getSourcePath(component)) == null) continue;
                openFiles.add(path);
            }
            return openFiles;
        }

        public List<File> getSourceFiles() {
            return SourceCodeManager.this.viewAdmin.getSourceFiles();
        }

        public List<URL> getSourceUrls() {
            return SourceCodeManager.this.viewAdmin.getSourceUrls();
        }

        public EditorType getCurrentEditorType() {
            return SourceCodeManager.this.viewAdmin.getViewType(SourceCodeManager.this.view.getTabView().getSelectedComponent());
        }

        public void navigateTo(EditorType targetType) {
            Component component = SourceCodeManager.this.view.getTabView().getSelectedComponent();
            EditorType currentType = SourceCodeManager.this.viewAdmin.getViewType(component);
            if (currentType == null || currentType == targetType) {
                return;
            }
            if (!(currentType != EditorType.DISASSEMBLED_SOURCE && currentType != EditorType.DECOMPILED_SOURCE || targetType != EditorType.DISASSEMBLED_SOURCE && targetType != EditorType.DECOMPILED_SOURCE)) {
                this.toggleBetweenDisassemblyAndDecompiledCode();
                return;
            }
            if (targetType == EditorType.SOURCE) {
                assert (currentType == EditorType.DISASSEMBLED_SOURCE || currentType == EditorType.DECOMPILED_SOURCE);
                String className = SourceCodeManager.this.viewAdmin.getClassName(component);
                String sourcePath = SourceCodeManager.this.viewAdmin.getSourcePath(className);
                if (sourcePath == null) {
                    sourcePath = className.replace('.', '/');
                    int dollar = sourcePath.indexOf(36);
                    if (dollar >= 0) {
                        sourcePath = sourcePath.substring(0, dollar);
                    }
                    sourcePath = sourcePath + ".java";
                }
                String path = sourcePath;
                Component sourceView = SourceCodeManager.this.viewAdmin.getSourceView(path, null);
                if (sourceView != null) {
                    SourceCodeManager.this.view.getTabView().setSelectedComponent(sourceView);
                    return;
                }
                if (SourceCodeManager.this.showSource(path, "", 0, 0, 0L, -1, null, false, false)) {
                    return;
                }
                SourceCodeManager.this.showLinkPage(path, className);
                return;
            }
            assert (targetType == EditorType.DISASSEMBLED_SOURCE || targetType == EditorType.DECOMPILED_SOURCE);
            String path = SourceCodeManager.this.viewAdmin.getSourcePath(component);
            Object[] knownClasses = SourceCodeManager.this.viewAdmin.getKnownClasses(path);
            Arrays.sort(knownClasses);
            if (knownClasses.length == 0) {
                JOptionPane.showMessageDialog(SwingUtilities.getRoot(SourceCodeManager.this.getSource()), "Unfortunately, no classes have been discovered to be in this source file.", "No Classes Known", 0);
                return;
            }
            String className = (String)JOptionPane.showInputDialog(SwingUtilities.getRoot(SourceCodeManager.this.getSource()), "Please choose the navigation target:", "Select Navigation Target", 3, null, knownClasses, knownClasses[0]);
            if (className != null) {
                Component disassemblyView = SourceCodeManager.this.viewAdmin.getSourceView(null, className);
                if (disassemblyView != null) {
                    SourceCodeManager.this.view.getTabView().setSelectedComponent(disassemblyView);
                    if (SourceCodeManager.this.viewAdmin.getViewType(disassemblyView) != targetType) {
                        this.toggleBetweenDisassemblyAndDecompiledCode();
                    }
                    return;
                }
                if (targetType == EditorType.DISASSEMBLED_SOURCE) {
                    SourceCodeManager.this.disassembleClass(className);
                    return;
                }
                assert (targetType == EditorType.DECOMPILED_SOURCE);
                SourceCodeManager.this.decompileClass(className);
            }
        }

        public boolean breakpointExists(int line) {
            Component component = SourceCodeManager.this.view.getTabView().getSelectedComponent();
            EditorType type = SourceCodeManager.this.viewAdmin.getViewType(component);
            if (type == EditorType.DISASSEMBLED_SOURCE || type == EditorType.DECOMPILED_SOURCE) {
                String className = SourceCodeManager.this.viewAdmin.getClassName(component);
                DisassembledClassPacket.MethodByteCodeIndex bci = SourceCodeManager.this.disassemblyManager.getMethodByteCodeIndex(className, type, line);
                if (bci != null) {
                    int signatureStart = bci.getMethod().indexOf(40);
                    String name = bci.getMethod().substring(0, signatureStart) + ":" + bci.getByteCodeIndex();
                    return SourceCodeManager.this.breakpoints.breakpointExists(name);
                }
            } else {
                String path = SourceCodeManager.this.viewAdmin.getSourcePath(component);
                assert (path != null);
                String name = path + ":" + line;
                return SourceCodeManager.this.breakpoints.breakpointExists(name);
            }
            return false;
        }

        public void editSourceCode(boolean enable) {
            JEditorPane editor = this.getActiveEditor();
            if (editor == null) {
                return;
            }
            assert (!this.isShowingLinkPage() && SourceCodeManager.this.viewAdmin.getViewType(SourceCodeManager.this.view.getTabView().getSelectedComponent()) == EditorType.SOURCE);
            editor.setEditable(enable);
        }

        public boolean isShowingLinkPage() {
            JEditorPane editor = this.getActiveEditor();
            if (editor == null) {
                return false;
            }
            return editor.getEditorKit() instanceof HTMLEditorKit;
        }

        public void search(String pattern) {
            SourceCodeManager.this.searchHelper.search(this.getActiveEditor(), pattern);
        }

        public void focusSearchResult(String pattern, int offset) {
            SourceCodeManager.this.searchHelper.focusSearchResult(this.getActiveEditor(), pattern, offset);
        }

        public void scrollToLine(JEditorPane editor, int line) {
            SourceCodeManager.this.scrollToLine(editor, line, false, true);
        }
    }
}

