/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.ui.swing.source;

import com.sap.jvm.debugging.ui.swing.JvmDebugger;
import com.sap.jvm.debugging.ui.swing.source.FileSerializer;
import com.sap.jvm.debugging.ui.swing.source.IdentitySerializer;
import com.sap.jvm.debugging.ui.swing.source.Serializer;
import com.sap.jvm.debugging.ui.swing.source.SourceCodeManager;
import com.sap.jvm.debugging.ui.swing.source.UrlSerializer;
import com.sap.jvm.debugging.ui.swing.source.ZipFileSerializer;
import com.sap.jvm.tracing.Trace;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipFile;

public final class SourceCodeProperties {
    private static final String SOURCE_DIR_COUNT_KEY = "source_dirs";
    private static final String SOURCE_DIR_PREFIX = "source_dir_";
    private static final String SOURCE_ZIP_COUNT_KEY = "source_zips";
    private static final String SOURCE_ZIP_PREFIX = "source_zip_";
    private static final String SUPER_SOURCE_DIR_COUNT_KEY = "super_source_dirs";
    private static final String SUPER_SOURCE_DIR_PREFIX = "super_source_dir_";
    private static final String SOURCE_TAB_COUNT_KEY = "source_tabs";
    private static final String SOURCE_TAB_PREFIX = "source_tab_";
    private static final String SOURCE_FILE_TAB_COUNT_KEY = "source_file_tabs";
    private static final String SOURCE_FILE_TAB_PREFIX = "source_file_tab_";
    private static final String SOURCE_URL_TAB_COUNT_KEY = "source_url_tabs";
    private static final String SOURCE_URL_TAB_PREFIX = "source_url_tab_";
    private static final String LAST_USED_DIRECTORY = "last_used_directory";
    private final SourceCodeManager.SourceCodeManagerInternal internal;
    private JvmDebugger.SwingDebugger context = null;

    public SourceCodeProperties(SourceCodeManager.SourceCodeManagerInternal internal) {
        this.internal = internal;
    }

    public void setContext(JvmDebugger.SwingDebugger context) {
        assert (this.context == null && context != null);
        this.context = context;
    }

    public List<File> getSourceDirs() {
        return this.getSourceDirsImpl("com.sap.jvm.debugging.ui.source");
    }

    public List<File> getSuperSourceDirs() {
        return this.getSourceDirsImpl("com.sap.jvm.debugging.ui.super.source");
    }

    private List<File> getSourceDirsImpl(String property) {
        String[] dirs;
        String sourceDirs = System.getProperty(property);
        if (sourceDirs == null) {
            return Collections.emptyList();
        }
        ArrayList<File> result = new ArrayList<File>();
        for (String d : dirs = sourceDirs.split(File.pathSeparator)) {
            File file = new File(d);
            if (!file.exists() || !file.isDirectory()) continue;
            result.add(file);
        }
        return result;
    }

    public List<ZipFile> getSourceZips() {
        String[] zips;
        String sourceZipFiles = System.getProperty("com.sap.jvm.debugging.ui.source.zip");
        if (sourceZipFiles == null) {
            return Collections.emptyList();
        }
        ArrayList<ZipFile> result = new ArrayList<ZipFile>();
        for (String z : zips = sourceZipFiles.split(File.pathSeparator)) {
            File file = new File(z);
            if (!file.exists() || !file.isFile()) continue;
            try {
                ZipFile zipFile = new ZipFile(file);
                result.add(zipFile);
            }
            catch (IOException e) {
                Trace.warn((Throwable)e, () -> "Exception while opening zip file '" + z + "'");
            }
        }
        return result;
    }

    public void updateSourceProperties(List<File> sourceBase, List<ZipFile> sourceZips, List<File> superSourceBase, List<String> openFiles, List<File> sourceFiles, List<URL> sourceUrls) {
        Properties properties = this.context.getProperties();
        this.updateSourcePropertiesImpl(properties, SOURCE_DIR_COUNT_KEY, SOURCE_DIR_PREFIX, sourceBase, new FileSerializer());
        this.updateSourcePropertiesImpl(properties, SOURCE_ZIP_COUNT_KEY, SOURCE_ZIP_PREFIX, sourceZips, new ZipFileSerializer());
        this.updateSourcePropertiesImpl(properties, SUPER_SOURCE_DIR_COUNT_KEY, SUPER_SOURCE_DIR_PREFIX, superSourceBase, new FileSerializer());
        this.updateSourcePropertiesImpl(properties, SOURCE_TAB_COUNT_KEY, SOURCE_TAB_PREFIX, openFiles, new IdentitySerializer());
        this.updateSourcePropertiesImpl(properties, SOURCE_FILE_TAB_COUNT_KEY, SOURCE_FILE_TAB_PREFIX, sourceFiles, new FileSerializer());
        this.updateSourcePropertiesImpl(properties, SOURCE_URL_TAB_COUNT_KEY, SOURCE_URL_TAB_PREFIX, sourceUrls, new UrlSerializer());
    }

    private void updateSourcePropertiesImpl(Properties properties, String countKey, String prefix, List<?> sources, Serializer serializer) {
        int i;
        int oldCount = Integer.parseInt(properties.getProperty(countKey, "0"));
        int newCount = sources.size();
        properties.setProperty(countKey, Integer.toString(newCount));
        for (i = newCount; i < oldCount; ++i) {
            properties.remove(prefix + i);
        }
        for (i = 0; i < newCount; ++i) {
            properties.setProperty(prefix + i, serializer.serialize(sources.get(i)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertiesChanged(List<File> sourceBase, List<ZipFile> sourceZips, List<File> superSourceBase) {
        Properties properties = this.context.getProperties();
        this.propertiesChangedImpl(properties, SOURCE_DIR_COUNT_KEY, SOURCE_DIR_PREFIX, sourceBase, new FileSerializer());
        this.propertiesChangedImpl(properties, SOURCE_ZIP_COUNT_KEY, SOURCE_ZIP_PREFIX, sourceZips, new ZipFileSerializer());
        this.propertiesChangedImpl(properties, SUPER_SOURCE_DIR_COUNT_KEY, SUPER_SOURCE_DIR_PREFIX, superSourceBase, new FileSerializer());
        ArrayList openTabs = new ArrayList();
        this.propertiesChangedImpl(properties, SOURCE_TAB_COUNT_KEY, SOURCE_TAB_PREFIX, openTabs, new IdentitySerializer());
        ArrayList openFiles = new ArrayList();
        this.propertiesChangedImpl(properties, SOURCE_FILE_TAB_COUNT_KEY, SOURCE_FILE_TAB_PREFIX, openFiles, new FileSerializer());
        for (File file : openFiles) {
            if (!file.exists()) continue;
            this.internal.openTab(file, null, null, null);
        }
        ArrayList openUrls = new ArrayList();
        this.propertiesChangedImpl(properties, SOURCE_URL_TAB_COUNT_KEY, SOURCE_URL_TAB_PREFIX, openUrls, new UrlSerializer());
        for (URL url : openUrls) {
            InputStream is = null;
            BufferedReader reader = null;
            try {
                String str;
                JarURLConnection connection = (JarURLConnection)url.openConnection();
                connection.setUseCaches(false);
                is = connection.getInputStream();
                reader = new BufferedReader(new InputStreamReader(is));
                StringBuilder text = new StringBuilder();
                String lineSeparator = System.getProperty("line.separator");
                while ((str = reader.readLine()) != null) {
                    text.append(str);
                    text.append(lineSeparator);
                }
                String path = connection.getEntryName();
                this.internal.openTab(null, text.toString(), path, url);
            }
            catch (IOException e) {
                Trace.warn((Throwable)e, () -> "Exception restoring source code from '" + url + "'");
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        Trace.warn((Throwable)e, () -> "Exception while closing reader of url '" + url + "'");
                    }
                    continue;
                }
                if (is == null) continue;
                try {
                    is.close();
                }
                catch (IOException e) {
                    Trace.warn((Throwable)e, () -> "Exception while closing stream of url '" + url + "'");
                }
            }
        }
        for (String path : openTabs) {
            this.internal.openTabIfAvailable(path);
        }
    }

    private void propertiesChangedImpl(Properties properties, String countKey, String prefix, List<?> sources, Serializer serializer) {
        List<?> sourceList = sources;
        int count = Integer.parseInt(properties.getProperty(countKey, "0"));
        for (int i = 0; i < count; ++i) {
            Object object;
            String property = properties.getProperty(prefix + i);
            if (property == null || (object = serializer.deserialize(property)) == null) continue;
            sourceList.add(object);
        }
    }

    public String getLastUsedDirectory() {
        return this.context.getProperties().getProperty(LAST_USED_DIRECTORY);
    }

    public void setLastUsedDirectory(String dir) {
        this.context.getProperties().setProperty(LAST_USED_DIRECTORY, dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportProperties(File targetFile, List<File> sourceBase, List<File> superSourceBase, List<ZipFile> sourceZips) {
        Properties properties = new Properties();
        this.updateSourcePropertiesImpl(properties, SOURCE_DIR_COUNT_KEY, SOURCE_DIR_PREFIX, sourceBase, new FileSerializer());
        this.updateSourcePropertiesImpl(properties, SOURCE_ZIP_COUNT_KEY, SOURCE_ZIP_PREFIX, sourceZips, new ZipFileSerializer());
        this.updateSourcePropertiesImpl(properties, SUPER_SOURCE_DIR_COUNT_KEY, SUPER_SOURCE_DIR_PREFIX, superSourceBase, new FileSerializer());
        FilterOutputStream os = null;
        try {
            os = new BufferedOutputStream(new FileOutputStream(targetFile));
            properties.store(os, "sap jvm debugger source lookup configuration");
        }
        catch (IOException e) {
            Trace.warn((Throwable)e, (String)"Error while storing debugger source lookup configuration.");
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    Trace.warn((Throwable)e, (String)"Error while storing debugger source lookup configuration.");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importProperties(File sourceFile, List<File> sourceBase, List<File> superSourceBase, List<ZipFile> sourceZips) {
        Properties properties = new Properties();
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(sourceFile));
            properties.load(is);
        }
        catch (IOException e) {
            Trace.warn((Throwable)e, (String)"Error while loading debugger source lookup configuration");
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    Trace.warn((Throwable)e, (String)"Error while loading debugger source lookup configuration.");
                }
            }
        }
        this.propertiesChangedImpl(properties, SOURCE_DIR_COUNT_KEY, SOURCE_DIR_PREFIX, sourceBase, new FileSerializer());
        this.propertiesChangedImpl(properties, SOURCE_ZIP_COUNT_KEY, SOURCE_ZIP_PREFIX, sourceZips, new ZipFileSerializer());
        this.propertiesChangedImpl(properties, SUPER_SOURCE_DIR_COUNT_KEY, SUPER_SOURCE_DIR_PREFIX, superSourceBase, new FileSerializer());
    }
}

