/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.ui.swing.source;

import com.sap.jvm.debugging.ui.swing.icons.ImageRepository;
import com.sap.jvm.debugging.ui.swing.source.CancelableTextField;
import com.sap.jvm.debugging.ui.swing.source.EditorType;
import com.sap.jvm.debugging.ui.swing.source.SourceCodeManager;
import com.sap.jvm.debugging.ui.swing.source.TabCloseButton;
import com.sap.jvm.tracing.Trace;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public final class SourceCodeView {
    private final SourceCodeManager.SourceCodeManagerInternal internal;
    private final JPanel sourceView;
    private final JTabbedPane tabView;
    private final Method setTabComponentAt;
    private final JToolBar toolbar;
    private final JButton openFileToolbarButton;
    private final JButton addSourceDirToolbarButton;
    private final JButton addSuperSourceDirToolbarButton;
    private final JButton addSourceZipToolbarButton;
    private final JButton sourceLookupToolbarButton;
    private final JToggleButton editSourceToolbarButton;
    private final JButton closeSourceToolbarButton;
    private final JButton redefineClassToolbarButton;
    private final JButton disassembleClassToolbarButton;
    private final JButton decompileClassToolbarButton;
    private final JButton gotoSourceToolbarButton;
    private final JButton gotoDisassemblyToolbarButton;
    private final JButton gotoDecompiledCodeToolbarButton;
    private final JButton closeEditorsToolbarButton;
    private final CancelableTextField searchToolbarField;
    private final JButton previousToolbarButton;
    private final JButton nextToolbarButton;
    private final JTextField lineToolbarField;
    private final JPopupMenu contextMenu;
    private final JMenuItem inspectContextMenuItem;
    private final JMenuItem addLineBreakpointContextMenuItem;
    private final JMenuItem removeLineBreakpointContextMenuItem;
    private final JMenuItem switchToDisassemblyContextMenuItem;
    private final JMenuItem switchToDecompiledCodeContextMenuItem;

    public SourceCodeView(final SourceCodeManager.SourceCodeManagerInternal internal) {
        this.internal = internal;
        this.tabView = new JTabbedPane();
        this.tabView.setTabLayoutPolicy(1);
        this.toolbar = new JToolBar();
        ImageIcon sourceIcon = ImageRepository.getImage("resources/java_file.gif", "Java file");
        this.openFileToolbarButton = new JButton(sourceIcon);
        this.openFileToolbarButton.setToolTipText("Open File");
        this.openFileToolbarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                internal.openFile();
            }
        });
        this.toolbar.add(this.openFileToolbarButton);
        this.addSourceDirToolbarButton = new JButton(ImageRepository.getImage("resources/folder.gif", "Folder"));
        this.addSourceDirToolbarButton.setToolTipText("Add Source Directory");
        this.addSourceDirToolbarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                internal.addSourceDir(false);
            }
        });
        this.toolbar.add(this.addSourceDirToolbarButton);
        this.addSuperSourceDirToolbarButton = new JButton(ImageRepository.getImage("resources/folders.png", "Folders"));
        this.addSuperSourceDirToolbarButton.setToolTipText("Add Super Source Directory");
        this.addSuperSourceDirToolbarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                internal.addSourceDir(true);
            }
        });
        this.toolbar.add(this.addSuperSourceDirToolbarButton);
        this.addSourceZipToolbarButton = new JButton(ImageRepository.getImage("resources/zip_file.gif", "Zip file"));
        this.addSourceZipToolbarButton.setToolTipText("Add Source Zip File");
        this.addSourceZipToolbarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                internal.addSourceZip();
            }
        });
        this.toolbar.add(this.addSourceZipToolbarButton);
        this.sourceLookupToolbarButton = new JButton(ImageRepository.getImage("resources/source_lookup.gif", "Source Code Lookup"));
        this.sourceLookupToolbarButton.setToolTipText("Edit Source Lookup");
        this.sourceLookupToolbarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                internal.editSourceLookupPaths();
            }
        });
        this.toolbar.add(this.sourceLookupToolbarButton);
        this.toolbar.addSeparator();
        this.editSourceToolbarButton = new JToggleButton(ImageRepository.getImage("resources/edit_source.gif", "Edit Source Code"), false);
        this.editSourceToolbarButton.setToolTipText("Edit Source Code");
        this.editSourceToolbarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                internal.editSourceCode(SourceCodeView.this.editSourceToolbarButton.isSelected());
            }
        });
        this.toolbar.add(this.editSourceToolbarButton);
        this.toolbar.addSeparator();
        this.redefineClassToolbarButton = new JButton(ImageRepository.createIconWithOverlay(ImageRepository.getImage("resources/class.gif", "Class"), null, ImageRepository.getImage("resources/overlay_replace.gif", "Replace"), null, null));
        this.redefineClassToolbarButton.setToolTipText("Redefine Class");
        this.redefineClassToolbarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                internal.redefineClass();
            }
        });
        this.toolbar.add(this.redefineClassToolbarButton);
        this.toolbar.addSeparator();
        ImageIcon disassemblyIcon = ImageRepository.getImage("resources/disassembly.gif", "Disassembly");
        this.disassembleClassToolbarButton = new JButton(disassemblyIcon);
        this.disassembleClassToolbarButton.setToolTipText("Disassemble Class");
        this.disassembleClassToolbarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                internal.disassembleClass();
            }
        });
        this.toolbar.add(this.disassembleClassToolbarButton);
        ImageIcon decompiledCodeIcon = ImageRepository.getImage("resources/decompiled_code.gif", "Decompiled code");
        this.decompileClassToolbarButton = new JButton(decompiledCodeIcon);
        this.decompileClassToolbarButton.setToolTipText("Decompile Class");
        this.decompileClassToolbarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                internal.decompileClass();
            }
        });
        this.toolbar.add(this.decompileClassToolbarButton);
        this.toolbar.addSeparator();
        ImageIcon nextIcon = ImageRepository.getImage("resources/next.png", "Next");
        this.gotoSourceToolbarButton = new JButton(ImageRepository.createIconWithOverlay(sourceIcon, null, nextIcon, null, null));
        this.gotoSourceToolbarButton.setToolTipText("Goto Source File");
        this.gotoSourceToolbarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                internal.navigateTo(EditorType.SOURCE);
            }
        });
        this.gotoSourceToolbarButton.setEnabled(false);
        this.toolbar.add(this.gotoSourceToolbarButton);
        this.gotoDisassemblyToolbarButton = new JButton(ImageRepository.createIconWithOverlay(disassemblyIcon, null, nextIcon, null, null));
        this.gotoDisassemblyToolbarButton.setToolTipText("Goto Disassembly...");
        this.gotoDisassemblyToolbarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                internal.navigateTo(EditorType.DISASSEMBLED_SOURCE);
            }
        });
        this.gotoDisassemblyToolbarButton.setEnabled(false);
        this.toolbar.add(this.gotoDisassemblyToolbarButton);
        this.gotoDecompiledCodeToolbarButton = new JButton(ImageRepository.createIconWithOverlay(decompiledCodeIcon, null, nextIcon, null, null));
        this.gotoDecompiledCodeToolbarButton.setToolTipText("Goto Decompiled Code...");
        this.gotoDecompiledCodeToolbarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                internal.navigateTo(EditorType.DECOMPILED_SOURCE);
            }
        });
        this.gotoDecompiledCodeToolbarButton.setEnabled(false);
        this.toolbar.add(this.gotoDecompiledCodeToolbarButton);
        this.toolbar.addSeparator();
        this.closeSourceToolbarButton = new JButton(ImageRepository.getImage("resources/remove.gif", "Close"));
        this.closeSourceToolbarButton.setToolTipText("Close the current Source File");
        this.closeSourceToolbarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                internal.closeCurrentEditor();
            }
        });
        this.toolbar.add(this.closeSourceToolbarButton);
        this.closeSourceToolbarButton.setVisible(false);
        this.closeEditorsToolbarButton = new JButton(ImageRepository.getImage("resources/remove_grey_all.gif", "Close Editors"));
        this.closeEditorsToolbarButton.setToolTipText("Close all Editors");
        this.closeEditorsToolbarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                internal.closeEditors();
            }
        });
        this.toolbar.add(this.closeEditorsToolbarButton);
        this.toolbar.addSeparator();
        JLabel searchLabel = new JLabel("Search:");
        searchLabel.setToolTipText("Search pattern (Ctrl-F)");
        this.toolbar.add(searchLabel);
        this.searchToolbarField = new CancelableTextField(20, "<enter a string to search>");
        this.searchToolbarField.setToolTipText("Search pattern (Ctrl-F)");
        this.searchToolbarField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateSearch();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateSearch();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateSearch();
            }

            private void updateSearch() {
                internal.search(SourceCodeView.this.searchToolbarField.getRealText());
            }
        });
        this.searchToolbarField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                internal.search(SourceCodeView.this.searchToolbarField.getRealText());
            }
        });
        boolean isMacOS = System.getProperty("os.name").startsWith("Mac OS X");
        String actionKey = "setSearchFocus";
        this.searchToolbarField.getInputMap(2).put(KeyStroke.getKeyStroke(70, isMacOS ? 4 : 2), actionKey);
        this.searchToolbarField.getActionMap().put(actionKey, new AbstractAction(){
            private static final long serialVersionUID = -3861986587969679391L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SourceCodeView.this.searchToolbarField.requestFocus();
                SourceCodeView.this.searchToolbarField.setSelectionStart(0);
                SourceCodeView.this.searchToolbarField.setSelectionEnd(SourceCodeView.this.searchToolbarField.getRealText().length());
            }
        });
        actionKey = "resetSearchField";
        this.searchToolbarField.getInputMap(0).put(KeyStroke.getKeyStroke("ESCAPE"), actionKey);
        this.searchToolbarField.getActionMap().put(actionKey, new AbstractAction(){
            private static final long serialVersionUID = -1780854514327480423L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SourceCodeView.this.searchToolbarField.cancel();
            }
        });
        this.toolbar.add(this.searchToolbarField);
        this.previousToolbarButton = new JButton(ImageRepository.getImage("resources/arrow_up.gif", "Back"));
        this.previousToolbarButton.setToolTipText("Focus previous search match (Ctrl-F3)");
        this.previousToolbarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                internal.focusSearchResult(SourceCodeView.this.searchToolbarField.getRealText(), -1);
            }
        });
        actionKey = "previousSearchResult";
        this.previousToolbarButton.getInputMap(2).put(KeyStroke.getKeyStroke(114, isMacOS ? 4 : 2), actionKey);
        this.previousToolbarButton.getActionMap().put(actionKey, new AbstractAction(){
            private static final long serialVersionUID = -7645381512257961147L;

            @Override
            public void actionPerformed(ActionEvent e) {
                internal.focusSearchResult(SourceCodeView.this.searchToolbarField.getRealText(), -1);
            }
        });
        this.toolbar.add(this.previousToolbarButton);
        this.nextToolbarButton = new JButton(ImageRepository.getImage("resources/arrow_down.gif", "Forward"));
        this.nextToolbarButton.setToolTipText("Focus next search match (F3)");
        this.nextToolbarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                internal.focusSearchResult(SourceCodeView.this.searchToolbarField.getRealText(), 1);
            }
        });
        actionKey = "nextSearchResult";
        this.nextToolbarButton.getInputMap(2).put(KeyStroke.getKeyStroke(114, 0), actionKey);
        this.nextToolbarButton.getActionMap().put(actionKey, new AbstractAction(){
            private static final long serialVersionUID = -8532076332476691421L;

            @Override
            public void actionPerformed(ActionEvent e) {
                internal.focusSearchResult(SourceCodeView.this.searchToolbarField.getRealText(), 1);
            }
        });
        this.toolbar.add(this.nextToolbarButton);
        this.toolbar.addSeparator();
        JLabel gotoLabel = new JLabel("Line:");
        gotoLabel.setToolTipText("Go to Line (Ctrl-L)");
        this.toolbar.add(gotoLabel);
        this.lineToolbarField = new JTextField(4);
        this.lineToolbarField.setToolTipText("Go to Line (Ctrl-L)");
        this.lineToolbarField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String lineNumber = SourceCodeView.this.lineToolbarField.getText();
                if (lineNumber == null || (lineNumber = lineNumber.trim()).length() == 0) {
                    return;
                }
                try {
                    int line = Integer.parseInt(lineNumber);
                    internal.scrollToLine(internal.getActiveEditor(), line);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        actionKey = "gotoLine";
        this.lineToolbarField.getInputMap(2).put(KeyStroke.getKeyStroke(76, isMacOS ? 4 : 2), actionKey);
        this.lineToolbarField.getInputMap(2).put(KeyStroke.getKeyStroke(71, isMacOS ? 4 : 2), actionKey);
        this.lineToolbarField.getActionMap().put(actionKey, new AbstractAction(){
            private static final long serialVersionUID = -2553777172026983096L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SourceCodeView.this.lineToolbarField.requestFocus();
                SourceCodeView.this.lineToolbarField.setSelectionStart(0);
                SourceCodeView.this.lineToolbarField.setSelectionEnd(SourceCodeView.this.lineToolbarField.getText().length());
            }
        });
        this.toolbar.add(this.lineToolbarField);
        this.sourceView = new JPanel(new BorderLayout());
        this.sourceView.add((Component)this.toolbar, "First");
        this.sourceView.add((Component)this.tabView, "Center");
        this.contextMenu = new JPopupMenu();
        this.inspectContextMenuItem = new JMenuItem("Inspect Selection", ImageRepository.getImage("resources/variable_expression.gif", "Expression variable"));
        this.inspectContextMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                internal.inspectSelection();
            }
        });
        this.contextMenu.add(this.inspectContextMenuItem);
        this.addLineBreakpointContextMenuItem = new JMenuItem("Add Line Breakpoint", ImageRepository.getImage("resources/breakpoint.gif", "Breakpoint"));
        this.addLineBreakpointContextMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                internal.toggleBreakpoint();
            }
        });
        this.contextMenu.add(this.addLineBreakpointContextMenuItem);
        this.removeLineBreakpointContextMenuItem = new JMenuItem("Remove Line Breakpoint", ImageRepository.getImage("resources/ignore_breakpoint.gif", "Remove Breakpoint"));
        this.removeLineBreakpointContextMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                internal.toggleBreakpoint();
            }
        });
        this.contextMenu.add(this.removeLineBreakpointContextMenuItem);
        this.switchToDisassemblyContextMenuItem = new JMenuItem("Switch to Disassembly", disassemblyIcon);
        this.switchToDisassemblyContextMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                internal.toggleBetweenDisassemblyAndDecompiledCode();
            }
        });
        this.contextMenu.add(this.switchToDisassemblyContextMenuItem);
        this.switchToDecompiledCodeContextMenuItem = new JMenuItem("Switch to Decompiled Code", decompiledCodeIcon);
        this.switchToDecompiledCodeContextMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                internal.toggleBetweenDisassemblyAndDecompiledCode();
            }
        });
        this.contextMenu.add(this.switchToDecompiledCodeContextMenuItem);
        Method m = null;
        try {
            m = JTabbedPane.class.getMethod("setTabComponentAt", Integer.TYPE, Component.class);
        }
        catch (SecurityException e) {
            Trace.warn((Throwable)e, (String)"Exception while looking up method setTabComponentAt.");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        this.setTabComponentAt = m;
        this.tabView.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SourceCodeView.this.updateNavigationButtons();
            }
        });
    }

    public JComponent getSource() {
        return this.sourceView;
    }

    public void updateButtons(boolean enabled) {
        this.redefineClassToolbarButton.setEnabled(enabled);
        this.disassembleClassToolbarButton.setEnabled(enabled);
        this.decompileClassToolbarButton.setEnabled(enabled);
        this.inspectContextMenuItem.setEnabled(enabled);
    }

    public JTabbedPane getTabView() {
        return this.tabView;
    }

    public void setInspectMenuItemVisible(boolean isVisible) {
        this.inspectContextMenuItem.setVisible(isVisible);
    }

    public void setAddLineBreakpointMenuItemVisible(boolean isVisible) {
        this.addLineBreakpointContextMenuItem.setVisible(isVisible);
    }

    public void setRemoveLineBreakpointMenuItemVisible(boolean isVisible) {
        this.removeLineBreakpointContextMenuItem.setVisible(isVisible);
    }

    public void setSwitchToDisassemblyMenuItemVisible(boolean isVisible) {
        this.switchToDisassemblyContextMenuItem.setVisible(isVisible);
    }

    public void setSwitchToDecompiledCodeMenuItemVisible(boolean isVisible) {
        this.switchToDecompiledCodeContextMenuItem.setVisible(isVisible);
    }

    public void showContextMenu(Component parent, int x, int y) {
        if (this.inspectContextMenuItem.isVisible() || this.addLineBreakpointContextMenuItem.isVisible() || this.removeLineBreakpointContextMenuItem.isVisible() || this.switchToDisassemblyContextMenuItem.isVisible() || this.switchToDecompiledCodeContextMenuItem.isVisible()) {
            this.contextMenu.show(parent, x, y);
        }
    }

    public Icon getSourceDirIcon() {
        return this.addSourceDirToolbarButton.getIcon();
    }

    public Icon getSuperSourceDirIcon() {
        return this.addSuperSourceDirToolbarButton.getIcon();
    }

    public Icon getSourceZipIcon() {
        return this.addSourceZipToolbarButton.getIcon();
    }

    public void updateNavigationButtons() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditorType type = null;
                try {
                    type = SourceCodeView.this.internal.getCurrentEditorType();
                }
                catch (IllegalArgumentException e) {
                    SwingUtilities.invokeLater(this);
                    return;
                }
                if (type == null) {
                    SourceCodeView.this.gotoSourceToolbarButton.setEnabled(false);
                    SourceCodeView.this.gotoDisassemblyToolbarButton.setEnabled(false);
                    SourceCodeView.this.gotoDecompiledCodeToolbarButton.setEnabled(false);
                    SourceCodeView.this.editSourceToolbarButton.setEnabled(false);
                } else {
                    SourceCodeView.this.gotoSourceToolbarButton.setEnabled(true);
                    SourceCodeView.this.gotoDisassemblyToolbarButton.setEnabled(true);
                    SourceCodeView.this.gotoDecompiledCodeToolbarButton.setEnabled(true);
                    SourceCodeView.this.editSourceToolbarButton.setEnabled(false);
                    if (type == EditorType.SOURCE) {
                        SourceCodeView.this.gotoSourceToolbarButton.setEnabled(false);
                        SourceCodeView.this.editSourceToolbarButton.setEnabled(!SourceCodeView.this.internal.isShowingLinkPage());
                    } else if (type == EditorType.DISASSEMBLED_SOURCE) {
                        SourceCodeView.this.gotoDisassemblyToolbarButton.setEnabled(false);
                    } else if (type == EditorType.DECOMPILED_SOURCE) {
                        SourceCodeView.this.gotoDecompiledCodeToolbarButton.setEnabled(false);
                    }
                }
            }
        });
    }

    public void addTabCloseButton(int index, Component component, EditorType type) {
        boolean closeButtonNeeded = true;
        if (this.setTabComponentAt != null) {
            try {
                this.setTabComponentAt.invoke((Object)this.tabView, index, this.createTabHeader(component, type));
                closeButtonNeeded = false;
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                Trace.warn((Throwable)e, (String)"Exception while setting tab header.");
            }
        }
        if (closeButtonNeeded) {
            this.closeSourceToolbarButton.setVisible(true);
        }
    }

    private JPanel createTabHeader(Component component, EditorType type) {
        JPanel panel = new JPanel(new FlowLayout(0, 0, 0));
        panel.setOpaque(false);
        int index = this.tabView.indexOfComponent(component);
        assert (index >= 0);
        String title = this.tabView.getTitleAt(index);
        JLabel label = new JLabel(title);
        label.setIcon(type.getIcon());
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        panel.add(label);
        TabCloseButton button = new TabCloseButton(this.internal, component);
        panel.add(button);
        return panel;
    }
}

