/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.ui.swing.source;

import com.sap.jvm.debugging.ui.swing.source.EditorType;
import com.sap.jvm.debugging.ui.swing.source.LinePainter;
import java.awt.Component;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkListener;

public final class SourceCodeViewAdministration {
    private final Map<String, JScrollPane> path2SourceView = new HashMap<String, JScrollPane>();
    private final Map<String, JScrollPane> class2DisassemblyView = new HashMap<String, JScrollPane>();
    private final Map<String, String> class2Path = new HashMap<String, String>();
    private final Map<String, Set<String>> path2Classes = new HashMap<String, Set<String>>();
    private final Map<JScrollPane, EditorType> view2Type = new HashMap<JScrollPane, EditorType>();
    private final Map<JScrollPane, String> view2Id = new HashMap<JScrollPane, String>();
    private final Map<JScrollPane, File> view2File = new HashMap<JScrollPane, File>();
    private final Map<JScrollPane, URL> view2Url = new HashMap<JScrollPane, URL>();
    private final Map<JScrollPane, LinePainter> view2Painter = new HashMap<JScrollPane, LinePainter>();
    private final Map<JScrollPane, HyperlinkListener> view2Listeners = new HashMap<JScrollPane, HyperlinkListener>();

    public boolean isDisassemblyView(Component view) {
        return this.view2Type.get(view) == EditorType.DISASSEMBLED_SOURCE;
    }

    public EditorType getViewType(Component view) {
        EditorType result = this.view2Type.get(view);
        if (result == null && view != null) {
            throw new IllegalArgumentException("View unknown: " + view);
        }
        return result;
    }

    public void updateViewType(Component view, EditorType type) {
        this.view2Type.put((JScrollPane)view, type);
    }

    public Component getSourceView(String path, String className) {
        JScrollPane result = this.path2SourceView.get(path);
        if (result != null) {
            return result;
        }
        return this.class2DisassemblyView.get(className);
    }

    public JEditorPane getEditor(Component view) {
        if (view == null) {
            return null;
        }
        return (JEditorPane)((JScrollPane)view).getViewport().getView();
    }

    public void registerView(String path, String className, Component component, EditorType type, File file, URL url, LinePainter painter) {
        JScrollPane pane = (JScrollPane)component;
        this.view2Type.put(pane, type);
        if (type == EditorType.SOURCE) {
            this.path2SourceView.put(path, pane);
            this.view2Id.put(pane, path);
        } else {
            assert (className != null);
            this.class2DisassemblyView.put(className, pane);
            this.view2Id.put(pane, className);
        }
        this.registerClassMapping(path, className);
        if (file != null) {
            this.view2File.put(pane, file);
        }
        if (url != null) {
            this.view2Url.put(pane, url);
        }
        this.view2Painter.put(pane, painter);
        this.removeListener(pane);
    }

    public void registerClassMapping(String path, String className) {
        String clazz = className;
        if (clazz == null && (clazz = path.replace('/', '.')).endsWith(".java")) {
            clazz = clazz.substring(0, clazz.length() - ".java".length());
        }
        if (clazz != null) {
            this.class2Path.put(clazz, path);
            Set<String> classes = this.path2Classes.get(path);
            if (classes == null) {
                classes = new HashSet<String>();
                this.path2Classes.put(path, classes);
            }
            classes.add(clazz);
        }
    }

    public void registerHyperlinkListener(Component component, HyperlinkListener listener) {
        this.removeListener(component);
        JEditorPane editor = this.getEditor(component);
        if (editor != null) {
            this.view2Listeners.put((JScrollPane)component, listener);
            editor.addHyperlinkListener(listener);
        }
    }

    public void deregisterView(Component component) {
        JScrollPane pane = (JScrollPane)component;
        EditorType type = this.view2Type.remove(pane);
        String id = this.view2Id.remove(pane);
        if (type == EditorType.SOURCE) {
            this.path2SourceView.remove(id);
        } else if (type == EditorType.DISASSEMBLED_SOURCE || type == EditorType.DECOMPILED_SOURCE) {
            this.class2DisassemblyView.remove(id);
        }
        this.view2File.remove(pane);
        this.view2Url.remove(pane);
        this.view2Painter.remove(pane);
        this.removeListener(pane);
    }

    public String[] getKnownClasses(String path) {
        Set<String> result = this.path2Classes.get(path);
        if (result == null) {
            result = Collections.emptySet();
        }
        return result.toArray(new String[result.size()]);
    }

    public String getSourcePath(String className) {
        return this.class2Path.get(className);
    }

    public String getSourcePath(Component component) {
        JScrollPane pane = (JScrollPane)component;
        assert (this.view2Type.get(pane) == EditorType.SOURCE);
        return this.view2Id.get(pane);
    }

    public String getClassName(Component component) {
        JScrollPane pane = (JScrollPane)component;
        assert (this.view2Type.get(pane) == EditorType.DISASSEMBLED_SOURCE || this.view2Type.get(pane) == EditorType.DECOMPILED_SOURCE);
        return this.view2Id.get(pane);
    }

    public List<File> getSourceFiles() {
        return new ArrayList<File>(this.view2File.values());
    }

    public List<URL> getSourceUrls() {
        return new ArrayList<URL>(this.view2Url.values());
    }

    public void updateLinePainters() {
        for (LinePainter painter : this.view2Painter.values()) {
            painter.update();
        }
    }

    public LinePainter getPainter(Component component) {
        return this.view2Painter.get(component);
    }

    private void removeListener(Component component) {
        JEditorPane editor;
        HyperlinkListener listener = this.view2Listeners.remove(component);
        if (listener != null && (editor = this.getEditor(component)) != null) {
            editor.removeHyperlinkListener(listener);
        }
    }
}

