/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.ui.swing.source;

import com.sap.jvm.debugging.ui.swing.dialog.SourcePathMaintenanceDialog;
import com.sap.jvm.debugging.ui.swing.icons.ImageRepository;
import com.sap.jvm.debugging.ui.swing.source.DirectoryFileFilter;
import com.sap.jvm.debugging.ui.swing.source.FileSerializer;
import com.sap.jvm.debugging.ui.swing.source.Serializer;
import com.sap.jvm.debugging.ui.swing.source.SourceCodeManager;
import com.sap.jvm.debugging.ui.swing.source.SourceCodeProperties;
import com.sap.jvm.debugging.ui.swing.source.SourceCodeView;
import com.sap.jvm.debugging.ui.swing.source.ZipFileFilter;
import com.sap.jvm.debugging.ui.swing.source.ZipFileSerializer;
import com.sap.jvm.tracing.Trace;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public final class SourceLookup {
    private final SourceCodeManager.SourceCodeManagerInternal internal;
    private final SourceCodeProperties sourceProperties;
    private final SourceCodeView view;
    private final List<File> sourceBase = new ArrayList<File>();
    private final List<File> superSourceBase = new ArrayList<File>();
    private final List<ZipFile> sourceZips = new ArrayList<ZipFile>();

    public SourceLookup(SourceCodeManager.SourceCodeManagerInternal internal, SourceCodeProperties sourceProperties, SourceCodeView view) {
        this.internal = internal;
        this.sourceProperties = sourceProperties;
        this.view = view;
        this.sourceBase.addAll(sourceProperties.getSourceDirs());
        this.superSourceBase.addAll(sourceProperties.getSuperSourceDirs());
        this.sourceZips.addAll(sourceProperties.getSourceZips());
    }

    public void addSourceDir(File[] dirs, boolean isSuperSourceDir) {
        if (dirs == null) {
            return;
        }
        List<File> list = isSuperSourceDir ? this.superSourceBase : this.sourceBase;
        for (File f : dirs) {
            list.add(f);
        }
        this.updateSourceProperties();
    }

    public void addSourceZips(File[] zips) {
        if (zips == null) {
            return;
        }
        for (File f : zips) {
            try {
                ZipFile zipFile = new ZipFile(f);
                this.sourceZips.add(zipFile);
                this.updateSourceProperties();
            }
            catch (IOException e) {
                Trace.warn((Throwable)e, () -> "Exception while opening zip file '" + f + "'");
            }
        }
    }

    public void editSourceLookupPaths() {
        boolean SOURCE_DIRS = false;
        boolean SUPER_SOURCE_DIRS = true;
        int SOURCE_ZIPS = 2;
        SourcePathMaintenanceDialog.SourceConfiguration[] configs = new SourcePathMaintenanceDialog.SourceConfiguration[3];
        final Serializer[] serializers = new Serializer[3];
        ArrayList<String> sourceDirs = new ArrayList<String>();
        for (File file : this.sourceBase) {
            sourceDirs.add(file.getPath());
        }
        configs[0] = new SourcePathMaintenanceDialog.SourceConfiguration("Source Folders", "Add Source Directory", true, this.view.getSourceDirIcon(), new DirectoryFileFilter(), 1, sourceDirs);
        serializers[0] = new FileSerializer();
        ArrayList<String> superSourceDirs = new ArrayList<String>();
        for (File file : this.superSourceBase) {
            superSourceDirs.add(file.getPath());
        }
        configs[1] = new SourcePathMaintenanceDialog.SourceConfiguration("Super Source Folders", "Add Super Source Directory", true, this.view.getSuperSourceDirIcon(), new DirectoryFileFilter(), 1, superSourceDirs);
        serializers[1] = new FileSerializer();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ZipFile f : this.sourceZips) {
            arrayList.add(f.getName());
        }
        configs[2] = new SourcePathMaintenanceDialog.SourceConfiguration("Source Zips", "Add Source Zip File", true, this.view.getSourceZipIcon(), new ZipFileFilter(), 0, arrayList);
        serializers[2] = new ZipFileSerializer();
        JButton jButton = new JButton(ImageRepository.getImage("resources/import.gif", "Import"));
        jButton.setToolTipText("Import Source Code Lookup");
        JButton exportButton = new JButton(ImageRepository.getImage("resources/export.gif", "Export"));
        exportButton.setToolTipText("Export Source Code Lookup");
        final SourcePathMaintenanceDialog dialog = new SourcePathMaintenanceDialog((JFrame)SwingUtilities.getRoot(this.view.getSource()), configs, this.sourceProperties, jButton, exportButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                chooser.setMultiSelectionEnabled(false);
                chooser.setFileSelectionMode(0);
                chooser.setDialogTitle("Import Debugger Source Lookup Configuration");
                int result = chooser.showOpenDialog(dialog.getDialog());
                if (result == 0 && chooser.getSelectedFile().exists()) {
                    ArrayList<File> sources = new ArrayList<File>();
                    ArrayList<File> superSources = new ArrayList<File>();
                    ArrayList<ZipFile> zips = new ArrayList<ZipFile>();
                    SourceLookup.this.sourceProperties.importProperties(chooser.getSelectedFile(), sources, superSources, zips);
                    for (File file : sources) {
                        dialog.add(0, serializers[0].serialize(file));
                    }
                    for (File file : superSources) {
                        dialog.add(1, serializers[1].serialize(file));
                    }
                    for (ZipFile zipFile : zips) {
                        dialog.add(2, serializers[2].serialize(zipFile));
                    }
                }
            }
        });
        exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser(){
                    private static final long serialVersionUID = 334969322427557609L;

                    @Override
                    public void approveSelection() {
                        int result;
                        File file = this.getSelectedFile();
                        if (file != null && file.exists() && (result = JOptionPane.showConfirmDialog(this, "The selected file already exists. Do you want to overwrite it?", "Overwrite Existing File?", 0)) == 1) {
                            return;
                        }
                        super.approveSelection();
                    }
                };
                chooser.setMultiSelectionEnabled(false);
                chooser.setFileSelectionMode(0);
                chooser.setDialogTitle("Export Debugger Source Lookup Configuration");
                int result = chooser.showSaveDialog(dialog.getDialog());
                if (result == 0) {
                    ArrayList<File> sources = new ArrayList<File>();
                    for (String s : dialog.getEntries(0)) {
                        sources.add((File)serializers[0].deserialize(s));
                    }
                    ArrayList<File> superSources = new ArrayList<File>();
                    for (String s : dialog.getEntries(1)) {
                        superSources.add((File)serializers[1].deserialize(s));
                    }
                    ArrayList<ZipFile> zips = new ArrayList<ZipFile>();
                    for (String s : dialog.getEntries(2)) {
                        zips.add((ZipFile)serializers[2].deserialize(s));
                    }
                    SourceLookup.this.sourceProperties.exportProperties(chooser.getSelectedFile(), sources, superSources, zips);
                }
            }
        });
        dialog.show();
        this.sourceBase.clear();
        for (String s : sourceDirs) {
            this.sourceBase.add(new File(s));
        }
        this.superSourceBase.clear();
        for (String s : superSourceDirs) {
            this.superSourceBase.add(new File(s));
        }
        this.sourceZips.clear();
        for (String s : arrayList) {
            try {
                this.sourceZips.add(new ZipFile(s));
            }
            catch (Exception e) {
                Trace.warn((Throwable)e, (String)"Error while adding source zip");
            }
        }
        this.updateSourceProperties();
    }

    public void updateSourceProperties() {
        this.sourceProperties.updateSourceProperties(new ArrayList<File>(this.sourceBase), new ArrayList<ZipFile>(this.sourceZips), new ArrayList<File>(this.superSourceBase), this.internal.getOpenFiles(), this.internal.getSourceFiles(), this.internal.getSourceUrls());
    }

    public void propertiesChanged() {
        this.sourceProperties.propertiesChanged(this.sourceBase, this.sourceZips, this.superSourceBase);
    }

    public void clearProperties() {
        this.sourceBase.clear();
        this.sourceZips.clear();
        this.superSourceBase.clear();
        this.updateSourceProperties();
    }

    public File lookup(String path) {
        for (File f : this.sourceBase) {
            File potentialFile;
            if (!f.isDirectory() || !(potentialFile = new File(f, path)).exists()) continue;
            return potentialFile;
        }
        for (File f : this.superSourceBase) {
            ArrayList<File> currentDirs = new ArrayList<File>();
            currentDirs.add(f);
            ArrayList<File> toBeSearched = new ArrayList<File>();
            while (!currentDirs.isEmpty()) {
                for (File dir : currentDirs) {
                    if (!dir.isDirectory()) continue;
                    File potentialFile = new File(dir, path);
                    if (potentialFile.exists()) {
                        return potentialFile;
                    }
                    File[] files = dir.listFiles(new DirectoryFileFilter());
                    if (files == null) continue;
                    toBeSearched.addAll(Arrays.asList(files));
                }
                currentDirs.clear();
                ArrayList<File> tmp = currentDirs;
                currentDirs = toBeSearched;
                toBeSearched = tmp;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZipData lookupZip(String path) {
        for (ZipFile f : this.sourceZips) {
            ZipEntry entry = f.getEntry(path);
            if (entry == null) continue;
            InputStream is = null;
            BufferedReader reader = null;
            try {
                String str;
                is = f.getInputStream(entry);
                reader = new BufferedReader(new InputStreamReader(is));
                StringBuilder text = new StringBuilder();
                String lineSeparator = System.getProperty("line.separator");
                while ((str = reader.readLine()) != null) {
                    text.append(str);
                    text.append(lineSeparator);
                }
                ZipData zipData = new ZipData(text.toString(), new URL("jar:" + new File(f.getName()).toURI().toURL() + "!/" + path));
                return zipData;
            }
            catch (IOException e) {
                Trace.warn((Throwable)e, () -> "Exception while reading from file '" + f.getName() + "'");
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        Trace.warn((Throwable)e, () -> "Exception while closing reader of file '" + f.getName() + "'");
                    }
                    continue;
                }
                if (is == null) continue;
                try {
                    is.close();
                }
                catch (IOException e) {
                    Trace.warn((Throwable)e, () -> "Exception while closing stream of file '" + f.getName() + "'");
                }
            }
        }
        return new ZipData(null, null);
    }

    public static final class ZipData {
        private final String content;
        private final URL url;

        public ZipData(String content, URL url) {
            this.content = content;
            this.url = url;
        }

        public String getContent() {
            return this.content;
        }

        public URL getUrl() {
            return this.url;
        }

        public boolean isValid() {
            return this.content != null;
        }
    }
}

