/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.ui.swing.source;

import com.sap.jvm.debugging.ui.swing.source.LineNumberPanel;
import com.sap.jvm.debugging.ui.swing.source.SourceCodeManager;
import com.sap.jvm.debugging.ui.swing.source.SourceCodeView;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JEditorPane;
import javax.swing.text.Element;

public final class SourceMouseListener
extends MouseAdapter {
    private final SourceCodeManager.SourceCodeManagerInternal internal;
    private final SourceCodeView view;
    private String selection = null;
    private int line = -1;

    public SourceMouseListener(SourceCodeManager.SourceCodeManagerInternal internal, SourceCodeView view) {
        this.internal = internal;
        this.view = view;
    }

    public String getCurrentSelection() {
        return this.selection;
    }

    public void resetCurrentSelection() {
        this.selection = null;
    }

    public int getCurrentLine() {
        return this.line;
    }

    public void resetCurrentLine() {
        this.line = -1;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.handleMouseEvent(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.handleMouseEvent(e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        JEditorPane current = this.internal.getActiveEditor();
        if ((e.getSource() instanceof LineNumberPanel || e.getSource() instanceof JEditorPane) && current != null && e.getClickCount() == 2) {
            int index;
            int rowStartOffset = current.viewToModel(new Point(0, e.getY()));
            Element root = current.getDocument().getDefaultRootElement();
            Element lineElement = root.getElement(index = root.getElementIndex(rowStartOffset));
            if (lineElement.getStartOffset() == rowStartOffset) {
                this.internal.toggleBreakpoint(index + 1);
            }
            e.consume();
        }
    }

    private void handleMouseEvent(MouseEvent e) {
        JEditorPane current = this.internal.getActiveEditor();
        if (e.isPopupTrigger() && current != null) {
            this.selection = current.getSelectedText();
            this.view.setInspectMenuItemVisible(this.selection != null && this.selection.trim().length() > 0);
            int rowStartOffset = current.viewToModel(new Point(0, e.getY()));
            Element root = current.getDocument().getDefaultRootElement();
            int index = root.getElementIndex(rowStartOffset);
            Element lineElement = root.getElement(index);
            this.line = lineElement.getStartOffset() == rowStartOffset ? index + 1 : -1;
            boolean hasBreakpoint = this.internal.breakpointExists(this.line);
            this.view.setAddLineBreakpointMenuItemVisible(!hasBreakpoint && lineElement.getStartOffset() == rowStartOffset);
            this.view.setRemoveLineBreakpointMenuItemVisible(hasBreakpoint && lineElement.getStartOffset() == rowStartOffset);
            String className = this.internal.getCurrentClassName();
            this.view.setSwitchToDisassemblyMenuItemVisible(this.internal.showsDecompiledCode(className));
            this.view.setSwitchToDecompiledCodeMenuItemVisible(this.internal.showsDisassembly(className));
            this.view.showContextMenu(e.getComponent(), e.getX(), e.getY());
        }
    }
}

