/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.ui.swing.source;

import com.sap.jvm.debugging.ui.swing.source.SourceCodeManager;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;

public final class TabCloseButton
extends JButton
implements ActionListener {
    private static final long serialVersionUID = 7249488759683755830L;
    private final SourceCodeManager.SourceCodeManagerInternal internal;
    private final Component component;

    public TabCloseButton(SourceCodeManager.SourceCodeManagerInternal internal, Component component) {
        this.internal = internal;
        this.component = component;
        this.setPreferredSize(new Dimension(16, 16));
        this.setToolTipText("Close this tab");
        this.setContentAreaFilled(false);
        this.setFocusable(false);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setBorderPainted(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (e.getComponent() == TabCloseButton.this) {
                    TabCloseButton.this.setBorderPainted(true);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (e.getComponent() == TabCloseButton.this) {
                    TabCloseButton.this.setBorderPainted(false);
                }
            }
        });
        this.setRolloverEnabled(true);
        this.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.internal.removeTab(this.component);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g.create();
        if (this.getModel().isPressed()) {
            g2.translate(1, 1);
        }
        g2.setStroke(new BasicStroke(2.0f));
        g2.setColor(Color.BLACK);
        if (this.getModel().isRollover()) {
            g2.setColor(Color.MAGENTA);
        }
        int delta = 6;
        g2.drawLine(delta, delta, this.getWidth() - delta - 1, this.getHeight() - delta - 1);
        g2.drawLine(this.getWidth() - delta - 1, delta, delta, this.getHeight() - delta - 1);
        g2.dispose();
    }
}

