/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.debugging.ui.swing.treetable;

import com.sap.jvm.debugging.ui.swing.treetable.TreeTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class TreeTable
extends JTable {
    private static final long serialVersionUID = 5198307604316994479L;
    protected TreeTableCellRenderer tree;

    public TreeTable(TreeTableModel treeTableModel) {
        this.tree = new TreeTableCellRenderer(treeTableModel);
        super.setModel(new TreeTableModelAdapter(treeTableModel, this.tree));
        ListToTreeSelectionModelWrapper selectionWrapper = new ListToTreeSelectionModelWrapper();
        this.tree.setSelectionModel(selectionWrapper);
        this.setSelectionModel(selectionWrapper.getListSelectionModel());
        this.setDefaultRenderer(TreeTableModel.class, this.tree);
        this.setDefaultEditor(TreeTableModel.class, new TreeTableCellEditor());
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        if (this.tree.getRowHeight() < 1) {
            this.setRowHeight(18);
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.tree != null) {
            this.tree.updateUI();
        }
        LookAndFeel.installColorsAndFont(this, "Tree.background", "Tree.foreground", "Tree.font");
    }

    @Override
    public int getEditingRow() {
        return this.getColumnClass(this.editingColumn) == TreeTableModel.class ? -1 : this.editingRow;
    }

    @Override
    public void setRowHeight(int rowHeight) {
        super.setRowHeight(rowHeight);
        if (this.tree != null && this.tree.getRowHeight() != rowHeight) {
            this.tree.setRowHeight(this.getRowHeight());
        }
    }

    public JTree getTree() {
        return this.tree;
    }

    public class TreeTableModelAdapter
    extends AbstractTableModel {
        private static final long serialVersionUID = -7658049112696073196L;
        JTree jtree;
        TreeTableModel treeTableModel;

        public TreeTableModelAdapter(TreeTableModel treeTableModel, JTree tree) {
            this.jtree = tree;
            this.treeTableModel = treeTableModel;
            tree.addTreeExpansionListener(new TreeExpansionListener(){

                @Override
                public void treeExpanded(TreeExpansionEvent event) {
                    TreeTableModelAdapter.this.fireTableDataChanged();
                }

                @Override
                public void treeCollapsed(TreeExpansionEvent event) {
                    TreeTableModelAdapter.this.fireTableDataChanged();
                }
            });
            treeTableModel.addTreeModelListener(new TreeModelListener(){

                @Override
                public void treeNodesChanged(TreeModelEvent e) {
                    TreeTableModelAdapter.this.delayedFireTableDataChanged();
                }

                @Override
                public void treeNodesInserted(TreeModelEvent e) {
                    TreeTableModelAdapter.this.delayedFireTableDataChanged();
                }

                @Override
                public void treeNodesRemoved(TreeModelEvent e) {
                    TreeTableModelAdapter.this.delayedFireTableDataChanged();
                }

                @Override
                public void treeStructureChanged(TreeModelEvent e) {
                    TreeTableModelAdapter.this.delayedFireTableDataChanged();
                }
            });
        }

        @Override
        public int getColumnCount() {
            return this.treeTableModel.getColumnCount();
        }

        @Override
        public String getColumnName(int column) {
            return this.treeTableModel.getColumnName(column);
        }

        @Override
        public Class<?> getColumnClass(int column) {
            return this.treeTableModel.getColumnClass(column);
        }

        @Override
        public int getRowCount() {
            return this.jtree.getRowCount();
        }

        protected Object nodeForRow(int row) {
            TreePath treePath = this.jtree.getPathForRow(row);
            return treePath.getLastPathComponent();
        }

        @Override
        public Object getValueAt(int row, int column) {
            return this.treeTableModel.getValueAt(this.nodeForRow(row), column);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return this.treeTableModel.isCellEditable(this.nodeForRow(row), column);
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            if (row < 0 || row >= this.getRowCount()) {
                return;
            }
            this.treeTableModel.setValueAt(value, this.nodeForRow(row), column);
        }

        protected void delayedFireTableDataChanged() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TreeTableModelAdapter.this.fireTableDataChanged();
                }
            });
        }
    }

    class ListToTreeSelectionModelWrapper
    extends DefaultTreeSelectionModel {
        private static final long serialVersionUID = -1771746839819190093L;
        protected boolean updatingListSelectionModel;

        public ListToTreeSelectionModelWrapper() {
            this.getListSelectionModel().addListSelectionListener(this.createListSelectionListener());
        }

        ListSelectionModel getListSelectionModel() {
            return this.listSelectionModel;
        }

        @Override
        public void resetRowSelection() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    super.resetRowSelection();
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        protected ListSelectionListener createListSelectionListener() {
            return new ListSelectionHandler();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateSelectedPathsFromSelectedRows() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    int min = this.listSelectionModel.getMinSelectionIndex();
                    int max = this.listSelectionModel.getMaxSelectionIndex();
                    this.clearSelection();
                    if (min != -1 && max != -1) {
                        for (int counter = min; counter <= max; ++counter) {
                            TreePath selPath;
                            if (!this.listSelectionModel.isSelectedIndex(counter) || (selPath = TreeTable.this.tree.getPathForRow(counter)) == null) continue;
                            this.addSelectionPath(selPath);
                        }
                    }
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        class ListSelectionHandler
        implements ListSelectionListener {
            ListSelectionHandler() {
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListToTreeSelectionModelWrapper.this.updateSelectedPathsFromSelectedRows();
            }
        }
    }

    public class TreeTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = -6708058734781765528L;

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int r, int c) {
            return TreeTable.this.tree;
        }

        @Override
        public boolean isCellEditable(EventObject e) {
            if (e instanceof MouseEvent) {
                for (int counter = TreeTable.this.getColumnCount() - 1; counter >= 0; --counter) {
                    if (TreeTable.this.getColumnClass(counter) != TreeTableModel.class) continue;
                    MouseEvent me = (MouseEvent)e;
                    MouseEvent newME = new MouseEvent(TreeTable.this.tree, me.getID(), me.getWhen(), me.getModifiersEx(), me.getX() - TreeTable.this.getCellRect((int)0, (int)counter, (boolean)true).x, me.getY(), me.getClickCount(), me.isPopupTrigger());
                    TreeTable.this.tree.dispatchEvent(newME);
                    break;
                }
            }
            return false;
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }
    }

    public class TreeTableCellRenderer
    extends JTree
    implements TableCellRenderer {
        private static final long serialVersionUID = -337198172813072536L;
        protected int visibleRow;

        public TreeTableCellRenderer(TreeModel model) {
            super(model);
        }

        @Override
        public void setRowHeight(int rowHeight) {
            if (rowHeight > 0) {
                super.setRowHeight(rowHeight);
                if (TreeTable.this.getRowHeight() != rowHeight) {
                    TreeTable.this.setRowHeight(this.getRowHeight());
                }
            }
        }

        @Override
        public void setBounds(int x, int y, int w, int h) {
            super.setBounds(x, 0, w, TreeTable.this.getHeight());
        }

        @Override
        public void paint(Graphics g) {
            g.translate(0, -this.visibleRow * this.getRowHeight());
            super.paint(g);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            this.visibleRow = row;
            return this;
        }
    }
}

