/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.internal.util.cmdline;

import com.sap.jvm.internal.util.cmdline.ArgumentException;
import com.sap.jvm.internal.util.cmdline.Flag;
import com.sap.jvm.internal.util.cmdline.FlagWithOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ArgumentParser {
    private String toolDescription = "";
    private String toolName = "";
    private List<Flag> flags = new ArrayList<Flag>();
    private HashMap<Character, Flag> flagsByFlagChar = new HashMap();
    private HashMap<String, Flag> flagsByLongName = new HashMap();
    private static final String tabs = "\t\t\t\t\t\t\t\t\t\t";
    boolean allowPositionalArguments = false;
    String[] positionalArguments = null;

    private static String formatParagraph(String s, int indention, int maxLineLen) {
        String[] paragraphs = s.split("[\r\n]+");
        StringBuffer bld = new StringBuffer();
        String prefix = tabs.substring(0, indention);
        for (int i = 0; i < paragraphs.length; ++i) {
            int nextBreak;
            String paragraph = paragraphs[i];
            if (paragraph.trim().length() == 0) {
                bld.append("\n");
                continue;
            }
            String p = paragraph;
            int maxLen = maxLineLen - prefix.length() * 4;
            while (p.length() > maxLen && (nextBreak = p.indexOf(32, maxLen)) != -1) {
                bld.append(prefix);
                bld.append(p.substring(0, nextBreak).trim());
                bld.append("\n");
                p = p.substring(nextBreak).trim();
            }
            if (p.length() <= 0) continue;
            bld.append(prefix);
            bld.append(p);
            bld.append("\n");
        }
        return bld.toString();
    }

    public final void setAllowPositionalArguments(boolean v) {
        this.allowPositionalArguments = v;
    }

    public final String[] getPositionalArguments() {
        return this.positionalArguments;
    }

    public final void addFlag(Flag f) {
        this.flags.add(f);
        if (f.getFlagChar() != null) {
            this.flagsByFlagChar.put(f.getFlagChar(), f);
        }
        if (f.getLongName() != null) {
            this.flagsByLongName.put(f.getLongName(), f);
        }
    }

    public final void setToolDescription(String toolDescription) {
        this.toolDescription = toolDescription;
    }

    public final void setToolName(String toolName) {
        this.toolName = toolName;
    }

    public final String getUsageString() {
        int maxLineLen = 80;
        StringBuffer sb = new StringBuffer();
        sb.append("Usage: \n");
        sb.append(this.toolName);
        StringBuffer sb2 = new StringBuffer();
        for (Flag flag : this.flags) {
            sb2.append(" ");
            sb2.append(flag.getUsageString());
        }
        sb.append(ArgumentParser.formatParagraph(sb2.toString(), 1, 80));
        sb.append("\n\n");
        sb.append(ArgumentParser.formatParagraph(this.toolDescription, 1, 80));
        sb.append("\n\n");
        if (this.flags.size() > 0) {
            sb.append("Options:\n");
            for (Flag flag : this.flags) {
                FlagWithOption fwo = null;
                if (flag instanceof FlagWithOption) {
                    fwo = (FlagWithOption)flag;
                }
                if (flag.getFlagChar() != null) {
                    sb.append("-" + flag.getFlagChar());
                    if (fwo != null) {
                        if (fwo.optionValueIsOptional()) {
                            sb.append(" [" + fwo.getOptionName() + "]");
                        } else {
                            sb.append(" " + fwo.getOptionName());
                        }
                    }
                    sb.append("\n");
                }
                if (flag.getLongName() != null) {
                    sb.append("--" + flag.getLongName());
                    if (fwo != null) {
                        if (fwo.optionValueIsOptional()) {
                            sb.append("[=" + fwo.getOptionName() + "]");
                        } else {
                            sb.append("=" + fwo.getOptionName());
                        }
                    }
                    sb.append("\n");
                }
                sb.append(ArgumentParser.formatParagraph(flag.getDescription(), 1, 80));
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public final void parseArguments(String[] arguments) throws ArgumentException {
        FlagWithOption flagExpectingValue = null;
        for (int nArg = 0; nArg < arguments.length; ++nArg) {
            Flag f;
            String arg = arguments[nArg];
            if (flagExpectingValue != null) {
                if (arg.startsWith("-")) {
                    flagExpectingValue = null;
                } else {
                    flagExpectingValue.setOptionValue(arg);
                    continue;
                }
            }
            if (arg.startsWith("--")) {
                String s = arg.substring(2, arg.length());
                int equalspos = s.indexOf("=");
                if (equalspos != -1) {
                    String flagname = s.substring(0, equalspos);
                    String option = s.substring(equalspos + 1);
                    Flag f2 = this.flagsByLongName.get(flagname);
                    if (f2 == null) {
                        throw new ArgumentException("unknown flag " + arg);
                    }
                    try {
                        FlagWithOption fwo = (FlagWithOption)f2;
                        fwo.setOptionValue(option);
                    }
                    catch (ClassCastException ex) {
                        throw new ArgumentException("flag " + arg + " cannot have an option.");
                    }
                    f2.set();
                    continue;
                }
                f = this.flagsByLongName.get(s);
                if (f == null) {
                    throw new ArgumentException("unknown flag " + arg);
                }
                f.set();
                if (!(f instanceof FlagWithOption)) continue;
                flagExpectingValue = (FlagWithOption)f;
                continue;
            }
            if (arg.startsWith("-")) {
                for (int i = 1; i < arg.length(); ++i) {
                    Character flagChar = Character.valueOf(arg.charAt(i));
                    f = this.flagsByFlagChar.get(flagChar);
                    if (f == null) {
                        throw new ArgumentException("flag not found: -" + flagChar);
                    }
                    f.set();
                    if (f instanceof FlagWithOption) {
                        flagExpectingValue = (FlagWithOption)f;
                        if (i >= arg.length() - 1) continue;
                        throw new ArgumentException("Flag -" + flagChar + " expects value.");
                    }
                    flagExpectingValue = null;
                }
                continue;
            }
            if (this.allowPositionalArguments) {
                this.positionalArguments = new String[arguments.length - nArg];
                int i = nArg;
                int j = 0;
                while (i < arguments.length) {
                    this.positionalArguments[j] = arguments[i];
                    ++i;
                    ++j;
                }
                break;
            }
            throw new ArgumentException("don't understand " + arg);
        }
        for (Flag flag : this.flags) {
            flag.postParse();
        }
    }
}

