/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.internal.util.cmdline;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class CommandLineParser {
    protected static final String FLAG_VALUE = "true";
    protected String[] args;
    protected ArrayList<Option> options = new ArrayList();
    protected Map<String, String> shortNames = new HashMap<String, String>();
    protected Map<String, String> longNames = new HashMap<String, String>();
    protected Map<String, Properties> properties = new HashMap<String, Properties>();
    protected List<String> remainingArguments = new ArrayList<String>();
    protected boolean ignoreUnknownOptions;
    protected boolean allToLower = false;

    protected CommandLineParser() {
    }

    public CommandLineParser(String[] args, Option[] options, boolean ignoreUnknownOptions) throws UnknownOptionException, MissingOptionException, MissingOptionValueException, IllegalOptionFormatException {
        this(args, options, ignoreUnknownOptions, false);
    }

    public CommandLineParser(String[] args, Option[] options, boolean ignoreUnknownOptions, boolean allToLower) throws UnknownOptionException, MissingOptionException, MissingOptionValueException, IllegalOptionFormatException {
        this.allToLower = allToLower;
        if (args == null) {
            throw new NullPointerException("arg==null");
        }
        if (options == null) {
            throw new NullPointerException("options==null");
        }
        this.args = args;
        for (int i = 0; i < options.length; ++i) {
            this.addValidOption(options[i]);
        }
        this.ignoreUnknownOptions = ignoreUnknownOptions;
        this.parseChecked();
    }

    public void addValidOption(Option o) {
        this.options.add(o);
    }

    public CommandLineParser(String[] args) {
        this(args, false);
    }

    public CommandLineParser(String[] args, boolean allToLower) {
        this.allToLower = allToLower;
        if (args == null) {
            throw new NullPointerException("arg==null");
        }
        this.args = args;
        try {
            this.parseUnchecked();
        }
        catch (CommandLineException commandLineException) {
            // empty catch block
        }
    }

    public boolean isOptionSet(String option) {
        return this.shortNames.containsKey(option) || this.longNames.containsKey(option);
    }

    public boolean isOptionSet(Option option) {
        return this.isOptionSet(option.getLongName());
    }

    public String getValue(String option) {
        String value;
        String processedOption = option;
        if (this.allToLower) {
            processedOption = processedOption.toLowerCase();
        }
        if ((value = this.shortNames.get(processedOption)) == null) {
            value = this.longNames.get(processedOption);
        }
        return value;
    }

    public String getValue(String option, String defaultValue) {
        String value = this.getValue(option);
        return value != null ? value : defaultValue;
    }

    public String getValue(Option option) {
        return this.getValue(option.getLongName());
    }

    public Number getNumericValue(Option option) {
        String val = this.getValue(option);
        if (val == null) {
            return option.getNumericDefaultValue();
        }
        return Long.parseLong(val);
    }

    public String getValue(Option option, String defaultValue) {
        return this.getValue(option.getLongName(), defaultValue);
    }

    public String[] getValues(String optionPrefix) {
        String prefix = optionPrefix;
        if (this.allToLower) {
            prefix = prefix.toLowerCase();
        }
        ArrayList<String> result = new ArrayList<String>();
        Set<String> keys = this.longNames.keySet();
        for (int i = 0; i < 100; ++i) {
            String suffix = "_" + (i < 10 ? "0" : "") + i;
            String key = prefix + suffix;
            if (!keys.contains(key)) break;
            result.add(this.longNames.get(key));
        }
        if (result.size() == 0) {
            return null;
        }
        return result.toArray(new String[result.size()]);
    }

    public void removeValue(String option) {
        String optionName = option;
        if (this.allToLower) {
            optionName = optionName.toLowerCase();
        }
        this.shortNames.remove(optionName);
        this.longNames.remove(optionName);
    }

    public void removeValues(String optionPrefix) {
        String prefix = optionPrefix;
        if (this.allToLower) {
            prefix = prefix.toLowerCase();
        }
        for (int i = 0; i < 100; ++i) {
            String suffix = "_" + (i < 10 ? "0" : "") + i;
            String key = prefix + suffix;
            if (this.longNames.remove(key) == null) break;
        }
    }

    public String[] getShortNames() {
        Set<String> names = this.shortNames.keySet();
        return names.toArray(new String[names.size()]);
    }

    public String[] getLongNames() {
        Set<String> names = this.longNames.keySet();
        return names.toArray(new String[names.size()]);
    }

    public String[] getRemainingArguments() {
        return this.remainingArguments.toArray(new String[this.remainingArguments.size()]);
    }

    public Properties getProperties(String option) {
        String optionName = option;
        if (this.allToLower) {
            optionName = optionName.toLowerCase();
        }
        return this.properties.get(optionName);
    }

    public Properties getProperties(Option option) {
        return this.getProperties(option.getShortName());
    }

    public boolean isPropertiesSet(String option) {
        String optionName = option;
        if (this.allToLower) {
            optionName = option.toLowerCase();
        }
        return this.properties.containsKey(optionName);
    }

    protected void parseChecked() throws UnknownOptionException, MissingOptionException, MissingOptionValueException, IllegalOptionFormatException {
        boolean CHECKED = true;
        for (int i = 0; i < this.args.length; ++i) {
            Option descr;
            String arg = this.args[i];
            String paramName = null;
            if (arg.startsWith("--") & arg.length() > 2) {
                paramName = this.handleLongOption(arg.substring(2), true);
            } else if (arg.startsWith("-") && arg.length() > 1) {
                paramName = this.handleShortOption(arg.substring(1), true);
            } else {
                this.remainingArguments.add(arg);
            }
            if (paramName == null || (descr = this.findDescriptionChecked(paramName)) == null) continue;
            if (!descr.isSwitchOnly() && i < this.args.length - 1) {
                String nextArg = this.args[i + 1];
                if (!nextArg.startsWith("-")) {
                    this.shortNames.put(descr.getShortName(), nextArg);
                    this.longNames.put(descr.getLongName(), nextArg);
                    ++i;
                    continue;
                }
                throw new MissingOptionValueException(paramName);
            }
            this.shortNames.put(descr.getShortName(), FLAG_VALUE);
            this.longNames.put(descr.getLongName(), FLAG_VALUE);
        }
        for (Option o : this.options) {
            if (!o.isMandatory()) continue;
            String shortName = o.getShortName();
            String longName = o.getLongName();
            if (this.shortNames.containsKey(shortName) || this.longNames.containsKey(longName)) continue;
            throw new MissingOptionException(shortName);
        }
    }

    private String handleShortOption(String paramName, boolean checked) throws IllegalOptionFormatException, UnknownOptionException {
        String optionName = paramName;
        int pos = optionName.indexOf(61);
        if (pos >= 0 && pos < optionName.length()) {
            Properties props;
            String param = optionName.substring(0, 1);
            String name = optionName.substring(1, pos);
            String value = optionName.substring(pos + 1);
            if (this.allToLower) {
                name = name.toLowerCase();
                param = param.toLowerCase();
            }
            if (checked) {
                Option descr = this.findDescriptionChecked(param);
                if (descr == null) {
                    return null;
                }
                if (!descr.isPropertiesOption()) {
                    throw new IllegalOptionFormatException(paramName);
                }
            }
            if ((props = this.properties.get(param)) == null) {
                props = new Properties();
                this.properties.put(param, props);
            }
            props.setProperty(name, value);
            optionName = null;
        }
        return optionName;
    }

    private String handleLongOption(String paramName, boolean checked) throws UnknownOptionException, IllegalOptionFormatException {
        String optionName = paramName;
        int pos = optionName.indexOf(61);
        if (pos >= 0 && pos < optionName.length()) {
            String name = optionName.substring(0, pos);
            String value = optionName.substring(pos + 1);
            if (this.allToLower) {
                name = name.toLowerCase();
            }
            String longName = name;
            String shortName = name;
            if (checked) {
                Option descr = this.findDescriptionChecked(name);
                if (descr == null) {
                    return null;
                }
                if (descr.isEqualsOnly()) {
                    shortName = descr.getShortName();
                    longName = descr.getLongName();
                } else {
                    throw new IllegalOptionFormatException(paramName);
                }
            }
            this.shortNames.put(shortName, value);
            this.longNames.put(longName, value);
            optionName = null;
        } else if (checked) {
            Option descr = this.findDescriptionChecked(optionName);
            if (descr == null) {
                return null;
            }
            if (descr.isEqualsOnly()) {
                throw new IllegalOptionFormatException(optionName);
            }
        }
        return optionName;
    }

    protected void parseUnchecked() throws UnknownOptionException, IllegalOptionFormatException {
        boolean UNCHECKED = false;
        for (int i = 0; i < this.args.length; ++i) {
            String arg = this.args[i];
            String paramName = null;
            if (arg.startsWith("--") & arg.length() > 2) {
                paramName = this.handleLongOption(arg.substring(2), false);
            } else if (arg.startsWith("-") && arg.length() > 1) {
                paramName = this.handleShortOption(arg.substring(1), false);
            } else {
                this.remainingArguments.add(arg);
            }
            if (paramName == null) continue;
            if (i < this.args.length - 1) {
                String nextArg = this.args[i + 1];
                if (!nextArg.startsWith("-")) {
                    this.shortNames.put(paramName, nextArg);
                    this.longNames.put(paramName, nextArg);
                    ++i;
                    continue;
                }
                this.shortNames.put(paramName, FLAG_VALUE);
                this.longNames.put(paramName, FLAG_VALUE);
                continue;
            }
            this.shortNames.put(paramName, FLAG_VALUE);
            this.longNames.put(paramName, FLAG_VALUE);
        }
    }

    private Option findDescription(String paramName) {
        String name = paramName;
        if (this.allToLower) {
            name = name.toLowerCase();
        }
        for (Option o : this.options) {
            String shortName = o.getShortName();
            String longName = o.getLongName();
            if (!name.equals(shortName) && !name.equals(longName)) continue;
            return o;
        }
        return null;
    }

    private Option findDescriptionChecked(String paramName) throws UnknownOptionException {
        Option descr;
        String name = paramName;
        if (this.allToLower) {
            name = name.toLowerCase();
        }
        if ((descr = this.findDescription(name)) == null && !this.ignoreUnknownOptions) {
            throw new UnknownOptionException(name);
        }
        return descr;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("CommandLineParser [args=<");
        for (int i = 0; i < this.args.length; ++i) {
            result.append('\"');
            result.append(this.args[i]);
            result.append('\"');
            if (i >= this.args.length - 1) continue;
            result.append(", ");
        }
        result.append(">]");
        return result.toString();
    }

    public void printOptionHelp(PrintStream st) {
        st.println("The follwing options are supported:");
        for (Option option : this.options) {
            option.printOption(st);
            if (option.getDescription() != null) {
                st.println(": " + option.getDescription());
                continue;
            }
            st.println(": No description available");
        }
    }

    public static class PropertyOption
    extends Option {
        public PropertyOption(String shortName) {
            super(shortName, null, false, true, false, true, null, null);
        }
    }

    public static class OptionalSwitch
    extends Option {
        public OptionalSwitch(String shortName, String longName) {
            super(shortName, longName, false, true, false, false, null, null);
        }

        public OptionalSwitch(String shortName, String longName, String description) {
            super(shortName, longName, false, true, false, false, null, description);
        }
    }

    public static class MandatorySwitch
    extends Option {
        public MandatorySwitch(String shortName, String longName) {
            super(shortName, longName, true, true, false, false, null, null);
        }
    }

    public static class OptionalOption
    extends Option {
        public OptionalOption(String shortName, String longName) {
            super(shortName, longName, false, false, false, false, null, null);
        }
    }

    public static class OptionalEqualsOption
    extends Option {
        public OptionalEqualsOption(String longName) {
            this(null, longName);
        }

        public OptionalEqualsOption(String shortName, String longName) {
            super(shortName, longName, false, false, true, false, null, null);
        }

        public OptionalEqualsOption(String shortName, String longName, String defaultValue, String description) {
            super(shortName, longName, false, false, true, false, defaultValue, description);
        }

        public OptionalEqualsOption(String longName, Number defaultValue, String description) {
            super(null, longName, false, false, true, false, defaultValue, description);
        }
    }

    public static class MandatoryEqualsOption
    extends Option {
        public MandatoryEqualsOption(String longName) {
            super(null, longName, true, false, true, false, null, null);
        }
    }

    public static class MandatoryOption
    extends Option {
        public MandatoryOption(String shortName, String longName) {
            super(shortName, longName, true, false, false, false, null, null);
        }
    }

    public static abstract class Option {
        private final String shortName;
        private final String longName;
        private final boolean mandatory;
        private final boolean switchOnly;
        private final boolean equalsOnly;
        private final boolean propertyOption;
        private final Object defaultValue;
        private final String parameterName;
        private final String description;

        public Option(String shortName, String longName, boolean mandatory, boolean switchOnly, boolean equalsOnly, boolean propertyOption, Object defaultValue, String description) {
            String tmpShortName = shortName;
            String tmpLongName = longName;
            if (tmpShortName == null && tmpLongName == null) {
                throw new NullPointerException("shortname, longname==null");
            }
            if (tmpShortName == null) {
                tmpShortName = tmpLongName;
            } else if (tmpLongName == null) {
                tmpLongName = tmpShortName;
            }
            this.shortName = tmpShortName;
            this.longName = tmpLongName;
            this.mandatory = mandatory;
            this.switchOnly = switchOnly;
            this.equalsOnly = equalsOnly;
            this.propertyOption = propertyOption;
            this.defaultValue = defaultValue;
            this.description = description;
            this.parameterName = "param";
        }

        public String getLongName() {
            return this.longName;
        }

        public String getShortName() {
            return this.shortName;
        }

        public boolean isMandatory() {
            return this.mandatory;
        }

        public boolean isSwitchOnly() {
            return this.switchOnly;
        }

        public boolean isEqualsOnly() {
            return this.equalsOnly;
        }

        public boolean isPropertiesOption() {
            return this.propertyOption;
        }

        public boolean getBooleanDefaultValue() {
            if (this.defaultValue instanceof Boolean) {
                return (Boolean)this.defaultValue;
            }
            return this.defaultValue != null;
        }

        public String getStringDefaultValue() {
            if (this.defaultValue == null) {
                return "<no default value>";
            }
            return this.defaultValue.toString();
        }

        public Number getNumericDefaultValue() {
            if (this.defaultValue instanceof Number) {
                return (Number)this.defaultValue;
            }
            return null;
        }

        public String getDescription() {
            return this.description;
        }

        public void printOption(PrintStream st) {
            if (!this.isEqualsOnly()) {
                st.print("-" + this.getShortName());
                if (!this.isSwitchOnly()) {
                    st.print(" <" + this.parameterName + ">");
                }
                if (this.getLongName() != null) {
                    st.print("  ");
                }
            }
            if (!this.isPropertiesOption() && this.getLongName() != null) {
                st.print("--" + this.getLongName());
                if (!this.isSwitchOnly()) {
                    st.print("=<" + this.parameterName + ">");
                }
            }
            if (this.isMandatory()) {
                st.print(" {mandatory}");
            }
        }
    }

    public static class UnknownOptionException
    extends CommandLineException {
        private static final long serialVersionUID = 3763973563725407925L;

        public UnknownOptionException(String message) {
            super(message);
        }

        public UnknownOptionException() {
        }
    }

    public static class IllegalOptionFormatException
    extends CommandLineException {
        private static final long serialVersionUID = -5998938721068838675L;

        public IllegalOptionFormatException(String message) {
            super(message);
        }

        public IllegalOptionFormatException() {
        }
    }

    public static class MissingOptionException
    extends CommandLineException {
        private static final long serialVersionUID = 547107602136654654L;

        public MissingOptionException(String message) {
            super(message);
        }

        public MissingOptionException() {
        }
    }

    public static class MissingOptionValueException
    extends CommandLineException {
        private static final long serialVersionUID = 3888199825525058171L;

        public MissingOptionValueException(String message) {
            super(message);
        }

        public MissingOptionValueException() {
        }
    }

    public static abstract class CommandLineException
    extends Exception {
        private static final long serialVersionUID = -6666692423825504877L;

        public CommandLineException(String message) {
            super(message);
        }

        public CommandLineException() {
        }
    }
}

