/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.internal.util.cmdline;

import com.sap.jvm.internal.util.cmdline.ArgumentException;
import com.sap.jvm.internal.util.cmdline.FlagWithBooleanOption;
import com.sap.jvm.internal.util.cmdline.FlagWithOption;

public class Flag {
    private final Character flagChar;
    private final String longName;
    private final String description;
    private boolean flagIsMandatory = false;
    private boolean isSet = false;

    protected void postParse() throws ArgumentException {
        if (this.isMandatory() && !this.isSet()) {
            throw new ArgumentException("missing: " + this.shortLongName());
        }
    }

    final String shortLongName() {
        if (this.flagChar != null && this.longName != null) {
            return "-" + this.flagChar + " ( --" + this.longName + ")";
        }
        if (this.flagChar != null) {
            return "-" + this.flagChar;
        }
        if (this.longName != null) {
            return "--" + this.longName;
        }
        return null;
    }

    final String getUsageString() {
        StringBuffer bld = new StringBuffer();
        if (!this.isMandatory()) {
            bld.append("[");
        }
        if (this.flagChar != null) {
            bld.append("-" + this.flagChar);
            if (this.longName != null) {
                bld.append("|");
            }
        }
        if (this.longName != null) {
            bld.append("--" + this.longName);
        }
        if (this instanceof FlagWithOption) {
            FlagWithOption fwo = (FlagWithOption)this;
            if (fwo.optionValueIsOptional()) {
                bld.append("[");
            }
            bld.append(" <");
            bld.append(fwo.getOptionName());
            bld.append(">");
            if (fwo.optionValueIsOptional()) {
                bld.append("]");
            }
        }
        if (!this.isMandatory()) {
            bld.append("]");
        }
        return bld.toString();
    }

    final void set() {
        this.isSet = true;
    }

    public Flag(Character flagChar, String longName) {
        this.flagChar = flagChar;
        this.longName = longName;
        this.description = null;
    }

    public Flag(char flagChar, String longName) {
        this(Character.valueOf(flagChar), longName);
    }

    public Flag(Character flagChar, String longName, String description) {
        this.flagChar = flagChar;
        this.longName = longName != null ? (longName.startsWith("--") ? longName.substring(2) : longName) : null;
        this.description = description;
    }

    public Flag(char flagChar, String longName, String description) {
        this(Character.valueOf(flagChar), longName, description);
    }

    public final boolean isMandatory() {
        return this.flagIsMandatory;
    }

    public final void setIsMandatory(boolean flagIsMandatory) {
        this.flagIsMandatory = flagIsMandatory;
    }

    public final Character getFlagChar() {
        return this.flagChar;
    }

    public final String getLongName() {
        return this.longName;
    }

    public String getDescription() {
        return this.description;
    }

    public final boolean isSet() {
        return this.isSet;
    }

    public static Flag createHelpFlag() {
        return new Flag('?', "help", "display command help");
    }

    public static Flag createVerboseFlag() {
        return new FlagWithBooleanOption(null, "--verbose", "verbose mode");
    }
}

