/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.internal.util.cmdline;

import com.sap.jvm.internal.util.cmdline.ArgumentException;
import com.sap.jvm.internal.util.cmdline.FlagWithOption;

public class FlagWithBooleanOption
extends FlagWithOption {
    boolean boolValue = false;

    public FlagWithBooleanOption(char flagChar, String longName, String description) {
        super(Character.valueOf(flagChar), longName, description, "value");
    }

    public FlagWithBooleanOption(Character flagChar, String longName, String description) {
        super(flagChar, longName, description, "value");
    }

    @Override
    protected void postParse() throws ArgumentException {
        super.postParse();
        if (this.isSet()) {
            String o = this.getOptionValue();
            if ("1".equals(o) || "true".equalsIgnoreCase(o) || "yes".equalsIgnoreCase(o) || "on".equalsIgnoreCase(o)) {
                this.boolValue = true;
            } else if ("0".equals(o) || "false".equalsIgnoreCase(o) || "no".equalsIgnoreCase(o) || "off".equalsIgnoreCase(o)) {
                this.boolValue = false;
            } else {
                throw new ArgumentException("invalid value for " + this.shortLongName());
            }
        }
    }

    public final boolean getOptionValueAsBoolean() {
        return this.boolValue;
    }
}

