/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.internal.util.cmdline;

import com.sap.jvm.internal.util.cmdline.ArgumentException;
import com.sap.jvm.internal.util.cmdline.FlagWithOption;

public class FlagWithIntegerOption
extends FlagWithOption {
    int intValue = -1;

    public FlagWithIntegerOption(Character flagChar, String longName, String description) {
        super(flagChar, longName, description, "value");
    }

    public FlagWithIntegerOption(char flagChar, String longName, String description) {
        super(Character.valueOf(flagChar), longName, description, "value");
    }

    @Override
    protected void postParse() throws ArgumentException {
        super.postParse();
        if (this.isSet()) {
            String o = this.getOptionValue();
            try {
                this.intValue = Integer.parseInt(o);
            }
            catch (NumberFormatException e) {
                throw new ArgumentException("invalid value for " + this.shortLongName());
            }
        }
    }

    public final int getOptionValueAsInteger() {
        return this.intValue;
    }
}

