/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.internal.util.cmdline;

import com.sap.jvm.internal.util.cmdline.ArgumentException;
import com.sap.jvm.internal.util.cmdline.FlagWithOptionList;

public class FlagWithIntegerOptionList
extends FlagWithOptionList {
    private int[] integerOptionValues = null;

    public FlagWithIntegerOptionList(char flagChar, String longName, String description, String optionName) {
        super(Character.valueOf(flagChar), longName, description, optionName);
    }

    public FlagWithIntegerOptionList(Character flagChar, String longName, String description, String optionName) {
        super(flagChar, longName, description, optionName);
    }

    @Override
    protected void postParse() throws ArgumentException {
        super.postParse();
        if (this.isSet()) {
            String[] optionValues = this.getOptionValues();
            this.integerOptionValues = new int[optionValues.length];
            for (int i = 0; i < this.integerOptionValues.length; ++i) {
                try {
                    this.integerOptionValues[i] = Integer.parseInt(optionValues[i]);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new ArgumentException("\"" + optionValues[i] + "\" - invalid option for " + this.shortLongName() + " (not a number)");
                }
            }
        }
    }

    public final int[] getOptionValuesAsIntegers() {
        return this.integerOptionValues;
    }
}

