/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.internal.util.cmdline;

import com.sap.jvm.internal.util.cmdline.ArgumentException;
import com.sap.jvm.internal.util.cmdline.Flag;

public class FlagWithOption
extends Flag {
    private final String optionName;
    private String optionValue = null;
    private final boolean optionValueIsOptional;
    private final String defaultOtionValue;

    public FlagWithOption(char flagChar, String longName, String description, String optionName) {
        this(Character.valueOf(flagChar), longName, description, optionName);
    }

    public FlagWithOption(char flagChar, String longName, String description, String optionName, String defaultOtionValue) {
        this(Character.valueOf(flagChar), longName, description, optionName, defaultOtionValue);
    }

    public FlagWithOption(Character flagChar, String longName, String description, String optionName) {
        super(flagChar, longName, description);
        this.optionName = optionName;
        this.optionValueIsOptional = false;
        this.defaultOtionValue = null;
    }

    public FlagWithOption(Character flagChar, String longName, String description, String optionName, String defaultOtionValue) {
        super(flagChar, longName, description);
        this.optionName = optionName;
        this.optionValueIsOptional = true;
        this.defaultOtionValue = defaultOtionValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void postParse() throws ArgumentException {
        super.postParse();
        if (!this.isSet()) return;
        if (this.optionValue == null) {
            if (!this.optionValueIsOptional) throw new ArgumentException("option missing for " + this.shortLongName());
            this.optionValue = this.defaultOtionValue;
            return;
        } else {
            if (this.optionValue.length() != 0) return;
            throw new ArgumentException("option missing for " + this.shortLongName());
        }
    }

    final void setOptionValue(String value) {
        this.optionValue = value;
    }

    public final String getOptionName() {
        return this.optionName;
    }

    public final boolean optionValueIsOptional() {
        return this.optionValueIsOptional;
    }

    public final String getDefaultOtionValue() {
        return this.defaultOtionValue;
    }

    String getOptionDetailedExplanation() {
        return null;
    }

    public final String getOptionValue() {
        return this.optionValue;
    }
}

