/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.jdi;

import com.sap.jvm.jdi.BooleanValue;
import com.sap.jvm.jdi.ByteValue;
import com.sap.jvm.jdi.CharValue;
import com.sap.jvm.jdi.ClassLoaderReference;
import com.sap.jvm.jdi.DoubleValue;
import com.sap.jvm.jdi.FloatValue;
import com.sap.jvm.jdi.IntegerValue;
import com.sap.jvm.jdi.LongValue;
import com.sap.jvm.jdi.Mirror;
import com.sap.jvm.jdi.ModuleReference;
import com.sap.jvm.jdi.ReferenceType;
import com.sap.jvm.jdi.ShortValue;
import com.sap.jvm.jdi.StringReference;
import com.sap.jvm.jdi.ThreadGroupReference;
import com.sap.jvm.jdi.ThreadReference;
import com.sap.jvm.jdi.VoidValue;
import com.sap.jvm.jdi.event.EventQueue;
import com.sap.jvm.jdi.request.EventRequestManager;
import java.util.List;
import java.util.Map;

public interface VirtualMachine
extends Mirror {
    public static final int TRACE_NONE = 0;
    public static final int TRACE_SENDS = 1;
    public static final int TRACE_RECEIVES = 2;
    public static final int TRACE_EVENTS = 4;
    public static final int TRACE_REFTYPES = 8;
    public static final int TRACE_OBJREFS = 16;
    public static final int TRACE_ALL = 0xFFFFFF;

    default public List<ModuleReference> allModules() {
        throw new UnsupportedOperationException("The method allModules() must be implemented");
    }

    public List<ReferenceType> classesByName(String var1);

    public List<ReferenceType> allClasses();

    public void redefineClasses(Map<? extends ReferenceType, byte[]> var1);

    public List<ThreadReference> allThreads();

    public void suspend();

    public void resume();

    public List<ThreadGroupReference> topLevelThreadGroups();

    public EventQueue eventQueue();

    public EventRequestManager eventRequestManager();

    public BooleanValue mirrorOf(boolean var1);

    public ByteValue mirrorOf(byte var1);

    public CharValue mirrorOf(char var1);

    public ShortValue mirrorOf(short var1);

    public IntegerValue mirrorOf(int var1);

    public LongValue mirrorOf(long var1);

    public FloatValue mirrorOf(float var1);

    public DoubleValue mirrorOf(double var1);

    public StringReference mirrorOf(String var1);

    public VoidValue mirrorOfVoid();

    public Process process();

    public void dispose();

    public void exit(int var1);

    public boolean canWatchFieldModification();

    public boolean canWatchFieldAccess();

    public boolean canGetBytecodes();

    public boolean canGetSyntheticAttribute();

    public boolean canGetOwnedMonitorInfo();

    public boolean canGetCurrentContendedMonitor();

    public boolean canGetMonitorInfo();

    public boolean canUseInstanceFilters();

    public boolean canRedefineClasses();

    public boolean canAddMethod();

    public boolean canUnrestrictedlyRedefineClasses();

    public boolean canPopFrames();

    public boolean canGetSourceDebugExtension();

    public boolean canRequestVMDeathEvent();

    public boolean canGetMethodReturnValues();

    public boolean canGetInstanceInfo();

    public boolean canUseSourceNameFilters();

    public boolean canForceEarlyReturn();

    public boolean canBeModified();

    public boolean canRequestMonitorEvents();

    public boolean canGetMonitorFrameInfo();

    public boolean canGetClassFileVersion();

    public boolean canGetConstantPool();

    default public boolean canGetModuleInfo() {
        return false;
    }

    public void setDefaultStratum(String var1);

    public String getDefaultStratum();

    public long[] instanceCounts(List<? extends ReferenceType> var1);

    public String description();

    public String version();

    public String name();

    public void setDebugTraceMode(int var1);

    public boolean canUseSapExtensions();

    public boolean canUseStringExtensions();

    public boolean hasStackTrackerSupportForAllStepTypes();

    public boolean hasStackTrackerSupportForStepEnd();

    public Object getTraceContext();

    public void setTraceContext(Object var1);

    public List<ReferenceType> visibleClasses(ClassLoaderReference var1);

    public void setConstantPoolMappingCreator(ConstantPoolMappingCreator var1);

    public ConstantPoolMappingCreator getConstantPoolMappingCreator();

    public static interface ConstantPoolMappingCreator {
        public Map<String, String> createNameMapping(byte[] var1, int var2);
    }
}

