/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller;

import com.sap.jvm.profiling.controller.impl.ControllerFactoryImpl;
import com.sap.jvm.profiling.controller.impl.FileControllerImpl;
import com.sap.jvm.profiling.controller.impl.RemoteControllerImpl;
import com.sap.jvm.profiling.resource.Resource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public final class ControllerFactory {
    private static final ControllerFactoryImpl impl = new ControllerFactoryImpl();

    public static FileControllerImpl create(String filename, String sessionDirectory, File tempDirectory) throws FileNotFoundException, IOException {
        return impl.createFileController(filename, sessionDirectory, tempDirectory);
    }

    public static RemoteControllerImpl createRemoteController(String backupFilename, String sessionDirectory, File tempDirectory) {
        return impl.createRemoteController(backupFilename, sessionDirectory, tempDirectory, true);
    }

    public static RemoteControllerImpl createRemoteController(String backupFilename, String sessionDirectory, File tempDirectory, boolean gcTraceAllowed) {
        return impl.createRemoteController(backupFilename, sessionDirectory, tempDirectory, gcTraceAllowed);
    }

    public static void extractOriginalData(String filename, String srcDirectory, String destDirectory, String destFilename) throws IOException {
        impl.extractOriginalData(filename, srcDirectory, destDirectory, destFilename);
    }

    public static boolean isRecoverWorkspace(String directory) {
        return impl.isRecoverWorkspace(directory);
    }

    public static boolean isSnapshotFile(String snpFilename) throws IOException {
        return impl.isSnapshotFile(snpFilename);
    }

    public static Resource getResource(String controllerId, int resourceId) throws IOException {
        return impl.getResource(controllerId, resourceId);
    }

    public static void setResourceCacheUsage(boolean useCache) {
        impl.setResourceCacheUsage(useCache);
    }
}

