/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl;

import com.sap.jvm.profiling.controller.Controller;
import com.sap.jvm.profiling.controller.ResourceController;
import com.sap.jvm.profiling.controller.impl.resource.AbstractResourceManagerImpl;
import com.sap.jvm.profiling.presentation.typed.TypedModel;
import com.sap.jvm.profiling.resource.AbstractResource;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.Resource;
import com.sap.jvm.profiling.resource.ResourceName;
import java.io.IOException;

public abstract class AbstractResourceController<T extends TypedModel>
extends AbstractResource
implements ResourceController<T> {
    private final AbstractResourceManagerImpl<T> resourceManager;

    protected AbstractResourceController(ResourceName name) {
        super(name);
        this.resourceManager = (AbstractResourceManagerImpl)name.getResourceManager();
    }

    @Override
    public Controller getController() {
        return ((AbstractResourceManagerImpl)this.getResourceName().getResourceManager()).getController();
    }

    @Override
    public ResourceController<T> getParent() throws IOException {
        ResourceName parentName = this.resourceManager.getParent(this.getResourceName());
        if (parentName == null) {
            return null;
        }
        ProgressReporter reporter = new ProgressReporter();
        Resource result = null;
        try {
            result = this.resourceManager.get(parentName, reporter);
        }
        catch (IOException e) {
            reporter.finish();
            throw e;
        }
        reporter.finish();
        if (result instanceof ResourceController) {
            return (ResourceController)result;
        }
        return null;
    }

    @Override
    public ResourceName getParentName() {
        return this.resourceManager.getParent(this.getResourceName());
    }

    public boolean isModifiable() {
        return false;
    }

    public String toString() {
        return "Controller for '" + this.getResourceName() + "'";
    }

    @Override
    public void open() {
        this.resourceManager.open(this.getResourceName());
    }

    @Override
    public void collapse() {
        this.resourceManager.collapse(this.getResourceName());
    }

    @Override
    public void expand() {
        this.resourceManager.expand(this.getResourceName());
    }

    @Override
    public boolean isExpanded() {
        return this.resourceManager.isExpanded(this.getResourceName());
    }

    public ResourceName[] getDependents() {
        return null;
    }

    @Override
    public boolean isOpen() {
        return this.resourceManager.isOpen(this);
    }

    @Override
    public void close() {
        this.resourceManager.closed(this.getResourceName());
    }

    @Override
    public ResourceController<T>[] getChildren() throws IOException {
        return this.resourceManager.getChildren(this);
    }

    public final ResourceName getBaseName() {
        return this.getResourceName().stripLastElement();
    }
}

