/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl;

import com.sap.jvm.profiling.CommandHandler;
import com.sap.jvm.profiling.Connection;
import com.sap.jvm.profiling.ProfilingFactory;
import com.sap.jvm.profiling.control.command.ControlCommandFactory;
import com.sap.jvm.profiling.core.command.Command;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class CommandHandlerThread
extends Thread {
    private static final String threadName = "ProfilingCommandHandlerThread";
    private static final ControlCommandFactory ctrlFactory = ProfilingFactory.createControlCommandFactory();
    private List<Command> commandQueue = new ArrayList<Command>();
    private boolean stopRequested = false;
    private CommandHandler commandHandler;
    private Connection connection;

    public CommandHandlerThread(Connection connection) {
        super(threadName);
        this.commandHandler = ProfilingFactory.createCommandHandler((Connection)connection);
        this.connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (true) {
                List<Command> list = this.commandQueue;
                synchronized (list) {
                    try {
                        Command command;
                        if (this.stopRequested) {
                            while (true) {
                                if (this.commandQueue.isEmpty()) {
                                    return;
                                }
                                command = this.commandQueue.remove(0);
                                this.commandHandler.sendCommand(command);
                            }
                        }
                        while (this.commandQueue.isEmpty() && this.connection.isOpen()) {
                            this.commandQueue.wait(5000L);
                        }
                        if (!this.connection.isOpen()) {
                            return;
                        }
                        command = this.commandQueue.remove(0);
                        this.commandHandler.sendCommand(command);
                    }
                    catch (IOException ex) {
                        Trace.warn((Throwable)ex, (String)"Got an I/O error during sending commands.");
                        return;
                    }
                }
            }
        }
        catch (InterruptedException ex) {
            Trace.error((Throwable)ex, (String)"Command handler thread gets interrupted.");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(boolean sendStopCommand) {
        List<Command> list = this.commandQueue;
        synchronized (list) {
            this.commandQueue.clear();
            this.stopRequested = true;
            if (sendStopCommand) {
                this.commandQueue.add((Command)ctrlFactory.createStopProfilingCommand());
                this.commandQueue.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendCommand(Command command) {
        List<Command> list = this.commandQueue;
        synchronized (list) {
            if (this.stopRequested) {
                return;
            }
            this.commandQueue.add(command);
            this.commandQueue.notify();
        }
    }
}

