/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl;

import com.sap.jvm.profiling.controller.Controller;
import com.sap.jvm.profiling.controller.impl.FileControllerImpl;
import com.sap.jvm.profiling.controller.impl.RemoteControllerImpl;
import com.sap.jvm.profiling.controller.impl.model.compare.CompareCreationContextFactory;
import com.sap.jvm.profiling.controller.impl.resource.AbstractResourceManagerImpl;
import com.sap.jvm.profiling.controller.impl.resource.ProfilingSessionReader;
import com.sap.jvm.profiling.presentation.resource.CreationContextFactory;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.Resource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public final class ControllerFactoryImpl {
    private static long uniqueId = 0L;
    private List<Controller> controllers = new LinkedList<Controller>();

    public ControllerFactoryImpl() {
        this.initializeStaticControllerContent();
    }

    public synchronized FileControllerImpl createFileController(String filename, String sessionDirectory, File tempDirectory) throws FileNotFoundException, IOException {
        FileControllerImpl controller = new FileControllerImpl(this, ControllerFactoryImpl.generateUniqueIdentifier(), filename, sessionDirectory, tempDirectory);
        this.controllers.add(controller);
        return controller;
    }

    public synchronized RemoteControllerImpl createRemoteController(String backupFilename, String tmpDirectory, File tempDirectory, boolean gcTraceAllowed) {
        RemoteControllerImpl controller = new RemoteControllerImpl(this, ControllerFactoryImpl.generateUniqueIdentifier(), backupFilename, tmpDirectory, tempDirectory, gcTraceAllowed);
        this.controllers.add(controller);
        return controller;
    }

    public void extractOriginalData(String filename, String srcDirectory, String destDirectory, String destFilename) throws IOException {
        ProfilingSessionReader.extractOriginalData(filename, srcDirectory, destDirectory, destFilename);
    }

    public boolean isRecoverWorkspace(String directory) {
        return ProfilingSessionReader.isRecoverWorkspace(directory);
    }

    public boolean isSnapshotFile(String snpFilename) throws IOException {
        return FileControllerImpl.isSnapshotFile(snpFilename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource getResource(String controllerId, int resourceId) throws IOException {
        Controller controller = null;
        ControllerFactoryImpl controllerFactoryImpl = this;
        synchronized (controllerFactoryImpl) {
            for (Controller current : this.controllers) {
                if (!current.getId().equals(controllerId)) continue;
                assert (controller == null);
                controller = current;
            }
        }
        if (controller == null) {
            return null;
        }
        AbstractResourceManagerImpl manager = (AbstractResourceManagerImpl)controller.getProfilingSession().getResourceManager();
        ProgressReporter reporter = new ProgressReporter();
        Resource resource = manager.get(resourceId, reporter);
        reporter.finish();
        return resource;
    }

    public synchronized void controllerClosed(Controller controller) {
        this.controllers.remove(controller);
    }

    private void initializeStaticControllerContent() {
        CreationContextFactory.registerElementContextCreatorFactory(new CompareCreationContextFactory());
    }

    private static synchronized String generateUniqueIdentifier() {
        long newId = System.currentTimeMillis();
        uniqueId = newId > uniqueId ? newId : uniqueId + 1L;
        return String.valueOf(uniqueId);
    }

    public void setResourceCacheUsage(boolean useCache) {
        AbstractResourceManagerImpl.setResourceCacheUsage(useCache);
    }
}

