/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl;

import com.sap.jvm.profiling.OfflineProfilingSession;
import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.controller.AlertsController;
import com.sap.jvm.profiling.controller.Controller;
import com.sap.jvm.profiling.controller.ErrorHandler;
import com.sap.jvm.profiling.controller.ResourceController;
import com.sap.jvm.profiling.controller.SnapshotListener;
import com.sap.jvm.profiling.controller.impl.ControllerFactoryImpl;
import com.sap.jvm.profiling.controller.impl.model.AbstractTypedController;
import com.sap.jvm.profiling.controller.impl.model.HeartBeatInfoImpl;
import com.sap.jvm.profiling.controller.impl.model.ModelControllerImpl;
import com.sap.jvm.profiling.controller.impl.model.alerts.AlertsInfoImpl;
import com.sap.jvm.profiling.controller.impl.resource.AbstractResourceManagerImpl;
import com.sap.jvm.profiling.controller.impl.resource.ResourceUtils;
import com.sap.jvm.profiling.controller.model.AlertsInfo;
import com.sap.jvm.profiling.controller.model.HeartBeatInfo;
import com.sap.jvm.profiling.controller.model.SnapshotController;
import com.sap.jvm.profiling.controller.trace.ProfilingTrace;
import com.sap.jvm.profiling.controller.trace.TraceListener;
import com.sap.jvm.profiling.core.ProfilingReader;
import com.sap.jvm.profiling.core.event.HeartBeatEventHandler;
import com.sap.jvm.profiling.core.event.SnapshotMarkerHandler;
import com.sap.jvm.profiling.io.event.IOEventHandler;
import com.sap.jvm.profiling.memory.event.AllocationEventHandler;
import com.sap.jvm.profiling.memory.event.ClassStatisticEventHandler;
import com.sap.jvm.profiling.memory.event.GcEventHandler;
import com.sap.jvm.profiling.memory.event.GcHistoryFileDumpEventHandler;
import com.sap.jvm.profiling.memory.event.HprofDumpEventHandler;
import com.sap.jvm.profiling.method.event.MethodParameterEventHandler;
import com.sap.jvm.profiling.method.event.MethodToTraceHandler;
import com.sap.jvm.profiling.method.event.TimeBasedSamplingEventHandler;
import com.sap.jvm.profiling.net.event.NetworkEventHandler;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceManager;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.snapshot.SnapshotResourceManagerFactory;
import com.sap.jvm.profiling.sync.event.SynchronizationEventHandler;
import com.sap.jvm.profiling.thread.event.ThreadDumpEventHandler;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;

public abstract class ControllerImpl
implements Controller {
    protected ModelControllerImpl modelController;
    protected ErrorHandler writeFailureHandler;
    protected ArrayList<TraceListener> traceListeners;
    protected HeartBeatInfoImpl heartBeatInfo;
    protected AlertsInfoImpl alertsInfo;
    protected ControllerFactoryImpl controllerFactory;
    private String id;
    private ArrayList<SnapshotListener> snapshotListeners;
    private boolean closed;
    protected Properties properties;

    public ControllerImpl(ControllerFactoryImpl factory, String id) {
        this.controllerFactory = factory;
        this.id = id;
        this.closed = false;
        this.modelController = new ModelControllerImpl(this);
        this.alertsInfo = new AlertsInfoImpl(this);
        this.traceListeners = new ArrayList();
        this.snapshotListeners = new ArrayList();
        this.properties = new Properties();
        this.heartBeatInfo = new HeartBeatInfoImpl(this);
        this.registerTraceListener(this.heartBeatInfo);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public ModelControllerImpl getModelController() {
        return this.modelController;
    }

    @Override
    public void registerErrorHandler(ErrorHandler handler) {
        this.writeFailureHandler = handler;
    }

    public ErrorHandler getErrorHandler() {
        return this.writeFailureHandler;
    }

    @Override
    public synchronized void registerTraceListener(TraceListener listener) {
        assert (listener != null);
        this.traceListeners.add(listener);
    }

    @Override
    public synchronized void removeTraceListener(TraceListener listener) {
        assert (listener != null);
        this.traceListeners.remove(listener);
    }

    @Override
    public HeartBeatInfo getHeartBeatInfo() {
        return this.heartBeatInfo;
    }

    @Override
    public AlertsInfo getAlertsInfo() {
        return this.alertsInfo;
    }

    public synchronized void traceEnabled(ProfilingTrace trace) {
        for (TraceListener listener : this.traceListeners) {
            listener.traceEnabled(trace, trace.getStartTimestamp());
        }
    }

    public synchronized void traceDisabled(ProfilingTrace trace) {
        for (TraceListener listener : this.traceListeners) {
            listener.traceDisabled(trace, trace.getEndTimestamp());
        }
    }

    @Override
    public ResourceController<?>[] getResourceController() throws IOException {
        ProgressReporter progressReporter = new ProgressReporter();
        ProfilingSession session = this.getProfilingSession();
        AbstractResourceManagerImpl resourceManager = (AbstractResourceManagerImpl)session.getResourceManager();
        ResourceController<T>[] retValue = resourceManager.getResourceController(progressReporter);
        progressReporter.finish();
        return retValue;
    }

    @Override
    public SnapshotController<?, ?>[] getSnapshotResourceController() throws IOException {
        if (this.closed) {
            return new SnapshotController[0];
        }
        ProfilingSession session = this.getProfilingSession();
        AbstractResourceManagerImpl resourceManager = (AbstractResourceManagerImpl)session.getResourceManager();
        return resourceManager.getSnapshotResourceController();
    }

    @Override
    public AlertsController<?> getAlertsResourceController(boolean open) throws IOException {
        if (!this.closed) {
            ProfilingSession session = this.getProfilingSession();
            AbstractResourceManagerImpl resourceManager = (AbstractResourceManagerImpl)session.getResourceManager();
            return resourceManager.getAlertsResourceController(open);
        }
        return null;
    }

    @Override
    public void close(boolean delete) {
        ProfilingSession session = this.getProfilingSession();
        if (session != null) {
            AbstractResourceManagerImpl manager = (AbstractResourceManagerImpl)session.getResourceManager();
            if (manager != null) {
                manager.close();
            }
            session.close();
            SnapshotResourceManagerFactory.remove(session);
        }
        this.controllerFactory.controllerClosed(this);
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SnapshotController<?, ?> getSnapshotController(Snapshot snapshot) {
        ResourceManager manager = this.getProfilingSession().getResourceManager();
        ProgressReporter reporter = new ProgressReporter();
        ResourceName snapshotControllerName = ResourceUtils.getControllerName(snapshot);
        SnapshotController result = null;
        try {
            result = (SnapshotController)manager.get(snapshotControllerName, reporter);
        }
        catch (IOException iOException) {
        }
        finally {
            reporter.finish();
        }
        return result;
    }

    public void snapshotCreated(Snapshot snapshot, ResourceName parentViewName) {
        SnapshotController<?, ?> snapshotController = this.getSnapshotController(snapshot);
        if (snapshotController == null) {
            return;
        }
        ResourceName snapshotControllerName = ResourceUtils.getControllerName(snapshot);
        ResourceManager manager = this.getProfilingSession().getResourceManager();
        if (parentViewName != null) {
            manager.setParent(parentViewName, snapshotControllerName);
        }
        if (snapshotController instanceof AbstractTypedController) {
            try {
                ResourceController parentController = snapshotController.getParent();
                AbstractTypedController controllerImpl = (AbstractTypedController)((Object)snapshotController);
                controllerImpl.notifyOfParent(parentController);
            }
            catch (IOException ex) {
                return;
            }
        }
        for (SnapshotListener listener : this.getCopyOfSnapshotListener()) {
            listener.snapshotCreated(snapshot, this);
        }
    }

    public void snapshotRenamed(Snapshot snapshot, String oldName, String newName) {
        SnapshotController<?, ?> snapshotController = this.getSnapshotController(snapshot);
        if (snapshotController == null) {
            return;
        }
        for (SnapshotListener listener : this.getCopyOfSnapshotListener()) {
            listener.snapshotRenamed(snapshot, this, oldName, newName);
        }
        try {
            PacketResourceWriter writer = this.getProfilingSession().getResourceManager().getWriter(snapshot.asResourceName());
            snapshot.write(writer);
            writer.close();
        }
        catch (IOException ex) {
            Trace.warn((Throwable)ex, (String)"Failure during updating the snapshot.");
        }
    }

    public void snapshotRemoved(Snapshot snapshot) {
        for (SnapshotListener listener : this.getCopyOfSnapshotListener()) {
            listener.snapshotRemoved(snapshot, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void registerSnapshotListener(SnapshotListener listener) {
        ArrayList<SnapshotListener> arrayList = this.snapshotListeners;
        synchronized (arrayList) {
            this.snapshotListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSnapshotListener(SnapshotListener listener) {
        ArrayList<SnapshotListener> arrayList = this.snapshotListeners;
        synchronized (arrayList) {
            this.snapshotListeners.remove(listener);
        }
    }

    protected void registerHandlers(ProfilingReader reader) {
        reader.registerAllocationEventHandler((AllocationEventHandler)this.modelController.getAllocationModel());
        reader.registerTimeBasedSamplingEventHandler((TimeBasedSamplingEventHandler)this.modelController.getPerformanceHotspotModel());
        reader.registerMethodParameterEventHandler((MethodParameterEventHandler)this.modelController.getMethodParameterModel());
        reader.registerIOEventHandler((IOEventHandler)this.modelController.getIOModel());
        reader.registerSynchronizationEventHandler((SynchronizationEventHandler)this.modelController.getSynchronizationModel());
        reader.registerNetworkEventHandler((NetworkEventHandler)this.modelController.getNetworkModel());
        reader.registerHprofDumpEventHandler((HprofDumpEventHandler)this.modelController.getHprofDumpModel());
        reader.registerGcEventHandler((GcEventHandler)this.modelController.getGcModel());
        reader.registerClassStatisticEventHandler((ClassStatisticEventHandler)this.modelController.getClassStatisticsModel());
        reader.registerThreadDumpEventHandler((ThreadDumpEventHandler)this.modelController.getThreadDumpModel());
        reader.registerSnapshotMarkHandler((SnapshotMarkerHandler)this.modelController.getMethodParameterModel());
        reader.registerSnapshotMarkHandler((SnapshotMarkerHandler)this.modelController.getAllocationModel());
        reader.registerSnapshotMarkHandler((SnapshotMarkerHandler)this.modelController.getPerformanceHotspotModel());
        reader.registerSnapshotMarkHandler((SnapshotMarkerHandler)this.modelController.getIOModel());
        reader.registerSnapshotMarkHandler((SnapshotMarkerHandler)this.modelController.getSynchronizationModel());
        reader.registerSnapshotMarkHandler((SnapshotMarkerHandler)this.modelController.getNetworkModel());
        reader.registerSnapshotMarkHandler((SnapshotMarkerHandler)this.modelController.getGcModel());
        reader.registerSnapshotMarkHandler((SnapshotMarkerHandler)this.modelController.getThreadDumpModel());
        reader.registerMethodToTraceHandler((MethodToTraceHandler)this.modelController.getMethodParameterModel());
        reader.registerMethodToTraceHandler((MethodToTraceHandler)this.modelController.getAllocationModel());
        reader.registerMethodToTraceHandler((MethodToTraceHandler)this.modelController.getPerformanceHotspotModel());
        reader.registerHeartBeatEventHandler((HeartBeatEventHandler)this.heartBeatInfo);
        reader.registerGcHistoryFileDumpEventHandler((GcHistoryFileDumpEventHandler)this.modelController.getGcHistoryFileDumpModel());
        this.alertsInfo.initHandler(reader);
    }

    public boolean usesChunkedFile() {
        ProfilingSession session = this.getProfilingSession();
        if (session instanceof OfflineProfilingSession) {
            OfflineProfilingSession offSession = (OfflineProfilingSession)session;
            return offSession.getReader() != null && offSession.usesChunkedFile();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<SnapshotListener> getCopyOfSnapshotListener() {
        ArrayList snapshotListenersCopy = null;
        ArrayList<SnapshotListener> arrayList = this.snapshotListeners;
        synchronized (arrayList) {
            snapshotListenersCopy = (ArrayList)this.snapshotListeners.clone();
        }
        return snapshotListenersCopy;
    }
}

