/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl;

import com.sap.jvm.profiling.ProfilingFactory;
import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.controller.FileController;
import com.sap.jvm.profiling.controller.impl.ControllerFactoryImpl;
import com.sap.jvm.profiling.controller.impl.ControllerImpl;
import com.sap.jvm.profiling.controller.impl.resource.OfflineResourceManagerImpl;
import com.sap.jvm.profiling.controller.impl.resource.PrfOfflineResourceManagerImpl;
import com.sap.jvm.profiling.controller.impl.resource.ProfilingSessionReader;
import com.sap.jvm.profiling.controller.impl.resource.ResourceReaderImpl;
import com.sap.jvm.profiling.controller.impl.resource.SnpOfflineResourceManagerImpl;
import com.sap.jvm.profiling.controller.impl.trace.ProfilingTraceSetImpl;
import com.sap.jvm.profiling.core.ProfilingPacket;
import com.sap.jvm.profiling.core.ProfilingReader;
import com.sap.jvm.profiling.core.event.HeartBeatEvent;
import com.sap.jvm.profiling.resource.PacketResourceReader;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceManager;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.tracing.Trace;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public final class FileControllerImpl
extends ControllerImpl
implements FileController {
    private final String filename;
    private ProfilingSession session;
    private ProfilingReader reader;
    private OfflineResourceManagerImpl resourceManager;
    private boolean isOrigDataRecovery;
    private boolean isSnapshotFile;
    private boolean isRestoreInfoAvail;
    private long fileLength;
    private boolean fallbackPrf;
    private boolean fallbackSnp;
    private String sessionDirectory;

    public FileControllerImpl(ControllerFactoryImpl controllerFactory, String id, String filename, String sessionDirectory, File tempDirectory) throws IOException {
        block10: {
            super(controllerFactory, id);
            this.filename = filename;
            this.sessionDirectory = sessionDirectory;
            this.fallbackPrf = false;
            this.fallbackSnp = false;
            String recoverFilename = sessionDirectory + File.separator + ".recover";
            if (filename == null && new File(recoverFilename).exists()) {
                this.isOrigDataRecovery = true;
                this.session = ProfilingFactory.createSession();
                this.resourceManager = new PrfOfflineResourceManagerImpl(this, sessionDirectory, tempDirectory, false, ProfilingSessionReader.getVersionInfo(sessionDirectory));
                this.session.registerResourceManager((ResourceManager)this.resourceManager);
                return;
            }
            this.isRestoreInfoAvail = OfflineResourceManagerImpl.isRestoreInfoAvail(sessionDirectory);
            if (!this.isRestoreInfoAvail && filename == null) {
                throw new FileNotFoundException("No information found");
            }
            boolean bl = this.isSnapshotFile = filename == null ? false : this.isSnapshotFile();
            if (!this.isSnapshotFile && !this.isRestoreInfoAvail) {
                this.session = ProfilingFactory.createSession((String)filename);
                this.reader = this.session.getReader();
                this.registerHandlers(this.reader);
                this.resourceManager = new PrfOfflineResourceManagerImpl(this, sessionDirectory, tempDirectory, true, null);
                this.session.registerResourceManager((ResourceManager)this.resourceManager);
                String controllerPropsFilename = sessionDirectory + File.separator + "controllerProps.tmp";
                FileInputStream is = null;
                try {
                    is = new FileInputStream(controllerPropsFilename);
                    this.properties.load(is);
                    for (String key : this.properties.keySet().toArray(new String[0])) {
                        if (key.startsWith("PERSIST_")) continue;
                        this.properties.remove(key);
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {}
            } else {
                this.session = this.isSnapshotFile || filename == null ? ProfilingFactory.createSession() : ProfilingFactory.createSession((String)filename);
                ProfilingSessionReader sessionReader = new ProfilingSessionReader(this.isSnapshotFile ? filename : null, sessionDirectory, this.isRestoreInfoAvail);
                this.resourceManager = new SnpOfflineResourceManagerImpl(filename, this.isSnapshotFile, sessionReader, this, sessionDirectory, tempDirectory);
                this.session.registerResourceManager((ResourceManager)this.resourceManager);
                try {
                    this.resourceManager.init();
                    this.properties = sessionReader.getProperties();
                    return;
                }
                catch (Throwable ex) {
                    Trace.warn((Throwable)ex, (String)"Error during initialization resource manager.");
                    if (filename == null) {
                        throw new IOException("Problem during initialization resource manager.");
                    }
                    this.fallbackPrf = !this.isSnapshotFile;
                    this.fallbackSnp = this.isSnapshotFile;
                    ((SnpOfflineResourceManagerImpl)this.resourceManager).fallback();
                    if (!this.fallbackPrf) break block10;
                    this.reader = this.session.getReader();
                    this.registerHandlers(this.reader);
                }
            }
        }
    }

    @Override
    public ProfilingSession getProfilingSession() {
        return this.session;
    }

    @Override
    public ProfilingReader getReader() {
        return this.reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void process(ProgressReporter progressReporter) throws IOException {
        String recoverFilename;
        block13: {
            block11: {
                block10: {
                    block12: {
                        boolean success;
                        if (this.isOrigDataRecovery) {
                            this.recover(progressReporter);
                            String recoverFilename2 = this.sessionDirectory + File.separator + ".recover";
                            new File(recoverFilename2).delete();
                            return;
                        }
                        recoverFilename = this.sessionDirectory + File.separator + ".recover";
                        if (!this.fallbackPrf && !this.isSnapshotFile && !this.isRestoreInfoAvail) break block12;
                        boolean bl = success = this.fallbackSnp ? false : this.processSnapshotInfo(progressReporter);
                        if (!success) {
                            this.restoreEventData(progressReporter);
                            if (this.isSnapshotFile) {
                                File corruptedFile = new File(this.sessionDirectory, ".corruptedSnpFile");
                                corruptedFile.createNewFile();
                            }
                        }
                        break block13;
                    }
                    long maxWorkToDo = this.fileLength;
                    try {
                        while (this.reader.nextPacket() != null) {
                            if (progressReporter == null || progressReporter.report(this.reader.getNrOfReadBytes(), maxWorkToDo)) continue;
                            new File(recoverFilename).delete();
                            break block10;
                        }
                        break block11;
                    }
                    catch (EOFException e) {
                        Trace.warn((Throwable)e, () -> "Got an unexpected EOF while reading " + this.filename);
                        break block11;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                this.resourceManager.closeWriters();
                return;
            }
            this.modelController.createSnapshotsInternal(this.reader.getLastlyReadTimestamp(), true);
        }
        if (this.session.getReader() != null) {
            this.session.getReader().close();
        }
        new File(recoverFilename).delete();
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    private boolean processSnapshotInfo(ProgressReporter progressReporter) throws IOException {
        SnpOfflineResourceManagerImpl snpResourceManager = (SnpOfflineResourceManagerImpl)this.resourceManager;
        if (progressReporter != null) {
            long maxLoadWork = snpResourceManager.calculateLoadWork();
            progressReporter.addToMaximumWork(maxLoadWork);
        }
        snpResourceManager.readMapInfo(progressReporter);
        snpResourceManager.readViewState();
        try {
            ProfilingTraceSetImpl traceSet = this.readTraceInfo(snpResourceManager.getTraceInfoReader());
            Snapshot[] snapshots = snpResourceManager.readSnapshots();
            this.modelController.setTraceHistory(traceSet);
            this.addSnapshots(snapshots, progressReporter);
        }
        catch (IOException ex) {
            Trace.warn((Throwable)ex, (String)"Error during reading trace and and snapshot information.");
            return false;
        }
        this.readHeartBeatInfo(snpResourceManager.getHeartBeatReader(), progressReporter);
        this.readAlertsInfo(snpResourceManager.getAlertsReader(), progressReporter);
        snpResourceManager.readResources();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreEventData(ProgressReporter progressReporter) throws IOException {
        SnpOfflineResourceManagerImpl snpResourceManager = (SnpOfflineResourceManagerImpl)this.resourceManager;
        try {
            this.reader = snpResourceManager.getEventReader();
            this.registerHandlers(this.reader);
            long maxWorkToDo = this.fileLength;
            while (this.reader.nextPacket() != null) {
                if (progressReporter == null || progressReporter.report(this.reader.getNrOfReadBytes(), maxWorkToDo)) continue;
                return;
            }
            this.modelController.createSnapshotsInternal(this.reader.getLastlyReadTimestamp(), true);
            snpResourceManager.createViewStateStore();
        }
        finally {
            if (this.reader != null) {
                this.reader.close();
            }
        }
    }

    private void recover(ProgressReporter reporter) throws IOException {
        this.fileLength = ProfilingSessionReader.getEventFileLength(this.sessionDirectory);
        reporter.addToMaximumWork(this.fileLength);
        ProfilingSessionReader.readMapInfo(this.sessionDirectory, this, reporter);
        try {
            this.reader = this.resourceManager.getEventReader();
            this.registerHandlers(this.reader);
            while (this.reader.nextPacket() != null) {
                if (reporter.report(this.reader.getNrOfReadBytes(), reporter.getMaximumWork())) continue;
                return;
            }
            this.modelController.createSnapshotsInternal(this.reader.getLastlyReadTimestamp(), true);
        }
        finally {
            if (this.reader != null) {
                this.reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSnapshotFile() {
        RandomAccessFile file = null;
        try {
            file = new RandomAccessFile(this.filename, "r");
            int encoding = file.read();
            this.fileLength = file.length();
            boolean bl = encoding == 8 || encoding == 4;
            return bl;
        }
        catch (IOException ex) {
            Trace.warn((Throwable)ex, () -> "I/O error during reading file \"" + this.filename + "\".");
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (IOException ex) {
                    Trace.warn((Throwable)ex, () -> "I/O error during closing file \"" + this.filename + "\".");
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSnapshotFile(String filename) {
        RandomAccessFile file = null;
        try {
            file = new RandomAccessFile(filename, "r");
            int encoding = file.read();
            boolean bl = encoding == 8 || encoding == 4;
            return bl;
        }
        catch (IOException ex) {
            Trace.warn((Throwable)ex, () -> "I/O error during reading file \"" + filename + "\".");
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (IOException ex) {
                    Trace.warn((Throwable)ex, () -> "I/O error during closing file \"" + filename + "\".");
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readHeartBeatInfo(ResourceReaderImpl heartBeatReader, ProgressReporter reporter) throws IOException {
        ProfilingReader tmpReader = null;
        try {
            tmpReader = this.session.getReader((PacketResourceReader)heartBeatReader, null);
            ProfilingPacket packet = null;
            while ((packet = tmpReader.nextPacket()) != null) {
                reporter.reportNextOrThrow();
                this.heartBeatInfo.handle((HeartBeatEvent)packet);
            }
            this.session.setLastlyReadTimestamp(this.heartBeatInfo.getEndTimeMillis());
        }
        finally {
            if (tmpReader != null) {
                tmpReader.close();
            }
            heartBeatReader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readAlertsInfo(ResourceReaderImpl alertsReader, ProgressReporter reporter) throws IOException {
        if (alertsReader == null) {
            Trace.warn((String)"There is no alerts store, no alerts info is provided!");
            return;
        }
        ProfilingReader tmpReader = null;
        try {
            tmpReader = this.session.getReader((PacketResourceReader)alertsReader, null);
            this.alertsInfo.initHandler(tmpReader);
            while (tmpReader.nextPacket() != null) {
                reporter.reportNextOrThrow();
            }
        }
        finally {
            if (tmpReader != null) {
                tmpReader.close();
            }
            alertsReader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProfilingTraceSetImpl readTraceInfo(ResourceReaderImpl traceInfoReader) throws IOException {
        try {
            boolean hasNext = traceInfoReader.nextPacket();
            assert (hasNext);
            ProfilingTraceSetImpl profilingTraceSetImpl = ProfilingTraceSetImpl.read((ResourceReader)traceInfoReader);
            return profilingTraceSetImpl;
        }
        finally {
            traceInfoReader.close();
        }
    }

    private void addSnapshots(Snapshot[] snapshots, ProgressReporter reporter) throws IOException {
        for (int i = 0; i < snapshots.length; ++i) {
            this.modelController.addSnapshot(snapshots[i]);
            if (reporter == null) continue;
            reporter.reportNext();
        }
    }
}

