/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl;

import com.sap.jvm.profiling.Connection;
import com.sap.jvm.profiling.DebuggingConnection;
import com.sap.jvm.profiling.controller.ErrorHandler;
import com.sap.jvm.profiling.controller.impl.RemoteControllerImpl;
import com.sap.jvm.profiling.controller.impl.model.ModelControllerImpl;
import com.sap.jvm.profiling.core.ProfilingPacket;
import com.sap.jvm.profiling.core.ProfilingReader;
import com.sap.jvm.profiling.core.Response;
import com.sap.jvm.profiling.core.command.SnapshotMarkerCommand;
import com.sap.jvm.profiling.exception.WriteFailedException;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;
import java.util.Map;

public final class PacketReceiveThread
extends Thread {
    private static final String threadName = "ProfilingPacketReceiveThread";
    private RemoteControllerImpl controller;
    private ProfilingReader reader;
    private Map<Long, Response> waitResponseQueue;
    private Map<Long, SnapshotMarkerCommand> snapshotMarkerQueue;

    public PacketReceiveThread(RemoteControllerImpl controller, Map<Long, Response> waitResponseQueue, Map<Long, SnapshotMarkerCommand> snapshotMarkerQueue) {
        this.controller = controller;
        this.reader = controller.getReader();
        this.waitResponseQueue = waitResponseQueue;
        this.snapshotMarkerQueue = snapshotMarkerQueue;
        this.setName(threadName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        ModelControllerImpl modelController = this.controller.getModelController();
        try {
            while (true) {
                block30: {
                    ProfilingPacket packet = null;
                    try {
                        ProfilingPacket profilingPacket = packet = this.reader != null ? this.reader.nextPacket() : null;
                        if (packet == null) {
                            modelController.createSnapshotsInternal(this.reader.getLastlyReadTimestamp(), true);
                            return;
                        }
                    }
                    catch (WriteFailedException ex) {
                        boolean retry;
                        ErrorHandler errorHandler = this.controller.getErrorHandler();
                        String backupFilename = this.controller.getConnection().getBackupFileName();
                        boolean bl = retry = errorHandler != null ? errorHandler.handleWriteError(backupFilename) : false;
                        if (!retry) {
                            modelController.createSnapshotsInternal(this.reader.getLastlyReadTimestamp(), true);
                            this.controller.disconnect(true);
                            try {
                                this.controller.disconnect(false);
                                return;
                            }
                            catch (IOException e) {
                                Trace.error((Throwable)e, (String)"Could not disconnect!");
                            }
                            return;
                        }
                        break block30;
                    }
                    {
                        if (!(packet instanceof Response)) break block30;
                        Response response = (Response)packet;
                        SnapshotMarkerCommand snpMarker = null;
                        Map<Long, SnapshotMarkerCommand> map = this.snapshotMarkerQueue;
                        synchronized (map) {
                            if (this.snapshotMarkerQueue.containsKey(response.getId())) {
                                snpMarker = this.snapshotMarkerQueue.remove(response.getId());
                            }
                        }
                        Connection con = this.controller.getConnection();
                        if (snpMarker != null && con instanceof DebuggingConnection) {
                            ((DebuggingConnection)con).insertPacket(snpMarker.asJdwpPacketResponse(response.getTime()));
                        }
                        Map<Long, Response> map2 = this.waitResponseQueue;
                        synchronized (map2) {
                            if (this.waitResponseQueue.containsKey(response.getId())) {
                                this.waitResponseQueue.put(response.getId(), response);
                                this.waitResponseQueue.notify();
                            }
                        }
                    }
                }
                continue;
                break;
            }
        }
        catch (IOException ex) {
            Trace.warn((Throwable)ex, (String)"Unexpected I/O error while reading packet.");
            modelController.createSnapshotsInternal(this.reader.getLastlyReadTimestamp(), true);
            return;
        }
        catch (RuntimeException ex) {
            Trace.warn((Throwable)ex, (String)"Unexpected runtime exception while reading packet.");
            modelController.createSnapshotsInternal(this.reader.getLastlyReadTimestamp(), true);
            throw ex;
        }
        finally {
            try {
                this.controller.disconnect(false);
            }
            catch (IOException e) {
                Trace.error((Throwable)e, (String)"Could not disconnect!");
            }
        }
    }
}

