/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl;

import com.sap.jvm.profiling.ProfilingFactory;
import com.sap.jvm.profiling.control.command.ControlCommandFactory;
import com.sap.jvm.profiling.control.command.FlushCommand;
import com.sap.jvm.profiling.controller.impl.CommandHandlerThread;
import com.sap.jvm.profiling.controller.impl.PacketReceiveThread;
import com.sap.jvm.profiling.controller.impl.RemoteControllerImpl;
import com.sap.jvm.profiling.core.Response;
import com.sap.jvm.profiling.core.command.Command;
import com.sap.jvm.profiling.core.command.SnapshotMarkerCommand;
import com.sap.jvm.tracing.Trace;
import java.util.HashMap;
import java.util.Map;

public final class RemoteConnectionHandler {
    private static final ControlCommandFactory ctrlFactory = ProfilingFactory.createControlCommandFactory();
    private static final int WAIT_FOR_RESPONSES = 2000;
    private RemoteControllerImpl controller = null;
    private CommandHandlerThread commandHandlerThread;
    private PacketReceiveThread packetReceiveThread;
    private Map<Long, Response> waitResponseQueue;
    private Map<Long, SnapshotMarkerCommand> snapshotMarkerQueue;
    private volatile boolean stopRequested;
    private volatile boolean started;

    public RemoteConnectionHandler(RemoteControllerImpl controller) {
        this.controller = controller;
        this.stopRequested = false;
        this.started = false;
        this.waitResponseQueue = new HashMap<Long, Response>();
        this.snapshotMarkerQueue = new HashMap<Long, SnapshotMarkerCommand>();
    }

    public void start() {
        this.commandHandlerThread = new CommandHandlerThread(this.controller.getConnection());
        this.packetReceiveThread = new PacketReceiveThread(this.controller, this.waitResponseQueue, this.snapshotMarkerQueue);
        this.started = true;
        this.commandHandlerThread.start();
        this.packetReceiveThread.start();
    }

    public void stop() {
        this.stopRequested = true;
        if (!this.started) {
            return;
        }
        this.commandHandlerThread.stop(true);
        try {
            this.commandHandlerThread.join();
        }
        catch (InterruptedException e) {
            Trace.warn((Throwable)e, (String)"Could not join command handler thread");
        }
        try {
            this.packetReceiveThread.join();
        }
        catch (InterruptedException e) {
            Trace.warn((Throwable)e, (String)"Could not join packet receive thread");
        }
    }

    public void requestStop() {
        this.stopRequested = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response sendCommand(Command command, boolean wait) {
        Map<Long, Response> map;
        Command cmdToSend = command;
        if (!this.controller.getProfilingSession().getCapabilities().hasSnapshotMarker() && command instanceof SnapshotMarkerCommand) {
            cmdToSend = ctrlFactory.createFlushCommand();
            map = this.snapshotMarkerQueue;
            synchronized (map) {
                this.snapshotMarkerQueue.put(cmdToSend.getId(), (SnapshotMarkerCommand)command);
            }
        }
        if (wait) {
            map = this.waitResponseQueue;
            synchronized (map) {
                this.waitResponseQueue.put(cmdToSend.getId(), null);
            }
        }
        this.commandHandlerThread.sendCommand(cmdToSend);
        if (!wait) {
            return null;
        }
        if (!(cmdToSend instanceof FlushCommand)) {
            this.commandHandlerThread.sendCommand((Command)ctrlFactory.createFlushCommand());
        }
        while (!this.stopRequested) {
            map = this.waitResponseQueue;
            synchronized (map) {
                Response response = this.waitResponseQueue.get(cmdToSend.getId());
                if (response == null) {
                    try {
                        this.waitResponseQueue.wait(2000L);
                    }
                    catch (InterruptedException ex) {
                        Trace.warn((Throwable)ex, (String)"Got an interrupted exception while waiting for a response.");
                    }
                } else {
                    this.waitResponseQueue.remove(cmdToSend.getId());
                    return response;
                }
            }
        }
        return null;
    }
}

