/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl;

import com.sap.jvm.profiling.Connection;
import com.sap.jvm.profiling.ProfilingFactory;
import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.controller.RemoteController;
import com.sap.jvm.profiling.controller.action.Action;
import com.sap.jvm.profiling.controller.action.ActionSet;
import com.sap.jvm.profiling.controller.impl.ControllerFactoryImpl;
import com.sap.jvm.profiling.controller.impl.ControllerImpl;
import com.sap.jvm.profiling.controller.impl.RemoteConnectionHandler;
import com.sap.jvm.profiling.controller.impl.action.ActionFactoryImpl;
import com.sap.jvm.profiling.controller.impl.action.ActionListener;
import com.sap.jvm.profiling.controller.impl.action.ActionListenerImpl;
import com.sap.jvm.profiling.controller.impl.action.ActionResponseImpl;
import com.sap.jvm.profiling.controller.impl.action.ActionResponseSetImpl;
import com.sap.jvm.profiling.controller.impl.resource.AbstractResourceManagerImpl;
import com.sap.jvm.profiling.controller.impl.resource.OnlineResourceManagerImpl;
import com.sap.jvm.profiling.controller.impl.trace.ProfilingTraceImpl;
import com.sap.jvm.profiling.controller.impl.trace.ProfilingTraceSetImpl;
import com.sap.jvm.profiling.core.Bookmark;
import com.sap.jvm.profiling.core.ProfilingReader;
import com.sap.jvm.profiling.core.Response;
import com.sap.jvm.profiling.core.command.Command;
import com.sap.jvm.profiling.core.command.CoreCommandFactory;
import com.sap.jvm.profiling.memory.command.MemoryCommandFactory;
import com.sap.jvm.profiling.presentation.typed.TypedModel;
import com.sap.jvm.tracing.Trace;
import com.sap.jvm.util.misc.SocketAdapter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class RemoteControllerImpl
extends ControllerImpl
implements RemoteController {
    private final CoreCommandFactory coreCmdFactory = ProfilingFactory.createCoreCommandFactory();
    private final MemoryCommandFactory memoryCmdFactory = ProfilingFactory.createMemoryCommandFactory();
    private String backupFilename;
    private Connection connection;
    private ProfilingSession session;
    private ProfilingReader reader;
    private RemoteConnectionHandler connectionHandler;
    private ActionFactoryImpl actionFactory;
    private ProfilingTraceSetImpl traceSet;
    private List<ActionListener> actionListeners;
    private String sessionDirectory;
    private File tempDirectory;
    private AbstractResourceManagerImpl<TypedModel> resourceManager;
    private volatile boolean disConnected = false;
    private long heartBeatInterval = 1000L;
    private boolean exactGcTrace = true;
    private final boolean gcTraceAllowed;

    public RemoteControllerImpl(ControllerFactoryImpl controllerFactory, String id, String backupFilename, String sessionDirectory, File tempDirectory, boolean gcTraceAllowed) {
        super(controllerFactory, id);
        this.backupFilename = backupFilename;
        this.sessionDirectory = sessionDirectory;
        this.tempDirectory = tempDirectory;
        this.actionFactory = new ActionFactoryImpl();
        this.connectionHandler = new RemoteConnectionHandler(this);
        this.traceSet = new ProfilingTraceSetImpl();
        this.actionListeners = new ArrayList<ActionListener>();
        this.gcTraceAllowed = gcTraceAllowed;
    }

    @Override
    public void connectSocket(int pid, String hostname, int daemonPort) throws IOException {
        SocketAdapter socket = ProfilingFactory.createSocket((int)pid, (String)hostname, (int)daemonPort);
        this.connection = ProfilingFactory.createSocketConnection((SocketAdapter)socket, (String)this.backupFilename);
        this.init();
    }

    @Override
    public void connectSocket(String identifier) throws IOException {
        SocketAdapter socket = ProfilingFactory.createFileSocket((int)-1, (String)identifier);
        this.connection = ProfilingFactory.createSocketConnection((SocketAdapter)socket, (String)this.backupFilename);
        this.init();
    }

    @Override
    public void connectSocket(SocketAdapter socket) throws IOException {
        this.connection = ProfilingFactory.createSocketConnection((SocketAdapter)socket, (String)this.backupFilename);
        this.init();
    }

    @Override
    public void connectDebugging(String hostname, int debuggingPort) throws IOException {
        this.connection = ProfilingFactory.createDebuggingConnection((String)hostname, (int)debuggingPort, (boolean)true, (String)this.backupFilename);
        this.init();
    }

    @Override
    public void connectDebugging(InputStream input, OutputStream output) throws IOException {
        this.connection = ProfilingFactory.createDebuggingConnection((InputStream)input, (OutputStream)output, (boolean)true, (String)this.backupFilename);
        this.init();
    }

    @Override
    public long getInitHeartBeatInterval() {
        return this.heartBeatInterval;
    }

    @Override
    public void setInitHeartBeatInterval(long interval) {
        if (interval >= 100L) {
            this.heartBeatInterval = interval;
        }
    }

    @Override
    public void disconnect(boolean soft) throws IOException {
        block10: {
            if (this.disConnected) {
                return;
            }
            this.disConnected = true;
            try {
                if (soft) {
                    this.connectionHandler.stop();
                    if (this.connection == null) break block10;
                    try {
                        this.connection.close();
                        break block10;
                    }
                    finally {
                        this.connection = null;
                    }
                }
                if (this.connection != null) {
                    this.connection.close();
                    this.connectionHandler.requestStop();
                }
            }
            finally {
                if (this.resourceManager != null) {
                    this.resourceManager.closeWriters();
                }
            }
        }
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public ProfilingReader getReader() {
        return this.reader;
    }

    @Override
    public ProfilingSession getProfilingSession() {
        return this.session;
    }

    @Override
    public ActionResponseSetImpl applyActions(ActionSet actions) {
        ActionResponseSetImpl responseSet = new ActionResponseSetImpl();
        Iterator<Action> iterator = actions.iterator();
        while (iterator.hasNext()) {
            Action action = iterator.next();
            Iterator<ActionListener> itListeners = this.actionListeners.iterator();
            while (itListeners.hasNext()) {
                itListeners.next().actionApplied(action);
            }
            Response response = action.doIt(this.connectionHandler);
            if (response == null) continue;
            responseSet.add(new ActionResponseImpl(response.isSuccess(), response.getErrorMessage(), action));
        }
        return responseSet;
    }

    @Override
    public ActionFactoryImpl getActionFactory() {
        return this.actionFactory;
    }

    @Override
    public ProfilingTraceSetImpl getTraceSet() {
        return this.traceSet;
    }

    public Response sendCommand(Command command, boolean wait) {
        return this.connectionHandler.sendCommand(command, wait);
    }

    public void onReadingStopped(Bookmark bookmark, long stoppedTimeStamp) {
        int nrTraces = this.traceSet.size();
        for (int i = 0; i < nrTraces; ++i) {
            ProfilingTraceImpl trace = this.traceSet.get(i);
            trace.setEndBookmark(bookmark);
            trace.setEndTimeStamp(stoppedTimeStamp);
            this.traceDisabled(trace);
        }
    }

    private void init() throws IOException {
        Response response;
        this.actionListeners.add(new ActionListenerImpl(this));
        this.session = ProfilingFactory.createSession((Connection)this.connection);
        this.reader = this.session.getReader();
        this.resourceManager = new OnlineResourceManagerImpl<TypedModel>(this, this.sessionDirectory, this.tempDirectory);
        this.session.registerResourceManager(this.resourceManager);
        this.modelController.setActionFactoryImpl(this.actionFactory);
        this.registerHandlers(this.reader);
        this.connectionHandler.start();
        if (this.session.getCapabilities().hasHeartBeatTrace() && ((response = this.sendCommand((Command)this.coreCmdFactory.createEnableHeartBeatCommand(this.heartBeatInterval), true)) == null || !response.isSuccess())) {
            String errorMsg = response != null ? response.getErrorMessage() : "lost connection to profilee";
            throw new IOException("Enabling heart beat trace failed: " + errorMsg);
        }
        if (this.session.getSystemInfo().hasAlertTrace() && ((response = this.sendCommand((Command)this.coreCmdFactory.createEnableAlertCommand(), true)) == null || !response.isSuccess())) {
            String errorMsg = response != null ? response.getErrorMessage() : "lost connection to profilee";
            throw new IOException("Enabling alerts failed: " + errorMsg);
        }
        if (this.session.getSystemInfo().hasMonitoringBoardTrace()) {
            boolean onlyFirst = !this.session.getSystemInfo().hasFullMonitoringBoardTrace();
            int diffToInitial = 0;
            int updateInterval = 1000;
            Response response2 = this.sendCommand((Command)ProfilingFactory.createMonitoringCommandFactory().createEnableMonitoringBoardTraceCommand(onlyFirst, diffToInitial, updateInterval), true);
            if (response2 == null || !response2.isSuccess()) {
                String errorMsg = response2 != null ? response2.getErrorMessage() : "lost connection to profilee";
                throw new IOException("Enabling monitoring board trace failed: " + errorMsg);
            }
        }
        if (this.gcTraceAllowed && this.session.getSystemInfo().hasGcTrace() && ((response = this.sendCommand((Command)this.memoryCmdFactory.createEnableGcStatisticCommand(this.exactGcTrace), true)) == null || !response.isSuccess())) {
            String errorMsg = response != null ? response.getErrorMessage() : "lost connection to profilee";
            throw new IOException("Enabling GC trace failed: " + errorMsg);
        }
    }

    @Override
    public void close(boolean delete) {
        try {
            this.disconnect(true);
        }
        catch (IOException e) {
            Trace.error((Throwable)e, (String)"Could not disconnect");
        }
        super.close(delete);
    }
}

