/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.action;

import com.sap.jvm.profiling.controller.action.Action;
import com.sap.jvm.profiling.controller.action.DisableAction;
import com.sap.jvm.profiling.controller.action.DumpAction;
import com.sap.jvm.profiling.controller.action.EnableAction;
import com.sap.jvm.profiling.controller.impl.RemoteControllerImpl;
import com.sap.jvm.profiling.controller.impl.action.ActionListener;
import com.sap.jvm.profiling.controller.impl.trace.ProfilingTraceImpl;
import com.sap.jvm.profiling.controller.trace.ProfilingTraceState;

public final class ActionListenerImpl
implements ActionListener {
    private RemoteControllerImpl controller;

    public ActionListenerImpl(RemoteControllerImpl controller) {
        this.controller = controller;
    }

    @Override
    public void actionApplied(Action action) {
        if (action instanceof EnableAction) {
            this.handleEnableAction((EnableAction)action);
        } else if (action instanceof DisableAction) {
            this.handleDisableAction((DisableAction)action);
        } else if (action instanceof DumpAction) {
            this.handleDumpAction((DumpAction)action);
        }
    }

    private void handleEnableAction(EnableAction action) {
        ProfilingTraceImpl trace = (ProfilingTraceImpl)action.createTrace(this.controller.getProfilingSession());
        trace.setTraceState(ProfilingTraceState.ENABLE);
        this.controller.getTraceSet().add(trace);
    }

    private void handleDisableAction(DisableAction action) {
        ProfilingTraceImpl trace = (ProfilingTraceImpl)action.getTrace();
        trace.setTraceState(ProfilingTraceState.DISABLE);
    }

    private void handleDumpAction(DumpAction action) {
        this.controller.getTraceSet().add((ProfilingTraceImpl)action.create(this.controller.getProfilingSession()));
    }
}

