/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.model;

import com.sap.jvm.profiling.controller.ErrorHandler;
import com.sap.jvm.profiling.controller.action.ActionSet;
import com.sap.jvm.profiling.controller.impl.ControllerImpl;
import com.sap.jvm.profiling.controller.impl.RemoteControllerImpl;
import com.sap.jvm.profiling.controller.impl.action.ActionFactoryImpl;
import com.sap.jvm.profiling.controller.impl.model.SnapshotCreator;
import com.sap.jvm.profiling.controller.impl.model.SnapshotStoreImpl;
import com.sap.jvm.profiling.controller.impl.trace.ProfilingTraceImpl;
import com.sap.jvm.profiling.controller.impl.trace.ProfilingTraceSetImpl;
import com.sap.jvm.profiling.controller.model.Model;
import com.sap.jvm.profiling.controller.model.SnapshotNameProvider;
import com.sap.jvm.profiling.controller.trace.ProfilingTraceState;
import com.sap.jvm.profiling.core.Bookmark;
import com.sap.jvm.profiling.core.ProfilingTraceType;
import com.sap.jvm.profiling.core.Response;
import com.sap.jvm.profiling.core.response.SnapshotMarkerResponse;
import com.sap.jvm.profiling.method.response.EnableMethodParameterTraceResponse;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceManager;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.snapshot.SnapshotEndTag;
import com.sap.jvm.profiling.snapshot.SnapshotFactory;
import com.sap.jvm.profiling.snapshot.elements.GenericSnapshotElement;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractModelImpl<T extends Snapshot>
implements Model<T> {
    protected ControllerImpl controller;
    protected SnapshotStoreImpl<T> snapshotStore;
    protected ArrayList<T> tmpSnapshots;
    protected Bookmark startTraceBookmark;
    protected long startTimeStamp;
    protected Bookmark lastSnapshotEndBookmark;
    protected long lastSnapshotEndTimeStamp = -1L;
    protected ProfilingTraceImpl trace;
    protected ProfilingTraceType traceType;
    private SnapshotNameProvider snpNameProvider;
    protected SnapshotFactory snapshotFactory;

    protected AbstractModelImpl(ProfilingTraceType traceType, ControllerImpl controller) {
        this.traceType = traceType;
        this.controller = controller;
        assert (controller != null);
        this.snapshotStore = new SnapshotStoreImpl(controller);
        this.tmpSnapshots = new ArrayList();
    }

    @Override
    public void setSnapshotNameProvider(SnapshotNameProvider provider) {
        this.snpNameProvider = provider;
    }

    public void handleEnableResponse(Response response) {
        this.resetCollectionState();
        if (response.isSuccess()) {
            this.lastSnapshotEndBookmark = this.startTraceBookmark = this.controller.getReader().createBookmark();
            this.startTimeStamp = response.getTime();
            if (this.traceType != ProfilingTraceType.GC_TRACE && this.controller instanceof RemoteControllerImpl) {
                ProfilingTraceSetImpl traceSet = ((RemoteControllerImpl)this.controller).getTraceSet();
                this.trace = traceSet.setState(this.traceType, ProfilingTraceState.ENABLED);
                if (this.trace == null) {
                    return;
                }
            } else {
                this.trace = this.createTrace(response);
            }
            this.trace.setStartBookmark(this.startTraceBookmark);
            this.trace.setStartTimeStamp(this.startTimeStamp);
            this.controller.getModelController().getTraceHistory().add(this.trace);
            this.controller.traceEnabled(this.trace);
        } else {
            ErrorHandler errorHandler;
            Trace.error(() -> "The " + this.traceType.toString() + " cannot be enabled: [" + response.getErrorMessage() + "].");
            if (this.controller instanceof RemoteControllerImpl) {
                ProfilingTraceSetImpl traceSet = ((RemoteControllerImpl)this.controller).getTraceSet();
                traceSet.remove(this.traceType);
            }
            if ((errorHandler = this.controller.getErrorHandler()) != null) {
                String errorMessage = response instanceof EnableMethodParameterTraceResponse ? ((EnableMethodParameterTraceResponse)response).getError().getMessage() : response.getErrorMessage();
                errorHandler.handleTraceEnableError(this.traceType, errorMessage);
            }
        }
    }

    public void handleDisableResponse(Response response) {
        if (response.isSuccess()) {
            this.createSnapshotInternal(true, response.getTime(), true);
        } else {
            Trace.error(() -> "The " + this.traceType.toString() + " cannot be disabled: [" + response.getErrorMessage() + "].");
        }
        this.resetCollectionState();
    }

    @Override
    public SnapshotStoreImpl<T> getSnapshotStore() {
        return this.snapshotStore;
    }

    @Override
    public void createSnapshot(boolean delta) {
        ActionFactoryImpl actionFactory = this.controller.getModelController().getActionFactory();
        if (actionFactory == null) {
            throw new IllegalStateException("We are running in a remote scenario.");
        }
        String proposedName = this.proposeSnapshotName(true);
        if (proposedName == null) {
            return;
        }
        ActionSet actionSet = new ActionSet();
        actionSet.add(actionFactory.getSnapshotMarkerAction(this.traceType, proposedName, delta));
        actionSet.add(actionFactory.getFlushAction());
        ((RemoteControllerImpl)this.controller).applyActions(actionSet);
    }

    @Override
    public void createSnapshotWithParent(ResourceName parentName, String name, long endTimeStamp, boolean delta) {
        this.createSnapshotInternal(name, delta, endTimeStamp, false, parentName);
    }

    protected void handleSnapshotMarkerResponse(SnapshotMarkerResponse event) {
        this.createSnapshotInternal(event.getName(), event.isDelta(), event.getCreationTimeStamp(), false);
    }

    protected synchronized void createSnapshotInternal(boolean delta, long endCollectionTimeStamp, boolean stop) {
        if (this.trace == null) {
            return;
        }
        this.createSnapshotInternal(this.proposeSnapshotName(false), delta, endCollectionTimeStamp, stop);
    }

    private long getStartTimeStamp(boolean delta) {
        return delta && this.lastSnapshotEndTimeStamp != -1L ? this.lastSnapshotEndTimeStamp : this.startTimeStamp;
    }

    protected synchronized Snapshot createSnapshotInternal(String name, boolean delta, long endCollectionTimeStamp, boolean stop) {
        return this.createSnapshotInternal(name, delta, endCollectionTimeStamp, stop, null);
    }

    protected synchronized Snapshot createSnapshotInternal(String name, boolean delta, long endCollectionTimeStamp, boolean stop, ResourceName parentName) {
        if (this.trace == null) {
            return null;
        }
        Bookmark snapshotEndBookmark = this.controller.getReader().createBookmark();
        Bookmark snapshotStartBookmark = delta ? this.lastSnapshotEndBookmark : this.startTraceBookmark;
        int snapshotId = ((SnapshotStoreImpl)this.getSnapshotStore()).getNextFreeSnapshotId();
        Snapshot snapshotNew = this.createSnapshot(snapshotId, name, snapshotStartBookmark, snapshotEndBookmark, this.getStartTimeStamp(delta), endCollectionTimeStamp, false, delta, null);
        this.addSnapshot(snapshotNew);
        this.controller.snapshotCreated(snapshotNew, parentName);
        if (stop) {
            this.trace.setEndBookmark(snapshotEndBookmark);
            this.trace.setEndTimeStamp(endCollectionTimeStamp);
            this.trace.setTraceState(ProfilingTraceState.DISABLED);
            if (this.controller instanceof RemoteControllerImpl) {
                ProfilingTraceSetImpl traceSet = ((RemoteControllerImpl)this.controller).getTraceSet();
                traceSet.remove(this.traceType);
            }
            this.controller.traceDisabled(this.trace);
            this.trace = null;
        }
        this.lastSnapshotEndBookmark = snapshotEndBookmark;
        this.lastSnapshotEndTimeStamp = endCollectionTimeStamp;
        return snapshotNew;
    }

    public void addSnapshot(Snapshot snapshot, ProgressReporter reporter) throws IOException {
        if (!snapshot.isVirtual()) {
            this.tmpSnapshots.add(snapshot);
            try {
                snapshot.computeProperties(reporter);
            }
            finally {
                this.tmpSnapshots.remove(snapshot);
            }
        }
        this.addSnapshot(snapshot);
    }

    public void addSnapshot(Snapshot snapshot) {
        if (snapshot.getName() == null) {
            String proposedName = this.proposeSnapshotName(true);
            if (proposedName == null) {
                proposedName = "";
            }
            snapshot.setName(proposedName);
        }
        ((SnapshotStoreImpl)this.getSnapshotStore()).add(snapshot);
        try {
            ResourceManager manager = this.controller.getProfilingSession().getResourceManager();
            ResourceName resourceName = snapshot.asResourceName();
            PacketResourceWriter writer = manager.getWriter(resourceName);
            snapshot.write(writer);
            manager.store(resourceName, writer.getFilename());
            writer.close();
        }
        catch (IOException ex) {
            Trace.error((Throwable)ex, () -> "Could not write snapshot " + snapshot.getName());
        }
    }

    @Override
    public synchronized void createSnapshots(long startHeartBeatPacketIndex, long endHeartBeatPacketIndex, ProgressReporter reporter) throws IOException {
        SnapshotCreator creator = new SnapshotCreator(this.controller, new ProfilingTraceType[]{this.traceType}, startHeartBeatPacketIndex, endHeartBeatPacketIndex);
        creator.create(reporter);
        if (reporter != null && reporter.isCancelled()) {
            return;
        }
        Snapshot[] snapshots = creator.getSnapshots(ProfilingTraceType.ALLOCATION_TRACE);
        for (int i = 0; i < snapshots.length; ++i) {
            this.addSnapshot(snapshots[i], reporter);
            this.controller.snapshotCreated(snapshots[i], null);
        }
    }

    protected abstract ProfilingTraceImpl createTrace(Response var1);

    protected abstract String getDefaultSnapshotName();

    private String proposeSnapshotName(boolean notifyNameProvider) {
        String name = null;
        int searchCount = 0;
        block0: while (name == null) {
            name = this.getDefaultSnapshotName() + " " + ++searchCount;
            for (int i = 0; i < this.snapshotStore.size(); ++i) {
                if (!this.snapshotStore.get(i).getName().equals(name)) continue;
                name = null;
                continue block0;
            }
        }
        if (!notifyNameProvider) {
            return name;
        }
        if (this.snpNameProvider == null) {
            return name;
        }
        String userName = this.snpNameProvider.provideName(this.traceType, name);
        if (userName == null) {
            return null;
        }
        String newProposal = null;
        name = userName;
        block2: while (name != null) {
            newProposal = name;
            name = null;
            for (int i = 0; i < this.snapshotStore.size(); ++i) {
                if (!this.snapshotStore.get(i).getName().equals(newProposal)) continue;
                name = this.snpNameProvider.updateProposal(userName, newProposal);
                continue block2;
            }
        }
        return newProposal;
    }

    protected abstract void resetCollectionState();

    protected abstract Snapshot createSnapshot(int var1, String var2, Bookmark var3, Bookmark var4, long var5, long var7, boolean var9, boolean var10, Snapshot var11);

    public synchronized Snapshot createSnapshot(String name, Snapshot snapshot, List<ResourceNameElement> filterElements, boolean isVirtual, ProgressReporter reporter) throws IOException {
        int snapshotId;
        if (!snapshot.getType().hasExplicitStartAndStop()) {
            return null;
        }
        if (this.snapshotFactory == null) {
            this.snapshotFactory = SnapshotFactory.get(this.controller.getProfilingSession());
        }
        int elementId = snapshotId = ((SnapshotStoreImpl)this.getSnapshotStore()).getNextFreeSnapshotId();
        if (isVirtual) {
            ResourceNameElement[] elements = snapshot.asResourceName().getElements();
            elementId = ((GenericSnapshotElement)elements[0]).getId();
        }
        GenericSnapshotElement snapshotElement = this.createSnapshotElement(elementId);
        ResourceName resourceName = this.controller.getProfilingSession().getResourceManager().createResourceName((ResourceNameElement)snapshotElement);
        for (ResourceNameElement resourceNameElement : filterElements) {
            resourceName = resourceName.addElement(resourceNameElement);
        }
        resourceName = resourceName.addElement((ResourceNameElement)new SnapshotEndTag());
        Snapshot snapshotNew = this.createSnapshot(this.snapshotFactory, snapshotId, resourceName, name, snapshot, isVirtual, reporter);
        this.addSnapshot(snapshotNew, reporter);
        return snapshotNew;
    }

    protected abstract GenericSnapshotElement createSnapshotElement(int var1);

    protected abstract Snapshot createSnapshot(SnapshotFactory var1, int var2, ResourceName var3, String var4, Snapshot var5, boolean var6, ProgressReporter var7) throws IOException;
}

