/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.model;

import com.sap.jvm.profiling.controller.AlertsController;
import com.sap.jvm.profiling.controller.impl.AbstractResourceController;
import com.sap.jvm.profiling.controller.impl.model.ResourceControllerUtils;
import com.sap.jvm.profiling.controller.impl.model.alerts.AlertsControllerImpl;
import com.sap.jvm.profiling.controller.impl.model.alerts.CreateAlertsController;
import com.sap.jvm.profiling.controller.model.Model;
import com.sap.jvm.profiling.controller.model.SnapshotController;
import com.sap.jvm.profiling.presentation.typed.TypedModel;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.snapshot.SnapshotStore;
import java.io.IOException;

public abstract class AbstractSnapshotController<S extends Snapshot>
extends AbstractResourceController<TypedModel>
implements SnapshotController<S, TypedModel> {
    protected AbstractSnapshotController(ResourceName name) {
        super(name);
    }

    @Override
    public AlertsController<TypedModel> getAlertsController() throws IOException {
        ResourceName parent = this.getResourceName();
        ResourceName resourceName = parent.stripLastElement().addElement((ResourceNameElement)new CreateAlertsController(this.getSnapshot()));
        return (AlertsControllerImpl)ResourceControllerUtils.getResourceController(parent, resourceName);
    }

    @Override
    public TypedModel getModel() {
        return new TypedModel(){

            @Override
            public void setTitle(String title) {
                if (title == null) {
                    return;
                }
                Model<?> model = AbstractSnapshotController.this.getController().getModelController().getModel(AbstractSnapshotController.this.getSnapshot().getType().getTraceType());
                SnapshotStore<?> store = model.getSnapshotStore();
                store.rename(AbstractSnapshotController.this.getSnapshot(), title);
            }

            @Override
            public String getTitle() {
                return AbstractSnapshotController.this.getSnapshot().getName();
            }

            @Override
            public String getIconKey() {
                return "";
            }
        };
    }
}

