/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.model;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.controller.ColumnResourceController;
import com.sap.jvm.profiling.controller.ResourceController;
import com.sap.jvm.profiling.controller.TableResourceController;
import com.sap.jvm.profiling.controller.impl.AbstractResourceController;
import com.sap.jvm.profiling.controller.impl.model.ResourceControllerUtils;
import com.sap.jvm.profiling.controller.impl.model.compare.CreateCompareTableController;
import com.sap.jvm.profiling.controller.impl.resource.AbstractResourceManagerImpl;
import com.sap.jvm.profiling.controller.model.IncludeType;
import com.sap.jvm.profiling.core.event.SystemInfo;
import com.sap.jvm.profiling.core.type.ClassLoaderObject;
import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.core.type.PackageName;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.typed.ColumnBasedModel;
import com.sap.jvm.profiling.presentation.typed.TypedColumnBasedModel;
import com.sap.jvm.profiling.presentation.typed.TypedColumnSpec;
import com.sap.jvm.profiling.presentation.typed.TypedModel;
import com.sap.jvm.profiling.presentation.typed.TypedTableModel;
import com.sap.jvm.profiling.presentation.typed.TypedTimeSeriesModel;
import com.sap.jvm.profiling.presentation.typed.TypedTreeModel;
import com.sap.jvm.profiling.presentation.typed.VisibilitySet;
import com.sap.jvm.profiling.presentation.typed.entries.CalledMethod;
import com.sap.jvm.profiling.presentation.typed.entries.CallingMethod;
import com.sap.jvm.profiling.presentation.typed.entries.NormalClass;
import com.sap.jvm.profiling.presentation.typed.entries.NormalClassLoader;
import com.sap.jvm.profiling.presentation.typed.entries.NormalMethod;
import com.sap.jvm.profiling.presentation.typed.entries.NormalThreadName;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceManager;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.elements.NarrowSnapshotByPacketNr;
import com.sap.jvm.profiling.snapshot.filter.ClassFilter;
import com.sap.jvm.profiling.snapshot.filter.MethodFilter;
import com.sap.jvm.profiling.snapshot.resource.InlineFilterExtractor;
import com.sap.jvm.profiling.snapshot.util.TimestampToBookmarkConverter;
import com.sap.jvm.util.pair.LongPair;
import java.io.IOException;
import java.util.ArrayList;

public abstract class AbstractTypedController<T extends TypedModel>
extends AbstractResourceController<T> {
    private final T model;

    protected AbstractTypedController(ResourceName name, ProgressReporter reporter) throws IOException {
        super(name);
        this.model = (TypedModel)name.getResourceManager().get(this.getModelName(), reporter);
    }

    protected String getParentVisibilitySpec(ResourceController<?> parent) {
        if (parent instanceof ColumnResourceController) {
            ColumnResourceController controllerImpl = (ColumnResourceController)parent;
            return ((TypedColumnBasedModel)controllerImpl.getModel()).getColumnVisibility();
        }
        return null;
    }

    protected final Class<?> getParentSortColumnType(ResourceController<?> parent) {
        if (parent instanceof ColumnResourceController) {
            ColumnResourceController controllerImpl = (ColumnResourceController)parent;
            int sortColumn = ((TypedColumnBasedModel)controllerImpl.getModel()).getSortedColumn();
            if (sortColumn == -1) {
                return null;
            }
            return ((TypedColumnBasedModel)controllerImpl.getModel()).getSpec().getColumnType(sortColumn);
        }
        return null;
    }

    protected final String getParentSortVisibilitySets(ResourceController<?> parent) {
        if (parent instanceof ColumnResourceController) {
            int nrOfSorts;
            ColumnResourceController controllerImpl = (ColumnResourceController)parent;
            int sortColumn = ((TypedColumnBasedModel)controllerImpl.getModel()).getSortedColumn();
            int sortDirection = ((TypedColumnBasedModel)controllerImpl.getModel()).getSortDirection();
            if (sortColumn < 0) {
                return null;
            }
            TypedColumnSpec parentSpec = ((TypedColumnBasedModel)controllerImpl.getModel()).getSpec();
            if (parentSpec.getDefaultSortColumn((nrOfSorts = parentSpec.getNrOfDefaultSorts()) - 1) == sortColumn && parentSpec.getDefaultSortDirection(nrOfSorts - 1) == sortDirection) {
                return null;
            }
            String result = "";
            for (VisibilitySet set : parentSpec.getColumnVisibilitySets()) {
                for (int column : set.getColumns()) {
                    if (column != sortColumn) continue;
                    if (result.length() > 0) {
                        result = result + "|";
                    }
                    result = result + set.getId();
                }
            }
            return result;
        }
        return null;
    }

    protected final int getParentSortDirection(ResourceController<?> parent) {
        if (parent instanceof ColumnResourceController) {
            ColumnResourceController controllerImpl = (ColumnResourceController)parent;
            return ((TypedColumnBasedModel)controllerImpl.getModel()).getSortDirection();
        }
        return 0;
    }

    protected final ProfilingSession getSession() {
        return this.getResourceName().getSession();
    }

    @Override
    public final T getModel() {
        return this.model;
    }

    @Override
    public final void close() {
        AbstractResourceManagerImpl resourceManager = (AbstractResourceManagerImpl)this.getResourceName().getResourceManager();
        resourceManager.closed(this.getResourceName());
    }

    public TableResourceController getComparison(ColumnResourceController<?> other) throws IOException {
        if (this instanceof TableResourceController && other instanceof TableResourceController) {
            ResourceName parent = this.getResourceName();
            ResourceName comparisonName = parent.addElement((ResourceNameElement)new CreateCompareTableController((TableResourceController)((Object)this), (TableResourceController)other));
            return (TableResourceController)ResourceControllerUtils.getResourceController(parent, comparisonName);
        }
        return null;
    }

    public final boolean isComparableWith(ColumnResourceController<?> other) {
        if (this.model instanceof ColumnBasedModel) {
            return ((ColumnBasedModel)this.model).isComparableWith((ColumnBasedModel)other.getModel());
        }
        return false;
    }

    public final boolean isAnySelected() {
        if (this.model instanceof ColumnBasedModel) {
            return ((ColumnBasedModel)this.model).isAnySelected();
        }
        if (this.model instanceof TypedTimeSeriesModel) {
            return ((TypedTimeSeriesModel)this.model).hasSelection();
        }
        return false;
    }

    public void notifyOfParent(ResourceController<?> parent) {
        if (this.model instanceof TypedColumnBasedModel) {
            int sortColumn;
            TypedColumnBasedModel columnModel = (TypedColumnBasedModel)this.model;
            TypedColumnSpec spec = columnModel.getSpec();
            String parentVisibility = this.getParentVisibilitySpec(parent);
            if (parentVisibility != null) {
                columnModel.setColumnVisibility(spec.getDependentVisibility(parentVisibility));
            }
            String parentSortVisibilitySets = this.getParentSortVisibilitySets(parent);
            int parentSortDirection = this.getParentSortDirection(parent);
            Class<?> parentSortColumnType = this.getParentSortColumnType(parent);
            if (parentSortVisibilitySets != null && (sortColumn = spec.getDependentSortColumn(parentSortVisibilitySets, parentSortColumnType)) >= 0) {
                columnModel.setSorting(sortColumn, parentSortDirection);
            }
        }
    }

    protected int getNrOfElementsToRemove() {
        return 2;
    }

    protected final TypedTableModel getTableModelForName(ResourceName modelName) throws IOException {
        ResourceManager manager = modelName.getResourceManager();
        ProgressReporter reporter = new ProgressReporter();
        TypedTableModel result = (TypedTableModel)manager.get(modelName, reporter);
        reporter.finish();
        return result;
    }

    protected final TypedTreeModel getTreeModelForName(ResourceName modelName) throws IOException {
        ResourceManager manager = modelName.getResourceManager();
        ProgressReporter reporter = new ProgressReporter();
        TypedTreeModel result = (TypedTreeModel)manager.get(modelName, new ProgressReporter());
        reporter.finish();
        return result;
    }

    protected final MethodFilter getFilterForMethods(MethodObject[] methods) {
        ArrayList<MethodObject> notInlined = new ArrayList<MethodObject>();
        for (MethodObject method : methods) {
            if (method.isInlinedAway()) continue;
            notInlined.add(method);
        }
        return MethodFilter.createForMethods(this.getSession(), I18n._ss((String)"FilterDefinitionName", (String)"selected methods"), notInlined.toArray(new MethodObject[notInlined.size()]));
    }

    protected final MethodFilter getFilterForInlinedMethods(MethodObject[] methods) {
        boolean hasInlined = false;
        for (MethodObject method : methods) {
            if (!method.isInlinedAway()) continue;
            hasInlined = true;
            break;
        }
        if (hasInlined) {
            return InlineFilterExtractor.getInlineFilter(this.getResourceName());
        }
        return null;
    }

    protected final MethodFilter getFilterForClasses(ClassObject[] classes) {
        ArrayList<ClassObject> notInlined = new ArrayList<ClassObject>();
        for (ClassObject clazz : classes) {
            if (clazz.isInlinedAway()) continue;
            notInlined.add(clazz);
        }
        return new MethodFilter(ClassFilter.createForClasses(this.getSession(), I18n._ss((String)"FilterDefinitionName", (String)"selected classes"), notInlined.toArray(new ClassObject[notInlined.size()])), I18n._ss((String)"FilterDefinitionName", (String)"selected classes"));
    }

    protected final MethodFilter getFilterForInlinedClasses(ClassObject[] classes) {
        boolean hasInlined = false;
        for (ClassObject clazz : classes) {
            if (!clazz.isInlinedAway()) continue;
            hasInlined = true;
            break;
        }
        if (hasInlined) {
            return InlineFilterExtractor.getInlineFilter(this.getResourceName());
        }
        return null;
    }

    protected final MethodFilter getFilterForClassLoaders(ClassLoaderObject[] loaders) {
        ArrayList<ClassLoaderObject> notInlined = new ArrayList<ClassLoaderObject>();
        for (ClassLoaderObject loader : loaders) {
            if (loader.isInlinedAway()) continue;
            notInlined.add(loader);
        }
        return new MethodFilter(ClassFilter.createForLoaders(this.getSession(), I18n._ss((String)"FilterDefinitionName", (String)"selected loaders"), notInlined.toArray(new ClassLoaderObject[notInlined.size()])), I18n._ss((String)"FilterDefinitionName", (String)"selected loaders"));
    }

    protected final MethodFilter getFilterForInlinedClassLoaders(ClassLoaderObject[] loaders) {
        boolean hasInlined = false;
        for (ClassLoaderObject loader : loaders) {
            if (!loader.isInlinedAway()) continue;
            hasInlined = true;
            break;
        }
        if (hasInlined) {
            return InlineFilterExtractor.getInlineFilter(this.getResourceName());
        }
        return null;
    }

    protected final MethodFilter getFilterForPackages(PackageName[] packages) {
        ArrayList<PackageName> notInlined = new ArrayList<PackageName>();
        for (PackageName pkg : packages) {
            if (pkg.isInlinedAway()) continue;
            notInlined.add(pkg);
        }
        return new MethodFilter(ClassFilter.createForPackages(this.getSession(), I18n._ss((String)"FilterDefinitionName", (String)"selected packages"), notInlined.toArray(new PackageName[notInlined.size()])), I18n._ss((String)"FilterDefinitionName", (String)"selected packages"));
    }

    protected final MethodFilter getFilterForInlinedPackages(PackageName[] packages) {
        boolean hasInlined = false;
        for (PackageName pkg : packages) {
            if (!pkg.isInlinedAway()) continue;
            hasInlined = true;
            break;
        }
        if (hasInlined) {
            return InlineFilterExtractor.getInlineFilter(this.getResourceName());
        }
        return null;
    }

    protected static Object convertDisplayTypeToRawType(ProviderEntry type) {
        if (type instanceof NormalClass) {
            return ((NormalClass)type).getClassObject();
        }
        if (type instanceof NormalClassLoader) {
            return ((NormalClassLoader)type).getClassLoader();
        }
        if (type instanceof NormalMethod) {
            return ((NormalMethod)type).getMethod();
        }
        if (type instanceof CalledMethod) {
            return ((CalledMethod)type).getLocation();
        }
        if (type instanceof CallingMethod) {
            return ((CallingMethod)type).getLocation();
        }
        if (type instanceof NormalThreadName) {
            return type;
        }
        return null;
    }

    protected abstract ResourceName getModelName();

    @Override
    public final ResourceName[] getDependents() {
        return new ResourceName[]{this.getModelName()};
    }

    protected final ResourceName getSelectedCalledName(IncludeType type) {
        if (type == IncludeType.SELF) {
            return this.getSelectedCalledNameSelf();
        }
        return this.getSelectedCalledNameTotal();
    }

    protected final ResourceName getCalledName(IncludeType type, boolean useSelection) {
        if (useSelection) {
            return this.getSelectedCalledName(type);
        }
        return this.getResourceName();
    }

    protected final ResourceName getCallingName(IncludeType type, boolean useSelection) {
        if (useSelection) {
            return this.getSelectedCallingName(type);
        }
        return this.getResourceName();
    }

    protected ResourceName getSelectedCalledNameSelf() {
        throw new IllegalStateException("Not implemented");
    }

    protected ResourceName getSelectedCalledNameTotal() {
        throw new IllegalStateException("Not implemented");
    }

    protected final ResourceName getSelectedCalledNameForMethods(IncludeType type) {
        if (type == IncludeType.SELF) {
            return this.getSelectedCalledNameForMethodsSelf();
        }
        return this.getSelectedCalledNameForMethodsTotal();
    }

    protected ResourceName getSelectedCalledNameForMethodsSelf() {
        return this.getSelectedCalledNameSelf();
    }

    protected ResourceName getSelectedCalledNameForMethodsTotal() {
        return this.getSelectedCalledNameTotal();
    }

    protected final ResourceName getSelectedCallingName(IncludeType type) {
        if (type == IncludeType.SELF) {
            return this.getSelectedCallingNameSelf();
        }
        return this.getSelectedCallingNameTotal();
    }

    protected ResourceName getSelectedCallingNameSelf() {
        throw new IllegalStateException("Not implemented");
    }

    protected ResourceName getSelectedCallingNameTotal() {
        throw new IllegalStateException("Not implemented");
    }

    protected final ResourceName getSelectedCallingNameForMethods(IncludeType type) {
        if (type == IncludeType.SELF) {
            return this.getSelectedCallingNameForMethodsSelf();
        }
        return this.getSelectedCallingNameForMethodsTotal();
    }

    protected ResourceName getSelectedCallingNameForMethodsSelf() {
        return this.getSelectedCallingNameSelf();
    }

    protected ResourceName getSelectedCallingNameForMethodsTotal() {
        return this.getSelectedCallingNameTotal();
    }

    protected static ResourceName narrowSnapshot(TypedTimeSeriesModel model, ResourceName name) {
        TimestampToBookmarkConverter converter = model.getTimestampConverter();
        long startTimeStamp = model.getSelectedStartTimeStamp();
        long endTimeStamp = model.getSelectedEndTimeStamp();
        SystemInfo info = name.getSession().getSystemInfo();
        startTimeStamp = info.getTimeMillis() + startTimeStamp / 1000L;
        endTimeStamp = info.getTimeMillis() + endTimeStamp / 1000L;
        LongPair packets = converter.getBookmarks(startTimeStamp, endTimeStamp);
        assert (packets.getFirst() <= packets.getSecond());
        NarrowSnapshotByPacketNr narrowElement = new NarrowSnapshotByPacketNr(startTimeStamp, endTimeStamp, packets.getFirst(), packets.getSecond());
        return name.addElement((ResourceNameElement)narrowElement);
    }
}

