/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.model;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.controller.Controller;
import com.sap.jvm.profiling.controller.model.HeartBeatInfo;
import com.sap.jvm.profiling.controller.model.HeartBeatListener;
import com.sap.jvm.profiling.controller.trace.ProfilingTrace;
import com.sap.jvm.profiling.controller.trace.TraceListener;
import com.sap.jvm.profiling.core.ProfilingTraceType;
import com.sap.jvm.profiling.core.command.ChangeHeartBeatIntervalCommand;
import com.sap.jvm.profiling.core.event.HeartBeatEvent;
import com.sap.jvm.profiling.core.event.HeartBeatEventHandler;
import com.sap.jvm.profiling.core.event.HeartBeatGCStatistic;
import com.sap.jvm.profiling.core.response.ChangeHeartBeatIntervalResponse;
import com.sap.jvm.profiling.core.response.DisableHeartBeatResponse;
import com.sap.jvm.profiling.core.response.EnableHeartBeatResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public final class HeartBeatInfoImpl
implements HeartBeatInfo,
TraceListener,
HeartBeatEventHandler {
    private int packetsReceieved = 0;
    private long heapSize = -1L;
    private double minCPU = 100.0;
    private double maxCPU = 0.0;
    private double accCPU;
    private long minMem = Long.MAX_VALUE;
    private long maxMem = Long.MIN_VALUE;
    private long accMem;
    private long accGcDuration;
    private int gcCount;
    private long firtHbTs;
    private long lastHbTs;
    private Map<ProfilingTraceType, List<HeartBeatInfo.TraceLifeRange>> traceLifeRanges = new Hashtable<ProfilingTraceType, List<HeartBeatInfo.TraceLifeRange>>();
    private Map<ProfilingTraceType, HeartBeatInfo.TraceLifeRange> enabledTraces = new HashMap<ProfilingTraceType, HeartBeatInfo.TraceLifeRange>();
    private ArrayList<HeartBeatListener> listeners = new ArrayList();
    private long lastSeenLocalTS = 0L;
    private long lastSeenRemoteTS = 0L;
    private Controller controller;

    public HeartBeatInfoImpl(Controller controller) {
        this.controller = controller;
    }

    public void handle(EnableHeartBeatResponse response) {
    }

    public void handle(DisableHeartBeatResponse response) {
    }

    public void handle(ChangeHeartBeatIntervalCommand response) {
    }

    public void handle(ChangeHeartBeatIntervalResponse response) {
    }

    public void handle(HeartBeatEvent event) {
        this.addPacket(event);
        for (HeartBeatInfo.TraceLifeRange range : this.enabledTraces.values()) {
            range.setEndTS(event.getTimeMillis());
        }
        this.notifyHeartBeatListeners(event);
    }

    @Override
    public void traceEnabled(ProfilingTrace trace, long enableTimeStamp) {
        ProfilingTraceType type = trace.getType();
        HeartBeatInfo.TraceLifeRange traceRange = new HeartBeatInfo.TraceLifeRange(enableTimeStamp);
        List<HeartBeatInfo.TraceLifeRange> tracesList = this.traceLifeRanges.get(type);
        if (tracesList == null) {
            tracesList = new ArrayList<HeartBeatInfo.TraceLifeRange>();
            tracesList.add(traceRange);
            this.traceLifeRanges.put(type, tracesList);
        } else {
            tracesList.add(traceRange);
        }
        this.enabledTraces.put(type, traceRange);
        this.lastSeenLocalTS = System.currentTimeMillis();
        this.lastSeenRemoteTS = enableTimeStamp;
    }

    @Override
    public void traceDisabled(ProfilingTrace trace, long disabledTimeStamp) {
        ProfilingTraceType type = trace.getType();
        List<HeartBeatInfo.TraceLifeRange> tracesList = this.traceLifeRanges.get(type);
        if (tracesList == null) {
            throw new IllegalStateException("The profiling trace could not be disabled without be enabled! " + type);
        }
        this.enabledTraces.get(type).setEndTS(disabledTimeStamp);
        this.enabledTraces.remove(type);
        this.lastSeenLocalTS = System.currentTimeMillis();
        this.lastSeenRemoteTS = disabledTimeStamp;
    }

    @Override
    public int getReceivedPacketCount() {
        return this.packetsReceieved;
    }

    @Override
    public boolean isDataReceived() {
        return this.packetsReceieved > 0;
    }

    @Override
    public void reset() {
        this.firtHbTs = 0L;
        this.lastHbTs = 0L;
        this.minCPU = 0.0;
        this.maxCPU = 0.0;
        this.accCPU = 0.0;
        this.minMem = 0L;
        this.maxMem = 0L;
        this.accMem = 0L;
        this.heapSize = -1L;
        this.accGcDuration = 0L;
        this.gcCount = 0;
        this.packetsReceieved = 0;
    }

    private void addPacket(HeartBeatEvent packet) {
        if (this.packetsReceieved == 0) {
            this.firtHbTs = packet.getTimeMillis();
            for (HeartBeatGCStatistic gc : packet.getGCStatistics()) {
                if (gc.getTimeMillis() >= this.firtHbTs) continue;
                this.firtHbTs = gc.getTimeMillis();
            }
        }
        this.lastHbTs = packet.getTimeMillis();
        ++this.packetsReceieved;
        this.minCPU = packet.getCPULoad() < this.minCPU ? packet.getCPULoad() : this.minCPU;
        this.maxCPU = packet.getCPULoad() > this.maxCPU ? packet.getCPULoad() : this.maxCPU;
        this.accCPU += packet.getCPULoad();
        this.minMem = packet.getMemSize() < this.minMem ? packet.getMemSize() : this.minMem;
        this.maxMem = packet.getMemSize() > this.maxMem ? packet.getMemSize() : this.maxMem;
        this.accMem += packet.getMemSize();
        this.heapSize = packet.getMemCapacity();
        for (HeartBeatGCStatistic gc : packet.getGCStatistics()) {
            this.accGcDuration += gc.getDuration();
            ++this.gcCount;
        }
    }

    @Override
    public long getHeapSize() {
        return this.isDataReceived() ? this.heapSize : 0L;
    }

    @Override
    public double getMaxCPULoad() {
        return this.maxCPU;
    }

    @Override
    public long getMaxMemUsage() {
        return this.maxMem;
    }

    @Override
    public double getMinCPULoad() {
        return this.minCPU;
    }

    @Override
    public long getMinMemUsage() {
        return this.minMem;
    }

    @Override
    public double getAvgCPULoad() {
        return this.isDataReceived() ? this.accCPU / (double)this.packetsReceieved : 0.0;
    }

    @Override
    public long getAvgGcDuration() {
        return this.isDataReceived() ? this.accGcDuration / (long)this.gcCount : 0L;
    }

    @Override
    public long getAvgMemUsage() {
        return this.isDataReceived() ? this.accMem / (long)this.packetsReceieved : 0L;
    }

    @Override
    public int getGcCount() {
        return this.gcCount;
    }

    @Override
    public long getEndTimeMillis() {
        long max = 0L;
        for (Map.Entry<ProfilingTraceType, List<HeartBeatInfo.TraceLifeRange>> entry : this.traceLifeRanges.entrySet()) {
            HeartBeatInfo.TraceLifeRange range = entry.getValue().get(entry.getValue().size() - 1);
            long ts = range.isClosed() ? range.getEndTS() : this.lastSeenRemoteTS + (System.currentTimeMillis() - this.lastSeenLocalTS);
            if (max >= ts) continue;
            max = ts;
        }
        if (this.isDataReceived() && max < this.lastHbTs) {
            max = this.lastHbTs;
        }
        return max == 0L ? this.getStartTimeMillis() : max;
    }

    @Override
    public long getStartTimeMillis() {
        long min = Long.MAX_VALUE;
        for (Map.Entry<ProfilingTraceType, List<HeartBeatInfo.TraceLifeRange>> entry : this.traceLifeRanges.entrySet()) {
            if (min <= entry.getValue().get(0).getStartTS()) continue;
            min = entry.getValue().get(0).getStartTS();
        }
        if (this.isDataReceived() && min > this.firtHbTs) {
            min = this.firtHbTs;
        }
        return min == Long.MAX_VALUE ? 0L : min;
    }

    @Override
    public List<HeartBeatInfo.TraceLifeRange> getTraceLifeCycle(ProfilingTraceType type) {
        if (type == ProfilingTraceType.ALL_TRACES) {
            ArrayList<HeartBeatInfo.TraceLifeRange> resultList = new ArrayList<HeartBeatInfo.TraceLifeRange>();
            for (Map.Entry<ProfilingTraceType, List<HeartBeatInfo.TraceLifeRange>> entry : this.traceLifeRanges.entrySet()) {
                resultList.addAll((Collection<HeartBeatInfo.TraceLifeRange>)entry.getValue());
            }
            return resultList;
        }
        return this.traceLifeRanges.containsKey(type) ? this.traceLifeRanges.get(type) : new ArrayList<HeartBeatInfo.TraceLifeRange>();
    }

    @Override
    public void addHeartBeatListener(HeartBeatListener listener) {
        if (this.listeners.indexOf(listener) == -1) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeHeartBeatListener(HeartBeatListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyHeartBeatListeners(HeartBeatEvent packet) {
        for (HeartBeatListener l : this.listeners) {
            l.packetReceived(packet);
        }
    }

    public ProfilingSession getSession() {
        return this.controller.getProfilingSession();
    }
}

