/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.model;

import com.sap.jvm.profiling.controller.ResourceController;
import com.sap.jvm.profiling.controller.impl.ControllerImpl;
import com.sap.jvm.profiling.controller.impl.action.ActionFactoryImpl;
import com.sap.jvm.profiling.controller.impl.model.AbstractModelImpl;
import com.sap.jvm.profiling.controller.impl.model.SnapshotCreator;
import com.sap.jvm.profiling.controller.impl.model.SnapshotStoreImpl;
import com.sap.jvm.profiling.controller.impl.model.alloc.AllocationModelImpl;
import com.sap.jvm.profiling.controller.impl.model.cls.ClsModelImpl;
import com.sap.jvm.profiling.controller.impl.model.gc.GcHistoryFileDumpModelImpl;
import com.sap.jvm.profiling.controller.impl.model.gc.GcModelImpl;
import com.sap.jvm.profiling.controller.impl.model.hprof.HprofDumpModelImpl;
import com.sap.jvm.profiling.controller.impl.model.io.IOModelImpl;
import com.sap.jvm.profiling.controller.impl.model.mpt.MethodParameterModelImpl;
import com.sap.jvm.profiling.controller.impl.model.net.NetworkModelImpl;
import com.sap.jvm.profiling.controller.impl.model.sync.SynchronizationModelImpl;
import com.sap.jvm.profiling.controller.impl.model.tbs.PerformanceHotspotModelImpl;
import com.sap.jvm.profiling.controller.impl.model.thread.ThreadDumpModelImpl;
import com.sap.jvm.profiling.controller.impl.resource.AbstractResourceManagerImpl;
import com.sap.jvm.profiling.controller.impl.resource.ProfilingSessionWriter;
import com.sap.jvm.profiling.controller.impl.resource.ResourceUtils;
import com.sap.jvm.profiling.controller.impl.trace.ProfilingTraceImpl;
import com.sap.jvm.profiling.controller.impl.trace.ProfilingTraceSetImpl;
import com.sap.jvm.profiling.controller.model.ModelController;
import com.sap.jvm.profiling.controller.model.SnapshotController;
import com.sap.jvm.profiling.core.ProfilingTraceType;
import com.sap.jvm.profiling.resource.OperationCanceledException;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.snapshot.SnapshotResourceManagerFactory;
import com.sap.jvm.profiling.snapshot.SnapshotStore;
import com.sap.jvm.tracing.Trace;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class ModelControllerImpl
implements ModelController {
    private AbstractModelImpl<?>[] models;
    private ControllerImpl controller;
    private ActionFactoryImpl actionFactory;
    private ProfilingTraceSetImpl traceHistory;

    public ModelControllerImpl(ControllerImpl controller) {
        this.controller = controller;
        this.models = new AbstractModelImpl[ProfilingTraceType.values().length];
        this.models[ProfilingTraceType.ALLOCATION_TRACE.ordinal()] = new AllocationModelImpl(controller);
        this.models[ProfilingTraceType.PERFORMANCE_HOTSPOT_TRACE.ordinal()] = new PerformanceHotspotModelImpl(controller);
        this.models[ProfilingTraceType.METHOD_PARAMETER_TRACE.ordinal()] = new MethodParameterModelImpl(controller);
        this.models[ProfilingTraceType.IO_TRACE.ordinal()] = new IOModelImpl(controller);
        this.models[ProfilingTraceType.SYNCHRONIZATION_TRACE.ordinal()] = new SynchronizationModelImpl(controller);
        this.models[ProfilingTraceType.NETWORK_TRACE.ordinal()] = new NetworkModelImpl(controller);
        this.models[ProfilingTraceType.HPROF_DUMP.ordinal()] = new HprofDumpModelImpl(controller);
        this.models[ProfilingTraceType.GC_TRACE.ordinal()] = new GcModelImpl(controller);
        this.models[ProfilingTraceType.CLASS_STATISTIC_TRACE.ordinal()] = new ClsModelImpl(controller);
        this.models[ProfilingTraceType.THREAD_DUMP_TRACE.ordinal()] = new ThreadDumpModelImpl(controller);
        this.models[ProfilingTraceType.GC_HISTORY_FILE_DUMP.ordinal()] = new GcHistoryFileDumpModelImpl(controller);
        this.traceHistory = new ProfilingTraceSetImpl();
    }

    @Override
    public ProfilingTraceSetImpl getTraceHistory() {
        return this.traceHistory;
    }

    @Override
    public AllocationModelImpl getAllocationModel() {
        return (AllocationModelImpl)this.models[ProfilingTraceType.ALLOCATION_TRACE.ordinal()];
    }

    @Override
    public PerformanceHotspotModelImpl getPerformanceHotspotModel() {
        return (PerformanceHotspotModelImpl)this.models[ProfilingTraceType.PERFORMANCE_HOTSPOT_TRACE.ordinal()];
    }

    @Override
    public MethodParameterModelImpl getMethodParameterModel() {
        return (MethodParameterModelImpl)this.models[ProfilingTraceType.METHOD_PARAMETER_TRACE.ordinal()];
    }

    @Override
    public IOModelImpl getIOModel() {
        return (IOModelImpl)this.models[ProfilingTraceType.IO_TRACE.ordinal()];
    }

    @Override
    public SynchronizationModelImpl getSynchronizationModel() {
        return (SynchronizationModelImpl)this.models[ProfilingTraceType.SYNCHRONIZATION_TRACE.ordinal()];
    }

    @Override
    public NetworkModelImpl getNetworkModel() {
        return (NetworkModelImpl)this.models[ProfilingTraceType.NETWORK_TRACE.ordinal()];
    }

    @Override
    public HprofDumpModelImpl getHprofDumpModel() {
        return (HprofDumpModelImpl)this.models[ProfilingTraceType.HPROF_DUMP.ordinal()];
    }

    @Override
    public GcModelImpl getGcModel() {
        return (GcModelImpl)this.models[ProfilingTraceType.GC_TRACE.ordinal()];
    }

    @Override
    public ClsModelImpl getClassStatisticsModel() {
        return (ClsModelImpl)this.models[ProfilingTraceType.CLASS_STATISTIC_TRACE.ordinal()];
    }

    @Override
    public ThreadDumpModelImpl getThreadDumpModel() {
        return (ThreadDumpModelImpl)this.models[ProfilingTraceType.THREAD_DUMP_TRACE.ordinal()];
    }

    @Override
    public boolean hasModel(ProfilingTraceType type) {
        return this.models[type.ordinal()] != null;
    }

    @Override
    public GcHistoryFileDumpModelImpl getGcHistoryFileDumpModel() {
        return (GcHistoryFileDumpModelImpl)this.models[ProfilingTraceType.GC_HISTORY_FILE_DUMP.ordinal()];
    }

    public AbstractModelImpl<?> getModel(ProfilingTraceType type) {
        AbstractModelImpl<?> result = this.models[type.ordinal()];
        if (result == null) {
            Trace.error(() -> "No model found for trace type " + type);
        }
        return result;
    }

    @Override
    public void createSnapshots() {
        for (int i = 0; i < this.models.length; ++i) {
            if (this.models[i] == null) continue;
            this.models[i].createSnapshot(false);
        }
    }

    @Override
    public void createSnapshot(ProfilingTraceType type, boolean delta) {
        AbstractModelImpl<?> m = this.models[type.ordinal()];
        if (m != null) {
            m.createSnapshot(delta);
        } else assert (false);
    }

    @Override
    public void createSnapshots(ProfilingTraceType[] types, long startHeartBeatPacketIndex, long endHeartBeatPacketIndex, ProgressReporter reporter) {
        SnapshotCreator creator = new SnapshotCreator(this.controller, types, startHeartBeatPacketIndex, endHeartBeatPacketIndex);
        try {
            creator.create(reporter);
        }
        catch (OperationCanceledException e) {
            return;
        }
        catch (IOException e) {
            Trace.error((Throwable)e, (String)"Could not create the snapshots");
            return;
        }
        Snapshot[] snapshots = creator.getSnapshots(ProfilingTraceType.ALL_TRACES);
        for (int i = 0; i < snapshots.length; ++i) {
            int modelIndex = snapshots[i].getType().getTraceType().ordinal();
            if (this.models[modelIndex] != null) {
                this.models[modelIndex].addSnapshot(snapshots[i]);
            } else assert (false);
            this.controller.snapshotCreated(snapshots[i], null);
        }
    }

    public ControllerImpl getController() {
        return this.controller;
    }

    @Override
    public void addSnapshot(Snapshot snapshot) {
        int modelIndex = snapshot.getType().getTraceType().ordinal();
        if (this.models[modelIndex] != null) {
            SnapshotStore store = this.models[modelIndex].getSnapshotStore();
            store.add(snapshot);
        } else assert (false);
    }

    @Override
    public Snapshot[] getSnapshots() {
        ArrayList<Object> tmpSnapshots = new ArrayList<Object>();
        for (int i = 0; i < this.models.length; ++i) {
            if (this.models[i] == null) continue;
            SnapshotStoreImpl store = this.models[i].snapshotStore;
            int size = store.size();
            for (int j = 0; j < size; ++j) {
                tmpSnapshots.add(store.get(j));
            }
            for (Snapshot snapshot : this.models[i].tmpSnapshots) {
                tmpSnapshots.add(snapshot);
            }
        }
        Snapshot[] snapshots = new Snapshot[tmpSnapshots.size()];
        snapshots = tmpSnapshots.toArray(snapshots);
        return snapshots;
    }

    @Override
    public Snapshot getSnapshot(ResourceName resourceName) {
        if (resourceName == null) {
            throw new IllegalArgumentException("The parameter \"resourceName\" is null.");
        }
        return SnapshotResourceManagerFactory.get(resourceName.getSession()).getSnapshot(resourceName);
    }

    @Override
    public void removeSnapshot(Snapshot snapshot) {
        AbstractResourceManagerImpl resourceManager = (AbstractResourceManagerImpl)this.controller.getProfilingSession().getResourceManager();
        this.removeSubSnapshots(snapshot, resourceManager);
        resourceManager.removeSnapshot(snapshot);
        int modelIndex = snapshot.getType().getTraceType().ordinal();
        if (this.models[modelIndex] != null) {
            SnapshotStore store = this.models[modelIndex].getSnapshotStore();
            store.remove(snapshot);
        } else assert (false);
    }

    private void removeSubSnapshots(Snapshot snapshot, AbstractResourceManagerImpl<?> resourceManager) {
        try {
            ProgressReporter reporter = new ProgressReporter();
            ResourceName controllerName = ResourceUtils.getControllerName(snapshot);
            SnapshotController snapshotController = (SnapshotController)resourceManager.get(controllerName, reporter);
            ArrayList snps = new ArrayList();
            this.findSubSnapshots(snapshotController, snps, resourceManager);
            for (SnapshotController snapshotController2 : snps) {
                this.removeSnapshot((Snapshot)snapshotController2.getSnapshot());
            }
        }
        catch (IOException e) {
            Trace.error((Throwable)e);
        }
    }

    private void findSubSnapshots(ResourceController resCnt, List<SnapshotController<?, ?>> snps, AbstractResourceManagerImpl<?> mgr) {
        for (ResourceController<?> res : mgr.getChildren(resCnt)) {
            if (res instanceof SnapshotController) {
                snps.add((SnapshotController)res);
                continue;
            }
            this.findSubSnapshots(res, snps, mgr);
        }
    }

    @Override
    public void write(String filename, ProgressReporter reporter) throws IOException {
        ProfilingSessionWriter writer = new ProfilingSessionWriter(this.controller);
        writer.write(filename, reporter);
    }

    public ActionFactoryImpl getActionFactory() {
        return this.actionFactory;
    }

    public void setActionFactoryImpl(ActionFactoryImpl actionFactory) {
        this.actionFactory = actionFactory;
    }

    public void createSnapshotsInternal(long creationTimeStamp, boolean stopTrace) {
        for (int i = 0; i < this.models.length; ++i) {
            if (i == ProfilingTraceType.GC_HISTORY_FILE_DUMP.ordinal() || this.models[i] == null) continue;
            this.models[i].createSnapshotInternal(true, creationTimeStamp, stopTrace);
        }
    }

    public void setTraceHistory(ProfilingTraceSetImpl traces) {
        this.traceHistory = traces;
        for (int i = 0; i < this.traceHistory.size(); ++i) {
            ProfilingTraceImpl trace = this.traceHistory.get(i);
            this.controller.traceEnabled(trace);
            this.controller.traceDisabled(trace);
        }
    }

    @Override
    public boolean supportsPrfWriting() {
        AbstractResourceManagerImpl manager = (AbstractResourceManagerImpl)this.controller.getProfilingSession().getResourceManager();
        return new File(manager.getBackupFileName()).exists();
    }

    @Override
    public void writePrf(String filename, ProgressReporter reporter) throws IOException {
        int read;
        if (!this.supportsPrfWriting()) {
            Trace.warn((String)"Trying to write the missing prf file");
            return;
        }
        AbstractResourceManagerImpl manager = (AbstractResourceManagerImpl)this.controller.getProfilingSession().getResourceManager();
        File prfFile = new File(manager.getBackupFileName());
        FileInputStream fis = new FileInputStream(prfFile);
        FileOutputStream fos = new FileOutputStream(filename);
        long length = prfFile.length();
        reporter.addWork("", length);
        byte[] buffer = new byte[8192];
        while ((read = fis.read(buffer)) > 0) {
            if ((long)read > length) {
                read = (int)length;
            }
            fos.write(buffer, 0, read);
            reporter.report(reporter.getActualWork() + (long)read);
            length -= (long)read;
        }
        fis.close();
        fos.close();
    }
}

