/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.model;

import com.sap.jvm.profiling.controller.impl.ControllerImpl;
import com.sap.jvm.profiling.controller.impl.model.SnapshotStoreImpl;
import com.sap.jvm.profiling.core.Bookmark;
import com.sap.jvm.profiling.core.ProfilingReader;
import com.sap.jvm.profiling.core.ProfilingTraceType;
import com.sap.jvm.profiling.core.command.ChangeHeartBeatIntervalCommand;
import com.sap.jvm.profiling.core.event.HeartBeatEvent;
import com.sap.jvm.profiling.core.event.HeartBeatEventHandler;
import com.sap.jvm.profiling.core.event.ObjectIdentificationEvent;
import com.sap.jvm.profiling.core.response.ChangeHeartBeatIntervalResponse;
import com.sap.jvm.profiling.core.response.DisableHeartBeatResponse;
import com.sap.jvm.profiling.core.response.EnableHeartBeatResponse;
import com.sap.jvm.profiling.io.command.IOTraceConfiguration;
import com.sap.jvm.profiling.io.event.FileCloseEvent;
import com.sap.jvm.profiling.io.event.FileNotFoundEvent;
import com.sap.jvm.profiling.io.event.FileOpenEvent;
import com.sap.jvm.profiling.io.event.FileReadEvent;
import com.sap.jvm.profiling.io.event.FileWriteEvent;
import com.sap.jvm.profiling.io.event.IOEventHandler;
import com.sap.jvm.profiling.io.response.DisableIOTraceResponse;
import com.sap.jvm.profiling.io.response.EnableIOTraceResponse;
import com.sap.jvm.profiling.memory.command.AllocationTraceConfiguration;
import com.sap.jvm.profiling.memory.command.GcTraceConfiguration;
import com.sap.jvm.profiling.memory.event.AllocationEvent;
import com.sap.jvm.profiling.memory.event.AllocationEventHandler;
import com.sap.jvm.profiling.memory.event.GcEventHandler;
import com.sap.jvm.profiling.memory.event.GcStatistic;
import com.sap.jvm.profiling.memory.event.GcType;
import com.sap.jvm.profiling.memory.response.DisableAllocationMptTraceResponse;
import com.sap.jvm.profiling.memory.response.DisableAllocationTraceResponse;
import com.sap.jvm.profiling.memory.response.DisableGcStatisticResponse;
import com.sap.jvm.profiling.memory.response.EnableAdaptiveAllocationMptTraceResponse;
import com.sap.jvm.profiling.memory.response.EnableAdaptiveAllocationTraceResponse;
import com.sap.jvm.profiling.memory.response.EnableAllocationMptTraceResponse;
import com.sap.jvm.profiling.memory.response.EnableAllocationTraceResponse;
import com.sap.jvm.profiling.memory.response.EnableGcStatisticResponse;
import com.sap.jvm.profiling.method.command.TimeBasedSamplingConfiguration;
import com.sap.jvm.profiling.method.event.MethodParameterApplyErrorEvent;
import com.sap.jvm.profiling.method.event.MethodParameterEntryEvent;
import com.sap.jvm.profiling.method.event.MethodParameterEventHandler;
import com.sap.jvm.profiling.method.event.MethodParameterExitEvent;
import com.sap.jvm.profiling.method.event.MethodParameterMethodToTraceEvent;
import com.sap.jvm.profiling.method.event.MethodParameterNearMissEvent;
import com.sap.jvm.profiling.method.event.MethodToTraceHandler;
import com.sap.jvm.profiling.method.event.TimeBasedSamplingEvent;
import com.sap.jvm.profiling.method.event.TimeBasedSamplingEventHandler;
import com.sap.jvm.profiling.method.parameters.Parameter;
import com.sap.jvm.profiling.method.response.DisableMethodParameterTraceResponse;
import com.sap.jvm.profiling.method.response.DisableTimeBasedSamplingMptResponse;
import com.sap.jvm.profiling.method.response.DisableTimeBasedSamplingResponse;
import com.sap.jvm.profiling.method.response.EnableMethodParameterTraceResponse;
import com.sap.jvm.profiling.method.response.EnableTimeBasedSamplingMptResponse;
import com.sap.jvm.profiling.method.response.EnableTimeBasedSamplingResponse;
import com.sap.jvm.profiling.method.response.MethodParameterSpec;
import com.sap.jvm.profiling.net.command.NetworkTraceConfiguration;
import com.sap.jvm.profiling.net.event.DirectedSocketReadEvent;
import com.sap.jvm.profiling.net.event.DirectedSocketWriteEvent;
import com.sap.jvm.profiling.net.event.NetworkEventHandler;
import com.sap.jvm.profiling.net.event.SocketAcceptEvent;
import com.sap.jvm.profiling.net.event.SocketBindEvent;
import com.sap.jvm.profiling.net.event.SocketCloseEvent;
import com.sap.jvm.profiling.net.event.SocketConnectEvent;
import com.sap.jvm.profiling.net.event.SocketConnectFailureEvent;
import com.sap.jvm.profiling.net.event.SocketOpenEvent;
import com.sap.jvm.profiling.net.event.SocketReadEvent;
import com.sap.jvm.profiling.net.event.SocketWriteEvent;
import com.sap.jvm.profiling.net.response.DisableNetworkTraceResponse;
import com.sap.jvm.profiling.net.response.EnableNetworkTraceResponse;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.snapshot.SnapshotEndTag;
import com.sap.jvm.profiling.snapshot.SnapshotFactory;
import com.sap.jvm.profiling.snapshot.alloc.AllocationSnapshot;
import com.sap.jvm.profiling.snapshot.alloc.Elements;
import com.sap.jvm.profiling.snapshot.gc.Elements;
import com.sap.jvm.profiling.snapshot.gc.GcSnapshot;
import com.sap.jvm.profiling.snapshot.gc.GcSnapshotProperties;
import com.sap.jvm.profiling.snapshot.io.Elements;
import com.sap.jvm.profiling.snapshot.io.IOSnapshot;
import com.sap.jvm.profiling.snapshot.mpt.Elements;
import com.sap.jvm.profiling.snapshot.mpt.MethodParameterSnapshot;
import com.sap.jvm.profiling.snapshot.net.Elements;
import com.sap.jvm.profiling.snapshot.net.NetworkSnapshot;
import com.sap.jvm.profiling.snapshot.sync.Elements;
import com.sap.jvm.profiling.snapshot.sync.SynchronizationSnapshot;
import com.sap.jvm.profiling.snapshot.tbs.Elements;
import com.sap.jvm.profiling.snapshot.tbs.PerformanceHotspotSnapshot;
import com.sap.jvm.profiling.snapshot.thread.Elements;
import com.sap.jvm.profiling.snapshot.thread.ThreadDumpSnapshot;
import com.sap.jvm.profiling.sync.command.SynchronizationTraceConfiguration;
import com.sap.jvm.profiling.sync.event.MonitorEnterEvent;
import com.sap.jvm.profiling.sync.event.MonitorEnteredEvent;
import com.sap.jvm.profiling.sync.event.MonitorExitEvent;
import com.sap.jvm.profiling.sync.event.MonitorNotifyAllEvent;
import com.sap.jvm.profiling.sync.event.MonitorNotifyEvent;
import com.sap.jvm.profiling.sync.event.MonitorWaitEnterEvent;
import com.sap.jvm.profiling.sync.event.MonitorWaitExitEvent;
import com.sap.jvm.profiling.sync.event.ReentrantLockEnterEvent;
import com.sap.jvm.profiling.sync.event.ReentrantLockEnteredEvent;
import com.sap.jvm.profiling.sync.event.ReentrantLockExitEvent;
import com.sap.jvm.profiling.sync.event.SyncEnterEvent;
import com.sap.jvm.profiling.sync.event.SyncEnteredEvent;
import com.sap.jvm.profiling.sync.event.SyncExitEvent;
import com.sap.jvm.profiling.sync.event.SynchronizationEventHandler;
import com.sap.jvm.profiling.sync.response.DisableSynchronizationTraceResponse;
import com.sap.jvm.profiling.sync.response.EnableSynchronizationTraceResponse;
import com.sap.jvm.profiling.thread.ThreadDump;
import com.sap.jvm.profiling.thread.command.ThreadDumpConfiguration;
import com.sap.jvm.profiling.thread.event.ThreadDumpEventHandler;
import com.sap.jvm.profiling.thread.event.ThreadDumpsEvent;
import com.sap.jvm.profiling.thread.event.ThreadDumpsLastEvent;
import com.sap.jvm.profiling.thread.response.EnableThreadDumpsResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class SnapshotCreator {
    private final ControllerImpl controller;
    private final long startHeartBeatPacketIndex;
    private final long endHeartBeatPacketIndex;
    private final Map<ProfilingTraceType, ArrayList<Snapshot>> snapshots;
    private final SnapshotFactory snapshotFactory;
    private Set<ProfilingTraceType> requestedSnapshots;

    public SnapshotCreator(ControllerImpl controller, ProfilingTraceType[] types, long startHeartBeatPacketIndex, long endHeartBeatPacketIndex) {
        this.controller = controller;
        this.startHeartBeatPacketIndex = startHeartBeatPacketIndex;
        this.endHeartBeatPacketIndex = endHeartBeatPacketIndex;
        this.snapshots = new HashMap<ProfilingTraceType, ArrayList<Snapshot>>();
        this.snapshotFactory = SnapshotFactory.get(controller.getProfilingSession());
        this.requestedSnapshots = new HashSet<ProfilingTraceType>();
        for (int i = 0; i < types.length; ++i) {
            if (types[i] == ProfilingTraceType.ALL_TRACES) {
                this.requestedSnapshots.add(ProfilingTraceType.ALLOCATION_TRACE);
                this.requestedSnapshots.add(ProfilingTraceType.PERFORMANCE_HOTSPOT_TRACE);
                this.requestedSnapshots.add(ProfilingTraceType.METHOD_PARAMETER_TRACE);
                this.requestedSnapshots.add(ProfilingTraceType.IO_TRACE);
                this.requestedSnapshots.add(ProfilingTraceType.SYNCHRONIZATION_TRACE);
                this.requestedSnapshots.add(ProfilingTraceType.NETWORK_TRACE);
                this.requestedSnapshots.add(ProfilingTraceType.THREAD_DUMP_TRACE);
                continue;
            }
            this.requestedSnapshots.add(types[i]);
        }
    }

    public void create(ProgressReporter reporter) throws IOException {
        ProfilingReader reader = this.controller.getProfilingSession().getResourceManager().getEventReader();
        EventHandler eventHandler = new EventHandler(reader, reporter);
        if (this.requestedSnapshots.contains(ProfilingTraceType.ALLOCATION_TRACE)) {
            reader.registerAllocationEventHandler((AllocationEventHandler)eventHandler);
        }
        if (this.requestedSnapshots.contains(ProfilingTraceType.PERFORMANCE_HOTSPOT_TRACE)) {
            reader.registerTimeBasedSamplingEventHandler((TimeBasedSamplingEventHandler)eventHandler);
        }
        if (this.requestedSnapshots.contains(ProfilingTraceType.METHOD_PARAMETER_TRACE)) {
            reader.registerMethodParameterEventHandler((MethodParameterEventHandler)eventHandler);
        }
        if (this.requestedSnapshots.contains(ProfilingTraceType.IO_TRACE)) {
            reader.registerIOEventHandler((IOEventHandler)eventHandler);
        }
        if (this.requestedSnapshots.contains(ProfilingTraceType.SYNCHRONIZATION_TRACE)) {
            reader.registerSynchronizationEventHandler((SynchronizationEventHandler)eventHandler);
        }
        if (this.requestedSnapshots.contains(ProfilingTraceType.NETWORK_TRACE)) {
            reader.registerNetworkEventHandler((NetworkEventHandler)eventHandler);
        }
        if (this.requestedSnapshots.contains(ProfilingTraceType.GC_TRACE)) {
            reader.registerGcEventHandler((GcEventHandler)eventHandler);
        }
        if (this.requestedSnapshots.contains(ProfilingTraceType.THREAD_DUMP_TRACE)) {
            reader.registerThreadDumpEventHandler((ThreadDumpEventHandler)eventHandler);
        }
        reader.registerMethodToTraceHandler((MethodToTraceHandler)eventHandler);
        reader.registerHeartBeatEventHandler((HeartBeatEventHandler)eventHandler);
        if (reporter != null) {
            reporter.report(0L, this.endHeartBeatPacketIndex);
        }
        while (!(eventHandler.stop() || reporter != null && reporter.isCancelled() || reader.nextPacket() == null)) {
        }
        eventHandler.finish();
    }

    public Snapshot[] getSnapshots(ProfilingTraceType type) {
        ArrayList<Object> retSnapshots = null;
        if (type == ProfilingTraceType.ALL_TRACES) {
            retSnapshots = new ArrayList();
            for (ArrayList<Snapshot> snapshotList : this.snapshots.values()) {
                retSnapshots.addAll(snapshotList);
            }
        } else {
            retSnapshots = this.snapshots.get(type);
        }
        if (retSnapshots == null) {
            return new Snapshot[0];
        }
        Snapshot[] retValue = new Snapshot[retSnapshots.size()];
        retValue = retSnapshots.toArray(retValue);
        return retValue;
    }

    private void addSnapshot(ProfilingTraceType type, Snapshot snapshot) {
        ArrayList<Snapshot> typeSnapshots = this.snapshots.get(type);
        if (typeSnapshots == null) {
            typeSnapshots = new ArrayList();
            this.snapshots.put(type, typeSnapshots);
        }
        typeSnapshots.add(snapshot);
    }

    private class EventHandler
    implements HeartBeatEventHandler,
    AllocationEventHandler,
    TimeBasedSamplingEventHandler,
    MethodParameterEventHandler,
    IOEventHandler,
    MethodToTraceHandler,
    SynchronizationEventHandler,
    NetworkEventHandler,
    GcEventHandler,
    ThreadDumpEventHandler {
        private AllocationTraceValues allocTraceValues;
        private PerformanceHotspotTraceValues perfTraceValues;
        private MethodParameterTraceValues mptTraceValues;
        private IOTraceValues ioTraceValues;
        private SynchronizationTraceValues syncTraceValues;
        private NetworkTraceValues netTraceValues;
        private GcTraceValues gcTraceValues;
        private ThreadDumpTraceValues threadDumpTraceValues;
        public List<MethodParameterMethodToTraceEvent> methodsToTrace;
        private ProfilingReader reader;
        private boolean isInSection;
        private long currentHeartBeatPacketIndex;
        private boolean stopReading;
        private ProgressReporter reporter;
        public final Bookmark overallStartBookmark;

        EventHandler(ProfilingReader reader, ProgressReporter reporter) {
            this.reader = reader;
            this.reporter = reporter;
            this.allocTraceValues = new AllocationTraceValues();
            this.perfTraceValues = new PerformanceHotspotTraceValues();
            this.mptTraceValues = new MethodParameterTraceValues();
            this.ioTraceValues = new IOTraceValues();
            this.syncTraceValues = new SynchronizationTraceValues();
            this.netTraceValues = new NetworkTraceValues();
            this.gcTraceValues = new GcTraceValues();
            this.threadDumpTraceValues = new ThreadDumpTraceValues();
            if (SnapshotCreator.this.startHeartBeatPacketIndex == 0L) {
                this.isInSection = true;
            }
            for (int i = 0; i < this.syncTraceValues.startBlockedTimes.length; ++i) {
                this.syncTraceValues.startBlockedTimes[i] = -1L;
            }
            this.overallStartBookmark = reader.createBookmark();
        }

        public void finish() {
            if (this.syncTraceValues.creationTimestamp != 0L) {
                assert (this.syncTraceValues.endBookmark != null);
                this.createSynchronizationSnapshot(this.syncTraceValues.creationTimestamp, this.syncTraceValues.endBookmark);
                this.syncTraceValues.creationTimestamp = 0L;
                this.syncTraceValues.endBookmark = null;
            }
            if (SnapshotCreator.this.requestedSnapshots.contains(ProfilingTraceType.GC_TRACE) && this.gcTraceValues.config != null) {
                this.createGcSnapshot(this.gcTraceValues.lastEventTimeStamp);
            }
        }

        public boolean stop() {
            return this.stopReading;
        }

        public void handle(EnableAllocationTraceResponse response) {
            this.allocTraceValues.config = response.getConfiguration();
            if (this.isInSection && this.allocTraceValues.startBookmark == null) {
                this.allocTraceValues.startBookmark = this.reader.createBookmark();
                this.allocTraceValues.startTimeStamp = response.getTime();
            }
        }

        public void handle(EnableAdaptiveAllocationTraceResponse response) {
            this.allocTraceValues.config = response.getConfiguration();
            if (this.isInSection && this.allocTraceValues.startBookmark == null) {
                this.allocTraceValues.startBookmark = this.reader.createBookmark();
                this.allocTraceValues.startTimeStamp = response.getTime();
            }
        }

        public void handle(DisableAllocationTraceResponse response) {
            if (this.isInSection) {
                this.createAllocSnapshot(response.getTime());
            }
            this.allocTraceValues.config = null;
        }

        public void handle(EnableAllocationMptTraceResponse response) {
            this.allocTraceValues.config = response.getConfiguration();
            this.allocTraceValues.specs = response.getParameterSpecs();
            this.methodsToTrace = new ArrayList<MethodParameterMethodToTraceEvent>();
            if (this.isInSection && this.allocTraceValues.startBookmark == null) {
                this.allocTraceValues.startBookmark = this.reader.createBookmark();
                this.allocTraceValues.startTimeStamp = response.getTime();
            }
        }

        public void handle(EnableAdaptiveAllocationMptTraceResponse response) {
            this.allocTraceValues.config = response.getConfiguration();
            this.allocTraceValues.specs = response.getParameterSpecs();
            this.methodsToTrace = new ArrayList<MethodParameterMethodToTraceEvent>();
            if (this.isInSection && this.allocTraceValues.startBookmark == null) {
                this.allocTraceValues.startBookmark = this.reader.createBookmark();
                this.allocTraceValues.startTimeStamp = response.getTime();
            }
        }

        public void handle(DisableAllocationMptTraceResponse response) {
            if (this.isInSection) {
                this.createAllocSnapshot(response.getTime());
            }
            this.allocTraceValues.config = null;
            this.methodsToTrace = null;
        }

        public void handle(AllocationEvent event) {
            if (!this.isInSection) {
                return;
            }
            this.allocTraceValues.objects += (long)event.getNrOfAllocations();
            this.allocTraceValues.bytes += (long)event.getNrOfAllocations() * event.getSize();
        }

        public void handle(EnableHeartBeatResponse response) {
        }

        public void handle(DisableHeartBeatResponse response) {
        }

        public void handle(ChangeHeartBeatIntervalCommand response) {
        }

        public void handle(ChangeHeartBeatIntervalResponse response) {
        }

        public void handle(HeartBeatEvent event) {
            ++this.currentHeartBeatPacketIndex;
            if (this.reporter != null) {
                this.reporter.report(this.currentHeartBeatPacketIndex);
            }
            if (!this.isInSection && this.currentHeartBeatPacketIndex >= SnapshotCreator.this.startHeartBeatPacketIndex && this.currentHeartBeatPacketIndex <= SnapshotCreator.this.endHeartBeatPacketIndex) {
                this.isInSection = true;
                if (this.allocTraceValues.config != null && SnapshotCreator.this.requestedSnapshots.contains(ProfilingTraceType.ALLOCATION_TRACE)) {
                    this.allocTraceValues.startBookmark = this.reader.createBookmark();
                    this.allocTraceValues.startTimeStamp = event.getTimeMillis();
                }
                if (this.perfTraceValues.config != null && SnapshotCreator.this.requestedSnapshots.contains(ProfilingTraceType.PERFORMANCE_HOTSPOT_TRACE)) {
                    this.perfTraceValues.startBookmark = this.reader.createBookmark();
                    this.perfTraceValues.startTimeStamp = event.getTimeMillis();
                }
                if (this.mptTraceValues.specList != null && SnapshotCreator.this.requestedSnapshots.contains(ProfilingTraceType.METHOD_PARAMETER_TRACE)) {
                    this.mptTraceValues.startBookmark = this.reader.createBookmark();
                    this.mptTraceValues.startTimeStamp = event.getTimeMillis();
                }
                if (this.ioTraceValues.config != null && SnapshotCreator.this.requestedSnapshots.contains(ProfilingTraceType.IO_TRACE)) {
                    this.ioTraceValues.startBookmark = this.reader.createBookmark();
                    this.ioTraceValues.startTimeStamp = event.getTimeMillis();
                }
                if (this.syncTraceValues.config != null && SnapshotCreator.this.requestedSnapshots.contains(ProfilingTraceType.SYNCHRONIZATION_TRACE)) {
                    this.syncTraceValues.startBookmark = this.reader.createBookmark();
                    this.syncTraceValues.startTimeStamp = event.getTimeMillis();
                    for (int i = 0; i < this.syncTraceValues.isBlockedStartInSection.length; ++i) {
                        this.syncTraceValues.isBlockedStartInSection[i] = true;
                    }
                }
                if (this.netTraceValues.config != null && SnapshotCreator.this.requestedSnapshots.contains(ProfilingTraceType.NETWORK_TRACE)) {
                    this.netTraceValues.startBookmark = this.reader.createBookmark();
                    this.netTraceValues.startTimeStamp = event.getTimeMillis();
                }
                if (this.gcTraceValues.config != null && SnapshotCreator.this.requestedSnapshots.contains(ProfilingTraceType.GC_TRACE)) {
                    this.gcTraceValues.startBookmark = this.reader.createBookmark();
                    this.gcTraceValues.startTimeStamp = event.getTimeMillis();
                }
                if (this.threadDumpTraceValues.config != null && SnapshotCreator.this.requestedSnapshots.contains(ProfilingTraceType.THREAD_DUMP_TRACE)) {
                    this.threadDumpTraceValues.startBookmark = this.reader.createBookmark();
                    this.threadDumpTraceValues.startTimeStamp = event.getTimeMillis();
                }
            }
            if (this.currentHeartBeatPacketIndex == SnapshotCreator.this.endHeartBeatPacketIndex) {
                this.stopReading = true;
                if (SnapshotCreator.this.requestedSnapshots.contains(ProfilingTraceType.ALLOCATION_TRACE)) {
                    this.createAllocSnapshot(event.getTimeMillis());
                }
                if (SnapshotCreator.this.requestedSnapshots.contains(ProfilingTraceType.PERFORMANCE_HOTSPOT_TRACE)) {
                    this.createPerformanceSnapshot(event.getTimeMillis());
                }
                if (SnapshotCreator.this.requestedSnapshots.contains(ProfilingTraceType.METHOD_PARAMETER_TRACE)) {
                    this.createMethodParameterSnapshot(event.getTimeMillis());
                }
                if (SnapshotCreator.this.requestedSnapshots.contains(ProfilingTraceType.IO_TRACE)) {
                    this.createIOSnapshot(event.getTimeMillis());
                }
                if (SnapshotCreator.this.requestedSnapshots.contains(ProfilingTraceType.SYNCHRONIZATION_TRACE)) {
                    if (this.syncTraceValues.config != null) {
                        assert (this.syncTraceValues.creationTimestamp == 0L);
                        this.syncTraceValues.creationTimestamp = event.getTimeMillis();
                        this.syncTraceValues.endBookmark = this.reader.createBookmark();
                        this.stopReading = false;
                        this.isInSection = false;
                    } else {
                        this.createSynchronizationSnapshot(event.getTimeMillis(), this.reader.createBookmark());
                    }
                }
                if (SnapshotCreator.this.requestedSnapshots.contains(ProfilingTraceType.NETWORK_TRACE)) {
                    this.createNetworkSnapshot(event.getTimeMillis());
                }
                if (SnapshotCreator.this.requestedSnapshots.contains(ProfilingTraceType.GC_TRACE)) {
                    this.createGcSnapshot(event.getTimeMillis());
                }
                if (SnapshotCreator.this.requestedSnapshots.contains(ProfilingTraceType.THREAD_DUMP_TRACE)) {
                    this.createThreadDumpSnapshot(event.getTimeMillis());
                }
            }
        }

        public void handle(EnableTimeBasedSamplingResponse response) {
            this.perfTraceValues.config = response.getConfiguration();
            if (this.isInSection && this.perfTraceValues.startBookmark == null) {
                this.perfTraceValues.startBookmark = this.reader.createBookmark();
                this.perfTraceValues.startTimeStamp = response.getTime();
            }
        }

        public void handle(DisableTimeBasedSamplingResponse response) {
            if (this.isInSection) {
                this.createPerformanceSnapshot(response.getTime());
            }
            this.perfTraceValues.config = null;
        }

        public void handle(EnableTimeBasedSamplingMptResponse response) {
            this.perfTraceValues.config = response.getTbsConfiguration();
            this.perfTraceValues.specs = response.getParameterSpecs();
            this.methodsToTrace = new ArrayList<MethodParameterMethodToTraceEvent>();
            if (this.isInSection && this.perfTraceValues.startBookmark == null) {
                this.perfTraceValues.startBookmark = this.reader.createBookmark();
                this.perfTraceValues.startTimeStamp = response.getTime();
            }
        }

        public void handle(DisableTimeBasedSamplingMptResponse response) {
            if (this.isInSection) {
                this.createPerformanceSnapshot(response.getTime());
            }
            this.perfTraceValues.config = null;
            this.methodsToTrace = null;
        }

        public void handle(DisableMethodParameterTraceResponse response) {
            if (this.isInSection) {
                this.createMethodParameterSnapshot(response.getTime());
            }
            this.mptTraceValues.specList = null;
            this.methodsToTrace = null;
        }

        public void handle(EnableMethodParameterTraceResponse response) {
            this.mptTraceValues.specList = response.getParameterSpecs();
            this.methodsToTrace = new ArrayList<MethodParameterMethodToTraceEvent>();
            if (this.isInSection && this.mptTraceValues.startBookmark == null) {
                this.mptTraceValues.startBookmark = this.reader.createBookmark();
                this.mptTraceValues.startTimeStamp = response.getTime();
            }
        }

        public void handle(MethodParameterEntryEvent event) {
            if (!this.isInSection) {
                return;
            }
            ++this.mptTraceValues.nrOfInvocations;
        }

        public void handle(MethodParameterExitEvent event) {
        }

        public void handle(MethodParameterMethodToTraceEvent event) {
            if (this.methodsToTrace != null) {
                this.methodsToTrace.add(event);
            }
        }

        public void handle(MethodParameterApplyErrorEvent event) {
        }

        public void handle(MethodParameterNearMissEvent event) {
        }

        public boolean providesReturnValuesInEntryEvents() {
            return false;
        }

        public ArrayList<Parameter> getReturnValuesForEntryEvent(MethodParameterEntryEvent event) {
            assert (false);
            return null;
        }

        public void handle(EnableIOTraceResponse response) {
            this.ioTraceValues.config = response.getConfiguration();
            if (this.isInSection && this.ioTraceValues.startBookmark == null) {
                this.ioTraceValues.startBookmark = this.reader.createBookmark();
                this.ioTraceValues.startTimeStamp = response.getTime();
            }
        }

        public void handle(DisableIOTraceResponse response) {
            if (this.isInSection) {
                this.createIOSnapshot(response.getTime());
            }
            this.ioTraceValues.config = null;
        }

        public void handle(FileOpenEvent event) {
        }

        public void handle(FileNotFoundEvent event) {
        }

        public void handle(FileReadEvent event) {
            if (!this.isInSection) {
                return;
            }
            this.ioTraceValues.readBytes += (long)event.getNrOfReadBytes();
            this.ioTraceValues.readDuration += event.getDuration();
        }

        public void handle(FileWriteEvent event) {
            if (!this.isInSection) {
                return;
            }
            this.ioTraceValues.writtenBytes += (long)event.getNrOfWrittenBytes();
            this.ioTraceValues.writeDuration += event.getDuration();
        }

        public void handle(FileCloseEvent event) {
        }

        public void handle(TimeBasedSamplingEvent event) {
            if (!this.isInSection) {
                return;
            }
            ++this.perfTraceValues.nrOfSamples;
            for (int i = 0; i < event.getNrOfThreads(); ++i) {
                if (event.isSleeping(i)) {
                    this.perfTraceValues.sleepingTime += event.getElapsedTime();
                    continue;
                }
                this.perfTraceValues.runningTime += event.getElapsedTime();
                this.perfTraceValues.cpuTime += event.getElapsedCpuTime(i);
            }
        }

        public void handle(EnableGcStatisticResponse response) {
            this.gcTraceValues.config = response.getConfiguration();
            if (this.isInSection && this.gcTraceValues.startBookmark == null) {
                this.gcTraceValues.startBookmark = this.reader.createBookmark();
                this.gcTraceValues.startTimeStamp = response.getTime();
            }
        }

        public void handle(DisableGcStatisticResponse response) {
            if (this.isInSection) {
                this.createGcSnapshot(response.getTime());
            }
            this.gcTraceValues.config = null;
        }

        public void handle(GcStatistic event) {
            if (!this.isInSection) {
                return;
            }
            if (this.gcTraceValues.gcType == null) {
                this.gcTraceValues.gcType = event.getGcType();
            } else assert (this.gcTraceValues.gcType == event.getGcType());
            this.gcTraceValues.lastEventTimeStamp = Math.max(this.gcTraceValues.lastEventTimeStamp, event.getTimestamp());
            if (this.gcTraceValues.properties == null) {
                this.gcTraceValues.properties = new GcSnapshotProperties(event.getGcType());
            }
            this.gcTraceValues.properties.update(event);
        }

        private void createAllocSnapshot(long creationTimeStamp) {
            if (this.allocTraceValues.startBookmark != null) {
                Bookmark endBookmark = this.reader.createBookmark();
                int snapshotId = ((SnapshotStoreImpl)SnapshotCreator.this.controller.getModelController().getAllocationModel().getSnapshotStore()).getNextFreeSnapshotId();
                Elements.AllocationSnapshotElement element = new Elements.AllocationSnapshotElement(snapshotId);
                ResourceName resourceName = SnapshotCreator.this.controller.getProfilingSession().getResourceManager().createResourceName((ResourceNameElement)element);
                resourceName = resourceName.addElement((ResourceNameElement)new SnapshotEndTag());
                AllocationSnapshot snapshot = SnapshotCreator.this.snapshotFactory.createAllocationSnapshot(snapshotId, resourceName, null, this.allocTraceValues.startBookmark, endBookmark, this.allocTraceValues.config, this.allocTraceValues.objects, this.allocTraceValues.bytes, this.allocTraceValues.invocations, this.allocTraceValues.specs, this.methodsToTrace, this.allocTraceValues.startTimeStamp, creationTimeStamp, false, null);
                SnapshotCreator.this.addSnapshot(ProfilingTraceType.ALLOCATION_TRACE, snapshot);
                this.resetValues();
            }
        }

        private void createPerformanceSnapshot(long creationTimeStamp) {
            if (this.perfTraceValues.startBookmark != null) {
                Bookmark endBookmark = this.reader.createBookmark();
                int snapshotId = ((SnapshotStoreImpl)SnapshotCreator.this.controller.getModelController().getPerformanceHotspotModel().getSnapshotStore()).getNextFreeSnapshotId();
                Elements.PerformanceHotspotSnapshotElement element = new Elements.PerformanceHotspotSnapshotElement(snapshotId);
                ResourceName resourceName = SnapshotCreator.this.controller.getProfilingSession().getResourceManager().createResourceName((ResourceNameElement)element);
                resourceName = resourceName.addElement((ResourceNameElement)new SnapshotEndTag());
                PerformanceHotspotSnapshot snapshot = SnapshotCreator.this.snapshotFactory.createPerformanceHotspotSnapshot(snapshotId, resourceName, null, this.perfTraceValues.startBookmark, endBookmark, this.perfTraceValues.config, this.perfTraceValues.nrOfSamples, this.perfTraceValues.runningTime, this.perfTraceValues.cpuTime, this.perfTraceValues.sleepingTime, this.perfTraceValues.invocations, this.perfTraceValues.specs, this.methodsToTrace, this.perfTraceValues.startTimeStamp, creationTimeStamp, false, null);
                SnapshotCreator.this.addSnapshot(ProfilingTraceType.PERFORMANCE_HOTSPOT_TRACE, snapshot);
                this.resetValues();
            }
        }

        private void createMethodParameterSnapshot(long creationTimeStamp) {
            if (this.mptTraceValues.startBookmark != null) {
                Bookmark endBookmark = this.reader.createBookmark();
                int snapshotId = ((SnapshotStoreImpl)SnapshotCreator.this.controller.getModelController().getMethodParameterModel().getSnapshotStore()).getNextFreeSnapshotId();
                Elements.MethodParameterSnapshotElement element = new Elements.MethodParameterSnapshotElement(snapshotId);
                ResourceName resourceName = SnapshotCreator.this.controller.getProfilingSession().getResourceManager().createResourceName((ResourceNameElement)element);
                resourceName = resourceName.addElement((ResourceNameElement)new SnapshotEndTag());
                MethodParameterSnapshot snapshot = SnapshotCreator.this.snapshotFactory.createMethodParameterSnapshot(snapshotId, resourceName, null, this.mptTraceValues.startBookmark, endBookmark, this.mptTraceValues.nrOfInvocations, this.mptTraceValues.specList, this.methodsToTrace, this.mptTraceValues.startTimeStamp, creationTimeStamp, false, null);
                SnapshotCreator.this.addSnapshot(ProfilingTraceType.METHOD_PARAMETER_TRACE, snapshot);
                this.resetValues();
            }
        }

        private void createIOSnapshot(long creationTimeStamp) {
            if (this.ioTraceValues.startBookmark != null) {
                Bookmark endBookmark = this.reader.createBookmark();
                int snapshotId = ((SnapshotStoreImpl)SnapshotCreator.this.controller.getModelController().getIOModel().getSnapshotStore()).getNextFreeSnapshotId();
                Elements.IOSnapshotElement element = new Elements.IOSnapshotElement(snapshotId);
                ResourceName resourceName = SnapshotCreator.this.controller.getProfilingSession().getResourceManager().createResourceName((ResourceNameElement)element);
                resourceName = resourceName.addElement((ResourceNameElement)new SnapshotEndTag());
                IOSnapshot snapshot = SnapshotCreator.this.snapshotFactory.createIOSnapshot(snapshotId, resourceName, null, this.ioTraceValues.startBookmark, endBookmark, this.ioTraceValues.config, this.ioTraceValues.readBytes, this.ioTraceValues.writtenBytes, this.ioTraceValues.readDuration, this.ioTraceValues.writeDuration, this.ioTraceValues.startTimeStamp, creationTimeStamp, false, null);
                SnapshotCreator.this.addSnapshot(ProfilingTraceType.IO_TRACE, snapshot);
                this.resetValues();
            }
        }

        private void createSynchronizationSnapshot(long creationTimeStamp, Bookmark endBookmark) {
            if (this.syncTraceValues.startBookmark != null) {
                Bookmark overallEndBookmark = this.reader.createBookmark();
                int snapshotId = ((SnapshotStoreImpl)SnapshotCreator.this.controller.getModelController().getSynchronizationModel().getSnapshotStore()).getNextFreeSnapshotId();
                Elements.SynchronizationSnapshotElement element = new Elements.SynchronizationSnapshotElement(snapshotId);
                ResourceName resourceName = SnapshotCreator.this.controller.getProfilingSession().getResourceManager().createResourceName((ResourceNameElement)element);
                resourceName = resourceName.addElement((ResourceNameElement)new SnapshotEndTag());
                SynchronizationSnapshot snapshot = SnapshotCreator.this.snapshotFactory.createSynchronizationSnapshot(snapshotId, resourceName, null, this.syncTraceValues.startBookmark, endBookmark, this.overallStartBookmark, overallEndBookmark, this.syncTraceValues.config, this.syncTraceValues.blockedEvents, this.syncTraceValues.blockedTime, this.syncTraceValues.waitEvents, this.syncTraceValues.startTimeStamp, creationTimeStamp, false, null);
                SnapshotCreator.this.addSnapshot(ProfilingTraceType.SYNCHRONIZATION_TRACE, snapshot);
                this.resetValues();
            }
        }

        private void createNetworkSnapshot(long creationTimeStamp) {
            if (this.netTraceValues.startBookmark != null) {
                Bookmark endBookmark = this.reader.createBookmark();
                int snapshotId = ((SnapshotStoreImpl)SnapshotCreator.this.controller.getModelController().getNetworkModel().getSnapshotStore()).getNextFreeSnapshotId();
                Elements.NetworkSnapshotElement element = new Elements.NetworkSnapshotElement(snapshotId);
                ResourceName resourceName = SnapshotCreator.this.controller.getProfilingSession().getResourceManager().createResourceName((ResourceNameElement)element);
                resourceName = resourceName.addElement((ResourceNameElement)new SnapshotEndTag());
                NetworkSnapshot snapshot = SnapshotCreator.this.snapshotFactory.createNetworkSnapshot(snapshotId, resourceName, null, this.netTraceValues.startBookmark, endBookmark, this.netTraceValues.config, this.netTraceValues.readBytes, this.netTraceValues.writtenBytes, this.netTraceValues.readDuration, this.netTraceValues.writeDuration, this.netTraceValues.startTimeStamp, creationTimeStamp, false, null);
                SnapshotCreator.this.addSnapshot(ProfilingTraceType.NETWORK_TRACE, snapshot);
                this.resetValues();
            }
        }

        private void createGcSnapshot(long creationTimeStamp) {
            if (this.gcTraceValues.startBookmark != null) {
                Bookmark endBookmark = this.reader.createBookmark();
                int snapshotId = ((SnapshotStoreImpl)SnapshotCreator.this.controller.getModelController().getGcModel().getSnapshotStore()).getNextFreeSnapshotId();
                Elements.GcSnapshotElement element = new Elements.GcSnapshotElement(snapshotId);
                ResourceName resourceName = SnapshotCreator.this.controller.getProfilingSession().getResourceManager().createResourceName((ResourceNameElement)element);
                resourceName = resourceName.addElement((ResourceNameElement)new SnapshotEndTag());
                GcSnapshotProperties props = this.gcTraceValues.properties;
                if (props == null) {
                    props = new GcSnapshotProperties(null);
                    props.update(null);
                }
                GcSnapshot snapshot = SnapshotCreator.this.snapshotFactory.createGcSnapshot(snapshotId, resourceName, null, this.gcTraceValues.startBookmark, endBookmark, this.gcTraceValues.config, props, this.gcTraceValues.startTimeStamp, creationTimeStamp, false, null);
                SnapshotCreator.this.addSnapshot(ProfilingTraceType.GC_TRACE, snapshot);
                this.resetValues();
            }
        }

        private void createThreadDumpSnapshot(long creationTimeStamp) {
            if (this.threadDumpTraceValues != null && this.threadDumpTraceValues.startBookmark != null) {
                Bookmark endBookmark = this.reader.createBookmark();
                int snapshotId = ((SnapshotStoreImpl)SnapshotCreator.this.controller.getModelController().getThreadDumpModel().getSnapshotStore()).getNextFreeSnapshotId();
                Elements.ThreadDumpSnapshotElement element = new Elements.ThreadDumpSnapshotElement(snapshotId);
                ResourceName resourceName = SnapshotCreator.this.controller.getProfilingSession().getResourceManager().createResourceName((ResourceNameElement)element);
                resourceName = resourceName.addElement((ResourceNameElement)new SnapshotEndTag());
                long startTimeStamp = this.threadDumpTraceValues.startTimeStamp;
                long endTimeStamp = this.threadDumpTraceValues.lastTimestamp;
                if (endTimeStamp > creationTimeStamp || endTimeStamp <= startTimeStamp) {
                    endTimeStamp = creationTimeStamp;
                }
                ThreadDumpSnapshot snapshot = SnapshotCreator.this.snapshotFactory.createThreadDumpSnapshot(snapshotId, resourceName, null, this.threadDumpTraceValues.startBookmark, endBookmark, startTimeStamp, endTimeStamp, this.threadDumpTraceValues.dumps.toArray(new ThreadDump[0]), false);
                SnapshotCreator.this.addSnapshot(ProfilingTraceType.THREAD_DUMP_TRACE, snapshot);
                this.resetValues();
            }
        }

        private void resetValues() {
            this.allocTraceValues.config = null;
            this.allocTraceValues.startBookmark = null;
            this.allocTraceValues.bytes = 0L;
            this.allocTraceValues.objects = 0L;
            this.perfTraceValues.config = null;
            this.perfTraceValues.startBookmark = null;
            this.perfTraceValues.nrOfSamples = 0L;
            this.perfTraceValues.runningTime = 0L;
            this.perfTraceValues.cpuTime = 0L;
            this.perfTraceValues.sleepingTime = 0L;
            this.mptTraceValues.specList = null;
            this.mptTraceValues.startBookmark = null;
            this.mptTraceValues.nrOfInvocations = 0L;
            this.ioTraceValues.config = null;
            this.ioTraceValues.startBookmark = null;
            this.ioTraceValues.readBytes = 0L;
            this.ioTraceValues.writtenBytes = 0L;
            this.ioTraceValues.readDuration = 0L;
            this.ioTraceValues.writeDuration = 0L;
            this.methodsToTrace = null;
            this.syncTraceValues.config = null;
            this.syncTraceValues.startBookmark = null;
            this.syncTraceValues.blockedEvents = 0L;
            this.syncTraceValues.blockedTime = 0L;
            this.syncTraceValues.waitEvents = 0L;
            for (int i = 0; i < this.syncTraceValues.startBlockedTimes.length; ++i) {
                this.syncTraceValues.startBlockedTimes[i] = -1L;
            }
            this.netTraceValues.config = null;
            this.netTraceValues.startBookmark = null;
            this.netTraceValues.readBytes = 0L;
            this.netTraceValues.writtenBytes = 0L;
            this.netTraceValues.readDuration = 0L;
            this.netTraceValues.writeDuration = 0L;
            this.gcTraceValues.config = null;
            this.gcTraceValues.gcType = null;
            this.gcTraceValues.startBookmark = null;
            this.gcTraceValues.properties = null;
            this.threadDumpTraceValues.reset();
        }

        public void handle(EnableSynchronizationTraceResponse response) {
            this.syncTraceValues.config = response.getConfiguration();
            if (this.isInSection && this.syncTraceValues.startBookmark == null) {
                this.syncTraceValues.startBookmark = this.reader.createBookmark();
                this.syncTraceValues.startTimeStamp = response.getTime();
            }
        }

        public void handle(DisableSynchronizationTraceResponse response) {
            if (this.isInSection) {
                assert (this.syncTraceValues.creationTimestamp == 0L && this.syncTraceValues.endBookmark == null);
                this.createSynchronizationSnapshot(response.getTime(), this.reader.createBookmark());
            } else if (this.syncTraceValues.creationTimestamp != 0L) {
                assert (this.syncTraceValues.endBookmark != null);
                this.createSynchronizationSnapshot(this.syncTraceValues.creationTimestamp, this.syncTraceValues.endBookmark);
                this.syncTraceValues.creationTimestamp = 0L;
                this.syncTraceValues.endBookmark = null;
            }
            this.syncTraceValues.config = null;
            for (int i = 0; i < this.syncTraceValues.isBlockedStartInSection.length; ++i) {
                this.syncTraceValues.isBlockedStartInSection[i] = false;
                this.syncTraceValues.startBlockedTimes[i] = -1L;
            }
        }

        public void handle(MonitorEnterEvent event) {
            this.handleImpl((SyncEnterEvent)event);
        }

        private void handleImpl(SyncEnterEvent event) {
            this.syncTraceValues.startBlockedTimes[event.getThreadIndex()] = event.getTimeStamp() - event.getCumulatedSafepointTime();
            this.syncTraceValues.isBlockedStartInSection[event.getThreadIndex()] = this.isInSection;
        }

        public void handle(MonitorEnteredEvent event) {
            this.handleImpl((SyncEnteredEvent)event);
        }

        private void handleImpl(SyncEnteredEvent event) {
            char threadIndex = event.getThreadIndex();
            if (!this.isInSection && !this.syncTraceValues.isBlockedStartInSection[threadIndex]) {
                return;
            }
            if (this.syncTraceValues.startBlockedTimes[threadIndex] == -1L) {
                return;
            }
            ++this.syncTraceValues.blockedEvents;
            this.syncTraceValues.blockedTime += event.getTimeStamp() - event.getCumulatedSafepointTime() - this.syncTraceValues.startBlockedTimes[threadIndex];
            this.syncTraceValues.isBlockedStartInSection[threadIndex] = false;
        }

        public void handle(MonitorWaitEnterEvent event) {
            if (!this.isInSection) {
                return;
            }
            ++this.syncTraceValues.waitEvents;
        }

        public void handle(MonitorWaitExitEvent event) {
        }

        public void handle(MonitorExitEvent event) {
            this.handleImpl((SyncExitEvent)event);
        }

        private void handleImpl(SyncExitEvent event) {
            this.syncTraceValues.startBlockedTimes[event.getThreadIndex()] = -1L;
            this.syncTraceValues.isBlockedStartInSection[event.getThreadIndex()] = false;
        }

        public void handle(MonitorNotifyEvent event) {
        }

        public void handle(MonitorNotifyAllEvent event) {
        }

        public void handle(ObjectIdentificationEvent event) {
        }

        public void handle(ReentrantLockEnterEvent event) {
            this.handleImpl((SyncEnterEvent)event);
        }

        public void handle(ReentrantLockEnteredEvent event) {
            this.handleImpl((SyncEnteredEvent)event);
        }

        public void handle(ReentrantLockExitEvent event) {
            this.handleImpl((SyncExitEvent)event);
        }

        public void handle(EnableNetworkTraceResponse response) {
            this.netTraceValues.config = response.getConfiguration();
            if (this.isInSection && this.netTraceValues.startBookmark == null) {
                this.netTraceValues.startBookmark = this.reader.createBookmark();
                this.netTraceValues.startTimeStamp = response.getTime();
            }
        }

        public void handle(DisableNetworkTraceResponse response) {
            if (this.isInSection) {
                this.createNetworkSnapshot(response.getTime());
            }
            this.netTraceValues.config = null;
        }

        public void handle(SocketOpenEvent event) {
        }

        public void handle(SocketBindEvent event) {
        }

        public void handle(SocketConnectEvent event) {
        }

        public void handle(SocketConnectFailureEvent event) {
        }

        public void handle(SocketAcceptEvent event) {
        }

        public void handle(SocketReadEvent event) {
            if (!this.isInSection) {
                return;
            }
            this.netTraceValues.readBytes += (long)event.getNrOfReadBytes();
            this.netTraceValues.readDuration += event.getDuration();
        }

        public void handle(DirectedSocketReadEvent event) {
            this.handle((SocketReadEvent)event);
        }

        public void handle(SocketWriteEvent event) {
            if (!this.isInSection) {
                return;
            }
            this.netTraceValues.writtenBytes += (long)event.getNrOfWrittenBytes();
            this.netTraceValues.writeDuration += event.getDuration();
        }

        public void handle(DirectedSocketWriteEvent event) {
            this.handle((SocketWriteEvent)event);
        }

        public void handle(SocketCloseEvent event) {
        }

        public void handle(ThreadDumpsEvent event) {
            if (this.isInSection) {
                if (this.threadDumpTraceValues.startBookmark == null) {
                    this.threadDumpTraceValues.startBookmark = this.reader.createBookmark();
                    this.threadDumpTraceValues.startTimeStamp = event.getTime();
                }
                this.threadDumpTraceValues.lastTimestamp = event.getTime();
                this.threadDumpTraceValues.dumps.add(event.getThreadDump());
            }
        }

        public void handle(EnableThreadDumpsResponse response) {
            this.threadDumpTraceValues.config = response.getConfiguration();
            if (this.isInSection && this.threadDumpTraceValues.startBookmark == null) {
                this.threadDumpTraceValues.startBookmark = this.reader.createBookmark();
                this.threadDumpTraceValues.startTimeStamp = response.getTime();
            }
        }

        public void handle(ThreadDumpsLastEvent event) {
            if (this.isInSection && this.threadDumpTraceValues != null) {
                this.createThreadDumpSnapshot(this.threadDumpTraceValues.lastTimestamp);
            }
            this.threadDumpTraceValues.reset();
        }
    }

    private class ThreadDumpTraceValues
    extends AbstractTraceValues {
        public ThreadDumpConfiguration config;
        public long lastTimestamp;
        public List<ThreadDump> dumps;

        private ThreadDumpTraceValues() {
            this.dumps = new ArrayList<ThreadDump>();
        }

        public void reset() {
            this.startBookmark = null;
            this.dumps.clear();
            this.lastTimestamp = 0L;
            this.config = null;
        }
    }

    private class GcTraceValues
    extends AbstractTraceValues {
        public GcTraceConfiguration config;
        public GcType gcType;
        private GcSnapshotProperties properties;
        public long lastEventTimeStamp;

        private GcTraceValues() {
        }
    }

    private class NetworkTraceValues
    extends AbstractTraceValues {
        public NetworkTraceConfiguration config;
        public long readBytes;
        public long writtenBytes;
        public long readDuration;
        public long writeDuration;

        private NetworkTraceValues() {
        }
    }

    private class SynchronizationTraceValues
    extends AbstractTraceValues {
        public SynchronizationTraceConfiguration config;
        public long blockedTime;
        public long blockedEvents;
        public long waitEvents;
        public long[] startBlockedTimes;
        public boolean[] isBlockedStartInSection;
        public long creationTimestamp;
        public Bookmark endBookmark;

        private SynchronizationTraceValues() {
            this.startBlockedTimes = new long[32768];
            this.isBlockedStartInSection = new boolean[32768];
        }
    }

    private class IOTraceValues
    extends AbstractTraceValues {
        public IOTraceConfiguration config;
        public long readBytes;
        public long writtenBytes;
        public long readDuration;
        public long writeDuration;

        private IOTraceValues() {
        }
    }

    private class MethodParameterTraceValues
    extends AbstractTraceValues {
        public List<MethodParameterSpec> specList;
        public long nrOfInvocations;

        private MethodParameterTraceValues() {
        }
    }

    private class PerformanceHotspotTraceValues
    extends AbstractTraceValues {
        public TimeBasedSamplingConfiguration config;
        public long nrOfSamples;
        public long runningTime;
        public long cpuTime;
        public long sleepingTime;
        public long invocations;
        public List<MethodParameterSpec> specs;

        private PerformanceHotspotTraceValues() {
        }
    }

    private class AllocationTraceValues
    extends AbstractTraceValues {
        public AllocationTraceConfiguration config;
        public long bytes;
        public long objects;
        public long invocations;
        public List<MethodParameterSpec> specs;

        private AllocationTraceValues() {
        }
    }

    private abstract class AbstractTraceValues {
        public Bookmark startBookmark;
        public long startTimeStamp;

        private AbstractTraceValues() {
        }
    }
}

