/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.model;

import com.sap.jvm.profiling.controller.impl.ControllerImpl;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.snapshot.SnapshotStore;
import java.util.ArrayList;
import java.util.List;

public final class SnapshotStoreImpl<T extends Snapshot>
implements SnapshotStore<T> {
    private List<T> snapshots;
    private int nextFreeSnapshotId;
    private ControllerImpl controller;

    public SnapshotStoreImpl(ControllerImpl controller) {
        this.controller = controller;
        this.snapshots = new ArrayList<T>();
        this.nextFreeSnapshotId = 1;
    }

    @Override
    public void add(T snapshot) {
        if (snapshot == null) {
            throw new IllegalArgumentException("The parameter \"snapshot\" is null.");
        }
        this.snapshots.add(snapshot);
        int id = snapshot.getId();
        if (id >= this.nextFreeSnapshotId) {
            this.nextFreeSnapshotId = id + 1;
        }
    }

    @Override
    public int size() {
        return this.snapshots.size();
    }

    @Override
    public T get(int index) {
        if (index < 0 || index >= this.snapshots.size()) {
            throw new IllegalArgumentException("The value of the \"index\" parameter \"" + index + "\" is not in the expected range of \"[0-" + this.snapshots.size() + "\"].");
        }
        return (T)((Snapshot)this.snapshots.get(index));
    }

    @Override
    public T getById(int id) {
        for (int i = 0; i < this.size(); ++i) {
            Snapshot current = (Snapshot)this.snapshots.get(i);
            if (current.getId() != id) continue;
            return (T)current;
        }
        return null;
    }

    @Override
    public void remove(T snapshot) {
        if (snapshot == null) {
            throw new IllegalArgumentException("The parameter \"snapshot\" is null.");
        }
        this.snapshots.remove(snapshot);
        this.controller.snapshotRemoved((Snapshot)snapshot);
    }

    @Override
    public void rename(T snapshot, String name) {
        String oldName = snapshot.getName();
        snapshot.setName(name);
        this.controller.snapshotRenamed((Snapshot)snapshot, oldName, name);
    }

    public int getNextFreeSnapshotId() {
        return this.nextFreeSnapshotId++;
    }
}

