/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.model.alerts;

import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.Snapshot;
import java.io.IOException;

public class CreateAlertsController
implements ResourceNameElement {
    private static final String TAG = "create alerts controller";
    private boolean isSnpControler;
    private String ID;

    public CreateAlertsController(String cfgID) {
        this.isSnpControler = false;
        this.ID = this.toString() + "_CFG_" + cfgID;
    }

    public CreateAlertsController(Snapshot snp) throws IOException {
        this.isSnpControler = true;
        this.ID = this.toString() + "_SNP_" + snp.getId();
    }

    public CreateAlertsController(ResourceReader reader) throws IOException {
        this.ID = reader.readString();
        this.isSnpControler = reader.readBoolean();
    }

    public void write(ResourceWriter writer) throws IOException {
        writer.writeString(this.ID);
        writer.writeBoolean(this.isSnpControler);
    }

    public boolean isSnapshotAssociated() {
        return this.isSnpControler;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CreateAlertsController)) {
            return false;
        }
        CreateAlertsController other = (CreateAlertsController)obj;
        return other.ID.equals(this.ID);
    }

    public int hashCode() {
        return this.ID.hashCode();
    }

    public String toString() {
        return "a alerts controller";
    }

    public String getTag() {
        return TAG;
    }
}

