/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.model.alloc;

import com.sap.jvm.profiling.controller.ResourceController;
import com.sap.jvm.profiling.controller.impl.model.AbstractTypedController;
import com.sap.jvm.profiling.controller.impl.model.alloc.CalledUtils;
import com.sap.jvm.profiling.controller.impl.model.alloc.ValueSetUtils;
import com.sap.jvm.profiling.controller.model.IncludeType;
import com.sap.jvm.profiling.controller.model.alloc.ArrayLengthHistogramController;
import com.sap.jvm.profiling.controller.model.alloc.ArrayLengthStatisticController;
import com.sap.jvm.profiling.controller.model.alloc.CalledAllocationController;
import com.sap.jvm.profiling.controller.model.alloc.CalledArrayLengthStatisticController;
import com.sap.jvm.profiling.controller.model.alloc.CalledClassStatisticController;
import com.sap.jvm.profiling.controller.model.alloc.CalledFilterStatisticController;
import com.sap.jvm.profiling.controller.model.alloc.CalledFilterTreeController;
import com.sap.jvm.profiling.controller.model.alloc.CalledJRubyMethodTreeController;
import com.sap.jvm.profiling.controller.model.alloc.CalledMethodStatisticByClassController;
import com.sap.jvm.profiling.controller.model.alloc.CalledMethodStatisticByClassLoaderController;
import com.sap.jvm.profiling.controller.model.alloc.CalledMethodStatisticByPackageController;
import com.sap.jvm.profiling.controller.model.alloc.CalledMethodStatisticByPackageTreeController;
import com.sap.jvm.profiling.controller.model.alloc.CalledMethodStatisticController;
import com.sap.jvm.profiling.controller.model.alloc.CalledMethodTreeController;
import com.sap.jvm.profiling.controller.model.alloc.CalledThreadAnnotationStatisticController;
import com.sap.jvm.profiling.controller.model.alloc.CalledThreadIdStatisticController;
import com.sap.jvm.profiling.controller.model.alloc.CalledThreadNameStatisticController;
import com.sap.jvm.profiling.controller.model.alloc.CalledTimeSeriesController;
import com.sap.jvm.profiling.controller.model.alloc.CallingMethodStatisticController;
import com.sap.jvm.profiling.controller.model.alloc.CallingMethodTreeController;
import com.sap.jvm.profiling.controller.model.alloc.ClassStatisticController;
import com.sap.jvm.profiling.controller.model.alloc.MethodInvocationStatisticController;
import com.sap.jvm.profiling.controller.model.alloc.MethodParameterStatisticController;
import com.sap.jvm.profiling.controller.model.alloc.ParameterValueStatisticController;
import com.sap.jvm.profiling.controller.model.alloc.ThreadAnnotationStatisticController;
import com.sap.jvm.profiling.controller.model.alloc.ThreadIdStatisticController;
import com.sap.jvm.profiling.controller.model.alloc.ThreadNameStatisticController;
import com.sap.jvm.profiling.controller.model.alloc.TimeSeriesController;
import com.sap.jvm.profiling.presentation.typed.TypedModel;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.snapshot.filter.ClassFilter;
import com.sap.jvm.profiling.snapshot.filter.MethodFilter;
import java.io.IOException;

public abstract class AbstractCalledController<T extends ResourceController<M>, M extends TypedModel>
extends AbstractTypedController<M>
implements CalledAllocationController<M, T> {
    private final boolean isCalled;

    protected AbstractCalledController(ResourceName name, ProgressReporter reporter, boolean isCalled) throws IOException {
        super(name, reporter);
        this.isCalled = isCalled;
    }

    @Override
    public T addFilterInliner(MethodFilter[] filters) throws IOException {
        return (T)CalledUtils.addFilterInliner(this.getResourceName(), filters);
    }

    @Override
    public CalledMethodStatisticController asCalledMethodStatistic() throws IOException {
        return CalledUtils.asCalledMethodStatistic(this.getResourceName());
    }

    @Override
    public CalledMethodStatisticByClassController asCalledMethodStatisticByClass() throws IOException {
        return CalledUtils.asCalledMethodStatisticByClass(this.getResourceName());
    }

    @Override
    public CalledMethodStatisticByClassLoaderController asCalledMethodStatisticByClassLoader() throws IOException {
        return CalledUtils.asCalledMethodStatisticByClassLoader(this.getResourceName());
    }

    @Override
    public CalledMethodStatisticByPackageController asCalledMethodStatisticByPackage() throws IOException {
        return CalledUtils.asCalledMethodStatisticByPackage(this.getResourceName());
    }

    @Override
    public CalledMethodStatisticByPackageTreeController asCalledMethodStatisticByPackageTree() throws IOException {
        return CalledUtils.asCalledMethodStatisticByPackageTree(this.getResourceName());
    }

    @Override
    public ThreadIdStatisticController asThreadIdStatistic() throws IOException {
        assert (!this.isCalled);
        return CalledUtils.asThreadIdStatistic(this.getResourceName());
    }

    @Override
    public CalledThreadIdStatisticController asCalledThreadIdStatistic() throws IOException {
        assert (this.isCalled);
        return CalledUtils.asCalledThreadIdStatistic(this.getResourceName());
    }

    @Override
    public ThreadNameStatisticController asThreadNameStatistic() throws IOException {
        assert (!this.isCalled);
        return CalledUtils.asThreadNameStatistic(this.getResourceName());
    }

    @Override
    public CalledThreadNameStatisticController asCalledThreadNameStatistic() throws IOException {
        assert (this.isCalled);
        return CalledUtils.asCalledThreadNameStatistic(this.getResourceName());
    }

    @Override
    public T filterByAllocatedClass(ClassFilter[] filters) throws IOException {
        return (T)CalledUtils.filterByAllocatedClass(this.getResourceName(), filters);
    }

    @Override
    public T filterByMethod(MethodFilter[] filters) throws IOException {
        return (T)CalledUtils.filterByMethod(this.getResourceName(), filters);
    }

    @Override
    public T filterHeapAllocations() throws IOException {
        return (T)CalledUtils.filterHeapAllocations(this.getResourceName());
    }

    @Override
    public T filterStackAllocations() throws IOException {
        return (T)CalledUtils.filterStackAllocations(this.getResourceName());
    }

    @Override
    public ArrayLengthStatisticController getSelectedArrayLengthStatistic(IncludeType type) throws IOException {
        assert (this.canGetArrayLengthStatistic());
        assert (!this.isCalled);
        return CalledUtils.getArrayLengthStatistic(this.getSelectedCalledName(type), this.getResourceName());
    }

    @Override
    public CalledArrayLengthStatisticController getSelectedCalledArrayLengthStatistic(IncludeType type) throws IOException {
        assert (this.canGetArrayLengthStatistic());
        assert (this.isCalled);
        return CalledUtils.getCalledArrayLengthStatistic(this.getSelectedCalledName(type), this.getResourceName());
    }

    @Override
    public CalledClassStatisticController getSelectedCalledClassStatistic(IncludeType type) throws IOException {
        assert (this.isCalled);
        return CalledUtils.getCalledClassStatistic(this.getSelectedCalledName(type), this.getResourceName());
    }

    @Override
    public CalledFilterStatisticController getSelectedCalledFilterStatistic(MethodFilter[] filters, IncludeType type) throws IOException {
        return CalledUtils.getCalledFilterStatistic(this.getSelectedCalledName(type), this.getResourceName(), filters);
    }

    @Override
    public CalledFilterTreeController getSelectedCalledFilterTree(MethodFilter[] filters, IncludeType type) throws IOException {
        return CalledUtils.getCalledFilterTree(this.getSelectedCalledName(type), this.getResourceName(), filters);
    }

    @Override
    public CalledMethodStatisticController getSelectedCalledMethodStatistic(IncludeType type) throws IOException {
        return CalledUtils.getCalledMethodStatistic(this.getSelectedCalledName(type), this.getResourceName());
    }

    @Override
    public CalledMethodTreeController getSelectedCalledMethodTree(IncludeType type) throws IOException {
        return CalledUtils.getCalledMethodTree(this.getSelectedCalledName(type), this.getResourceName());
    }

    @Override
    public CalledJRubyMethodTreeController getSelectedCalledJRubyMethodTree(IncludeType type) throws IOException {
        return CalledUtils.getCalledJRubyMethodTree(this.getSelectedCalledName(type), this.getResourceName());
    }

    @Override
    public CalledThreadAnnotationStatisticController getSelectedCalledThreadAnnotationStatistic(int slot, IncludeType type) throws IOException {
        assert (this.isCalled);
        return CalledUtils.getCalledThreadAnnotationStatistic(this.getSelectedCalledName(type), this.getResourceName(), slot);
    }

    @Override
    public CalledThreadIdStatisticController getSelectedCalledThreadIdStatistic(IncludeType type) throws IOException {
        assert (this.isCalled);
        return CalledUtils.getCalledThreadIdStatistic(this.getSelectedCalledName(type), this.getResourceName());
    }

    @Override
    public CalledThreadNameStatisticController getSelectedCalledThreadNameStatistic(IncludeType type) throws IOException {
        assert (this.isCalled);
        return CalledUtils.getCalledThreadNameStatistic(this.getSelectedCalledName(type), this.getResourceName());
    }

    @Override
    public CallingMethodStatisticController getSelectedCallingMethodStatistic(IncludeType type) throws IOException {
        return CalledUtils.getCallingMethodStatistic(this.getSelectedCallingName(type), this.getResourceName());
    }

    @Override
    public CallingMethodTreeController getSelectedCallingMethodTree(IncludeType type) throws IOException {
        return CalledUtils.getCallingMethodTree(this.getSelectedCallingName(type), this.getResourceName());
    }

    @Override
    public ClassStatisticController getSelectedClassStatistic(IncludeType type) throws IOException {
        assert (!this.isCalled);
        return CalledUtils.getClassStatistic(this.getSelectedCalledName(type), this.getResourceName());
    }

    @Override
    public ThreadAnnotationStatisticController getSelectedThreadAnnotationStatistic(int slot, IncludeType type) throws IOException {
        assert (!this.isCalled);
        return CalledUtils.getThreadAnnotationStatistic(this.getSelectedCalledName(type), this.getResourceName(), slot);
    }

    @Override
    public ThreadIdStatisticController getSelectedThreadIdStatistic(IncludeType type) throws IOException {
        assert (!this.isCalled);
        return CalledUtils.getThreadIdStatistic(this.getSelectedCalledName(type), this.getResourceName());
    }

    @Override
    public ThreadNameStatisticController getSelectedThreadNameStatistic(IncludeType type) throws IOException {
        assert (!this.isCalled);
        return CalledUtils.getThreadNameStatistic(this.getSelectedCalledName(type), this.getResourceName());
    }

    @Override
    public MethodParameterStatisticController getSelectedMethodParameterStatistic(IncludeType type) throws IOException {
        assert (!this.isCalled);
        return CalledUtils.getMethodParameterStatistic(this.getSelectedCalledName(type), this.getResourceName());
    }

    @Override
    public ParameterValueStatisticController getSelectedParameterValueStatistic(IncludeType type) throws IOException {
        assert (this.isCalled);
        return CalledUtils.getParameterValueStatistic(this.getSelectedCalledName(type), this.getResourceName());
    }

    @Override
    public MethodInvocationStatisticController getSelectedMethodInvocationStatistic(IncludeType type) throws IOException {
        assert (this.isCalled);
        return CalledUtils.getMethodInvocationStatistic(this.getSelectedCalledName(type), this.getResourceName());
    }

    @Override
    public CalledTimeSeriesController getSelectedCalledTimeSeriesController(IncludeType type) throws IOException {
        assert (this.isCalled);
        return CalledUtils.getCalledTimeSeries(this.getSelectedCalledName(type), this.getResourceName());
    }

    @Override
    public TimeSeriesController getSelectedTimeSeriesController(IncludeType type) throws IOException {
        assert (!this.isCalled);
        return CalledUtils.getTimeSeries(this.getSelectedCalledName(type), this.getResourceName());
    }

    @Override
    public boolean hasHeartBeat() {
        return this.getResourceName().getSession().getCapabilities().hasHeartBeatTrace();
    }

    @Override
    public T removeInlining() throws IOException {
        return (T)CalledUtils.removedInliners(this.getResourceName());
    }

    @Override
    public void createSnapshot(IncludeType type, ProgressReporter reporter) throws IOException {
        CalledUtils.createSnapshot(this.getResourceName(), this.getSelectedCalledName(type), null, reporter);
    }

    @Override
    public boolean canGetArrayLengthStatistic() {
        return false;
    }

    @Override
    public ArrayLengthHistogramController getArrayLengthHistogram() throws IOException {
        assert (!this.isCalled);
        return ValueSetUtils.getArrayLengthHistogramController(this.getSelectedCalledName(IncludeType.TOTAL), this.getResourceName());
    }

    @Override
    public ArrayLengthHistogramController getCalledArrayLengthHistogram() throws IOException {
        assert (this.isCalled);
        return ValueSetUtils.getArrayLengthHistogramController(this.getSelectedCalledName(IncludeType.TOTAL), this.getResourceName());
    }
}

