/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.model.alloc;

import com.sap.jvm.profiling.controller.ResourceController;
import com.sap.jvm.profiling.controller.impl.model.AbstractTypedController;
import com.sap.jvm.profiling.controller.impl.model.alloc.CallingUtils;
import com.sap.jvm.profiling.controller.impl.model.alloc.ValueSetUtils;
import com.sap.jvm.profiling.controller.model.IncludeType;
import com.sap.jvm.profiling.controller.model.alloc.ArrayLengthHistogramController;
import com.sap.jvm.profiling.controller.model.alloc.CalledMethodStatisticController;
import com.sap.jvm.profiling.controller.model.alloc.CalledMethodTreeController;
import com.sap.jvm.profiling.controller.model.alloc.CallingAllocationController;
import com.sap.jvm.profiling.controller.model.alloc.CallingClassStatisticController;
import com.sap.jvm.profiling.controller.model.alloc.CallingMethodStatisticController;
import com.sap.jvm.profiling.controller.model.alloc.CallingMethodTreeController;
import com.sap.jvm.profiling.controller.model.alloc.CallingThreadNameStatisticController;
import com.sap.jvm.profiling.presentation.typed.TypedColumnBasedModel;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.snapshot.filter.ClassFilter;
import com.sap.jvm.profiling.snapshot.filter.MethodFilter;
import java.io.IOException;

public abstract class AbstractCallingController<T extends ResourceController<M>, M extends TypedColumnBasedModel>
extends AbstractTypedController<M>
implements CallingAllocationController<M, T> {
    protected AbstractCallingController(ResourceName name, ProgressReporter reporter) throws IOException {
        super(name, reporter);
    }

    @Override
    public T addFilterInliner(MethodFilter[] filters) throws IOException {
        return (T)CallingUtils.addFilterInliner(this.getResourceName(), filters);
    }

    @Override
    public CallingMethodStatisticController asCallingMethodStatistic() throws IOException {
        return CallingUtils.asCallingMethodStatistic(this.getResourceName());
    }

    @Override
    public ResourceController<?> asCallingMethodStatisticByClass() throws IOException {
        return CallingUtils.asCallingMethodStatisticByClass(this.getResourceName());
    }

    @Override
    public ResourceController<?> asCallingMethodStatisticByClassLoader() throws IOException {
        return CallingUtils.asCallingMethodStatisticByClassLoader(this.getResourceName());
    }

    @Override
    public ResourceController<?> asCallingMethodStatisticByPackage() throws IOException {
        return CallingUtils.asCallingMethodStatisticByPackage(this.getResourceName());
    }

    @Override
    public ResourceController<?> asCallingMethodStatisticByPackageTree() throws IOException {
        return CallingUtils.asCallingMethodStatisticByPackageTree(this.getResourceName());
    }

    @Override
    public ResourceController<?> asThreadIdStatistic() throws IOException {
        return CallingUtils.asThreadIdStatistic(this.getResourceName());
    }

    @Override
    public CallingThreadNameStatisticController asThreadNameStatistic() throws IOException {
        return CallingUtils.asThreadNameStatistic(this.getResourceName());
    }

    @Override
    public void createSnapshot(IncludeType type, ProgressReporter reporter) throws IOException {
        CallingUtils.createSnapshot(this.getResourceName(), this.getSelectedCallingName(type), null, reporter);
    }

    @Override
    public T filterByAllocatedClass(ClassFilter[] filters) throws IOException {
        return (T)CallingUtils.filterByAllocatedClass(this.getResourceName(), filters);
    }

    @Override
    public T filterByMethod(MethodFilter[] filters) throws IOException {
        return (T)CallingUtils.filterByMethod(this.getResourceName(), filters);
    }

    @Override
    public T filterHeapAllocations() throws IOException {
        return (T)CallingUtils.filterHeapAllocations(this.getResourceName());
    }

    @Override
    public T filterStackAllocations() throws IOException {
        return (T)CallingUtils.filterStackAllocations(this.getResourceName());
    }

    @Override
    public CalledMethodStatisticController getSelectedCalledMethodStatistic(IncludeType type) throws IOException {
        return CallingUtils.getCalledMethodStatistic(this.getSelectedCalledName(type), this.getResourceName());
    }

    @Override
    public CalledMethodTreeController getSelectedCalledMethodTree(IncludeType type) throws IOException {
        return CallingUtils.getCalledMethodTree(this.getSelectedCalledName(type), this.getResourceName());
    }

    @Override
    public ResourceController<?> getSelectedCallingArrayLengthStatistic(IncludeType type) throws IOException {
        return CallingUtils.getCallingArrayLengthStatistic(this.getSelectedCallingName(type), this.getResourceName());
    }

    @Override
    public ArrayLengthHistogramController getCallingArrayLengthHistogram() throws IOException {
        return ValueSetUtils.getArrayLengthHistogramController(this.getSelectedCallingName(IncludeType.TOTAL), this.getResourceName());
    }

    @Override
    public CallingClassStatisticController getSelectedCallingClassStatistic(IncludeType type) throws IOException {
        return CallingUtils.getClassStatistic(this.getSelectedCallingName(type), this.getResourceName());
    }

    @Override
    public CallingMethodStatisticController getSelectedCallingMethodStatistic(IncludeType type) throws IOException {
        return CallingUtils.getCallingMethodStatistic(this.getSelectedCallingName(type), this.getResourceName());
    }

    @Override
    public CallingMethodTreeController getSelectedCallingMethodTree(IncludeType type) throws IOException {
        return CallingUtils.getCallingMethodTree(this.getSelectedCallingName(type), this.getResourceName());
    }

    @Override
    public ResourceController<?> getSelectedCallingThreadAnnotationStatistic(int slot, IncludeType type) throws IOException {
        return CallingUtils.getThreadAnnotationStatistic(this.getSelectedCallingName(type), this.getResourceName(), slot);
    }

    @Override
    public ResourceController<?> getSelectedCallingThreadIdStatistic(IncludeType type) throws IOException {
        return CallingUtils.getThreadIdStatistic(this.getSelectedCallingName(type), this.getResourceName());
    }

    @Override
    public CallingThreadNameStatisticController getSelectedCallingThreadNameStatistic(IncludeType type) throws IOException {
        return CallingUtils.getThreadNameStatistic(this.getSelectedCallingName(type), this.getResourceName());
    }

    @Override
    public T removeInlining() throws IOException {
        return (T)CallingUtils.removedInliners(this.getResourceName());
    }

    @Override
    public boolean canGetArrayLengthStatistic() {
        return false;
    }

    @Override
    public boolean hasHeartBeat() {
        return this.getResourceName().getSession().getCapabilities().hasHeartBeatTrace();
    }
}

