/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.model.alloc;

import com.sap.jvm.profiling.controller.impl.ControllerImpl;
import com.sap.jvm.profiling.controller.impl.model.AbstractModelImpl;
import com.sap.jvm.profiling.controller.impl.model.alloc.Elements;
import com.sap.jvm.profiling.controller.impl.trace.AllocationTraceImpl;
import com.sap.jvm.profiling.controller.impl.trace.ProfilingTraceImpl;
import com.sap.jvm.profiling.controller.model.alloc.AllocationModel;
import com.sap.jvm.profiling.controller.model.alloc.AllocationSnapshotController;
import com.sap.jvm.profiling.controller.trace.AllocationTraceSpec;
import com.sap.jvm.profiling.core.Bookmark;
import com.sap.jvm.profiling.core.ProfilingTraceType;
import com.sap.jvm.profiling.core.Response;
import com.sap.jvm.profiling.core.ThreadFilter;
import com.sap.jvm.profiling.core.event.SnapshotMarkerHandler;
import com.sap.jvm.profiling.core.response.SnapshotMarkerResponse;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.memory.command.AllocationTraceConfiguration;
import com.sap.jvm.profiling.memory.command.AllocationTraceType;
import com.sap.jvm.profiling.memory.event.AllocationEvent;
import com.sap.jvm.profiling.memory.event.AllocationEventHandler;
import com.sap.jvm.profiling.memory.response.DisableAllocationMptTraceResponse;
import com.sap.jvm.profiling.memory.response.DisableAllocationTraceResponse;
import com.sap.jvm.profiling.memory.response.EnableAdaptiveAllocationMptTraceResponse;
import com.sap.jvm.profiling.memory.response.EnableAdaptiveAllocationTraceResponse;
import com.sap.jvm.profiling.memory.response.EnableAllocationMptTraceResponse;
import com.sap.jvm.profiling.memory.response.EnableAllocationTraceResponse;
import com.sap.jvm.profiling.method.event.MethodParameterApplyErrorEvent;
import com.sap.jvm.profiling.method.event.MethodParameterEntryEvent;
import com.sap.jvm.profiling.method.event.MethodParameterEventHandler;
import com.sap.jvm.profiling.method.event.MethodParameterExitEvent;
import com.sap.jvm.profiling.method.event.MethodParameterMethodToTraceEvent;
import com.sap.jvm.profiling.method.event.MethodParameterNearMissEvent;
import com.sap.jvm.profiling.method.event.MethodToTraceHandler;
import com.sap.jvm.profiling.method.parameters.Parameter;
import com.sap.jvm.profiling.method.response.DisableMethodParameterTraceResponse;
import com.sap.jvm.profiling.method.response.EnableMethodParameterTraceResponse;
import com.sap.jvm.profiling.method.response.MethodParameterSpec;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceManager;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.snapshot.SnapshotEndTag;
import com.sap.jvm.profiling.snapshot.SnapshotFactory;
import com.sap.jvm.profiling.snapshot.alloc.AllocationSnapshot;
import com.sap.jvm.profiling.snapshot.alloc.Elements;
import com.sap.jvm.profiling.snapshot.elements.GenericSnapshotElement;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class AllocationModelImpl
extends AbstractModelImpl<AllocationSnapshot>
implements AllocationEventHandler,
AllocationModel,
MethodParameterEventHandler,
SnapshotMarkerHandler,
MethodToTraceHandler {
    public static final String DEFAULT_SNAPSHOT_NAME = I18n._s((String)"Allocation Snapshot");
    private long nrOfAllocations;
    private long nrOfAllocatedBytes;
    private long nrOfInvocations;
    private List<MethodParameterSpec> specs;
    private List<MethodParameterMethodToTraceEvent> methodsToTrace;
    private long nrOfAllocationsSinceLastSnapshotCreation;
    private long nrOfAllocatedBytesSinceLastSnapshotCreation;
    private long nrOfInvocationsSinceLastSnapshotCreation;
    private long nrOfExitEventsPending;
    private long nrOfExitEventsPendingInLastSnapshot;
    private AllocationTraceConfiguration allocTraceConfig;

    public AllocationModelImpl(ControllerImpl controller) {
        super(ProfilingTraceType.ALLOCATION_TRACE, controller);
    }

    @Override
    public long getNrOfAllocations() {
        return this.nrOfAllocations;
    }

    @Override
    public long getNrOfAllocatedBytes() {
        return this.nrOfAllocatedBytes;
    }

    @Override
    public AllocationTraceConfiguration getConfig() {
        return this.allocTraceConfig;
    }

    public void handle(EnableAllocationTraceResponse response) {
        this.handleEnableResponse((Response)response);
        if (response.isSuccess()) {
            this.allocTraceConfig = response.getConfiguration();
        }
    }

    public void handle(EnableAdaptiveAllocationTraceResponse response) {
        this.handleEnableResponse((Response)response);
        if (response.isSuccess()) {
            this.allocTraceConfig = response.getConfiguration();
        }
    }

    public void handle(DisableAllocationTraceResponse response) {
        this.handleDisableResponse((Response)response);
    }

    public void handle(EnableAllocationMptTraceResponse response) {
        this.handleEnableResponse((Response)response);
        if (response.isSuccess()) {
            this.allocTraceConfig = response.getConfiguration();
            this.specs = response.getParameterSpecs();
            this.methodsToTrace = new ArrayList<MethodParameterMethodToTraceEvent>();
        }
    }

    public void handle(EnableAdaptiveAllocationMptTraceResponse response) {
        this.handleEnableResponse((Response)response);
        if (response.isSuccess()) {
            this.allocTraceConfig = response.getConfiguration();
            this.specs = response.getParameterSpecs();
            this.methodsToTrace = new ArrayList<MethodParameterMethodToTraceEvent>();
        }
    }

    public void handle(DisableAllocationMptTraceResponse response) {
        this.handleDisableResponse((Response)response);
    }

    public void handle(AllocationEvent event) {
        this.nrOfAllocations += (long)event.getNrOfAllocations();
        this.nrOfAllocatedBytes += event.getSize() * (long)event.getNrOfAllocations();
        ((AllocationTraceImpl)this.trace).setNrOfAllocatedBytes(this.nrOfAllocatedBytes);
        ((AllocationTraceImpl)this.trace).setNrOfAllocations(this.nrOfAllocations);
        this.nrOfAllocationsSinceLastSnapshotCreation += (long)event.getNrOfAllocations();
        this.nrOfAllocatedBytesSinceLastSnapshotCreation += event.getSize() * (long)event.getNrOfAllocations();
    }

    public boolean handle(SnapshotMarkerResponse event) {
        ProfilingTraceType type;
        boolean consumed = false;
        if (this.allocTraceConfig != null && ((type = event.getTraceType()) == ProfilingTraceType.ALL_TRACES || type == ProfilingTraceType.ALLOCATION_TRACE)) {
            this.createSnapshotInternal(event.getName(), event.isDelta(), event.getCreationTimeStamp(), false);
            consumed = true;
            this.resetStateAfterSnapshotCreation();
        }
        return consumed;
    }

    public void handle(EnableMethodParameterTraceResponse response) {
    }

    public void handle(DisableMethodParameterTraceResponse response) {
    }

    public void handle(MethodParameterEntryEvent event) {
        ++this.nrOfInvocations;
        ++this.nrOfInvocationsSinceLastSnapshotCreation;
        ++this.nrOfExitEventsPending;
    }

    public void handle(MethodParameterExitEvent event) {
        --this.nrOfExitEventsPending;
    }

    public void handle(MethodParameterMethodToTraceEvent event) {
        if (this.methodsToTrace != null) {
            this.methodsToTrace.add(event);
        }
    }

    public void handle(MethodParameterApplyErrorEvent event) {
    }

    public void handle(MethodParameterNearMissEvent event) {
    }

    public boolean providesReturnValuesInEntryEvents() {
        return false;
    }

    public ArrayList<Parameter> getReturnValuesForEntryEvent(MethodParameterEntryEvent event) {
        assert (false);
        return null;
    }

    @Override
    public AllocationSnapshotController getSnapshotController(AllocationSnapshot snapshot) {
        ResourceName name = snapshot.asResourceName().addElement((ResourceNameElement)new Elements.CreateAllocationSnapshotController());
        ResourceManager manager = name.getResourceManager();
        AllocationSnapshotController result = null;
        ProgressReporter reporter = new ProgressReporter();
        try {
            result = (AllocationSnapshotController)manager.get(name, reporter);
        }
        catch (IOException e) {
            Trace.error((Throwable)e);
        }
        reporter.finish();
        return result;
    }

    @Override
    public synchronized void createSnapshotInternal(boolean delta, long endCollectionTimeStamp, boolean stop) {
        if (this.allocTraceConfig == null) {
            return;
        }
        super.createSnapshotInternal(delta, endCollectionTimeStamp, stop);
        if (stop) {
            this.allocTraceConfig = null;
        }
        this.resetStateAfterSnapshotCreation();
    }

    @Override
    protected String getDefaultSnapshotName() {
        return DEFAULT_SNAPSHOT_NAME;
    }

    @Override
    protected ProfilingTraceImpl createTrace(Response response) {
        AllocationTraceConfiguration config = null;
        if (response instanceof EnableAllocationTraceResponse) {
            config = ((EnableAllocationTraceResponse)response).getConfiguration();
        } else if (response instanceof EnableAdaptiveAllocationTraceResponse) {
            config = ((EnableAdaptiveAllocationTraceResponse)response).getConfiguration();
        } else if (response instanceof EnableAllocationMptTraceResponse) {
            config = ((EnableAllocationMptTraceResponse)response).getConfiguration();
        } else if (response instanceof EnableAdaptiveAllocationMptTraceResponse) {
            config = ((EnableAdaptiveAllocationMptTraceResponse)response).getConfiguration();
        } else assert (false);
        AllocationTraceSpec spec = this.createSpecification(config);
        return new AllocationTraceImpl("Allocation Trace", spec, this.controller.getProfilingSession());
    }

    @Override
    protected Snapshot createSnapshot(int snapshotId, String name, Bookmark startBookmark, Bookmark endBookmark, long startTimestamp, long endTimestamp, boolean isVirtual, boolean isDelta, Snapshot parentSnapshot) {
        if (this.snapshotFactory == null) {
            this.snapshotFactory = SnapshotFactory.get(this.controller.getProfilingSession());
        }
        Elements.AllocationSnapshotElement snapshotElement = new Elements.AllocationSnapshotElement(snapshotId);
        ResourceName resourceName = this.controller.getProfilingSession().getResourceManager().createResourceName((ResourceNameElement)snapshotElement);
        resourceName = resourceName.addElement((ResourceNameElement)new SnapshotEndTag());
        return this.snapshotFactory.createAllocationSnapshot(snapshotId, resourceName, name, startBookmark, endBookmark, this.allocTraceConfig, isDelta ? this.nrOfAllocationsSinceLastSnapshotCreation : this.nrOfAllocations, isDelta ? this.nrOfAllocatedBytesSinceLastSnapshotCreation : this.nrOfAllocatedBytes, isDelta ? this.nrOfInvocationsSinceLastSnapshotCreation + this.nrOfExitEventsPendingInLastSnapshot : this.nrOfInvocations, this.specs, this.methodsToTrace, startTimestamp, endTimestamp, isVirtual, (AllocationSnapshot)parentSnapshot);
    }

    @Override
    protected void resetCollectionState() {
        this.nrOfAllocations = 0L;
        this.nrOfAllocatedBytes = 0L;
        this.nrOfAllocatedBytesSinceLastSnapshotCreation = 0L;
        this.nrOfAllocationsSinceLastSnapshotCreation = 0L;
        this.nrOfInvocations = 0L;
        this.nrOfInvocationsSinceLastSnapshotCreation = 0L;
        this.nrOfExitEventsPending = 0L;
        this.nrOfExitEventsPendingInLastSnapshot = 0L;
        this.startTimeStamp = 0L;
        this.lastSnapshotEndTimeStamp = -1L;
        this.methodsToTrace = null;
        this.specs = null;
        this.allocTraceConfig = null;
    }

    private void resetStateAfterSnapshotCreation() {
        this.nrOfAllocationsSinceLastSnapshotCreation = 0L;
        this.nrOfAllocatedBytesSinceLastSnapshotCreation = 0L;
        this.nrOfInvocationsSinceLastSnapshotCreation = 0L;
        this.nrOfExitEventsPendingInLastSnapshot = this.nrOfExitEventsPending;
    }

    private AllocationTraceSpec createSpecification(AllocationTraceConfiguration config) {
        AllocationTraceSpec spec = new AllocationTraceSpec();
        spec.setIsAdaptive(config.getType() == AllocationTraceType.ADAPTIVE);
        spec.setIncludeLineNrs(config.isIncludingLineNrs());
        spec.setIncludeIds(config.getType() == AllocationTraceType.WITH_OBJECT_IDS);
        ThreadFilter threadFilter = config.getAllocatedObjectThreadFilter();
        spec.setThreadFilter(threadFilter);
        spec.setClassFilter(config.getAllocatedObjectClassFilter());
        return spec;
    }

    @Override
    protected GenericSnapshotElement createSnapshotElement(int id) {
        return new Elements.AllocationSnapshotElement(id);
    }

    @Override
    protected Snapshot createSnapshot(SnapshotFactory factory, int id, ResourceName resourceName, String name, Snapshot parent, boolean isVirtual, ProgressReporter reporter) throws IOException {
        return factory.createAllocationSnapshot(id, resourceName, name, (AllocationSnapshot)parent, isVirtual, reporter);
    }
}

