/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.model.alloc;

import com.sap.jvm.profiling.controller.ResourceController;
import com.sap.jvm.profiling.controller.impl.model.alloc.CalledMethodStatisticControllerImpl;
import com.sap.jvm.profiling.controller.impl.model.alloc.CalledMethodTreeControllerImpl;
import com.sap.jvm.profiling.controller.impl.model.alloc.CallingMethodTreeControllerImpl;
import com.sap.jvm.profiling.controller.impl.model.alloc.ClassStatisticControllerImpl;
import com.sap.jvm.profiling.controller.impl.model.alloc.Elements;
import com.sap.jvm.profiling.controller.impl.model.alloc.ThreadAnnotationStatisticControllerImpl;
import com.sap.jvm.profiling.controller.impl.model.alloc.ThreadIdStatisticControllerImpl;
import com.sap.jvm.profiling.controller.impl.model.alloc.ThreadNameStatisticControllerImpl;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceManager;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.alloc.AllocationSnapshot;
import com.sap.jvm.profiling.snapshot.elements.SwitchToCalling;
import com.sap.jvm.profiling.snapshot.elements.UseTopOfStackAsCalledRoots;
import java.io.IOException;

public final class AllocationStatisticUtils {
    public static ThreadIdStatisticControllerImpl getThreadIdStatistic(AllocationSnapshot snapshot, ResourceController<?> parent) throws IOException {
        assert (snapshot != null);
        return AllocationStatisticUtils.getThreadIdStatistic(snapshot.asResourceName(), parent);
    }

    public static ThreadIdStatisticControllerImpl getThreadIdStatistic(ResourceName baseName, ResourceController<?> parent) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateThreadIdStatisticController());
        ResourceManager manager = name.getSession().getResourceManager();
        ProgressReporter reporter = new ProgressReporter();
        ThreadIdStatisticControllerImpl retValue = (ThreadIdStatisticControllerImpl)manager.get(name, reporter);
        manager.setParent(parent.getResourceName(), name);
        reporter.finish();
        return retValue;
    }

    public static ThreadNameStatisticControllerImpl getThreadNameStatistic(AllocationSnapshot snapshot, ResourceController<?> parent) throws IOException {
        assert (snapshot != null);
        return AllocationStatisticUtils.getThreadNameStatistic(snapshot.asResourceName(), parent);
    }

    public static ThreadNameStatisticControllerImpl getThreadNameStatistic(ResourceName baseName, ResourceController<?> parent) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateThreadNameStatisticController());
        ResourceManager manager = name.getSession().getResourceManager();
        ProgressReporter reporter = new ProgressReporter();
        ThreadNameStatisticControllerImpl retValue = (ThreadNameStatisticControllerImpl)manager.get(name, reporter);
        manager.setParent(parent.getResourceName(), name);
        reporter.finish();
        return retValue;
    }

    public static ThreadAnnotationStatisticControllerImpl getThreadAnnotationStatistic(int annotationSlot, AllocationSnapshot snapshot, ResourceController<?> parent) throws IOException {
        assert (snapshot != null);
        return AllocationStatisticUtils.getThreadAnnotationStatistic(annotationSlot, snapshot.asResourceName(), parent);
    }

    public static ThreadAnnotationStatisticControllerImpl getThreadAnnotationStatistic(int annotationSlot, ResourceName baseName, ResourceController<?> parent) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateThreadAnnotationStatisticController(annotationSlot));
        ResourceManager manager = name.getSession().getResourceManager();
        ProgressReporter reporter = new ProgressReporter();
        ThreadAnnotationStatisticControllerImpl retValue = (ThreadAnnotationStatisticControllerImpl)manager.get(name, reporter);
        manager.setParent(parent.getResourceName(), name);
        reporter.finish();
        return retValue;
    }

    public static ClassStatisticControllerImpl getClassStatistic(AllocationSnapshot snapshot, ResourceController<?> parent) throws IOException {
        assert (snapshot != null);
        return AllocationStatisticUtils.getClassStatistic(snapshot.asResourceName(), parent);
    }

    public static ClassStatisticControllerImpl getClassStatistic(ResourceName baseName, ResourceController<?> parent) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateClassStatisticController());
        ResourceManager manager = name.getSession().getResourceManager();
        ProgressReporter reporter = new ProgressReporter();
        ClassStatisticControllerImpl retValue = (ClassStatisticControllerImpl)manager.get(name, reporter);
        manager.setParent(parent.getResourceName(), name);
        reporter.finish();
        return retValue;
    }

    public static CalledMethodStatisticControllerImpl getCalledMethodStatistic(AllocationSnapshot snapshot, ResourceController<?> parent) throws IOException {
        assert (snapshot != null);
        return AllocationStatisticUtils.getCalledMethodStatistic(snapshot.asResourceName(), parent);
    }

    public static CalledMethodStatisticControllerImpl getCalledMethodStatistic(ResourceName baseName, ResourceController<?> parent) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateCalledMethodStatisticController());
        ResourceManager manager = name.getSession().getResourceManager();
        ProgressReporter reporter = new ProgressReporter();
        CalledMethodStatisticControllerImpl retValue = (CalledMethodStatisticControllerImpl)manager.get(name, reporter);
        manager.setParent(parent.getResourceName(), name);
        reporter.finish();
        return retValue;
    }

    public static CalledMethodTreeControllerImpl getCalledMethodTree(AllocationSnapshot snapshot, ResourceController<?> parent) throws IOException {
        assert (snapshot != null);
        return AllocationStatisticUtils.getCalledMethodTree(snapshot.asResourceName(), parent);
    }

    public static CalledMethodTreeControllerImpl getCalledMethodTree(ResourceName baseName, ResourceController<?> parent) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateCalledMethodTreeController());
        ResourceManager manager = name.getSession().getResourceManager();
        ProgressReporter reporter = new ProgressReporter();
        CalledMethodTreeControllerImpl retValue = (CalledMethodTreeControllerImpl)manager.get(name, reporter);
        manager.setParent(parent.getResourceName(), name);
        reporter.finish();
        return retValue;
    }

    public static CallingMethodTreeControllerImpl getCallingMethodTree(AllocationSnapshot snapshot, ResourceController<?> parent) throws IOException {
        assert (snapshot != null);
        ResourceName name = snapshot.asResourceName().addElement((ResourceNameElement)new UseTopOfStackAsCalledRoots()).addElement((ResourceNameElement)new SwitchToCalling());
        return AllocationStatisticUtils.getCallingMethodTree(name, parent);
    }

    public static CallingMethodTreeControllerImpl getCallingMethodTree(ResourceName baseName, ResourceController<?> parent) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateCallingMethodTreeController());
        ResourceManager manager = name.getSession().getResourceManager();
        ProgressReporter reporter = new ProgressReporter();
        CallingMethodTreeControllerImpl retValue = (CallingMethodTreeControllerImpl)manager.get(name, reporter);
        manager.setParent(parent.getResourceName(), name);
        reporter.finish();
        return retValue;
    }
}

