/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.model.cls;

import com.sap.jvm.profiling.controller.impl.ControllerImpl;
import com.sap.jvm.profiling.controller.impl.model.AbstractModelImpl;
import com.sap.jvm.profiling.controller.impl.model.cls.Elements;
import com.sap.jvm.profiling.controller.impl.trace.DumpClassStatisticTraceImpl;
import com.sap.jvm.profiling.controller.impl.trace.ProfilingTraceImpl;
import com.sap.jvm.profiling.controller.model.cls.ClsModel;
import com.sap.jvm.profiling.controller.model.cls.ClsSnapshotController;
import com.sap.jvm.profiling.core.Bookmark;
import com.sap.jvm.profiling.core.ProfilingTraceType;
import com.sap.jvm.profiling.core.Response;
import com.sap.jvm.profiling.core.event.SnapshotMarkerHandler;
import com.sap.jvm.profiling.core.response.SnapshotMarkerResponse;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.memory.event.BasicClassStatistic;
import com.sap.jvm.profiling.memory.event.ClassStatisticDumpEnd;
import com.sap.jvm.profiling.memory.event.ClassStatisticDumpStart;
import com.sap.jvm.profiling.memory.event.ClassStatisticEventHandler;
import com.sap.jvm.profiling.memory.event.OldGenClassStatistic;
import com.sap.jvm.profiling.memory.event.PermGenClassStatistic;
import com.sap.jvm.profiling.memory.event.YoungGenClassStatistic;
import com.sap.jvm.profiling.memory.response.ClassStatisticDumpResponse;
import com.sap.jvm.profiling.memory.response.DisableOldGenClassStatisticResponse;
import com.sap.jvm.profiling.memory.response.DisablePermGenClassStatisticResponse;
import com.sap.jvm.profiling.memory.response.DisableYoungGenClassStatisticResponse;
import com.sap.jvm.profiling.memory.response.DumpClassStatisticEndResponse;
import com.sap.jvm.profiling.memory.response.DumpClassStatisticStartResponse;
import com.sap.jvm.profiling.memory.response.EnableOldGenClassStatisticResponse;
import com.sap.jvm.profiling.memory.response.EnablePermGenClassStatisticResponse;
import com.sap.jvm.profiling.memory.response.EnableYoungGenClassStatisticResponse;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceManager;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.snapshot.SnapshotEndTag;
import com.sap.jvm.profiling.snapshot.SnapshotFactory;
import com.sap.jvm.profiling.snapshot.cls.ClsSnapshot;
import com.sap.jvm.profiling.snapshot.cls.Elements;
import com.sap.jvm.profiling.snapshot.elements.GenericSnapshotElement;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;

public class ClsModelImpl
extends AbstractModelImpl<ClsSnapshot>
implements ClassStatisticEventHandler,
ClsModel,
SnapshotMarkerHandler {
    private OldGenClassStatistic currentOldGenClassStatistic;
    private PermGenClassStatistic currentPermGenClassStatistic;
    private YoungGenClassStatistic currentYoungGenClassStatistic;
    public boolean classStatisticIsRunning;
    public long gcNumber;
    public long sizeOfYoungGen;
    public long sizeOfOldGen;
    public long sizeOfPermGen;
    public static final String DEFAULT_SNAPSHOT_NAME = I18n._s((String)"Class Statistic");

    public ClsModelImpl(ControllerImpl controller) {
        super(ProfilingTraceType.CLASS_STATISTIC_TRACE, controller);
        this.resetStateAfterSnapshotCreation();
    }

    private boolean isAClassStatisticStillActive() {
        return this.classStatisticIsRunning;
    }

    public boolean handle(SnapshotMarkerResponse event) {
        return false;
    }

    @Override
    protected ProfilingTraceImpl createTrace(Response response) {
        ClassStatisticDumpResponse classStatResponse = (ClassStatisticDumpResponse)response;
        return new DumpClassStatisticTraceImpl("Dump Class Statisitcs", classStatResponse.forceGcRequested(), this.controller.getProfilingSession());
    }

    @Override
    protected String getDefaultSnapshotName() {
        return DEFAULT_SNAPSHOT_NAME;
    }

    @Override
    protected void resetCollectionState() {
    }

    @Override
    public ClsSnapshotController getSnapshotController(ClsSnapshot snapshot) {
        ResourceName name = snapshot.asResourceName().addElement((ResourceNameElement)new Elements.CreateClassStatisticDumpSnapshotController());
        ResourceManager manager = name.getResourceManager();
        ClsSnapshotController result = null;
        ProgressReporter reporter = new ProgressReporter();
        try {
            result = (ClsSnapshotController)manager.get(name, reporter);
        }
        catch (IOException e) {
            Trace.error((Throwable)e);
        }
        reporter.finish();
        return result;
    }

    @Override
    protected Snapshot createSnapshot(int snapshotId, String name, Bookmark startBookmark, Bookmark endBookmark, long startTimestamp, long endTimestamp, boolean isVirtual, boolean isDelta, Snapshot parentSnapshot) {
        if (this.snapshotFactory == null) {
            this.snapshotFactory = SnapshotFactory.get(this.controller.getProfilingSession());
        }
        Elements.ClsSnapshotElement snapshotElement = new Elements.ClsSnapshotElement(snapshotId);
        ResourceName resourceName = this.controller.getProfilingSession().getResourceManager().createResourceName((ResourceNameElement)snapshotElement);
        resourceName = resourceName.addElement((ResourceNameElement)new SnapshotEndTag());
        return this.snapshotFactory.createClassStatisticSnapshot(snapshotId, resourceName, name, startBookmark, endBookmark, startTimestamp, endTimestamp, isVirtual, (ClsSnapshot)parentSnapshot, this.currentYoungGenClassStatistic, this.currentOldGenClassStatistic, this.currentPermGenClassStatistic, this.sizeOfYoungGen, this.sizeOfOldGen, this.sizeOfPermGen);
    }

    private void resetStateAfterSnapshotCreation() {
        this.classStatisticIsRunning = false;
        this.gcNumber = -1L;
        this.currentOldGenClassStatistic = null;
        this.currentPermGenClassStatistic = null;
        this.currentYoungGenClassStatistic = null;
    }

    private void getGcNumber(BasicClassStatistic ev) {
        if (this.gcNumber <= 0L) {
            this.gcNumber = ev.getGCNr();
        } else if (this.gcNumber != ev.getGCNr()) {
            Trace.warn(() -> "Got GC number :" + ev.getGCNr() + " but expected:" + this.gcNumber);
        }
    }

    public void handle(OldGenClassStatistic event) {
        this.getGcNumber((BasicClassStatistic)event);
        if (this.classStatisticIsRunning) {
            if (this.currentOldGenClassStatistic == null) {
                this.currentOldGenClassStatistic = event;
            } else {
                Trace.warn(() -> "Got a second instance of " + event.getPacketName() + " during one class srtatistic snapshot.");
            }
        }
    }

    public void handle(PermGenClassStatistic event) {
        this.getGcNumber((BasicClassStatistic)event);
        if (this.classStatisticIsRunning) {
            if (this.currentPermGenClassStatistic == null) {
                this.currentPermGenClassStatistic = event;
            } else {
                Trace.warn(() -> "Got a second instance of " + event.getPacketName() + " during one class srtatistic snapshot.");
            }
        }
    }

    public void handle(YoungGenClassStatistic event) {
        this.getGcNumber((BasicClassStatistic)event);
        if (this.classStatisticIsRunning) {
            if (this.currentYoungGenClassStatistic == null) {
                this.currentYoungGenClassStatistic = event;
            } else {
                Trace.warn(() -> "Got a second instance of " + event.getPacketName() + " during one class srtatistic snapshot.");
            }
        }
    }

    public void handle(ClassStatisticDumpEnd event) {
        assert (this.isAClassStatisticStillActive());
        this.createSnapshotInternal(event.getName(), false, event.getEndTime(), true);
        this.resetStateAfterSnapshotCreation();
    }

    public void handle(ClassStatisticDumpStart event) {
        this.resetStateAfterSnapshotCreation();
        this.classStatisticIsRunning = true;
    }

    public void handle(ClassStatisticDumpResponse event) {
        this.handleEnableResponse((Response)event);
        this.sizeOfYoungGen = event.getMaxYoungGenSize();
        this.sizeOfOldGen = event.getMaxOldGenSize();
        this.sizeOfPermGen = event.getMaxPermGenSize();
    }

    public void handle(EnableOldGenClassStatisticResponse response) {
    }

    public void handle(DisableOldGenClassStatisticResponse response) {
    }

    public void handle(EnableYoungGenClassStatisticResponse response) {
    }

    public void handle(DisableYoungGenClassStatisticResponse response) {
    }

    public void handle(EnablePermGenClassStatisticResponse response) {
    }

    public void handle(DisablePermGenClassStatisticResponse response) {
    }

    public void handle(DumpClassStatisticEndResponse event) {
    }

    public void handle(DumpClassStatisticStartResponse event) {
    }

    @Override
    protected GenericSnapshotElement createSnapshotElement(int id) {
        return new Elements.ClsSnapshotElement(id);
    }

    @Override
    protected Snapshot createSnapshot(SnapshotFactory factory, int id, ResourceName resourceName, String name, Snapshot parent, boolean isVirtual, ProgressReporter reporter) throws IOException {
        throw new UnsupportedOperationException();
    }
}

