/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.model.compare;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.controller.ResourceController;
import com.sap.jvm.profiling.controller.impl.model.compare.CreateCompareTableController;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.resource.CreationContext;
import com.sap.jvm.profiling.presentation.resource.CreationContextFactory;
import com.sap.jvm.profiling.presentation.resource.CreationContextProvider;
import com.sap.jvm.profiling.presentation.resource.ElementContextCreator;
import com.sap.jvm.profiling.presentation.resource.ElementContextCreatorFactory;
import com.sap.jvm.profiling.presentation.typed.RendererTheme;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.viewer.ModelViewer;
import com.sap.jvm.profiling.viewer.renderer.MultiChildNode;
import com.sap.jvm.profiling.viewer.renderer.RendererNode;
import com.sap.jvm.profiling.viewer.renderer.TextNode;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;
import java.util.ArrayList;

public class CompareCreationContextFactory
implements ElementContextCreatorFactory {
    @Override
    public ElementContextCreator create(final ModelViewer viewer, final RendererTheme theme) {
        return new ElementContextCreator(){
            private static final String PATH_TAG = "context.selectedView";
            private TextNode otherPathTextNode;
            private MultiChildNode withSuffix;
            private RendererNode rootWithSuffix;
            private RendererNode rootWithoutSuffix;
            {
                this.otherPathTextNode = viewer.newTextNode(null);
                this.withSuffix = viewer.newMultiChildNode(this.otherPathTextNode, null);
                this.rootWithSuffix = theme.decorate(PATH_TAG, viewer, this.withSuffix);
                this.rootWithoutSuffix = theme.decorate(PATH_TAG, viewer, this.otherPathTextNode);
            }

            @Override
            public RendererNode createRendererNode(ResourceNameElement element, ProfilingSession session) {
                ResourceName baseViewName;
                CreationContextProvider provider;
                CreationContext context;
                RendererNode suffixNode;
                CreateCompareTableController compareCtrl = (CreateCompareTableController)element;
                ResourceController<?> base = compareCtrl.getTableResourceControllerB();
                if (base == null) {
                    String baseName = compareCtrl.getBaseViewName();
                    this.otherPathTextNode.setText(baseName);
                    return this.rootWithoutSuffix;
                }
                String name = CompareCreationContextFactory.getName(base);
                this.otherPathTextNode.setText(name);
                ResourceName parentName = base.getParentName();
                if (parentName != null && (suffixNode = (context = (provider = CreationContextFactory.getProvider(viewer, theme.getSpec())).get(null, parentName, baseViewName = base.getResourceName())).getRendererNode(session)) != null) {
                    this.withSuffix.getChildren()[1] = suffixNode;
                    return this.rootWithSuffix;
                }
                return this.rootWithoutSuffix;
            }

            @Override
            public String createToolTip(ResourceNameElement element, ProfilingSession session) {
                CreateCompareTableController createController = (CreateCompareTableController)element;
                CreationContextProvider provider = CreationContextFactory.getProvider(viewer, theme.getSpec());
                ResourceController<?> newCtrl = createController.getTableResourceControllerA();
                ResourceController<?> base = createController.getTableResourceControllerB();
                String newName = CompareCreationContextFactory.getFullName(newCtrl, provider);
                String basePath = null;
                String baseName = null;
                if (base == null) {
                    baseName = createController.getBaseViewName();
                    basePath = CompareCreationContextFactory.getPathString(createController.getBaseNamePath());
                } else {
                    baseName = CompareCreationContextFactory.getFullName(base, provider);
                    basePath = CompareCreationContextFactory.getPathString(base, provider);
                }
                return I18n._s((String)"Comparison of view '{0}' [new] \nwith view '{1}' [old]\n\nPath of [old] view:\n{2}", (Object[])new Object[]{newName, baseName, basePath});
            }

            @Override
            public Class<?>[] getSupportedElements() {
                return new Class[]{CreateCompareTableController.class};
            }

            @Override
            public String createContextDescription(ResourceNameElement element, ProfilingSession session) {
                ResourceName baseViewName;
                CreateCompareTableController createController = (CreateCompareTableController)element;
                CreationContextProvider provider = CreationContextFactory.getProvider(viewer, theme.getSpec());
                ResourceController<?> base = createController.getTableResourceControllerB();
                if (base == null) {
                    return null;
                }
                ResourceName parentName = base.getParentName();
                CreationContext context = provider.get(null, parentName, baseViewName = base.getResourceName());
                return context != null ? context.getContextDescription(session) : null;
            }
        };
    }

    protected static String getPathString(ResourceController<?> controller, CreationContextProvider provider) {
        ArrayList<String> pathElements = new ArrayList<String>();
        ResourceController<?> current = controller;
        while (current != null) {
            String text = CompareCreationContextFactory.getFullName(current, provider);
            pathElements.add(text);
            try {
                current = current.getParent();
            }
            catch (IOException e) {
                Trace.error((Throwable)e, (String)"Could not get the parent of a resource controller");
                current = null;
            }
        }
        StringBuilder result = new StringBuilder();
        String indent = "";
        for (int i = pathElements.size() - 1; i >= 0; --i) {
            result.append(indent);
            result.append((String)pathElements.get(i));
            if (i > 0) {
                result.append("\n");
            }
            indent = indent + "   ";
        }
        return result.toString();
    }

    protected static String getPathString(String[] path) {
        StringBuilder result = new StringBuilder();
        String indent = "";
        for (int i = 0; i < path.length; ++i) {
            result.append(indent);
            result.append(path[i]);
            if (i < path.length - 1) {
                result.append("\n");
            }
            indent = indent + "   ";
        }
        return result.toString();
    }

    protected static String getFullName(ResourceController<?> controller, CreationContextProvider provider) {
        RendererNode suffixNode;
        String result = CompareCreationContextFactory.getName(controller);
        ResourceName parentName = controller.getParentName();
        CreationContext context = provider.get(null, parentName, controller.getResourceName());
        RendererNode rendererNode = suffixNode = parentName == null ? null : context.getRendererNode(parentName.getSession());
        if (suffixNode != null) {
            result = result + " | " + suffixNode.asString();
        }
        return result;
    }

    public static String getName(ResourceController<?> controller) {
        return controller.getModel().getTitle();
    }

    public static String getIconKey(ResourceController<?> controller) {
        return controller.getModel().getIconKey();
    }
}

