/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.model.compare;

import com.sap.jvm.profiling.controller.ControllerFactory;
import com.sap.jvm.profiling.controller.ResourceController;
import com.sap.jvm.profiling.controller.TableResourceController;
import com.sap.jvm.profiling.presentation.typed.TypedTableModel;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;
import java.util.ArrayList;

public class CreateCompareTableController
implements ResourceNameElement {
    private static final String TAG = "create compare controller for typed tables";
    private int resourceControllerIdA;
    private int resourceControllerIdB;
    private String controllerIdA;
    private String controllerIdB;
    private ResourceName resourceControllerNameA;
    private String baseName;
    private String baseIconKey;
    private String[] baseNamePath;

    public CreateCompareTableController() {
        this.resourceControllerIdA = 0;
        this.resourceControllerIdB = 0;
        this.controllerIdA = null;
        this.controllerIdB = null;
        this.resourceControllerNameA = null;
        this.baseName = null;
        this.baseIconKey = null;
        this.baseNamePath = null;
    }

    public CreateCompareTableController(TableResourceController controllerA, TableResourceController controllerB) {
        this.resourceControllerIdA = controllerA.getId();
        this.resourceControllerIdB = controllerB.getId();
        this.controllerIdA = controllerA.getController().getId();
        this.controllerIdB = controllerB.getController().getId();
        this.resourceControllerNameA = controllerA.getResourceName();
        this.baseName = ((TypedTableModel)controllerB.getModel()).getTitle();
        this.baseIconKey = ((TypedTableModel)controllerB.getModel()).getIconKey();
        this.baseNamePath = CreateCompareTableController.getNamePath(controllerB);
    }

    public CreateCompareTableController(ResourceReader reader) throws IOException {
        this.resourceControllerIdA = reader.readInt32();
        this.resourceControllerIdB = reader.readInt32();
        this.controllerIdA = reader.readString();
        this.controllerIdB = reader.readString();
        this.resourceControllerNameA = reader.readResourceName();
        this.baseName = reader.readString();
        this.baseIconKey = reader.readString();
        int pathLength = reader.readInt32();
        this.baseNamePath = new String[pathLength];
        for (int i = 0; i < pathLength; ++i) {
            this.baseNamePath[i] = reader.readString();
        }
    }

    public TypedTableModel getTableModelA() {
        TableResourceController tableResourceController = (TableResourceController)this.getTableResourceControllerA();
        if (tableResourceController == null) {
            return null;
        }
        return (TypedTableModel)tableResourceController.getModel();
    }

    public TypedTableModel getTableModelB() {
        TableResourceController tableResourceController = (TableResourceController)this.getTableResourceControllerB();
        if (tableResourceController == null) {
            return null;
        }
        return (TypedTableModel)tableResourceController.getModel();
    }

    public ResourceController<?> getTableResourceControllerA() {
        try {
            ProgressReporter reporter = new ProgressReporter();
            ResourceController result = (ResourceController)this.resourceControllerNameA.getResourceManager().get(this.resourceControllerNameA, reporter);
            reporter.finish();
            return result;
        }
        catch (IOException e) {
            Trace.error((Throwable)e, (String)"Error while reading first table controller of comparison.");
            return null;
        }
    }

    public ResourceController<?> getTableResourceControllerB() {
        try {
            String newControllerID = this.controllerIdB;
            if (this.controllerIdA.equals(this.controllerIdB)) {
                newControllerID = this.getTableResourceControllerA().getController().getId();
            }
            return (ResourceController)ControllerFactory.getResource(newControllerID, this.resourceControllerIdB);
        }
        catch (IOException e) {
            Trace.error((Throwable)e, (String)"Error while reading second table controller of comparison.");
            return null;
        }
    }

    public String getTableModelUidB() {
        return this.controllerIdB + ":" + this.resourceControllerIdB;
    }

    public String getBaseViewName() {
        return this.baseName;
    }

    public String[] getBaseNamePath() {
        return this.baseNamePath;
    }

    public String getBaseViewIconKey() {
        return this.baseIconKey;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CreateCompareTableController)) {
            return false;
        }
        CreateCompareTableController other = (CreateCompareTableController)obj;
        return other.resourceControllerIdB == this.resourceControllerIdB && other.controllerIdB.equals(this.controllerIdB);
    }

    public int hashCode() {
        int result = this.toString().hashCode();
        result = result * 59 + this.resourceControllerIdB;
        result = result * 59 + this.controllerIdB.hashCode();
        return result;
    }

    public String toString() {
        return "a compare controller for typed tables";
    }

    public void write(ResourceWriter writer) throws IOException {
        writer.writeInt32(this.resourceControllerIdA);
        writer.writeInt32(this.resourceControllerIdB);
        writer.writeString(this.controllerIdA);
        writer.writeString(this.controllerIdB);
        this.resourceControllerNameA.write(writer);
        writer.writeString(this.baseName);
        writer.writeString(this.baseIconKey);
        writer.writeInt32(this.baseNamePath.length);
        for (int i = 0; i < this.baseNamePath.length; ++i) {
            writer.writeString(this.baseNamePath[i]);
        }
    }

    private static String[] getNamePath(ResourceController<?> controller) {
        ArrayList<String> pathToRoot = new ArrayList<String>();
        ResourceController<?> current = controller;
        while (current != null) {
            pathToRoot.add(CreateCompareTableController.getDisplayName(current));
            try {
                current = current.getParent();
            }
            catch (IOException e) {
                current = null;
            }
        }
        int size = pathToRoot.size();
        String[] result = new String[size];
        for (int i = 0; i < size; ++i) {
            result[size - (i + 1)] = (String)pathToRoot.get(i);
        }
        return result;
    }

    private static String getDisplayName(ResourceController<?> controller) {
        return controller.getModel().getTitle();
    }

    public String getTag() {
        return TAG;
    }
}

