/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.model.gc;

import com.sap.jvm.profiling.controller.ResourceController;
import com.sap.jvm.profiling.controller.impl.model.AbstractTypedController;
import com.sap.jvm.profiling.controller.impl.model.gc.Elements;
import com.sap.jvm.profiling.controller.model.gc.GcController;
import com.sap.jvm.profiling.memory.event.GcStatistic;
import com.sap.jvm.profiling.memory.event.GcType;
import com.sap.jvm.profiling.presentation.typed.TypedModel;
import com.sap.jvm.profiling.presentation.typed.gc.GcTimeSeriesSelection;
import com.sap.jvm.profiling.presentation.typed.gc.elements.SelectTimeSeriesElement;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.SnapshotResourceManagerFactory;
import com.sap.jvm.profiling.snapshot.gc.GcSnapshot;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractGcController<T extends ResourceController<M>, M extends TypedModel>
extends AbstractTypedController<M>
implements GcController<T> {
    public AbstractGcController(ResourceName name, ProgressReporter reporter) throws IOException {
        super(name, reporter);
    }

    @Override
    public GcStatistic getGcInformation(long gcId) {
        ProgressReporter reporter = new ProgressReporter();
        GcStatistic result = this.getSnapshot().getGcInfo(gcId, reporter);
        reporter.finish();
        return result;
    }

    @Override
    public long getFirstGcId() {
        return this.getSnapshot().getFirstGcId();
    }

    @Override
    public long getLastGcId() {
        return this.getSnapshot().getLastGcId();
    }

    @Override
    public List<Long> getFullGcIds() {
        return this.getSnapshot().getFullGcIds();
    }

    @Override
    public List<Long> getConcGcIds() {
        return this.getSnapshot().getConcGcIds();
    }

    @Override
    public GcType getGcType() {
        return this.getSnapshot().getGcType();
    }

    protected GcSnapshot getSnapshot() {
        GcSnapshot snapshot = (GcSnapshot)SnapshotResourceManagerFactory.get(this.getSession()).getSnapshot(this.getResourceName());
        return snapshot;
    }

    protected ResourceName getSelectedTimeSeriesName(GcTimeSeriesSelection timeSeries) {
        ResourceName name = this.getBaseName();
        if (timeSeries != null) {
            Iterator it = name.iterator();
            while (it.hasNext()) {
                ResourceNameElement element = (ResourceNameElement)it.next();
                if (!(element instanceof SelectTimeSeriesElement)) continue;
                it.remove();
            }
            name = name.addElement((ResourceNameElement)new SelectTimeSeriesElement(timeSeries));
        }
        name = name.addElement((ResourceNameElement)new Elements.CreateTimeSeriesController());
        return name;
    }
}

