/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.model.gc;

import com.sap.jvm.profiling.controller.impl.ControllerImpl;
import com.sap.jvm.profiling.controller.impl.model.AbstractModelImpl;
import com.sap.jvm.profiling.controller.impl.model.gc.Elements;
import com.sap.jvm.profiling.controller.impl.trace.GcTraceImpl;
import com.sap.jvm.profiling.controller.impl.trace.ProfilingTraceImpl;
import com.sap.jvm.profiling.controller.model.gc.GcModel;
import com.sap.jvm.profiling.controller.model.gc.GcSnapshotController;
import com.sap.jvm.profiling.controller.trace.GcTraceSpec;
import com.sap.jvm.profiling.core.Bookmark;
import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.core.ProfilingTraceType;
import com.sap.jvm.profiling.core.Response;
import com.sap.jvm.profiling.core.SimpleProfilingPrintStream;
import com.sap.jvm.profiling.core.event.SnapshotMarkerHandler;
import com.sap.jvm.profiling.core.response.SnapshotMarkerResponse;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.memory.command.GcTraceConfiguration;
import com.sap.jvm.profiling.memory.event.GcEventHandler;
import com.sap.jvm.profiling.memory.event.GcStatistic;
import com.sap.jvm.profiling.memory.event.GcStatisticConcMarkSweepGc;
import com.sap.jvm.profiling.memory.event.GcStatisticG1Gc;
import com.sap.jvm.profiling.memory.event.GcType;
import com.sap.jvm.profiling.memory.response.DisableGcStatisticResponse;
import com.sap.jvm.profiling.memory.response.EnableGcStatisticResponse;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceManager;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.snapshot.SnapshotEndTag;
import com.sap.jvm.profiling.snapshot.SnapshotFactory;
import com.sap.jvm.profiling.snapshot.elements.GenericSnapshotElement;
import com.sap.jvm.profiling.snapshot.gc.Elements;
import com.sap.jvm.profiling.snapshot.gc.GcSnapshot;
import com.sap.jvm.profiling.snapshot.gc.GcSnapshotProperties;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public final class GcModelImpl
extends AbstractModelImpl<GcSnapshot>
implements GcEventHandler,
GcModel,
SnapshotMarkerHandler {
    public static final String DEFAULT_SNAPSHOT_NAME = I18n._s((String)"GC Snapshot");
    private static boolean isTest = false;
    private GcType gcType;
    private GcSnapshotProperties properties;
    private GcSnapshotProperties propertiesSinceLastSnapshotCreation;
    private long maxCollectionPediodTimestamp = Long.MIN_VALUE;
    private GcTraceConfiguration gcTraceConfig;

    public GcModelImpl(ControllerImpl controller) {
        super(ProfilingTraceType.GC_TRACE, controller);
    }

    public void handle(EnableGcStatisticResponse response) {
        this.handleEnableResponse((Response)response);
        if (response.isSuccess()) {
            this.gcTraceConfig = response.getConfiguration();
        }
    }

    public void handle(DisableGcStatisticResponse response) {
        this.handleDisableResponse((Response)response);
    }

    public boolean handle(SnapshotMarkerResponse event) {
        ProfilingTraceType type;
        boolean consumed = false;
        if (this.gcTraceConfig != null && ((type = event.getTraceType()) == ProfilingTraceType.ALL_TRACES || type == ProfilingTraceType.GC_TRACE)) {
            this.createSnapshotInternal(event.getName(), event.isDelta(), event.getCreationTimeStamp(), false);
            consumed = true;
            this.resetStateAfterSnapshotCreation();
        }
        return consumed;
    }

    public void handle(GcStatistic event) {
        if (this.trace == null) {
            this.fakeEnableResponse(event);
        }
        if (this.gcType == null) {
            this.gcType = event.getGcType();
        } else assert (this.gcType == event.getGcType() || isTest);
        if (this.properties == null) {
            this.properties = new GcSnapshotProperties(this.gcType);
        }
        if (this.propertiesSinceLastSnapshotCreation == null) {
            this.propertiesSinceLastSnapshotCreation = new GcSnapshotProperties(this.gcType);
        }
        this.properties.update(event);
        this.propertiesSinceLastSnapshotCreation.update(event);
        long id = event.getGcNr();
        this.maxCollectionPediodTimestamp = Math.max(this.maxCollectionPediodTimestamp, event.getTimestamp() + event.getDuration() / 1000L);
        if (event.isFullGc()) {
            this.updateStatisticsFull(event.getDuration(), id);
        } else {
            GcStatisticG1Gc g1gc;
            GcStatisticConcMarkSweepGc cms;
            if (this.gcType == GcType.CONC_MARK_SWEEP_GC && (cms = (GcStatisticConcMarkSweepGc)event).isConcurrent()) {
                this.updateStatisticsConc(cms.getDuration(), cms.getMaxStopTheWorldDuration(), id);
                return;
            }
            if (this.gcType == GcType.GARBAGE_FIRST_GC && (g1gc = (GcStatisticG1Gc)event).isConcurrent()) {
                this.updateStatisticsConc(g1gc.getDuration(), g1gc.getMaxStopTheWorldDuration(), id);
                return;
            }
            this.updateStatisticsYoung(event.getDuration());
        }
    }

    private void fakeEnableResponse(final GcStatistic event) {
        EnableGcStatisticResponse response = new EnableGcStatisticResponse(){
            String name = "fake enable GC statistic response";

            public long getId() {
                return 0L;
            }

            public long getTime() {
                return event.getTimestamp() - 1L;
            }

            public boolean isSuccess() {
                return true;
            }

            public String getErrorMessage() {
                return null;
            }

            public ProfilingPacketType getType() {
                return ProfilingPacketType.ENABLE_GC_STATISTIC_RESPONSE;
            }

            public String getPacketName() {
                return this.name;
            }

            public void print(PrintStream stream) {
                SimpleProfilingPrintStream sps = new SimpleProfilingPrintStream((OutputStream)stream);
                this.print((ProfilingPrintStream)sps);
                sps.flush();
            }

            public void print(ProfilingPrintStream stream) {
                stream.println(this.name);
                stream.println("Use exact values: " + this.isExact());
            }

            public boolean isExact() {
                return false;
            }

            public GcTraceConfiguration getConfiguration() {
                GcTraceConfiguration config = new GcTraceConfiguration();
                config.setExact(this.isExact());
                return config;
            }
        };
        this.handle(response);
    }

    @Override
    public GcSnapshotController getSnapshotController(GcSnapshot snapshot) {
        ResourceName name = snapshot.asResourceName().addElement((ResourceNameElement)new Elements.CreateGcSnapshotController());
        ResourceManager manager = name.getResourceManager();
        GcSnapshotController result = null;
        ProgressReporter reporter = new ProgressReporter();
        try {
            result = (GcSnapshotController)manager.get(name, reporter);
        }
        catch (IOException e) {
            Trace.error((Throwable)e);
        }
        reporter.finish();
        return result;
    }

    @Override
    public synchronized void createSnapshotInternal(boolean delta, long endCollectionTimeStamp, boolean stop) {
        if (this.gcTraceConfig == null) {
            return;
        }
        if (!this.controller.getHeartBeatInfo().isDataReceived() || this.controller.usesChunkedFile()) {
            super.createSnapshotInternal(delta, Math.max(endCollectionTimeStamp, this.maxCollectionPediodTimestamp), stop);
        }
        if (stop) {
            this.gcTraceConfig = null;
        }
        this.resetStateAfterSnapshotCreation();
    }

    @Override
    protected String getDefaultSnapshotName() {
        return DEFAULT_SNAPSHOT_NAME;
    }

    @Override
    protected ProfilingTraceImpl createTrace(Response response) {
        GcTraceConfiguration config = null;
        if (response instanceof EnableGcStatisticResponse) {
            config = ((EnableGcStatisticResponse)response).getConfiguration();
        } else assert (false);
        GcTraceSpec spec = this.createSpecification(config);
        return new GcTraceImpl("GC Trace", spec, this.controller.getProfilingSession());
    }

    @Override
    protected Snapshot createSnapshot(int snapshotId, String name, Bookmark startBookmark, Bookmark endBookmark, long startTimestamp, long endTimestamp, boolean isVirtual, boolean isDelta, Snapshot parentSnapshot) {
        GcSnapshotProperties props;
        if (this.snapshotFactory == null) {
            this.snapshotFactory = SnapshotFactory.get(this.controller.getProfilingSession());
        }
        Elements.GcSnapshotElement snapshotElement = new Elements.GcSnapshotElement(snapshotId);
        ResourceName resourceName = this.controller.getProfilingSession().getResourceManager().createResourceName((ResourceNameElement)snapshotElement);
        resourceName = resourceName.addElement((ResourceNameElement)new SnapshotEndTag());
        GcSnapshotProperties gcSnapshotProperties = props = isDelta ? this.propertiesSinceLastSnapshotCreation : this.properties;
        if (props == null) {
            props = new GcSnapshotProperties(this.gcType);
            props.update(null);
        }
        return this.snapshotFactory.createGcSnapshot(snapshotId, resourceName, name, startBookmark, endBookmark, this.gcTraceConfig, props, startTimestamp, endTimestamp, isVirtual, (GcSnapshot)parentSnapshot);
    }

    @Override
    protected void resetCollectionState() {
        this.gcType = null;
        this.properties = null;
        this.resetStateAfterSnapshotCreation();
        this.startTimeStamp = 0L;
        this.lastSnapshotEndTimeStamp = -1L;
        this.gcTraceConfig = null;
    }

    private void resetStateAfterSnapshotCreation() {
        this.propertiesSinceLastSnapshotCreation = this.gcType == null ? null : new GcSnapshotProperties(this.gcType);
    }

    private GcTraceSpec createSpecification(GcTraceConfiguration config) {
        GcTraceSpec spec = new GcTraceSpec();
        return spec;
    }

    private void updateStatisticsFull(long durationToAdd, long gcId) {
        GcTraceImpl gcTrace = (GcTraceImpl)this.trace;
        gcTrace.setNrGcsFull(gcTrace.getNrOfGcsFull() + 1L);
        gcTrace.setDurationFull(gcTrace.getDurationFull() + durationToAdd);
        gcTrace.setMaxDurationFull(Math.max(gcTrace.getMaxDurationFull(), durationToAdd));
    }

    private void updateStatisticsYoung(long durationToAdd) {
        GcTraceImpl gcTrace = (GcTraceImpl)this.trace;
        gcTrace.setNrGcsYoung(gcTrace.getNrOfGcsYoung() + 1L);
        gcTrace.setDurationYoung(gcTrace.getDurationYoung() + durationToAdd);
        gcTrace.setMaxDurationYoung(Math.max(gcTrace.getMaxDurationYoung(), durationToAdd));
    }

    private void updateStatisticsConc(long durationToAdd, long maxPause, long gcId) {
        GcTraceImpl gcTrace = (GcTraceImpl)this.trace;
        gcTrace.setNrGcsConc(gcTrace.getNrOfGcsConc() + 1L);
        gcTrace.setDurationConc(gcTrace.getDurationConc() + durationToAdd);
        gcTrace.setMaxDurationConc(Math.max(gcTrace.getMaxDurationConc(), maxPause));
    }

    public static void enableTestMode() {
        isTest = true;
        GcSnapshotProperties.enableTestMode();
    }

    @Override
    protected GenericSnapshotElement createSnapshotElement(int id) {
        return new Elements.GcSnapshotElement(id);
    }

    @Override
    protected Snapshot createSnapshot(SnapshotFactory factory, int id, ResourceName resourceName, String name, Snapshot parent, boolean isVirtual, ProgressReporter reporter) throws IOException {
        return factory.createGcSnapshot(id, resourceName, name, (GcSnapshot)parent, isVirtual, reporter);
    }
}

