/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.model.gc;

import com.sap.jvm.profiling.controller.ResourceController;
import com.sap.jvm.profiling.controller.impl.model.ResourceControllerUtils;
import com.sap.jvm.profiling.controller.impl.model.gc.AbstractGcController;
import com.sap.jvm.profiling.controller.impl.model.gc.Elements;
import com.sap.jvm.profiling.controller.model.gc.GcReportController;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.typed.Elements;
import com.sap.jvm.profiling.presentation.typed.TypedReportModel;
import com.sap.jvm.profiling.presentation.typed.gc.Elements;
import com.sap.jvm.profiling.presentation.typed.gc.GcEventAttribute;
import com.sap.jvm.profiling.presentation.typed.gc.GcTimeSeriesSelection;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.elements.FilterByGcId;
import com.sap.jvm.profiling.snapshot.elements.FilterByGcPromotionFailures;
import com.sap.jvm.profiling.viewer.report.ReportLinkResolver;
import java.io.IOException;

public final class GcReportControllerImpl
extends AbstractGcController<GcReportController, TypedReportModel>
implements GcReportController {
    public GcReportControllerImpl(ResourceName name, ProgressReporter reporter) throws IOException {
        super(name, reporter);
        this.initModel();
    }

    @Override
    public long[] getSelectedGcIds() {
        return new long[0];
    }

    @Override
    public void createSnapshot(ProgressReporter reporter) throws IOException {
    }

    protected void initModel() {
        TypedReportModel reportModel = (TypedReportModel)this.getModel();
        reportModel.addLinkLocation("gc_report_system_load_timeseries", this.getSystemLoadTimeSeriesName());
        reportModel.addLinkLocation("gc_report_conc_gc_timeseries", this.getConcGcTimeSeriesName());
        reportModel.addLinkLocation("gc_report_gc_statistic_promotion_failures", this.getGcStatisticPromotionFailuresName());
        reportModel.setLinkResolver("gc_report_gc_statistic", new ReportLinkResolver(){

            @Override
            public ResourceName getResourceName(String location, String options) {
                if (options != null) {
                    long[] gcIds = GcReportControllerImpl.this.getLongsFromOptions(options);
                    return GcReportControllerImpl.this.getGcStatisticFilteredName(gcIds);
                }
                return GcReportControllerImpl.this.getGcStatisticName();
            }
        });
    }

    @Override
    protected ResourceName getModelName() {
        ResourceNameElement createElement = this.getResourceName().getLastElement();
        boolean justConfiguration = createElement instanceof Elements.CreateGcConfigurationReportController;
        return this.getBaseName().addElement((ResourceNameElement)(justConfiguration ? new Elements.CreateGcConfigurationReportProvider() : new Elements.CreateGcReportProvider())).addElement((ResourceNameElement)new Elements.CreateTypedReportModel());
    }

    protected ResourceName getSystemLoadTimeSeriesName() {
        GcTimeSeriesSelection loadTimeSeries = new GcTimeSeriesSelection();
        loadTimeSeries.addArea(GcEventAttribute.SYSTEM_LOAD_AVERAGE.getShortDescription(this.getResourceName().getSession()), new int[]{704, 705, 706, 707});
        return this.getSelectedTimeSeriesName(loadTimeSeries);
    }

    protected ResourceName getConcGcTimeSeriesName() {
        GcTimeSeriesSelection loadTimeSeries = new GcTimeSeriesSelection();
        loadTimeSeries.addArea(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Concurrent GCs and GC Duration"), new int[]{1, 701});
        return this.getSelectedTimeSeriesName(loadTimeSeries);
    }

    protected ResourceName getGcStatisticName() {
        return this.getResourceNameImpl(new ResourceNameElement[]{new Elements.CreateGcValueStatisticController()});
    }

    protected ResourceName getGcStatisticPromotionFailuresName() {
        return this.getResourceNameImpl(new ResourceNameElement[]{new FilterByGcPromotionFailures(), new Elements.CreateGcValueStatisticController()});
    }

    protected ResourceName getGcStatisticFilteredName(long[] ids) {
        return this.getResourceNameImpl(new ResourceNameElement[]{new FilterByGcId(ids), new Elements.CreateGcValueStatisticController()});
    }

    private ResourceName getResourceNameImpl(ResourceNameElement ... toAdd) {
        ResourceName parent = this.getResourceName();
        ResourceName result = parent.stripLastElement();
        for (ResourceNameElement element : toAdd) {
            result = result.addElement(element);
        }
        return result;
    }

    @Override
    public ResourceController<TypedReportModel> getResourceController(ResourceName name) throws IOException {
        return ResourceControllerUtils.getResourceController(this.getResourceName(), name);
    }

    private long[] getLongsFromOptions(String options) {
        String[] ids = options.split(",");
        long[] gcIds = new long[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            gcIds[i] = Long.parseLong(ids[i]);
        }
        return gcIds;
    }
}

