/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.model.gc;

import com.sap.jvm.profiling.controller.ResourceController;
import com.sap.jvm.profiling.controller.impl.model.AbstractSnapshotController;
import com.sap.jvm.profiling.controller.impl.model.ResourceControllerUtils;
import com.sap.jvm.profiling.controller.impl.model.gc.Elements;
import com.sap.jvm.profiling.controller.impl.model.gc.GcEventValueStatisticControllerImpl;
import com.sap.jvm.profiling.controller.impl.model.gc.GcTimeSeriesControllerImpl;
import com.sap.jvm.profiling.controller.impl.model.gc.GcValueStatisticControllerImpl;
import com.sap.jvm.profiling.controller.model.gc.GcEventValueStatisticController;
import com.sap.jvm.profiling.controller.model.gc.GcReportController;
import com.sap.jvm.profiling.controller.model.gc.GcSnapshotController;
import com.sap.jvm.profiling.controller.model.gc.GcTimeSeriesController;
import com.sap.jvm.profiling.controller.model.gc.GcValueStatisticController;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.memory.event.GcEventType;
import com.sap.jvm.profiling.presentation.typed.gc.GcEventAttributeGroup;
import com.sap.jvm.profiling.presentation.typed.gc.GcTimeSeriesSelection;
import com.sap.jvm.profiling.presentation.typed.gc.elements.SelectTimeSeriesElement;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.elements.FilterByGcEventType;
import com.sap.jvm.profiling.snapshot.elements.GcEventColumnsElement;
import com.sap.jvm.profiling.snapshot.gc.GcEventStatisticValueElement;
import com.sap.jvm.profiling.snapshot.gc.GcSnapshot;
import com.sap.jvm.profiling.snapshot.gc.GcStatisticValueElement;
import com.sap.jvm.profiling.snapshot.gc.StatisticValueElement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class GcSnapshotControllerImpl
extends AbstractSnapshotController<GcSnapshot>
implements GcSnapshotController {
    private final GcSnapshot snapshot;

    GcSnapshotControllerImpl(GcSnapshot snapshot) {
        super(snapshot.asResourceName().addElement((ResourceNameElement)new Elements.CreateGcSnapshotController()));
        this.snapshot = snapshot;
    }

    @Override
    public void close() {
    }

    @Override
    public GcSnapshot getSnapshot() {
        return this.snapshot;
    }

    @Override
    public GcValueStatisticController getGcStatisticController() throws IOException {
        return (GcValueStatisticControllerImpl)this.getResourceControllerImpl(new ResourceNameElement[]{new Elements.CreateGcValueStatisticController()});
    }

    @Override
    public GcReportController getGcReportController() throws IOException {
        return (GcReportController)this.getResourceControllerImpl(new ResourceNameElement[]{new Elements.CreateGcReportController()});
    }

    @Override
    public GcReportController getGcConfigurationReportController() throws IOException {
        return (GcReportController)this.getResourceControllerImpl(new ResourceNameElement[]{new Elements.CreateGcConfigurationReportController()});
    }

    @Override
    public GcEventValueStatisticController getRefHandlingEventStatisticController() throws IOException {
        Set<GcEventType> eventTypes = this.getRefHandlingEventTypes();
        List<GcEventStatisticValueElement> valueElements = GcEventAttributeGroup.getGroupForReferenceHandling(this.snapshot.getSession(), this.snapshot.getGcType()).getValueElements();
        StatisticValueElement[] defaultVisible = new StatisticValueElement[]{GcStatisticValueElement.GC_TYPE, GcStatisticValueElement.GC_CAUSE, GcEventStatisticValueElement.EVENT_TYPE, GcEventStatisticValueElement.TIME_STAMP, GcEventStatisticValueElement.DURATION, GcEventStatisticValueElement.CPU_TIME, GcEventStatisticValueElement.PAGE_FAULTS, GcEventStatisticValueElement.SOFT_REFERENCES_FOUND, GcEventStatisticValueElement.SOFT_REFERENCES_CLEARED, GcEventStatisticValueElement.SOFT_REFERENCE_HANDLING_DURATION, GcEventStatisticValueElement.WEAK_REFERENCES_FOUND, GcEventStatisticValueElement.WEAK_REFERENCES_CLEARED, GcEventStatisticValueElement.WEAK_REFERENCE_HANDLING_DURATION, GcEventStatisticValueElement.FINAL_REFERENCES_FOUND, GcEventStatisticValueElement.FINAL_REFERENCE_HANDLING_DURATION, GcEventStatisticValueElement.PHANTOM_REFERENCE_HANDLING_DURATION, GcEventStatisticValueElement.JNIWEAK_REFERENCE_HANDLING_DURATION, GcEventStatisticValueElement.TRANSITION_TO_SINGLE_THREADING_DURATION};
        return this.getGcEventValueStatisticController(I18n._ts((I18n.TextType)I18n.TextType.XTBS, (String)"Reference Handling Events"), false, eventTypes, valueElements, this.getColomnTags(defaultVisible));
    }

    @Override
    public GcEventValueStatisticController getGenerationalGcEventStatisticController() throws IOException {
        Set<GcEventType> eventTypes = this.getGenerationalEventTypes();
        List<GcEventStatisticValueElement> valueElements = GcEventAttributeGroup.getGroupForGenerationalEvents(this.snapshot.getSession(), this.snapshot.getGcType()).getValueElements();
        StatisticValueElement[] defaultVisible = new StatisticValueElement[]{GcStatisticValueElement.GC_TYPE, GcStatisticValueElement.GC_CAUSE, GcEventStatisticValueElement.EVENT_TYPE, GcEventStatisticValueElement.TIME_STAMP, GcEventStatisticValueElement.DURATION, GcEventStatisticValueElement.CPU_TIME, GcEventStatisticValueElement.PAGE_FAULTS, GcEventStatisticValueElement.BYTES_IN_EDEN_BEFORE_AND_AFTER, GcEventStatisticValueElement.BYTES_IN_FROM_BEFORE_AND_AFTER, GcEventStatisticValueElement.BYTES_IN_YOUNG_BEFORE_AND_AFTER, GcEventStatisticValueElement.BYTES_IN_OLD_BEFORE_AND_AFTER, GcEventStatisticValueElement.SYSTEM_LOAD_AVERAGE};
        return this.getGcEventValueStatisticController(I18n._ts((I18n.TextType)I18n.TextType.XTBS, (String)"Generational Events"), false, eventTypes, valueElements, this.getColomnTags(defaultVisible));
    }

    @Override
    public GcEventValueStatisticController getCustomGCEventValueStatisticController(Set<GcEventType> eventTypes, List<String> defaultVisibleColumnTags) throws IOException {
        ArrayList<GcEventStatisticValueElement> valueElements = this.getElementsForEventTypes(eventTypes);
        return this.getGcEventValueStatisticController(I18n._ts((I18n.TextType)I18n.TextType.XTBS, (String)"GC Events"), true, eventTypes, valueElements, defaultVisibleColumnTags);
    }

    private Set<GcEventType> getGenerationalEventTypes() {
        HashSet<GcEventType> typesForGc = new HashSet<GcEventType>(Arrays.asList(GcEventAttributeGroup.getEventTypes(this.getSnapshot().getGcType())));
        HashSet<GcEventType> generationalEvents = new HashSet<GcEventType>();
        generationalEvents.add(GcEventType.G1_INCREMENTAL_GC);
        generationalEvents.add(GcEventType.G1_MARK_SWEEP_GC);
        generationalEvents.add(GcEventType.PARALLEL_GC_MARK_SWEEP);
        generationalEvents.add(GcEventType.PARALLEL_GC_PARALLEL_COMPACT);
        generationalEvents.add(GcEventType.PARALLEL_GC_SCAVENGE);
        generationalEvents.add(GcEventType.PARALLEL_NEW_GC);
        generationalEvents.add(GcEventType.SERIAL_NEW_GC);
        generationalEvents.add(GcEventType.TENURED_GC);
        generationalEvents.retainAll(typesForGc);
        return generationalEvents;
    }

    private Set<GcEventType> getRefHandlingEventTypes() {
        HashSet<GcEventType> typesForGc = new HashSet<GcEventType>(Arrays.asList(GcEventAttributeGroup.getEventTypes(this.getSnapshot().getGcType())));
        HashSet<GcEventType> refHandling = new HashSet<GcEventType>();
        refHandling.add(GcEventType.ALL_GEN_REF_HANDLING);
        refHandling.add(GcEventType.OLD_GEN_REF_HANDLING);
        refHandling.add(GcEventType.PARTIAL_REF_HANDLING);
        refHandling.add(GcEventType.YOUNG_GEN_REF_HANDLING);
        refHandling.retainAll(typesForGc);
        return refHandling;
    }

    private GcEventValueStatisticController getGcEventValueStatisticController(String name, boolean custom, Set<GcEventType> eventTypes, List<GcEventStatisticValueElement> valueElements, List<String> defaultVisibleColumnTags) throws IOException {
        FilterByGcEventType filterElement = new FilterByGcEventType(eventTypes, name, custom);
        GcEventColumnsElement columnsElement = new GcEventColumnsElement(valueElements, defaultVisibleColumnTags);
        return (GcEventValueStatisticControllerImpl)this.getResourceControllerImpl(new ResourceNameElement[]{filterElement, columnsElement, new Elements.CreateGcEventValueStatisticController()});
    }

    private List<String> getColomnTags(StatisticValueElement[] elements) {
        ArrayList<String> defaultVisibleColumnTags = new ArrayList<String>(elements.length);
        for (StatisticValueElement element : elements) {
            defaultVisibleColumnTags.add(element.getColumnTag());
        }
        return defaultVisibleColumnTags;
    }

    private ArrayList<GcEventStatisticValueElement> getElementsForEventTypes(Set<GcEventType> eventTypes) {
        LinkedHashSet<GcEventStatisticValueElement> intersection = new LinkedHashSet<GcEventStatisticValueElement>();
        boolean first = true;
        for (GcEventType type : eventTypes) {
            List<GcEventStatisticValueElement> elements = GcEventAttributeGroup.getGroup(type, this.snapshot.getSession(), this.snapshot.getGcType()).getValueElements();
            if (first) {
                intersection.addAll(elements);
                first = false;
                continue;
            }
            intersection.retainAll(elements);
        }
        ArrayList<GcEventStatisticValueElement> result = new ArrayList<GcEventStatisticValueElement>(intersection);
        return result;
    }

    @Override
    public GcTimeSeriesController getTimeSeriesController() throws IOException {
        return (GcTimeSeriesControllerImpl)this.getResourceControllerImpl(new ResourceNameElement[]{new Elements.CreateTimeSeriesController()});
    }

    @Override
    public GcTimeSeriesController getTimeSeriesController(GcTimeSeriesSelection slection) throws IOException {
        ResourceName parent = this.getResourceName();
        ResourceName tmpName = parent.stripLastElement();
        tmpName = tmpName.addElement((ResourceNameElement)new SelectTimeSeriesElement(slection));
        tmpName = tmpName.addElement((ResourceNameElement)new Elements.CreateTimeSeriesController());
        return (GcTimeSeriesControllerImpl)ResourceControllerUtils.getResourceController(parent, tmpName);
    }

    private ResourceController<?> getResourceControllerImpl(ResourceNameElement ... toAdd) throws IOException {
        ResourceName parent = this.getResourceName();
        ResourceName tmpName = parent.stripLastElement();
        for (ResourceNameElement element : toAdd) {
            tmpName = tmpName.addElement(element);
        }
        return ResourceControllerUtils.getResourceController(parent, tmpName);
    }
}

