/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.model.gc;

import com.sap.jvm.profiling.controller.impl.model.ResourceControllerUtils;
import com.sap.jvm.profiling.controller.impl.model.gc.AbstractGcController;
import com.sap.jvm.profiling.controller.impl.model.gc.Elements;
import com.sap.jvm.profiling.controller.model.gc.GcTimeSeriesController;
import com.sap.jvm.profiling.controller.model.gc.GcValueStatisticController;
import com.sap.jvm.profiling.core.event.SystemInfo;
import com.sap.jvm.profiling.presentation.typed.Elements;
import com.sap.jvm.profiling.presentation.typed.TypedTimeSeriesModel;
import com.sap.jvm.profiling.presentation.typed.gc.Elements;
import com.sap.jvm.profiling.presentation.typed.gc.GcTimeSeriesSelection;
import com.sap.jvm.profiling.presentation.typed.gc.elements.SelectTimeSeriesElement;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.SnapshotResourceManager;
import com.sap.jvm.profiling.snapshot.SnapshotResourceManagerFactory;
import com.sap.jvm.profiling.snapshot.SnapshotType;
import com.sap.jvm.profiling.snapshot.gc.GcSnapshot;
import com.sap.jvm.util.pair.LongPair;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class GcTimeSeriesControllerImpl
extends AbstractGcController<GcTimeSeriesController, TypedTimeSeriesModel>
implements GcTimeSeriesController {
    public GcTimeSeriesControllerImpl(ResourceName name, ProgressReporter reporter) throws IOException {
        super(name, reporter);
    }

    @Override
    protected ResourceName getModelName() {
        return this.getBaseName().addElement((ResourceNameElement)new Elements.CreateTimeSeriesProvider()).addElement((ResourceNameElement)new Elements.CreateTypedTimeSeriesModel());
    }

    @Override
    public GcTimeSeriesSelection getTimeSeriesSelection(boolean onlyVisible) {
        GcTimeSeriesSelection selection = this.getTimeSeriesSelection();
        GcTimeSeriesSelection result = new GcTimeSeriesSelection();
        HashSet<String> visibility = new HashSet<String>(Arrays.asList(((TypedTimeSeriesModel)this.getModel()).getVisibilitySet()));
        List<GcTimeSeriesSelection.Area> areas = selection.getAreas();
        for (int groupIdx = 0; groupIdx < areas.size(); ++groupIdx) {
            GcTimeSeriesSelection.Area group = areas.get(groupIdx);
            if (onlyVisible && !visibility.contains(group.getTag())) continue;
            result.addArea(group.getTitle(), group.getTimeSeries());
        }
        return result;
    }

    private GcTimeSeriesSelection getTimeSeriesSelection() {
        ResourceNameElement element = this.getResourceName().stripLastElement().getLastElement();
        if (element instanceof SelectTimeSeriesElement) {
            SelectTimeSeriesElement selectElement = (SelectTimeSeriesElement)element;
            return selectElement.getSelection();
        }
        return GcTimeSeriesSelection.getDefault();
    }

    @Override
    public long[] getSelectedGcIds() {
        LongPair selectionRange = this.getSelectedGcRange();
        if (selectionRange == null) {
            return new long[0];
        }
        long first = selectionRange.getFirst();
        long second = selectionRange.getSecond();
        int size = (int)(second - first);
        long[] result = new long[size];
        for (int i = 0; i < size; ++i) {
            result[i] = first + (long)i;
        }
        return result;
    }

    private LongPair getSelectedGcRange() {
        TypedTimeSeriesModel model = (TypedTimeSeriesModel)this.getModel();
        if (!model.hasSelection()) {
            return null;
        }
        GcSnapshot snapshot = (GcSnapshot)SnapshotResourceManagerFactory.get(this.getSession()).getSnapshot(this.getResourceName());
        long startTimeStamp = model.getSelectedStartTimeStamp();
        long endTimeStamp = model.getSelectedEndTimeStamp();
        SystemInfo info = this.getResourceName().getSession().getSystemInfo();
        startTimeStamp = info.getTimeMillis() + startTimeStamp / 1000L;
        endTimeStamp = info.getTimeMillis() + endTimeStamp / 1000L;
        return snapshot.getGcAccessor().getGcRangeIds(startTimeStamp, endTimeStamp);
    }

    @Override
    public GcValueStatisticController getSelectedGcStatistic() throws IOException {
        ResourceName selectedName = GcTimeSeriesControllerImpl.narrowSnapshot((TypedTimeSeriesModel)this.getModel(), this.getBaseName());
        ResourceName parent = this.getResourceName();
        ResourceName name = selectedName.addElement((ResourceNameElement)new Elements.CreateGcValueStatisticController());
        return (GcValueStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    @Override
    public GcTimeSeriesController getSelectedTimeSeriesController() throws IOException {
        ResourceName selectedName = GcTimeSeriesControllerImpl.narrowSnapshot((TypedTimeSeriesModel)this.getModel(), this.getBaseName());
        ResourceName parent = this.getResourceName();
        ResourceName name = selectedName.addElement((ResourceNameElement)new Elements.CreateTimeSeriesController());
        return (GcTimeSeriesController)ResourceControllerUtils.getResourceController(parent, name);
    }

    @Override
    public GcTimeSeriesController getSelectedTimeSeriesController(GcTimeSeriesSelection timeSeries) throws IOException {
        ResourceName parent = this.getParentName();
        ResourceName name = this.getSelectedTimeSeriesName(timeSeries);
        return (GcTimeSeriesController)ResourceControllerUtils.getResourceController(parent, name);
    }

    @Override
    public void createSnapshot(ProgressReporter reporter) throws IOException {
        ResourceName selectedName = GcTimeSeriesControllerImpl.narrowSnapshot((TypedTimeSeriesModel)this.getModel(), this.getBaseName());
        ResourceName parent = this.getResourceName();
        SnapshotResourceManager manager = SnapshotResourceManagerFactory.get(this.getSession());
        manager.createSnapshot(SnapshotType.GC_SNAPSHOT, null, selectedName, parent, reporter);
    }
}

