/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.model.hprof;

import com.sap.jvm.profiling.controller.impl.ControllerImpl;
import com.sap.jvm.profiling.controller.impl.model.AbstractModelImpl;
import com.sap.jvm.profiling.controller.impl.model.alloc.AllocationModelImpl;
import com.sap.jvm.profiling.controller.impl.model.hprof.Elements;
import com.sap.jvm.profiling.controller.impl.trace.HprofDumpTraceImpl;
import com.sap.jvm.profiling.controller.impl.trace.ProfilingTraceImpl;
import com.sap.jvm.profiling.controller.model.hprof.HprofDumpModel;
import com.sap.jvm.profiling.controller.model.hprof.HprofDumpSnapshotController;
import com.sap.jvm.profiling.core.Bookmark;
import com.sap.jvm.profiling.core.ProfilingTraceType;
import com.sap.jvm.profiling.core.Response;
import com.sap.jvm.profiling.core.event.SnapshotMarkerHandler;
import com.sap.jvm.profiling.core.response.SnapshotMarkerResponse;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.memory.command.AllocationTraceConfiguration;
import com.sap.jvm.profiling.memory.command.AllocationTraceType;
import com.sap.jvm.profiling.memory.event.HprofDumpEnd;
import com.sap.jvm.profiling.memory.event.HprofDumpEventHandler;
import com.sap.jvm.profiling.memory.event.HprofDumpSeek;
import com.sap.jvm.profiling.memory.event.HprofDumpStart;
import com.sap.jvm.profiling.memory.event.HprofDumpWrite;
import com.sap.jvm.profiling.memory.event.HprofDumpWriteAddon;
import com.sap.jvm.profiling.memory.response.HprofDumpResponse;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceManager;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.snapshot.SnapshotEndTag;
import com.sap.jvm.profiling.snapshot.SnapshotFactory;
import com.sap.jvm.profiling.snapshot.elements.GenericSnapshotElement;
import com.sap.jvm.profiling.snapshot.hprof.Elements;
import com.sap.jvm.profiling.snapshot.hprof.HprofDumpProperties;
import com.sap.jvm.profiling.snapshot.hprof.HprofDumpSnapshot;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;

public final class HprofDumpModelImpl
extends AbstractModelImpl<HprofDumpSnapshot>
implements HprofDumpEventHandler,
HprofDumpModel,
SnapshotMarkerHandler {
    public static final String DEFAULT_SNAPSHOT_NAME = I18n._s((String)"Heap Dump");
    private HprofDumpProperties properties;
    private HprofDumpStart lastStart;

    public HprofDumpModelImpl(ControllerImpl controller) {
        super(ProfilingTraceType.HPROF_DUMP, controller);
    }

    @Override
    public HprofDumpSnapshotController getSnapshotController(HprofDumpSnapshot snapshot) {
        ResourceName name = snapshot.asResourceName().addElement((ResourceNameElement)new Elements.CreateHprofDumpSnapshotController());
        ResourceManager manager = name.getResourceManager();
        HprofDumpSnapshotController result = null;
        ProgressReporter reporter = new ProgressReporter();
        try {
            result = (HprofDumpSnapshotController)manager.get(name, reporter);
        }
        catch (IOException e) {
            Trace.error((Throwable)e);
        }
        reporter.finish();
        return result;
    }

    @Override
    protected String getDefaultSnapshotName() {
        return DEFAULT_SNAPSHOT_NAME;
    }

    @Override
    protected ProfilingTraceImpl createTrace(Response response) {
        HprofDumpProperties props = new HprofDumpProperties((HprofDumpResponse)response);
        return new HprofDumpTraceImpl("Heap Dump", props, props.forceGcRequested(), this.controller.getProfilingSession());
    }

    @Override
    protected Snapshot createSnapshot(int snapshotId, String name, Bookmark startBookmark, Bookmark endBookmark, long startTimestamp, long endTimestamp, boolean isVirtual, boolean isDelta, Snapshot parentSnapshot) {
        if (this.snapshotFactory == null) {
            this.snapshotFactory = SnapshotFactory.get(this.controller.getProfilingSession());
        }
        Elements.HprofDumpSnapshotElement snapshotElement = new Elements.HprofDumpSnapshotElement(snapshotId);
        ResourceName resourceName = this.controller.getProfilingSession().getResourceManager().createResourceName((ResourceNameElement)snapshotElement);
        resourceName = resourceName.addElement((ResourceNameElement)new SnapshotEndTag());
        return this.snapshotFactory.createHprofDumpSnapshot(snapshotId, resourceName, name, startBookmark, endBookmark, this.properties, startTimestamp, endTimestamp, isVirtual);
    }

    public boolean handle(SnapshotMarkerResponse event) {
        return false;
    }

    public void handle(HprofDumpResponse response) {
        this.handleEnableResponse((Response)response);
        if (this.trace != null) {
            this.properties = new HprofDumpProperties(response);
            ((HprofDumpTraceImpl)this.trace).setProperties(this.properties);
        }
    }

    public void handle(HprofDumpStart event) {
        this.lastStart = event;
    }

    public void handle(HprofDumpEnd event) {
        AllocationTraceConfiguration config;
        this.properties = new HprofDumpProperties(this.lastStart, event);
        ((HprofDumpTraceImpl)this.trace).setProperties(this.properties);
        Snapshot snp = this.createSnapshotInternal(this.lastStart.getName(), false, event.getEndTime(), true);
        AllocationModelImpl allocModel = this.controller.getModelController().getAllocationModel();
        if (snp != null && allocModel != null && (config = allocModel.getConfig()) != null && config.getType() == AllocationTraceType.WITH_OBJECT_IDS) {
            String name = I18n._ss((String)"Name for an associated allocation snapshot for a hprof dump", (String)"Associated Allocations");
            HprofDumpSnapshotController snpController = this.getSnapshotController((HprofDumpSnapshot)snp);
            allocModel.createSnapshotWithParent(snpController.getResourceName(), name, event.getEndTime(), false);
        }
    }

    public void handle(HprofDumpWrite event) {
        long size = event.getWrittenBytes();
        long nrOfObjects = event.getDumpedObjects();
        ((HprofDumpTraceImpl)this.trace).getProperties().setSize(size);
        ((HprofDumpTraceImpl)this.trace).getProperties().setNrOfObjects(nrOfObjects);
    }

    public void handle(HprofDumpWriteAddon event) {
        long addonSize = event.getWrittenBytes();
        ((HprofDumpTraceImpl)this.trace).getProperties().setAddonSize(addonSize);
    }

    public void handle(HprofDumpSeek event) {
    }

    @Override
    protected void resetCollectionState() {
    }

    @Override
    protected GenericSnapshotElement createSnapshotElement(int id) {
        return new Elements.HprofDumpSnapshotElement(id);
    }

    @Override
    protected Snapshot createSnapshot(SnapshotFactory factory, int id, ResourceName resourceName, String name, Snapshot parent, boolean isVirtual, ProgressReporter reporter) throws IOException {
        throw new UnsupportedOperationException();
    }
}

