/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.model.hprof;

import com.sap.jvm.profiling.controller.impl.model.AbstractSnapshotController;
import com.sap.jvm.profiling.controller.impl.model.ResourceControllerUtils;
import com.sap.jvm.profiling.controller.impl.model.alloc.CalledUtils;
import com.sap.jvm.profiling.controller.impl.model.hprof.Elements;
import com.sap.jvm.profiling.controller.model.alloc.AllocationSnapshotController;
import com.sap.jvm.profiling.controller.model.hprof.HprofDumpSnapshotController;
import com.sap.jvm.profiling.controller.model.hprof.MatController;
import com.sap.jvm.profiling.core.ProfilingPacket;
import com.sap.jvm.profiling.core.ProfilingReader;
import com.sap.jvm.profiling.memory.event.HprofDumpEnd;
import com.sap.jvm.profiling.memory.event.HprofDumpSeek;
import com.sap.jvm.profiling.memory.event.HprofDumpStart;
import com.sap.jvm.profiling.memory.event.HprofDumpWrite;
import com.sap.jvm.profiling.memory.event.HprofDumpWriteAddon;
import com.sap.jvm.profiling.presentation.typed.TypedModel;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.alloc.AllocationSnapshot;
import com.sap.jvm.profiling.snapshot.alloc.elements.FilterAllocationById;
import com.sap.jvm.profiling.snapshot.hprof.HprofDumpProperties;
import com.sap.jvm.profiling.snapshot.hprof.HprofDumpSnapshot;
import com.sap.jvm.profiling.snapshot.util.IdHashSet;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class HprofDumpSnapshotControllerImpl
extends AbstractSnapshotController<HprofDumpSnapshot>
implements HprofDumpSnapshotController {
    private final HprofDumpSnapshot snapshot;

    HprofDumpSnapshotControllerImpl(HprofDumpSnapshot snapshot) {
        super(snapshot.asResourceName().addElement((ResourceNameElement)new Elements.CreateHprofDumpSnapshotController()));
        this.snapshot = snapshot;
    }

    @Override
    public HprofDumpSnapshot getSnapshot() {
        return this.snapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportToHprofFile(File hprofFileName, File addonsFileName, ProgressReporter reporter) throws IOException {
        ProfilingReader reader = this.snapshot.getEventReader(reporter);
        HprofDumpProperties props = this.snapshot.getProperties();
        reporter.setWork("Writing hprof dump", props.getSize() + props.getAddonSize());
        if (hprofFileName.exists()) {
            hprofFileName.delete();
        }
        RandomAccessFile hprofFile = null;
        RandomAccessFile addonsFile = null;
        ProfilingPacket packet = null;
        long writtenDump = 0L;
        long writtenAddon = 0L;
        try {
            while ((packet = reader.nextPacket()) != null) {
                HprofDumpWrite event;
                if (packet instanceof HprofDumpWrite) {
                    event = (HprofDumpWrite)packet;
                    hprofFile.write(event.getData());
                    reporter.reportWorkOrThrow(event.getWrittenBytes() - writtenDump);
                    writtenDump = event.getWrittenBytes();
                    continue;
                }
                if (packet instanceof HprofDumpWriteAddon) {
                    if (addonsFile == null) {
                        addonsFile = new RandomAccessFile(addonsFileName, "rw");
                    }
                    event = (HprofDumpWriteAddon)packet;
                    addonsFile.write(event.getData());
                    reporter.reportWorkOrThrow(event.getWrittenBytes() - writtenAddon);
                    writtenAddon = event.getWrittenBytes();
                    continue;
                }
                if (packet instanceof HprofDumpSeek) {
                    event = (HprofDumpSeek)packet;
                    if (addonsFile != null) {
                        addonsFile.seek(event.getSeekOffset());
                        continue;
                    }
                    hprofFile.seek(event.getSeekOffset());
                    continue;
                }
                if (packet instanceof HprofDumpStart) {
                    if (hprofFileName.exists()) {
                        hprofFileName.delete();
                    }
                    if (addonsFileName.exists()) {
                        addonsFileName.delete();
                    }
                    hprofFile = new RandomAccessFile(hprofFileName, "rw");
                    continue;
                }
                if (!(packet instanceof HprofDumpEnd)) continue;
                break;
            }
        }
        finally {
            try {
                if (addonsFile != null) {
                    addonsFile.close();
                }
            }
            finally {
                if (hprofFile != null) {
                    hprofFile.close();
                }
            }
        }
    }

    @Override
    public AllocationSnapshot createAllocationSnapshot(IdHashSet ids, AllocationSnapshotController allocationSnapshot, String name, ProgressReporter reporter) throws IOException {
        ResourceName baseName = ((AllocationSnapshot)allocationSnapshot.getSnapshot()).asResourceName().addElement((ResourceNameElement)new FilterAllocationById(ids));
        return CalledUtils.createSnapshot(allocationSnapshot.getResourceName(), baseName, name, reporter);
    }

    @Override
    public MatController<TypedModel> getMatController() throws IOException {
        return (MatController)ResourceControllerUtils.getResourceController(this.getResourceName(), this.getResourceName().addElement((ResourceNameElement)new Elements.CreateMatController()));
    }
}

